/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.sounds;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.protocol.player.ClientVersion;
import com.github.retrooper.packetevents.protocol.sound.Sound;
import com.github.retrooper.packetevents.protocol.sound.Sounds;
import com.github.retrooper.packetevents.resources.ResourceLocation;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.sounds.SoundGroup;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class SoundManager {
    public void load() {
        SoundGroup.getGroups().clear();
        this.loadSounds();
        this.loadCustomSounds();
    }

    private void loadCustomSounds() {
        File f = new File(LibsDisguises.getInstance().getDataFolder(), "configs/sounds.yml");
        if (!f.exists()) {
            f.getParentFile().mkdirs();
            File old = new File(LibsDisguises.getInstance().getDataFolder(), "sounds.yml");
            if (old.exists()) {
                old.renameTo(f);
            } else {
                LibsDisguises.getInstance().saveResource("configs/sounds.yml", false);
            }
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)f);
        for (String key : config.getKeys(false)) {
            if (!config.isConfigurationSection(key) || key.equals("GroupName")) continue;
            if (SoundGroup.getGroups().keySet().stream().anyMatch(k -> k.equalsIgnoreCase(key))) {
                LibsDisguises.getInstance().getLogger().warning("The SoundGroup " + key + " has already been registered!");
                continue;
            }
            SoundGroup group = new SoundGroup(key);
            ConfigurationSection section = config.getConfigurationSection(key);
            for (SoundGroup.SoundType type : SoundGroup.SoundType.values()) {
                List list;
                if (type == SoundGroup.SoundType.CANCEL || (list = section.getStringList(type.name().charAt(0) + type.name().substring(1).toLowerCase(Locale.ENGLISH))) == null || list.isEmpty()) continue;
                for (String sound : list) {
                    if (!sound.matches(".+:.+")) {
                        SoundGroup subGroup = SoundGroup.getGroup(sound);
                        if (subGroup == null) {
                            LibsDisguises.getInstance().getLogger().warning("Invalid sound '" + sound + "'! Must be a minecraft:sound.name or SoundGroup name!");
                            continue;
                        }
                        ResourceLocation[] sounds = subGroup.getDisguiseSounds().get((Object)type);
                        if (sounds == null) {
                            LibsDisguises.getInstance().getLogger().warning("Sound group '" + sound + "' does not contain a category for " + (Object)((Object)type) + "! Can't use as default in " + key);
                            continue;
                        }
                        for (ResourceLocation obj : sounds) {
                            group.addSound(obj, type);
                        }
                        continue;
                    }
                    group.addSound(new ResourceLocation(sound), type);
                }
            }
            LibsDisguises.getInstance().getLogger().info("Loaded sound group '" + key + "'");
        }
    }

    private void loadSounds() {
        ClientVersion serverVersion = PacketEvents.getAPI().getServerManager().getVersion().toClientVersion();
        try (InputStream stream = LibsDisguises.getInstance().getResource("SOUND_MAPPINGS.txt");){
            String[] lines;
            for (String line : lines = new String(ReflectionManager.readFuzzyFully(stream), StandardCharsets.UTF_8).split("\n")) {
                String[] groups = line.split("/", -1);
                SoundGroup group = new SoundGroup(groups[0]);
                int i = 0;
                for (SoundGroup.SoundType type : SoundGroup.SoundType.values()) {
                    String[] sounds;
                    String s;
                    if ((s = groups[++i]).isEmpty()) continue;
                    for (String soundStr : sounds = s.split(",", -1)) {
                        if (soundStr.startsWith("^")) {
                            Pattern pattern = Pattern.compile(soundStr);
                            for (Sound s1 : Sounds.values()) {
                                if (s1.getId(serverVersion) < 0 || !s1.getSoundId().getKey().matches(soundStr)) continue;
                                group.addSound(s1.getSoundId(), type);
                            }
                            continue;
                        }
                        group.addSound(new ResourceLocation(soundStr), type);
                    }
                }
            }
        }
        catch (IOException | NoClassDefFoundError e) {
            e.printStackTrace();
        }
    }
}

