/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.sounds;

import com.github.retrooper.packetevents.resources.ResourceLocation;
import java.util.Arrays;
import java.util.LinkedHashMap;
import lombok.Generated;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import org.apache.commons.lang.math.RandomUtils;

public class SoundGroup {
    private static final LinkedHashMap<String, SoundGroup> groups = new LinkedHashMap();
    private float damageSoundVolume = 1.0f;
    private final LinkedHashMap<ResourceLocation, SoundType> disguiseSoundTypes = new LinkedHashMap();
    private final LinkedHashMap<SoundType, ResourceLocation[]> disguiseSounds = new LinkedHashMap();
    private boolean customSounds;

    public SoundGroup(String name) {
        groups.put(name, this);
        try {
            DisguiseType.valueOf(name);
        }
        catch (Exception ex) {
            this.customSounds = true;
        }
    }

    public void addSound(ResourceLocation soundString, SoundType type) {
        if (soundString == null) {
            return;
        }
        this.disguiseSoundTypes.putIfAbsent(soundString, type);
        if (this.disguiseSounds.containsKey((Object)type)) {
            ResourceLocation[] array = this.disguiseSounds.get((Object)type);
            array = Arrays.copyOf(array, array.length + 1);
            array[array.length - 1] = soundString;
            this.disguiseSounds.put(type, array);
        } else {
            this.disguiseSounds.put(type, new ResourceLocation[]{soundString});
        }
    }

    public float getDamageAndIdleSoundVolume() {
        return this.damageSoundVolume;
    }

    public void setDamageAndIdleSoundVolume(float strength) {
        this.damageSoundVolume = strength;
    }

    public ResourceLocation getSound(SoundType type) {
        if (type == null) {
            return null;
        }
        if (this.customSounds) {
            return this.getRandomSound(type);
        }
        ResourceLocation[] sounds = this.disguiseSounds.get((Object)type);
        if (sounds == null) {
            return null;
        }
        return sounds[0];
    }

    private ResourceLocation getRandomSound(SoundType type) {
        if (type == null) {
            return null;
        }
        ResourceLocation[] sounds = this.disguiseSounds.get((Object)type);
        if (sounds == null) {
            return null;
        }
        return sounds[RandomUtils.nextInt((int)sounds.length)];
    }

    public SoundType getSound(ResourceLocation sound) {
        if (sound == null) {
            return null;
        }
        return this.disguiseSoundTypes.get(sound);
    }

    public SoundType getType(ResourceLocation sound) {
        if (sound == null) {
            return SoundType.CANCEL;
        }
        return this.getSound(sound);
    }

    public static SoundGroup getGroup(Disguise disguise) {
        SoundGroup dSoundGroup;
        if (disguise.getSoundGroup() != null && (dSoundGroup = SoundGroup.getGroup(disguise.getSoundGroup())) != null) {
            return dSoundGroup;
        }
        return SoundGroup.getGroup(disguise.getType().name());
    }

    public static SoundGroup getGroup(String name) {
        return groups.get(name);
    }

    @Generated
    public static LinkedHashMap<String, SoundGroup> getGroups() {
        return groups;
    }

    @Generated
    public LinkedHashMap<ResourceLocation, SoundType> getDisguiseSoundTypes() {
        return this.disguiseSoundTypes;
    }

    @Generated
    public LinkedHashMap<SoundType, ResourceLocation[]> getDisguiseSounds() {
        return this.disguiseSounds;
    }

    public static enum SoundType {
        CANCEL,
        DEATH,
        HURT,
        IDLE,
        STEP;

    }
}

