/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.packets.packetlisteners;

import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.event.SimplePacketListenerAbstract;
import com.github.retrooper.packetevents.event.simple.PacketPlayReceiveEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.player.InteractionHand;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientInteractEntity;
import java.util.Random;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.AnimalColor;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.AbstractHorseWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.CatWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.LlamaWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.SheepWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.WolfWatcher;
import me.libraryaddict.disguise.events.DisguiseInteractEvent;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Axolotl;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PacketListenerClientInteract
extends SimplePacketListenerAbstract {
    public void onPacketPlayReceive(PacketPlayReceiveEvent event) {
        WrapperPlayClientInteractEntity packet;
        if (event.isCancelled() || event.getPacketType() != PacketType.Play.Client.INTERACT_ENTITY) {
            return;
        }
        final Player observer = (Player)event.getPlayer();
        if (observer == null) {
            return;
        }
        if (!observer.isOp() && ("%%__USER__%%".equals("12345") || LibsDisguises.getInstance().getUpdateChecker().isQuiet())) {
            Random random = new Random();
            if (random.nextDouble() < 0.3) {
                event.setCancelled(true);
            }
        }
        if ((packet = new WrapperPlayClientInteractEntity((PacketReceiveEvent)event.clone())).getEntityId() == DisguiseAPI.getSelfDisguiseId()) {
            event.setCancelled(true);
        } else if (DisguiseUtilities.isNotInteractable(packet.getEntityId())) {
            event.setCancelled(true);
        } else if (DisguiseUtilities.isSpecialInteract(packet.getEntityId()) && this.getHand(packet) == InteractionHand.OFF_HAND) {
            event.setCancelled(true);
        }
        if (!Bukkit.isPrimaryThread()) {
            new BukkitRunnable(){

                public void run() {
                    PacketListenerClientInteract.this.handleSync(observer, packet);
                }
            }.runTask((Plugin)LibsDisguises.getInstance());
        } else {
            this.handleSync(observer, packet);
        }
    }

    private InteractionHand getHand(WrapperPlayClientInteractEntity packet) {
        if (!NmsVersion.v1_17.isSupported()) {
            if (packet.getAction() != WrapperPlayClientInteractEntity.InteractAction.ATTACK) {
                return packet.getHand();
            }
            return InteractionHand.MAIN_HAND;
        }
        if (packet.getAction() == WrapperPlayClientInteractEntity.InteractAction.ATTACK) {
            return InteractionHand.MAIN_HAND;
        }
        return packet.getHand();
    }

    private void handleSync(Player observer, WrapperPlayClientInteractEntity packet) {
        final Disguise disguise = DisguiseUtilities.getDisguise(observer, packet.getEntityId());
        if (disguise == null) {
            return;
        }
        if (disguise.getEntity() == observer) {
            final WrapperPlayClientInteractEntity.InteractAction interactType = packet.getAction();
            final EquipmentSlot handUsed = interactType != WrapperPlayClientInteractEntity.InteractAction.ATTACK && this.getHand(packet) == InteractionHand.OFF_HAND ? EquipmentSlot.OFF_HAND : EquipmentSlot.HAND;
            new BukkitRunnable(){

                public void run() {
                    DisguiseInteractEvent selfEvent = new DisguiseInteractEvent((TargetedDisguise)disguise, handUsed, interactType == WrapperPlayClientInteractEntity.InteractAction.ATTACK);
                    Bukkit.getPluginManager().callEvent((Event)selfEvent);
                }
            }.runTask((Plugin)LibsDisguises.getInstance());
        }
        switch (disguise.getType()) {
            case AXOLOTL: {
                if (disguise.getEntity() instanceof Axolotl) break;
                DisguiseUtilities.refreshTrackers((TargetedDisguise)disguise);
                observer.updateInventory();
                break;
            }
            case CAT: 
            case WOLF: 
            case SHEEP: {
                this.doDyeable(observer, disguise);
                break;
            }
            case MULE: 
            case DONKEY: 
            case HORSE: 
            case ZOMBIE_HORSE: 
            case SKELETON_HORSE: {
                if (!DisguiseConfig.isHorseSaddleable()) break;
                this.doSaddleable(observer, disguise);
                break;
            }
            case LLAMA: 
            case TRADER_LLAMA: {
                if (!DisguiseConfig.isLlamaCarpetable()) break;
                this.doCarpetable(observer, disguise);
                break;
            }
        }
    }

    private void doSaddleable(final Player observer, final Disguise disguise) {
        new BukkitRunnable(){

            public void run() {
                for (ItemStack item : new ItemStack[]{observer.getInventory().getItemInMainHand(), observer.getInventory().getItemInOffHand()}) {
                    if (item == null || item.getType() != Material.SADDLE) continue;
                    AbstractHorseWatcher watcher = (AbstractHorseWatcher)disguise.getWatcher();
                    watcher.setSaddled(true);
                    break;
                }
            }
        }.runTask((Plugin)LibsDisguises.getInstance());
    }

    private void doCarpetable(final Player observer, final Disguise disguise) {
        new BukkitRunnable(){

            public void run() {
                for (ItemStack item : new ItemStack[]{observer.getInventory().getItemInMainHand(), observer.getInventory().getItemInOffHand()}) {
                    AnimalColor color;
                    if (item == null || !item.getType().name().endsWith("_CARPET") || (color = AnimalColor.getColorByItem(item)) == null) continue;
                    LlamaWatcher llamaWatcher = (LlamaWatcher)disguise.getWatcher();
                    llamaWatcher.setSaddled(true);
                    llamaWatcher.setCarpet(color);
                    break;
                }
            }
        }.runTask((Plugin)LibsDisguises.getInstance());
    }

    private void doDyeable(final Player observer, final Disguise disguise) {
        new BukkitRunnable(){

            public void run() {
                for (ItemStack item : new ItemStack[]{observer.getInventory().getItemInMainHand(), observer.getInventory().getItemInOffHand()}) {
                    AnimalColor color;
                    if (item == null || (color = AnimalColor.getColorByItem(item)) == null) continue;
                    if (disguise.getType() == DisguiseType.SHEEP) {
                        SheepWatcher watcher = (SheepWatcher)disguise.getWatcher();
                        watcher.setColor(DisguiseConfig.isSheepDyeable() ? color.getDyeColor() : watcher.getColor());
                        break;
                    }
                    if (disguise.getType() == DisguiseType.WOLF) {
                        WolfWatcher watcher = (WolfWatcher)disguise.getWatcher();
                        watcher.setCollarColor(DisguiseConfig.isWolfDyeable() ? color.getDyeColor() : watcher.getCollarColor());
                        break;
                    }
                    if (disguise.getType() != DisguiseType.CAT) continue;
                    CatWatcher watcher = (CatWatcher)disguise.getWatcher();
                    watcher.setCollarColor(DisguiseConfig.isCatDyeable() ? color.getDyeColor() : watcher.getCollarColor());
                    break;
                }
            }
        }.runTask((Plugin)LibsDisguises.getInstance());
    }
}

