/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.listeners;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.packettype.PacketTypeCommon;
import com.github.retrooper.packetevents.protocol.player.Equipment;
import com.github.retrooper.packetevents.util.Vector3d;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityEquipment;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityMetadata;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityTeleport;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerPlayerInfo;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import io.github.retrooper.packetevents.util.SpigotConversionUtil;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.events.UndisguiseEvent;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.packets.LibsPackets;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.reflection.WatcherValue;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerSkinHandler
implements Listener {
    private final Cache<Player, List<PlayerSkin>> cache = CacheBuilder.newBuilder().weakKeys().expireAfterWrite((long)DisguiseConfig.getPlayerDisguisesSkinExpiresMove() * 50L, TimeUnit.MILLISECONDS).removalListener(event -> {
        if (event.getCause() != RemovalCause.EXPIRED) {
            return;
        }
        List skins = (List)event.getValue();
        for (PlayerSkin skin : skins) {
            this.doPacketRemoval((Player)event.getKey(), skin);
        }
        skins.clear();
    }).build();

    public PlayerSkinHandler() {
        new BukkitRunnable(){

            public void run() {
                PlayerSkinHandler.this.getCache().asMap().forEach((key, value) -> PlayerSkinHandler.this.doTeleport(key, value));
            }
        }.runTaskTimer((Plugin)LibsDisguises.getInstance(), 1L, 1L);
    }

    public synchronized boolean isSleeping(Player player, PlayerDisguise disguise) {
        List disguises = (List)this.getCache().getIfPresent((Object)player);
        if (disguises == null) {
            return false;
        }
        return disguises.stream().anyMatch(d -> d.getDisguise().get() == disguise);
    }

    public synchronized PlayerSkin addPlayerSkin(Player player, PlayerDisguise disguise) {
        this.tryProcess(player, false);
        ArrayList<PlayerSkin> skins = (ArrayList<PlayerSkin>)this.getCache().getIfPresent((Object)player);
        if (skins == null) {
            skins = new ArrayList<PlayerSkin>();
        }
        PlayerSkin toReturn = new PlayerSkin(new WeakReference<PlayerDisguise>(disguise));
        skins.add(toReturn);
        this.getCache().put((Object)player, skins);
        return toReturn;
    }

    private synchronized void doTeleport(Player player, List<PlayerSkin> value) {
        if (player == null || !player.isOnline()) {
            return;
        }
        Location loc = player.getLocation();
        loc.add(loc.getDirection().normalize().multiply(10));
        for (PlayerSkin skin : new ArrayList<PlayerSkin>(value)) {
            PlayerDisguise disguise;
            if (!value.contains(skin) || !skin.isSleepPackets() || (disguise = (PlayerDisguise)skin.getDisguise().get()) == null || !disguise.isDisguiseInUse()) continue;
            int id = disguise.getEntity().getEntityId();
            if (id == player.getEntityId()) {
                id = DisguiseAPI.getSelfDisguiseId();
            }
            WrapperPlayServerEntityTeleport packet = new WrapperPlayServerEntityTeleport(id, SpigotConversionUtil.fromBukkitLocation((Location)loc), true);
            PacketEvents.getAPI().getPlayerManager().sendPacketSilently((Object)player, (PacketWrapper)packet);
        }
    }

    public synchronized void handlePackets(Player player, PlayerDisguise disguise, LibsPackets<?> packets) {
        boolean spawn = packets.isSkinHandling();
        List skins = (List)this.getCache().getIfPresent((Object)player);
        if (skins == null) {
            return;
        }
        PlayerSkin skin = skins.stream().filter(s -> s.getDisguise().get() == disguise).findAny().orElse(null);
        if (skin == null || !skin.isSleepPackets()) {
            return;
        }
        if (spawn) {
            packets.getDelayedPacketsMap().entrySet().removeIf(entry -> {
                ((ArrayList)entry.getValue()).removeIf(packet -> packet.getPacketTypeData().getPacketType() == PacketType.Play.Server.ENTITY_EQUIPMENT && this.isProcessedLater(skin, (PacketWrapper)packet));
                return ((ArrayList)entry.getValue()).isEmpty();
            });
            return;
        }
        packets.getPackets().removeIf(packet -> this.isProcessedLater(skin, (PacketWrapper)packet));
        packets.getDelayedPacketsMap().entrySet().removeIf(entry -> {
            ((ArrayList)entry.getValue()).removeIf(packet -> this.isProcessedLater(skin, (PacketWrapper)packet));
            return ((ArrayList)entry.getValue()).isEmpty();
        });
    }

    private boolean isProcessedLater(PlayerSkin skin, PacketWrapper packetContainer) {
        PacketTypeCommon type = packetContainer.getPacketTypeData().getPacketType();
        if (type == PacketType.Play.Server.ENTITY_EQUIPMENT) {
            WrapperPlayServerEntityEquipment equipment = (WrapperPlayServerEntityEquipment)packetContainer;
            ArrayList<Equipment> list = new ArrayList<Equipment>();
            for (Equipment equip : equipment.getEquipment()) {
                list.add(new Equipment(equip.getSlot(), equip.getItem().copy()));
            }
            skin.getSleptPackets().computeIfAbsent(3, a -> new ArrayList()).add(new WrapperPlayServerEntityEquipment(equipment.getEntityId(), list));
            return true;
        }
        return type == PacketType.Play.Server.ENTITY_METADATA;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    private synchronized void onUndisguise(UndisguiseEvent event) {
        if (!event.getDisguise().isPlayerDisguise()) {
            return;
        }
        PlayerDisguise disguise = (PlayerDisguise)event.getDisguise();
        ArrayList players = new ArrayList(this.getCache().asMap().keySet());
        for (Player player : players) {
            PlayerSkin skin;
            List skins = (List)this.getCache().getIfPresent((Object)player);
            if (skins == null || (skin = (PlayerSkin)skins.stream().filter(s -> s.getDisguise().get() == disguise).findAny().orElse(null)) == null) continue;
            this.doPacketRemoval(player, skin);
            if (skins.size() == 1) {
                this.getCache().invalidate((Object)player);
                continue;
            }
            skins.remove(skin);
        }
    }

    private synchronized void addMetadata(Player player, PlayerSkin skin) throws InvocationTargetException {
        PlayerDisguise disguise = (PlayerDisguise)skin.getDisguise().get();
        if (!disguise.isDisguiseInUse()) {
            return;
        }
        Entity entity = disguise.getEntity();
        List<WatcherValue> watcherValues = DisguiseUtilities.createSanitizedWatcherValues(player, entity, disguise.getWatcher());
        WrapperPlayServerEntityMetadata metaPacket = ReflectionManager.getMetadataPacket(entity.getEntityId(), watcherValues);
        PacketEvents.getAPI().getPlayerManager().sendPacketSilently((Object)player, (PacketWrapper)metaPacket);
    }

    private synchronized void addTeleport(Player player, PlayerSkin skin) throws InvocationTargetException {
        int id;
        float pitch;
        PlayerDisguise disguise = (PlayerDisguise)skin.getDisguise().get();
        Location loc = disguise.getEntity().getLocation().add(0.0, (double)disguise.getWatcher().getYModifier() + DisguiseUtilities.getYModifier(disguise), 0.0);
        Float pitchLock = DisguiseConfig.isMovementPacketsEnabled() ? disguise.getWatcher().getPitchLock() : null;
        Float yawLock = DisguiseConfig.isMovementPacketsEnabled() ? disguise.getWatcher().getYawLock() : null;
        float yaw = yawLock == null ? loc.getYaw() : yawLock.floatValue();
        float f = pitch = pitchLock == null ? loc.getPitch() : pitchLock.floatValue();
        if (DisguiseConfig.isMovementPacketsEnabled()) {
            if (yawLock == null) {
                yaw = DisguiseUtilities.getYaw(DisguiseType.getType(disguise.getEntity().getType()), yaw);
            }
            if (pitchLock == null) {
                pitch = DisguiseUtilities.getPitch(DisguiseType.getType(disguise.getEntity().getType()), pitch);
            }
            yaw = DisguiseUtilities.getYaw(disguise.getType(), yaw);
            pitch = DisguiseUtilities.getPitch(disguise.getType(), pitch);
        }
        if ((id = disguise.getEntity().getEntityId()) == player.getEntityId()) {
            id = DisguiseAPI.getSelfDisguiseId();
        }
        WrapperPlayServerEntityTeleport teleport = new WrapperPlayServerEntityTeleport(id, new Vector3d(loc.getX(), loc.getY(), loc.getZ()), yaw, pitch, disguise.getEntity().isOnGround());
        PacketEvents.getAPI().getPlayerManager().sendPacketSilently((Object)player, (PacketWrapper)teleport);
    }

    private synchronized void doPacketRemoval(final Player player, final PlayerSkin skin) {
        final PlayerDisguise disguise = (PlayerDisguise)skin.getDisguise().get();
        if (disguise == null) {
            return;
        }
        try {
            if (disguise.isDisguiseInUse()) {
                for (final Map.Entry<Integer, List<PacketWrapper>> entry : skin.getSleptPackets().entrySet()) {
                    if (entry.getKey() == 0) {
                        for (PacketWrapper packet : entry.getValue()) {
                            PacketEvents.getAPI().getPlayerManager().sendPacketSilently((Object)player, packet);
                        }
                        continue;
                    }
                    new BukkitRunnable(){

                        public void run() {
                            if (!disguise.isDisguiseInUse()) {
                                return;
                            }
                            for (PacketWrapper packet : (List)entry.getValue()) {
                                PacketEvents.getAPI().getPlayerManager().sendPacketSilently((Object)player, packet);
                            }
                        }
                    }.runTaskLater((Plugin)LibsDisguises.getInstance(), (long)entry.getKey().intValue());
                }
                if (skin.isSleepPackets()) {
                    this.addTeleport(player, skin);
                    new BukkitRunnable(){

                        public void run() {
                            try {
                                PlayerSkinHandler.this.addMetadata(player, skin);
                            }
                            catch (InvocationTargetException e) {
                                e.printStackTrace();
                            }
                        }
                    }.runTask((Plugin)LibsDisguises.getInstance());
                }
                if (DisguiseConfig.isArmorstandsName() && disguise.isNameVisible() && disguise.getMultiNameLength() > 0) {
                    List<PacketWrapper<?>> packets = DisguiseUtilities.getNamePackets(disguise, player, new String[0]);
                    for (PacketWrapper<?> p : packets) {
                        PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, p);
                    }
                }
            }
            if (skin.isDoTabList()) {
                PacketWrapper<?> packetContainer = DisguiseUtilities.createTablistPacket(disguise, WrapperPlayServerPlayerInfo.Action.REMOVE_PLAYER);
                PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, packetContainer);
            }
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private synchronized void tryProcess(Player player, boolean onMove) {
        List skins = (List)this.getCache().getIfPresent((Object)player);
        if (skins == null) {
            return;
        }
        ArrayList removed = new ArrayList();
        skins.removeIf(skin -> {
            if (!skin.canRemove(onMove)) {
                return false;
            }
            removed.add(skin);
            return true;
        });
        removed.forEach(skin -> this.doPacketRemoval(player, (PlayerSkin)skin));
        if (!skins.isEmpty()) {
            return;
        }
        this.getCache().invalidate((Object)player);
    }

    @EventHandler
    public void onMove(PlayerMoveEvent event) {
        this.tryProcess(event.getPlayer(), true);
    }

    @Generated
    public Cache<Player, List<PlayerSkin>> getCache() {
        return this.cache;
    }

    public static class PlayerSkin {
        private final long firstPacketSent = System.currentTimeMillis();
        private final WeakReference<PlayerDisguise> disguise;
        private final HashMap<Integer, List<PacketWrapper>> sleptPackets = new HashMap();
        private boolean doTabList = true;
        private boolean sleepPackets;

        public boolean canRemove(boolean onMoved) {
            return this.firstPacketSent + (long)DisguiseConfig.getTablistRemoveDelay() * 50L + (onMoved ? 0L : (long)DisguiseConfig.getPlayerDisguisesSkinExpiresMove() * 50L) < System.currentTimeMillis();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlayerSkin that = (PlayerSkin)o;
            return this.getDisguise().get() == that.getDisguise().get();
        }

        @Generated
        public PlayerSkin(WeakReference<PlayerDisguise> disguise) {
            this.disguise = disguise;
        }

        @Generated
        public long getFirstPacketSent() {
            return this.firstPacketSent;
        }

        @Generated
        public WeakReference<PlayerDisguise> getDisguise() {
            return this.disguise;
        }

        @Generated
        public HashMap<Integer, List<PacketWrapper>> getSleptPackets() {
            return this.sleptPackets;
        }

        @Generated
        public boolean isDoTabList() {
            return this.doTabList;
        }

        @Generated
        public boolean isSleepPackets() {
            return this.sleepPackets;
        }

        @Generated
        public void setDoTabList(boolean doTabList) {
            this.doTabList = doTabList;
        }

        @Generated
        public void setSleepPackets(boolean sleepPackets) {
            this.sleepPackets = sleepPackets;
        }
    }
}

