/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities;

import com.github.retrooper.packetevents.protocol.player.UserProfile;
import com.mojang.authlib.GameProfile;
import java.io.File;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.mineskin.models.responses.MineSkinQueueResponse;
import me.libraryaddict.disguise.utilities.mineskin.models.structures.SkinVariant;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SkinUtils {
    private static int skinsSinceLastPromotion = 0;
    private static int totalSkinsUsedSince;
    private static long timeSinceLastPromotion;

    public static void attemptPromoteMineskin(CommandSender sender) {
        ++totalSkinsUsedSince;
        if (skinsSinceLastPromotion++ < 10 || timeSinceLastPromotion + TimeUnit.DAYS.toMillis(2L) > System.currentTimeMillis() || DisguiseUtilities.getMineSkinAPI().getApiKey() != null) {
            return;
        }
        skinsSinceLastPromotion = 0;
        timeSinceLastPromotion = System.currentTimeMillis();
        String message = ChatColor.AQUA + "Enjoying the ability to create player skins via file & url? You're using MineSkin which is run by Haylee // inventivetalent! If you have the time, a small donation would be appreciated to help cover server costs https://support.inventivetalent.org/";
        LibsDisguises.getInstance().getLogger().info("Promoted the support for MineSkin, " + totalSkinsUsedSince + " skins were requested since server startup. Opt out by setting a MineSkin api key inside LibsDisguises/configs/players.yml");
        if (sender == null) {
            LibsDisguises.getInstance().getLogger().info(message);
        } else {
            sender.sendMessage(message);
        }
    }

    public static void handleFile(final File file, final SkinVariant modelType, final SkinCallback callback) {
        new BukkitRunnable(){

            public void run() {
                try {
                    final MineSkinQueueResponse response = DisguiseUtilities.getMineSkinAPI().generateFromFile(callback, file, modelType);
                    new BukkitRunnable(){

                        public void run() {
                            if (response == null) {
                                return;
                            }
                            if (response.getGameProfile() == null) {
                                callback.onError(LibsMsg.SKIN_API_FAIL, new Object[0]);
                                return;
                            }
                            SkinUtils.handleProfile(response.getGameProfile(), modelType, callback);
                        }
                    }.runTask((Plugin)LibsDisguises.getInstance());
                }
                catch (Throwable e) {
                    new BukkitRunnable(){

                        public void run() {
                            callback.onError(LibsMsg.SKIN_API_BAD_FILE, new Object[0]);
                        }
                    }.runTask((Plugin)LibsDisguises.getInstance());
                }
            }
        }.runTaskAsynchronously((Plugin)LibsDisguises.getInstance());
    }

    public static void handleUrl(final String url, final SkinVariant modelType, final SkinCallback callback) {
        new BukkitRunnable(){

            public void run() {
                final MineSkinQueueResponse response = DisguiseUtilities.getMineSkinAPI().generateFromUrl(callback, url, modelType);
                new BukkitRunnable(){

                    public void run() {
                        if (response == null) {
                            return;
                        }
                        if (response.getGameProfile() == null) {
                            callback.onError(LibsMsg.SKIN_API_FAIL, new Object[0]);
                        }
                        SkinUtils.handleProfile(response.getGameProfile(), modelType, callback);
                    }
                }.runTask((Plugin)LibsDisguises.getInstance());
            }
        }.runTaskAsynchronously((Plugin)LibsDisguises.getInstance());
    }

    public static void handleName(String playerName, SkinVariant modelType, SkinCallback callback) {
        UserProfile gameProfile = DisguiseUtilities.getProfileFromMojang(playerName, gameProfile1 -> {
            if (!Pattern.matches("\\w{1,16}", playerName)) {
                return;
            }
            if (gameProfile1 == null || gameProfile1.getTextureProperties().isEmpty()) {
                callback.onError(LibsMsg.CANNOT_FIND_PLAYER_NAME, playerName);
                return;
            }
            SkinUtils.handleProfile(gameProfile1, modelType, callback);
        });
        if (gameProfile == null) {
            return;
        }
        if (gameProfile.getTextureProperties().isEmpty()) {
            callback.onError(LibsMsg.CANNOT_FIND_PLAYER_NAME, playerName);
            return;
        }
        SkinUtils.handleProfile(gameProfile, modelType, callback);
    }

    public static void handleProfile(GameProfile profile, SkinVariant modelType, SkinCallback callback) {
        SkinUtils.handleProfile(ReflectionManager.getUserProfile(profile), modelType, callback);
    }

    public static void handleProfile(UserProfile profile, SkinVariant modelType, SkinCallback callback) {
        callback.onSuccess(profile);
    }

    public static void handleUUID(final UUID uuid, final SkinVariant modelType, final SkinCallback callback) {
        new BukkitRunnable(){

            public void run() {
                final UserProfile profile = ReflectionManager.getSkullBlob(new UserProfile(uuid, "AutoGenerated"));
                new BukkitRunnable(){

                    public void run() {
                        if (profile == null || profile.getTextureProperties().isEmpty()) {
                            callback.onError(LibsMsg.CANNOT_FIND_PLAYER_UUID, uuid.toString());
                            return;
                        }
                        SkinUtils.handleProfile(profile, modelType, callback);
                    }
                }.runTask((Plugin)LibsDisguises.getInstance());
            }
        }.runTaskAsynchronously((Plugin)LibsDisguises.getInstance());
    }

    public static boolean isUsable() {
        return SkinUtils.getUsableStatus() == null;
    }

    public static String getUsableStatus() {
        if (DisguiseUtilities.getMineSkinAPI().isInUse()) {
            return LibsMsg.SKIN_API_IN_USE.get(new Object[0]);
        }
        if (DisguiseUtilities.getMineSkinAPI().nextRequestIn() > 0) {
            String message = LibsMsg.SKIN_API_TIMER.get(DisguiseUtilities.getMineSkinAPI().nextRequestIn());
            return message;
        }
        return null;
    }

    @Deprecated
    public static void grabSkin(String param, SkinCallback callback) {
        SkinUtils.grabSkin(null, param, callback);
    }

    public static void grabSkin(CommandSender sender, String param, SkinCallback callback) {
        SkinVariant modelType = SkinVariant.UNKNOWN;
        for (SkinVariant variant : SkinVariant.values()) {
            if (!param.toLowerCase(Locale.ENGLISH).endsWith(":" + variant.name().toLowerCase(Locale.ENGLISH))) continue;
            param = param.substring(0, param.length() - (variant.name().length() + 1));
            break;
        }
        if (param.matches("https?://.+")) {
            callback.onInfo(LibsMsg.SKIN_API_USING_URL, new Object[0]);
            SkinUtils.handleUrl(param, modelType, callback);
            SkinUtils.attemptPromoteMineskin(sender);
        } else {
            if (!param.matches("[a-zA-Z\\d -_]+(\\.png)?")) {
                callback.onError(LibsMsg.SKIN_API_INVALID_NAME, new Object[0]);
                return;
            }
            File expectedFolder = new File(LibsDisguises.getInstance().getDataFolder(), "/Skins/");
            File file = new File(expectedFolder, param + (param.toLowerCase(Locale.ENGLISH).endsWith(".png") ? "" : ".png"));
            if (!file.exists()) {
                file = null;
                if (param.toLowerCase(Locale.ENGLISH).endsWith(".png")) {
                    callback.onError(LibsMsg.SKIN_API_BAD_FILE_NAME, new Object[0]);
                    return;
                }
            } else if (!file.getParentFile().getAbsolutePath().equals(expectedFolder.getAbsolutePath())) {
                callback.onError(LibsMsg.SKIN_API_INVALID_NAME, new Object[0]);
                return;
            }
            if (file != null) {
                callback.onInfo(LibsMsg.SKIN_API_USING_FILE, new Object[0]);
                SkinUtils.handleFile(file, modelType, callback);
                SkinUtils.attemptPromoteMineskin(sender);
            } else {
                UserProfile profile;
                if (param.contains("-")) {
                    try {
                        UUID uuid = UUID.fromString(param);
                        callback.onInfo(LibsMsg.SKIN_API_USING_UUID, new Object[0]);
                        SkinUtils.handleUUID(uuid, modelType, callback);
                        SkinUtils.attemptPromoteMineskin(sender);
                        return;
                    }
                    catch (Exception uuid) {
                        // empty catch block
                    }
                }
                if ((profile = DisguiseUtilities.getUserProfile(param)) != null) {
                    callback.onInfo(LibsMsg.SKIN_API_USING_EXISTING_NAME, new Object[0]);
                    callback.onSuccess(profile);
                    return;
                }
                callback.onInfo(LibsMsg.SKIN_API_USING_NAME, new Object[0]);
                SkinUtils.handleName(param, modelType, callback);
                SkinUtils.attemptPromoteMineskin(sender);
            }
        }
    }

    static {
        timeSinceLastPromotion = 0L;
    }

    public static interface SkinCallback {
        public void onError(LibsMsg var1, Object ... var2);

        public void onInfo(LibsMsg var1, Object ... var2);

        public void onSuccess(UserProfile var1);
    }
}

