/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import java.util.Optional;
import java.util.UUID;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.watchers.AgeableWatcher;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.annotations.MethodDescription;
import me.libraryaddict.disguise.utilities.reflection.annotations.NmsRemovedIn;

public abstract class AbstractHorseWatcher
extends AgeableWatcher {
    private static final int TAMED = 2;
    private static final int SADDLED = 4;
    private static final int REPRODUCED = 8;
    private static final int GRAZING = 16;
    private static final int REARING = 32;
    private static final int EATING = 64;

    public AbstractHorseWatcher(Disguise disguise) {
        super(disguise);
    }

    public UUID getOwner() {
        return this.getData(MetaIndex.HORSE_OWNER).orElse(null);
    }

    @NmsRemovedIn(value=NmsVersion.v1_19_R3)
    @MethodDescription
    public void setOwner(UUID uuid) {
        this.sendData(MetaIndex.HORSE_OWNER, Optional.of(uuid));
    }

    public boolean isReproduced() {
        return this.isHorseFlag(8);
    }

    @MethodDescription(noVisibleDifference=true)
    public void setReproduced(boolean reproduced) {
        this.setHorseFlag(8, reproduced);
    }

    public boolean isGrazing() {
        return this.isHorseFlag(16);
    }

    @MethodDescription(value="Is the horse's head lowered?")
    public void setGrazing(boolean grazing) {
        this.setHorseFlag(16, grazing);
    }

    public boolean isEating() {
        return this.isHorseFlag(64);
    }

    @MethodDescription(value="Is the horse's mouth open?")
    public void setEating(boolean mouthOpen) {
        this.setHorseFlag(64, mouthOpen);
    }

    public boolean isRearing() {
        return this.isHorseFlag(32);
    }

    @MethodDescription(value="Is the horse rearing in the air?")
    public void setRearing(boolean rear) {
        this.setHorseFlag(32, rear);
    }

    public boolean isSaddled() {
        return this.isHorseFlag(4);
    }

    @MethodDescription(value="Is the horse wearing a saddle?")
    public void setSaddled(boolean saddled) {
        this.setHorseFlag(4, saddled);
    }

    public boolean isTamed() {
        return this.isHorseFlag(2);
    }

    @MethodDescription(value="Is the horse tamed?")
    public void setTamed(boolean tamed) {
        this.setHorseFlag(2, tamed);
    }

    private boolean isHorseFlag(int i) {
        return (this.getHorseFlag() & i) != 0;
    }

    private byte getHorseFlag() {
        return this.getData(MetaIndex.HORSE_META);
    }

    private void setHorseFlag(int i, boolean flag) {
        byte j = this.getData(MetaIndex.HORSE_META);
        j = flag ? (byte)(j | i) : (byte)(j & ~i);
        this.sendData(MetaIndex.HORSE_META, j);
    }
}

