/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands.libsdisguises;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.commands.libsdisguises.LDCommand;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import me.libraryaddict.disguise.utilities.updates.PacketEventsUpdater;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class LDUpdatePacketEvents
implements LDCommand {
    private final AtomicBoolean updateInProgress = new AtomicBoolean(false);

    @Override
    public List<String> getTabComplete() {
        return Arrays.asList("updatepacketevents", "updatepe", "packetevents", "pe");
    }

    @Override
    public boolean hasPermission(CommandSender sender) {
        return sender.isOp() || sender.hasPermission("libsdisguises.update") || sender.hasPermission("minecraft.command.op");
    }

    @Override
    public String getPermission() {
        return null;
    }

    private void sendMessage(CommandSender sender, String message) {
        sender.sendMessage(ChatColor.DARK_RED + "[LibsDisguises] " + ChatColor.RED + message);
    }

    @Override
    public List<String> onTabComplete(String[] args) {
        if (args.length == 2) {
            return Arrays.asList("snapshots", "releases");
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onCommand(final CommandSender sender, String[] args) {
        DisguiseConfig.UpdatesBranch branch;
        if (this.updateInProgress.get()) {
            this.sendMessage(sender, "Update already in progress");
            return;
        }
        if (args.length > 1) {
            String type = args[1].toLowerCase(Locale.ENGLISH);
            if (type.equals("dev") || type.matches("snapshots?")) {
                branch = DisguiseConfig.UpdatesBranch.SNAPSHOTS;
            } else {
                if (!type.matches("releases?")) {
                    this.sendMessage(sender, "Unrecognized third argument, you can provide 'snapshots' and 'release' to force an update to one of those");
                    return;
                }
                branch = DisguiseConfig.UpdatesBranch.RELEASES;
            }
        } else {
            branch = DisguiseConfig.UpdatesBranch.SAME_BUILDS;
        }
        this.sendMessage(sender, "Please hold, now downloading " + (branch == DisguiseConfig.UpdatesBranch.RELEASES ? "latest release for " : (branch == DisguiseConfig.UpdatesBranch.SNAPSHOTS ? "latest snapshot build for " : "")) + "PacketEvents..");
        this.updateInProgress.set(true);
        new BukkitRunnable(){

            public void run() {
                try {
                    PacketEventsUpdater updater = new PacketEventsUpdater();
                    final boolean outcome = branch == DisguiseConfig.UpdatesBranch.SNAPSHOTS ? updater.doSnapshotUpdate() : (branch == DisguiseConfig.UpdatesBranch.RELEASES ? updater.doReleaseUpdate(null) : updater.doUpdate());
                    new BukkitRunnable(){

                        public void run() {
                            if (outcome) {
                                LDUpdatePacketEvents.this.sendMessage(sender, "Packetevents download success! Restart server to finish update!");
                            } else {
                                LDUpdatePacketEvents.this.sendMessage(sender, "Packetevents update failed, you may need to update PacketEvents");
                            }
                        }
                    }.runTask((Plugin)LibsDisguises.getInstance());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    new BukkitRunnable(){

                        public void run() {
                            LDUpdatePacketEvents.this.sendMessage(sender, "Packetevents update failed, " + ex.getMessage());
                        }
                    }.runTask((Plugin)LibsDisguises.getInstance());
                }
                finally {
                    LDUpdatePacketEvents.this.updateInProgress.set(false);
                }
            }
        }.runTaskAsynchronously((Plugin)LibsDisguises.getInstance());
    }

    @Override
    public LibsMsg getHelp() {
        return LibsMsg.LD_COMMAND_UPDATE_PACKET_EVENTS;
    }
}

