/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.updates;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.util.PEVersions;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.CodeSource;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import lombok.Generated;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.updates.BaseJenkins;
import me.libraryaddict.disguise.utilities.updates.DisguiseUpdate;
import me.libraryaddict.disguise.utilities.updates.UpdateChecker;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Nullable;

public class PacketEventsUpdater {
    @Nullable
    private File destination;
    private static boolean notedShadedPlugin;

    public static String getMinimumPacketEventsVersion() {
        return "2.7.1";
    }

    public static Instant getMinimumPacketEventsBuildTimestamp() {
        return Instant.ofEpochMilli(1739788578056L);
    }

    public static boolean isPacketEventsOutdated(Instant requiredTime) {
        try {
            return PEVersions.BUILD_TIMESTAMP.isBefore(requiredTime);
        }
        catch (Throwable throwable) {
            return true;
        }
    }

    private boolean isNotBukkitPlugin(String name) {
        return !name.toLowerCase(Locale.ENGLISH).matches(".*(bukkit|spigot|paper).*");
    }

    public boolean doUpdate() throws IOException {
        if (notedShadedPlugin) {
            LibsDisguises.getInstance().getLogger().warning("Unable to update PacketEvents, it is not installed as a plugin and instead has likely been shaded into another plugin.");
            return false;
        }
        boolean outcome = this.doReleaseUpdate(PacketEventsUpdater.getMinimumPacketEventsVersion());
        if (!outcome) {
            LibsDisguises.getInstance().getLogger().info("Release builds of PacketEvents didn't match criteria for Lib's Disguises, now looking at PacketEvents snapshot builds");
            outcome = this.doSnapshotUpdate();
        }
        return outcome;
    }

    public boolean doSnapshotUpdate() {
        try {
            return this.doJenkinsUpdate();
        }
        catch (IOException e) {
            LibsDisguises.getInstance().getLogger().warning("Error while trying to retrieve snapshot builds for PacketEvents");
            e.printStackTrace();
            return false;
        }
    }

    public static void doShadedWarning() {
        if (PacketEventsUpdater.isNotedShadedPlugin()) {
            return;
        }
        try {
            CodeSource src = PacketEvents.class.getProtectionDomain().getCodeSource();
            if (src == null) {
                return;
            }
            URL resource = src.getLocation();
            String path = resource.getPath().toLowerCase(Locale.ENGLISH);
            if (!(path.endsWith(".jar") || path.endsWith(".class") && !path.endsWith(".jar!"))) {
                return;
            }
            File file = Paths.get(resource.toURI()).toFile();
            YamlConfiguration yaml = ReflectionManager.getPluginYAML(file);
            String pluginName = yaml.getString("name");
            if (pluginName != null && pluginName.equalsIgnoreCase("packetevents")) {
                return;
            }
            if (pluginName == null) {
                LibsDisguises.getInstance().getLogger().info("Your installation of PacketEvents is curious, it's apparently in the file '" + file.getName() + "' and not installed as a plugin as expected. If everything works, then don't worry about it.");
            } else {
                LibsDisguises.getInstance().getLogger().warning("PacketEvents looks like it has been shaded into the plugin '" + pluginName + "' which is in the file '" + file.getName() + "' which is not 'packetevents', this may be fine but it also means that Lib's Disguises can't help you if you're experiencing issues with packetevents because there's no good way for Lib's Disguises to help you update. You must instead ask the author of that plugin to either update or relocate their shaded libraries.");
            }
            notedShadedPlugin = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private boolean doJenkinsUpdate() throws IOException {
        DisguiseUpdate jenkins = new BaseJenkins("https://ci.codemc.io/job/retrooper/job/packetevents/").getLatestSnapshot();
        if (jenkins == null || jenkins.getDownloads().isEmpty()) {
            return false;
        }
        jenkins.getDownloads().removeIf(this::isNotBukkitPlugin);
        if (jenkins.getDownloads().size() != 1) {
            LibsDisguises.getInstance().getLogger().severe("Failed to find jenkins update for PacketEvents, expected 1 download remaining but got: " + String.join((CharSequence)", ", jenkins.getDownloads()));
            return false;
        }
        String url = jenkins.getDownload();
        String file = url.substring(url.lastIndexOf("/") + 1);
        this.downloadFile(url, file);
        return true;
    }

    public boolean doReleaseUpdate(@Nullable String requiredVersion) throws IOException {
        URL url = new URL("https://api.modrinth.com/v2/project/packetevents/version");
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestProperty("User-Agent", "libraryaddict/LibsDisguises");
        con.setRequestProperty("Accept", "application/json");
        try (InputStream input = con.getInputStream();){
            ModrinthVersion[] versions;
            String json = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
            con.disconnect();
            for (ModrinthVersion version : versions = (ModrinthVersion[])new Gson().fromJson(json, ModrinthVersion[].class)) {
                if (version.files == null || !version.status.equals("listed") || !version.version_type.equals("release") || this.isNotBukkitPlugin(version.name) || requiredVersion != null && PacketEventsUpdater.isOlderThan(requiredVersion, version.version_number)) continue;
                for (ModrinthFile file : version.files) {
                    if (!file.filename.endsWith(".jar") || this.isNotBukkitPlugin(file.filename)) continue;
                    this.downloadFile(file.url, file.filename);
                    boolean bl = true;
                    return bl;
                }
            }
        }
        LibsDisguises.getInstance().getLogger().warning("Failed to find a " + requiredVersion + " or higher release build of PacketEvents, we probably want the snapshot builds.");
        return false;
    }

    private File getFileByPluginInstance() {
        try {
            Method getFile = JavaPlugin.class.getDeclaredMethod("getFile", new Class[0]);
            getFile.setAccessible(true);
            return (File)getFile.invoke(PacketEvents.getAPI().getPlugin(), new Object[0]);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private List<File> getFilesByYAML() {
        if (Bukkit.getPluginManager().getPlugin("packetevents") == null) {
            return new ArrayList<File>();
        }
        List<File> peJars = ReflectionManager.getFilesByPlugin("packetevents");
        if (peJars.size() > 1) {
            LibsDisguises.getInstance().getLogger().warning("You have multiple PacketEvents jars in your plugin folder, you may need to update PacketEvents yourself.");
        }
        return peJars;
    }

    private File getDestination(String preferredName) {
        List<File> files;
        File finalJarFolder = LibsDisguises.getInstance().getDataFolder().getAbsoluteFile().getParentFile();
        File fileJar = this.getFileByPluginInstance();
        if (fileJar == null && !(files = this.getFilesByYAML()).isEmpty()) {
            fileJar = files.get(0);
        }
        String fileName = preferredName;
        if (fileJar != null) {
            finalJarFolder = Bukkit.getUpdateFolderFile();
            if (!UpdateChecker.isFancyPluginUpdating()) {
                fileName = fileJar.getName();
            }
        }
        return new File(finalJarFolder, fileName);
    }

    private void downloadFile(String fileUrl, String filename) throws IOException {
        LibsDisguises.getInstance().getLogger().info("Now downloading " + filename);
        URL url = new URL(fileUrl);
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestProperty("User-Agent", "libraryaddict/LibsDisguises");
        con.setRequestProperty("Accept", "application/json");
        con.setDefaultUseCaches(false);
        File dest = this.destination = this.getDestination(filename);
        if (!dest.exists()) {
            dest.getParentFile().mkdirs();
            dest.createNewFile();
        }
        try (InputStream input = con.getInputStream();){
            Files.copy(input, dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        con.disconnect();
        if (dest.getParentFile().equals(Bukkit.getUpdateFolderFile())) {
            UpdateChecker.removeOtherJars(dest, "packetevents");
        }
        LibsDisguises.getInstance().getLogger().info(filename + " successfully downloaded and saved to " + dest.getPath());
        LibsDisguises.getInstance().setPacketEventsUpdateDownloaded(true);
    }

    public static boolean isOlderThan(String requiredVersion, String theirVersion) {
        int[] required = PacketEventsUpdater.getNumericVersion(requiredVersion);
        int[] has = PacketEventsUpdater.getNumericVersion(theirVersion);
        for (int i = 0; i < Math.min(required.length, has.length); ++i) {
            if (required[i] == has[i]) continue;
            return required[i] >= has[i];
        }
        return false;
    }

    public static int[] getNumericVersion(String version) {
        int[] v = new int[]{};
        for (String split : version.split("[.\\-]")) {
            if (!split.matches("\\d+")) {
                return v;
            }
            v = Arrays.copyOf(v, v.length + 1);
            v[v.length - 1] = Integer.parseInt(split);
        }
        return v;
    }

    public static boolean isPacketEventsOutdated() {
        String packetEventsVersion;
        Plugin plugin = Bukkit.getPluginManager().getPlugin("packetevents");
        if (plugin == null) {
            LibsDisguises.getInstance().getLogger().severe("PacketEvents not installed on server (as a plugin), must be missing!");
            return true;
        }
        try {
            packetEventsVersion = plugin.getDescription().getVersion();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return true;
        }
        return PacketEventsUpdater.isOlderThan(PacketEventsUpdater.getMinimumPacketEventsVersion(), packetEventsVersion) || PacketEventsUpdater.isPacketEventsOutdated(PacketEventsUpdater.getMinimumPacketEventsBuildTimestamp());
    }

    @Nullable
    @Generated
    public File getDestination() {
        return this.destination;
    }

    @Generated
    public static boolean isNotedShadedPlugin() {
        return notedShadedPlugin;
    }

    private static class ModrinthVersion {
        private String name;
        private String version_number;
        private String version_type;
        private String status;
        private String requested_status;
        private String id;
        private ModrinthFile[] files;

        private ModrinthVersion() {
        }
    }

    private static class ModrinthFile {
        private String url;
        private String filename;
        private boolean primary;
        private long size;

        private ModrinthFile() {
        }
    }
}

