/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.reflection.legacy;

import com.github.retrooper.packetevents.protocol.nbt.NBT;
import com.github.retrooper.packetevents.protocol.nbt.NBTByteArray;
import com.github.retrooper.packetevents.protocol.nbt.NBTCompound;
import com.github.retrooper.packetevents.protocol.nbt.NBTIntArray;
import com.github.retrooper.packetevents.protocol.nbt.NBTList;
import com.github.retrooper.packetevents.protocol.nbt.NBTLongArray;
import com.github.retrooper.packetevents.protocol.nbt.NBTNumber;
import com.github.retrooper.packetevents.protocol.nbt.NBTString;
import com.github.retrooper.packetevents.protocol.nbt.NBTType;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.ProfileLookupCallback;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import io.github.retrooper.packetevents.util.SpigotReflectionUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManagerAbstract;
import me.libraryaddict.disguise.utilities.reflection.annotations.NmsRemovedIn;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Art;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class LegacyReflectionManager
extends ReflectionManagerAbstract {
    private static Method itemAsCraftCopyMethod;
    private static Method damageAndIdleSoundMethod;
    private static Constructor<?> boundingBoxConstructor;
    private static Method setBoundingBoxMethod;
    private static Field pingField;
    private static Field entityCountField;
    private static Field chunkMapField;
    private static Field chunkProviderField;
    private static Field entityTrackerField;
    private static Field trackedEntitiesField;
    @NmsRemovedIn(value=NmsVersion.v1_14)
    private static Method ihmGet;
    @NmsRemovedIn(value=NmsVersion.v1_14)
    private static Field trackerField;
    @NmsRemovedIn(value=NmsVersion.v1_14)
    private static Field entitiesField;
    private static Method itemAsBukkitMethod;
    private static Method getServerMethod;
    private static Method getNmsEntityMethod;
    private static Method soundGetMethod;
    private static Method soundEffectGetMethod;
    private static Field soundEffectGetKey;
    private static Method entityTypesAMethod;
    private static Method craftBlockDataGetState;
    private static Method magicGetBlock;
    private static Method magicGetMaterial;
    private static Method getBlockData;
    private static Method getBlockDataAsId;
    private static Method getNmsWorld;
    private static Method deserializedItemMeta;
    private static Method boundingBoxMethod;
    private static Method bukkitEntityMethod;
    private static Method connectionEntityMethod;
    private static Field noDamageTicks;
    private static Method isInvul;
    private static Object genericDamage;
    private static Field playerConnection;
    private static Method incrementedInventoryStateId;
    private static Field playerInventoryContainer;
    private static Field trackedPlayers;
    private static Method clearEntityTracker;
    private static Method addEntityTracker;
    private static Method fillProfileProperties;
    private static Method getGameProfile;
    private static Method propertyName;
    private static Method propertyValue;
    private static Method propertySignature;
    private static Method getDatawatcher;
    private static Method datawatcherSerialize;
    private static Field datawatcherData;
    private static Field entitySize;
    private static Field entitySizeWidth;
    private static Field entityHeadHeight;
    private static Method entityGetHeadHeight;

    public LegacyReflectionManager() throws Exception {
        getServerMethod = ReflectionManager.getCraftMethod("CraftServer", "getServer", new Class[0]);
        trackedPlayers = ReflectionManager.getNmsField("EntityTrackerEntry", "trackedPlayers");
        String trackerClass = NmsVersion.v1_14.isSupported() ? "PlayerChunkMap$EntityTracker" : "EntityTrackerEntry";
        clearEntityTracker = ReflectionManager.getNmsMethod(trackerClass, "clear", ReflectionManager.getNmsClass("EntityPlayer"));
        addEntityTracker = ReflectionManager.getNmsMethod(trackerClass, "updatePlayer", ReflectionManager.getNmsClass("EntityPlayer"));
        getGameProfile = ReflectionManager.getCraftMethod("CraftPlayer", "getProfile", new Class[0]);
        boundingBoxConstructor = ReflectionManager.getNmsConstructor("AxisAlignedBB", Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE);
        setBoundingBoxMethod = ReflectionManager.getNmsMethod("Entity", "a", ReflectionManager.getNmsClass("AxisAlignedBB"));
        entityCountField = ReflectionManager.getNmsField("Entity", "entityCount");
        boundingBoxMethod = ReflectionManager.getNmsMethod("Entity", "getBoundingBox", new Class[0]);
        bukkitEntityMethod = ReflectionManager.getNmsMethod("Entity", "getBukkitEntity", new Class[0]);
        Class<?> craftItemClass = ReflectionManager.getCraftClass("CraftItemStack");
        itemAsCraftCopyMethod = ReflectionManager.getCraftMethod(craftItemClass, "asCraftCopy", ItemStack.class);
        itemAsBukkitMethod = ReflectionManager.getCraftMethod(craftItemClass, "asBukkitCopy", ReflectionManager.getNmsClass("ItemStack"));
        getNmsEntityMethod = ReflectionManager.getCraftMethod("CraftEntity", "getHandle", new Class[0]);
        Class<?> craftSound = ReflectionManager.getCraftClass("CraftSound");
        try {
            soundGetMethod = craftSound.getMethod("getSound", Sound.class);
        }
        catch (Exception ex) {
            soundEffectGetMethod = ReflectionManager.getCraftMethod("CraftSound", "getSoundEffect", Sound.class);
            soundEffectGetKey = ReflectionManager.getNmsField("SoundEffect", "b");
        }
        getBlockData = ReflectionManager.getNmsMethod(ReflectionManager.getNmsClass("Block"), "getBlockData", new Class[0]);
        if (NmsVersion.v1_13.isSupported()) {
            craftBlockDataGetState = ReflectionManager.getCraftMethod("CraftBlockData", "getState", new Class[0]);
            magicGetBlock = ReflectionManager.getCraftMethod("CraftMagicNumbers", "getBlock", Material.class);
            magicGetMaterial = ReflectionManager.getCraftMethod("CraftMagicNumbers", "getMaterial", ReflectionManager.getNmsClass("Block"));
            entityTypesAMethod = ReflectionManager.getNmsMethod("EntityTypes", "a", String.class);
        }
        getBlockDataAsId = ReflectionManager.getNmsMethod("Block", "getCombinedId", ReflectionManager.getNmsClass("IBlockData"));
        getNmsWorld = ReflectionManager.getCraftMethod("CraftWorld", "getHandle", new Class[0]);
        deserializedItemMeta = ReflectionManager.getCraftMethod(ReflectionManager.getCraftClass("CraftMetaItem$SerializableMeta"), "deserialize", Map.class);
        noDamageTicks = ReflectionManager.getNmsField("Entity", "noDamageTicks");
        isInvul = ReflectionManager.getNmsMethod("Entity", "isInvulnerable", ReflectionManager.getNmsClass("DamageSource"));
        for (Field f : ReflectionManager.getNmsClass("DamageSource").getFields()) {
            Object object;
            if (!Modifier.isStatic(f.getModifiers()) || (object = f.get(null)) == null || !object.toString().contains("(generic)")) continue;
            genericDamage = object;
            break;
        }
        try {
            Object entity = this.createEntityInstance(EntityType.COW, "Cow");
            for (Method method : ReflectionManager.getNmsClass("EntityCow").getDeclaredMethods()) {
                if (method.getReturnType() != Float.TYPE || !Modifier.isProtected(method.getModifiers()) || method.getParameterTypes().length != 0) continue;
                method.setAccessible(true);
                float value = ((Float)method.invoke(entity, new Object[0])).floatValue();
                if (((Float)method.invoke(entity, new Object[0])).floatValue() != 0.4f) continue;
                damageAndIdleSoundMethod = ReflectionManager.getNmsClass("EntityLiving").getDeclaredMethod(method.getName(), new Class[0]);
                damageAndIdleSoundMethod.setAccessible(true);
                break;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        pingField = ReflectionManager.getNmsField("EntityPlayer", "ping");
        if (NmsVersion.v1_14.isSupported()) {
            entitySize = ReflectionManager.getNmsField("Entity", "size");
            entitySizeWidth = ReflectionManager.getNmsField("EntitySize", "width");
            entityHeadHeight = ReflectionManager.getNmsField("Entity", "headHeight");
            chunkMapField = ReflectionManager.getNmsField("ChunkProviderServer", "playerChunkMap");
            trackedEntitiesField = ReflectionManager.getNmsField("PlayerChunkMap", "trackedEntities");
            entityTrackerField = ReflectionManager.getNmsField("PlayerChunkMap$EntityTracker", "trackerEntry");
            chunkProviderField = NmsVersion.v1_16.isSupported() ? ReflectionManager.getNmsField("WorldServer", "chunkProvider") : ReflectionManager.getNmsField("World", "chunkProvider");
        } else {
            trackerField = ReflectionManager.getNmsField("WorldServer", "tracker");
            entitiesField = ReflectionManager.getNmsField("EntityTracker", "trackedEntities");
            ihmGet = ReflectionManager.getNmsMethod("IntHashMap", "get", Integer.TYPE);
            entitySizeWidth = ReflectionManager.getNmsField("Entity", "width");
            entityGetHeadHeight = ReflectionManager.getNmsMethod("Entity", "getHeadHeight", new Class[0]);
        }
        Class dataClass = ReflectionManager.getNmsClass("DataWatcher");
        for (Method method : ReflectionManager.getNmsClass("Entity").getMethods()) {
            if (method.getParameterCount() != 0 || !method.getReturnType().isAssignableFrom(dataClass)) continue;
            getDatawatcher = method;
            break;
        }
        for (AccessibleObject accessibleObject : dataClass.getDeclaredFields()) {
            if (Modifier.isStatic(((Field)accessibleObject).getModifiers()) || !Map.class.isAssignableFrom(((Field)accessibleObject).getType())) continue;
            datawatcherData = accessibleObject;
            datawatcherData.setAccessible(true);
            break;
        }
        for (AccessibleObject accessibleObject : dataClass.getMethods()) {
            Class<?>[] params;
            Class<?> returnType = ((Method)accessibleObject).getReturnType();
            if (!Modifier.isPublic(((Method)accessibleObject).getModifiers()) || !Modifier.isStatic(((Method)accessibleObject).getModifiers()) || ((Method)accessibleObject).getParameterCount() != 2 || !(params = ((Method)accessibleObject).getParameterTypes())[0].isAssignableFrom(List.class)) continue;
            datawatcherSerialize = accessibleObject;
        }
    }

    public boolean hasInvul(Entity entity) {
        Object nmsEntity = this.getNmsEntity(entity);
        try {
            if (entity instanceof LivingEntity) {
                return noDamageTicks.getInt(nmsEntity) > 0;
            }
            return (Boolean)isInvul.invoke(nmsEntity, genericDamage);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public int getIncrementedStateId(Player player) {
        try {
            Object container = playerInventoryContainer.get(this.getNmsEntity((Entity)player));
            return (Integer)incrementedInventoryStateId.invoke(container, new Object[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    public int getNewEntityId() {
        return this.getNewEntityId(false);
    }

    public int getNewEntityId(boolean increment) {
        try {
            Number entityCount = (Number)entityCountField.get(null);
            if (increment) {
                if (NmsVersion.v1_14.isSupported()) {
                    return ((AtomicInteger)entityCount).incrementAndGet();
                }
                int id = entityCount.intValue();
                entityCountField.set(null, id + 1);
                return id;
            }
            if (NmsVersion.v1_14.isSupported()) {
                return entityCount.intValue() + 1;
            }
            return entityCount.intValue();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public Object getPlayerConnectionOrPlayer(Player player) {
        try {
            return this.getNmsEntity((Entity)player);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public Object createEntityInstance(EntityType entityType, String entityName) {
        try {
            Object entityObject;
            Class entityClass = ReflectionManager.getNmsClass("Entity" + entityName);
            Object world = this.getWorldServer((World)Bukkit.getWorlds().get(0));
            if (entityName.equals("Player")) {
                Object minecraftServer = ReflectionManager.getNmsMethod("MinecraftServer", "getServer", new Class[0]).invoke(null, new Object[0]);
                GameProfile profile = new GameProfile(new UUID(0L, 0L), "Steve");
                Object playerinteractmanager = ReflectionManager.getNmsClass("PlayerInteractManager").getDeclaredConstructor(ReflectionManager.getNmsClass(NmsVersion.v1_14.isSupported() ? "WorldServer" : "World")).newInstance(world);
                entityObject = entityClass.getDeclaredConstructor(ReflectionManager.getNmsClass("MinecraftServer"), ReflectionManager.getNmsClass("WorldServer"), profile.getClass(), playerinteractmanager.getClass()).newInstance(minecraftServer, world, profile, playerinteractmanager);
            } else {
                entityObject = entityName.equals("EnderPearl") ? entityClass.getDeclaredConstructor(ReflectionManager.getNmsClass("World"), ReflectionManager.getNmsClass("EntityLiving")).newInstance(world, this.createEntityInstance(EntityType.COW, "Cow")) : (entityName.equals("FishingHook") ? (NmsVersion.v1_14.isSupported() ? entityClass.getDeclaredConstructor(ReflectionManager.getNmsClass("EntityHuman"), ReflectionManager.getNmsClass("World"), Integer.TYPE, Integer.TYPE).newInstance(this.createEntityInstance(EntityType.PLAYER, "Player"), world, 0, 0) : entityClass.getDeclaredConstructor(ReflectionManager.getNmsClass("World"), ReflectionManager.getNmsClass("EntityHuman")).newInstance(world, this.createEntityInstance(EntityType.PLAYER, "Player"))) : (!NmsVersion.v1_14.isSupported() && entityName.equals("Potion") ? entityClass.getDeclaredConstructor(ReflectionManager.getNmsClass("World"), Double.TYPE, Double.TYPE, Double.TYPE, ReflectionManager.getNmsClass("ItemStack")).newInstance(world, 0.0, 0.0, 0.0, SpigotReflectionUtil.toNMSItemStack((ItemStack)new ItemStack(Material.SPLASH_POTION))) : (NmsVersion.v1_14.isSupported() ? entityClass.getDeclaredConstructor(ReflectionManager.getNmsClass("EntityTypes"), ReflectionManager.getNmsClass("World")).newInstance(this.getEntityType(entityType), world) : entityClass.getDeclaredConstructor(ReflectionManager.getNmsClass("World")).newInstance(world))));
            }
            ReflectionManager.getNmsMethod("Entity", "setPosition", Double.TYPE, Double.TYPE, Double.TYPE).invoke(entityObject, 1, 1, 1);
            ReflectionManager.getNmsMethod("Entity", "setPosition", Double.TYPE, Double.TYPE, Double.TYPE).invoke(entityObject, 0, 0, 0);
            return entityObject;
        }
        catch (Exception e) {
            LibsDisguises.getInstance().getLogger().warning("Error while attempting to create entity instance for " + entityType.name());
            e.printStackTrace();
            return null;
        }
    }

    protected Object createEntityInstance(String entityName) {
        throw new IllegalStateException("Not implemented");
    }

    public double[] getBoundingBox(Entity entity) {
        try {
            Object boundingBox = boundingBoxMethod.invoke(this.getNmsEntity(entity), new Object[0]);
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            int stage = 0;
            block10: for (Field field : boundingBox.getClass().getDeclaredFields()) {
                if (!field.getType().getSimpleName().equals("double") || Modifier.isStatic(field.getModifiers())) continue;
                switch (++stage) {
                    case 1: {
                        x -= field.getDouble(boundingBox);
                        continue block10;
                    }
                    case 2: {
                        y -= field.getDouble(boundingBox);
                        continue block10;
                    }
                    case 3: {
                        z -= field.getDouble(boundingBox);
                        continue block10;
                    }
                    case 4: {
                        x += field.getDouble(boundingBox);
                        continue block10;
                    }
                    case 5: {
                        y += field.getDouble(boundingBox);
                        continue block10;
                    }
                    case 6: {
                        z += field.getDouble(boundingBox);
                        continue block10;
                    }
                    default: {
                        throw new Exception("Error while setting the bounding box, more doubles than I thought??");
                    }
                }
            }
            return new double[]{x, y, z};
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public Object getPlayerFromPlayerConnection(Object nmsEntity) {
        try {
            return nmsEntity;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public Entity getBukkitEntity(Object nmsEntity) {
        try {
            return (Entity)bukkitEntityMethod.invoke(nmsEntity, new Object[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public ItemStack getBukkitItem(Object nmsItem) {
        try {
            return (ItemStack)itemAsBukkitMethod.invoke(null, nmsItem);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ItemStack getCraftItem(ItemStack bukkitItem) {
        try {
            return (ItemStack)itemAsCraftCopyMethod.invoke(null, bukkitItem);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object getMinecraftServer() {
        try {
            return getServerMethod.invoke((Object)Bukkit.getServer(), new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object getNmsEntity(Entity entity) {
        try {
            return getNmsEntityMethod.invoke((Object)entity, new Object[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public double getPing(Player player) {
        try {
            return pingField.getInt(this.getNmsEntity((Entity)player));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0.0;
        }
    }

    public float[] getSize(Entity entity) {
        try {
            if (NmsVersion.v1_14.isSupported()) {
                Object size = entitySize.get(this.getNmsEntity(entity));
                float width = entitySizeWidth.getFloat(size);
                float height = entityHeadHeight.getFloat(this.getNmsEntity(entity));
                return new float[]{width, height};
            }
            float width = entitySizeWidth.getFloat(this.getNmsEntity(entity));
            float height = ((Float)entityGetHeadHeight.invoke(this.getNmsEntity(entity), new Object[0])).floatValue();
            return new float[]{width, height};
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public MinecraftSessionService getMinecraftSessionService() {
        Object minecraftServer = this.getMinecraftServer();
        for (Method method : ReflectionManager.getNmsClass("MinecraftServer").getMethods()) {
            if (!method.getReturnType().getSimpleName().equals("MinecraftSessionService")) continue;
            return (MinecraftSessionService)method.invoke(minecraftServer, new Object[0]);
        }
        return null;
    }

    public Float getSoundModifier(Object entity) {
        try {
            return (Float)damageAndIdleSoundMethod.invoke(entity, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void injectCallback(String playername, ProfileLookupCallback callback) {
        Object minecraftServer = this.getMinecraftServer();
        for (Method method : ReflectionManager.getNmsClass("MinecraftServer").getMethods()) {
            if (!method.getReturnType().getSimpleName().equals("GameProfileRepository")) continue;
            Object agent = Class.forName("com.mojang.authlib.Agent").getDeclaredField("MINECRAFT").get(null);
            Object profileRepo = method.invoke(minecraftServer, new Object[0]);
            method.getReturnType().getMethod("findProfilesByNames", String[].class, agent.getClass(), Class.forName("com.mojang.authlib.ProfileLookupCallback")).invoke(profileRepo, new String[]{playername}, agent, callback);
            break;
        }
    }

    public void setBoundingBox(Entity entity, double x, double y, double z) {
        try {
            Location loc = entity.getLocation();
            Object boundingBox = boundingBoxConstructor.newInstance(loc.getX() - x / 2.0, loc.getY(), loc.getZ() - z / 2.0, loc.getX() + x / 2.0, loc.getY() + y, loc.getZ() + z / 2.0);
            setBoundingBoxMethod.invoke(this.getNmsEntity(entity), boundingBox);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getSoundString(Sound sound) {
        try {
            if (soundGetMethod == null) {
                return soundEffectGetKey.get(soundEffectGetMethod.invoke(null, sound)).toString();
            }
            return (String)soundGetMethod.invoke(null, sound);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ByteBuf getDataWatcherValues(Entity entity) {
        try {
            Object datawatcher = getDatawatcher.invoke(this.getNmsEntity(entity), new Object[0]);
            Map data = (Map)datawatcherData.get(datawatcher);
            ByteBuf buffer = PooledByteBufAllocator.DEFAULT.buffer();
            Object nmsBuff = SpigotReflectionUtil.createPacketDataSerializer((Object)buffer);
            datawatcherSerialize.invoke(null, new ArrayList(data.values()), nmsBuff);
            return buffer;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Material getMaterial(String name) {
        try {
            if (!NmsVersion.v1_13.isSupported()) {
                Method toMinecraft = ReflectionManager.getCraftMethod("CraftMagicNumbers", "getMaterialFromInternalName", String.class);
                Object instance = toMinecraft.getDeclaringClass().getField("INSTANCE").get(null);
                return (Material)toMinecraft.invoke(instance, name);
            }
            Object mcKey = ReflectionManager.getNmsConstructor("MinecraftKey", String.class).newInstance(name.toLowerCase(Locale.ENGLISH));
            Object registry = ReflectionManager.getNmsField("IRegistry", "ITEM").get(null);
            Method getMethod = ReflectionManager.getNmsMethod(ReflectionManager.getNmsClass("RegistryMaterials"), "get", mcKey.getClass());
            Object item = getMethod.invoke(registry, mcKey);
            if (item == null) {
                return null;
            }
            Method getMaterial = ReflectionManager.getCraftMethod("CraftMagicNumbers", "getMaterial", ReflectionManager.getNmsClass("Item"));
            return (Material)getMaterial.invoke(null, item);
        }
        catch (Exception ex) {
            LibsDisguises.getInstance().getLogger().severe("Error when trying to convert '" + name + "' into a Material");
            ex.printStackTrace();
            if (ex.getCause() != null) {
                ex.getCause().printStackTrace();
            }
            return null;
        }
    }

    public String getItemName(Material material) {
        try {
            Object item = ReflectionManager.getCraftMethod("CraftMagicNumbers", "getItem", Material.class).invoke(null, material);
            if (item == null) {
                return null;
            }
            Object registry = NmsVersion.v1_13.isSupported() ? ReflectionManager.getNmsField("IRegistry", "ITEM").get(null) : ReflectionManager.getNmsField("Item", "REGISTRY").get(null);
            Method getMethod = ReflectionManager.getNmsMethod(registry.getClass(), NmsVersion.v1_13.isSupported() ? "getKey" : "b", Object.class);
            Object mcKey = getMethod.invoke(registry, item);
            if (mcKey == null) {
                return null;
            }
            return (String)ReflectionManager.getNmsMethod("MinecraftKey", "getKey", new Class[0]).invoke(mcKey, new Object[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public Object createMinecraftKey(String name) {
        try {
            return ReflectionManager.getNmsConstructor("MinecraftKey", String.class).newInstance(name);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public Object getEntityType(EntityType entityType) {
        try {
            Object val = entityTypesAMethod.invoke(null, entityType.getName() == null ? entityType.name().toLowerCase(Locale.ENGLISH) : entityType.getName());
            if (NmsVersion.v1_14.isSupported()) {
                return ((Optional)val).orElse(null);
            }
            return val;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object registerEntityType(NamespacedKey key) {
        try {
            Object mcKey = ReflectionManager.getNmsConstructor("MinecraftKey", String.class).newInstance(key.toString());
            Class typesClass = ReflectionManager.getNmsClass("IRegistry");
            Object registry = typesClass.getField("ENTITY_TYPE").get(null);
            Constructor<?> c = ReflectionManager.getNmsClass("EntityTypes").getConstructors()[0];
            Object entityType = NmsVersion.v1_16.isSupported() ? c.newInstance(null, null, false, false, false, false, null, null, 0, 0) : c.newInstance(null, null, false, false, false, false, null);
            for (Field f : entityType.getClass().getDeclaredFields()) {
                if (f.getType() != String.class) continue;
                f.setAccessible(true);
                f.set(entityType, key.toString());
                break;
            }
            typesClass.getMethod("a", typesClass, mcKey.getClass(), Object.class).invoke(null, registry, mcKey, entityType);
            return entityType;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException("Failed to find EntityType id for " + key);
        }
    }

    public int getEntityTypeId(Object entityTypes) {
        try {
            Class typesClass = ReflectionManager.getNmsClass("IRegistry");
            Object registry = typesClass.getField("ENTITY_TYPE").get(null);
            return (Integer)registry.getClass().getMethod("a", Object.class).invoke(registry, entityTypes);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IllegalStateException("Failed to find EntityType id for " + entityTypes);
        }
    }

    public int getEntityTypeId(EntityType entityType) {
        try {
            if (NmsVersion.v1_13.isSupported()) {
                Object entityTypes = this.getEntityType(entityType);
                Class typesClass = ReflectionManager.getNmsClass("IRegistry");
                Object registry = typesClass.getField("ENTITY_TYPE").get(null);
                return (Integer)registry.getClass().getMethod("a", Object.class).invoke(registry, entityTypes);
            }
            return entityType.getTypeId();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IllegalStateException("Failed to find EntityType id for " + entityType);
        }
    }

    public Object getEntityType(NamespacedKey name) {
        try {
            Class typesClass = ReflectionManager.getNmsClass("IRegistry");
            Object registry = typesClass.getField("ENTITY_TYPE").get(null);
            Object mcKey = ReflectionManager.getNmsConstructor("MinecraftKey", String.class).newInstance(name.toString());
            return registry.getClass().getMethod("a", mcKey.getClass()).invoke(registry, mcKey);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IllegalStateException("The entity " + name + " is not registered!");
        }
    }

    public int getCombinedIdByBlockData(BlockData data) {
        try {
            Object iBlockData = craftBlockDataGetState.invoke((Object)data, new Object[0]);
            return (Integer)ReflectionManager.getNmsMethod("Block", "getCombinedId", ReflectionManager.getNmsClass("IBlockData")).invoke(null, iBlockData);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    public int getCombinedIdByItemStack(ItemStack itemStack) {
        try {
            if (!NmsVersion.v1_13.isSupported()) {
                return ReflectionManager.enumOrdinal(itemStack.getType()) + (itemStack.getDurability() << 12);
            }
            Object nmsBlock = magicGetBlock.invoke(null, itemStack.getType());
            Object iBlockData = getBlockData.invoke(nmsBlock, new Object[0]);
            return (Integer)getBlockDataAsId.invoke(null, iBlockData);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    public BlockData getBlockDataByCombinedId(int id) {
        try {
            Method idMethod = ReflectionManager.getNmsMethod("Block", "getByCombinedId", Integer.TYPE);
            Object iBlockData = idMethod.invoke(null, id);
            Class iBlockClass = ReflectionManager.getNmsClass("IBlockData");
            return (BlockData)ReflectionManager.getCraftMethod("CraftBlockData", "fromData", iBlockClass).invoke(null, iBlockData);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public ItemStack getItemStackByCombinedId(int id) {
        try {
            Method idMethod = ReflectionManager.getNmsMethod("Block", "getByCombinedId", Integer.TYPE);
            Object iBlockData = idMethod.invoke(null, id);
            Class iBlockClass = ReflectionManager.getNmsClass("IBlockData");
            Method getBlock = ReflectionManager.getNmsMethod(NmsVersion.v1_16.isSupported() ? iBlockClass.getSuperclass() : iBlockClass, "getBlock", new Class[0]);
            Object block = getBlock.invoke(iBlockData, new Object[0]);
            if (NmsVersion.v1_13.isSupported()) {
                return new ItemStack((Material)magicGetMaterial.invoke(null, block));
            }
            Method getItem = ReflectionManager.getNmsMethod("Block", "u", iBlockClass);
            return this.getBukkitItem(getItem.invoke(block, iBlockData));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public Object getWorldServer(World w) {
        try {
            return getNmsWorld.invoke((Object)w, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ItemMeta getDeserializedItemMeta(Map<String, Object> meta) {
        try {
            return (ItemMeta)deserializedItemMeta.invoke(null, meta);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public GameProfile getProfile(Player player) {
        try {
            return (GameProfile)getGameProfile.invoke((Object)player, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Art getPaintingFromInt(int paintingId) {
        throw new IllegalArgumentException("Not supported prior to 1.19");
    }

    public int getPaintingAsInt(Art type) {
        throw new IllegalArgumentException("Not supported prior to 1.19");
    }

    public Object getEntityTracker(Entity target) throws Exception {
        if (!NmsVersion.v1_14.isSupported()) {
            return this.getEntityTrackerEntry(target, null);
        }
        Object world = this.getWorldServer(target.getWorld());
        Object chunkProvider = chunkProviderField.get(world);
        Object chunkMap = chunkMapField.get(chunkProvider);
        Map trackedEntities = (Map)trackedEntitiesField.get(chunkMap);
        return trackedEntities.get(target.getEntityId());
    }

    public Object getEntityTrackerEntry(Entity target, Object entityTracker) throws Exception {
        if (NmsVersion.v1_14.isSupported()) {
            if (entityTracker == null) {
                return null;
            }
            return entityTrackerField.get(entityTracker);
        }
        if (entityTracker != null) {
            return entityTracker;
        }
        Object world = this.getWorldServer(target.getWorld());
        entityTracker = trackerField.get(world);
        Object trackedEntities = entitiesField.get(entityTracker);
        return ihmGet.invoke(trackedEntities, target.getEntityId());
    }

    protected Object getTrackerEntryFromTracker(Object tracker) throws Exception {
        throw new IllegalStateException("Method shouldn't be invoked");
    }

    public void addEntityTracker(Object trackedEntity, Object serverPlayer) {
        addEntityTracker.invoke(trackedEntity, serverPlayer);
    }

    public void clearEntityTracker(Object trackedEntity, Object serverPlayer) {
        clearEntityTracker.invoke(trackedEntity, serverPlayer);
    }

    public Set getTrackedEntities(Object trackedEntity) {
        return (Set)trackedPlayers.get(trackedEntity);
    }

    public Cat.Type getCatTypeFromInt(int catType) {
        return ReflectionManager.fromEnum(Cat.Type.class, catType);
    }

    public int getCatVariantAsInt(Cat.Type type) {
        return ReflectionManager.enumOrdinal(type);
    }

    public String getDataAsString(ItemStack itemStack) {
        NBTCompound nbt = DisguiseUtilities.fromBukkitItemStack(itemStack).getNBT();
        if (nbt == null) {
            return null;
        }
        return this.serialize((NBT)nbt);
    }

    private String serialize(NBT base) {
        return this.serialize(0, base);
    }

    private String serialize(int depth, NBT base) {
        if (base.getType() == NBTType.COMPOUND) {
            StringBuilder builder = new StringBuilder();
            builder.append("{");
            for (String key : ((NBTCompound)base).getTagNames()) {
                NBT nbt = ((NBTCompound)base).getTagOrThrow(key);
                String val = this.serialize(depth + 1, nbt);
                if (depth == 0 && val.matches("0(\\.0)?")) continue;
                if (builder.length() > 1) {
                    builder.append(",");
                }
                builder.append(key).append(":").append(val);
            }
            builder.append("}");
            return builder.toString();
        }
        if (base.getType() == NBTType.LIST) {
            ArrayList<String> serialized = new ArrayList<String>();
            for (NBT something : ((NBTList)base).getTags()) {
                serialized.add(this.serialize(depth + 1, something));
            }
            return "[" + StringUtils.join(serialized, (String)",") + "]";
        }
        if (base.getType() == NBTType.BYTE_ARRAY) {
            NBTByteArray byteArray = (NBTByteArray)base;
            ArrayList<String> bytes = new ArrayList<String>();
            for (byte b : byteArray.getValue()) {
                bytes.add(String.valueOf(b));
            }
            return "[B;" + String.join((CharSequence)",", bytes) + "]";
        }
        if (base.getType() == NBTType.INT_ARRAY) {
            NBTIntArray byteArray = (NBTIntArray)base;
            ArrayList<String> bytes = new ArrayList<String>();
            for (int b : byteArray.getValue()) {
                bytes.add(String.valueOf(b));
            }
            return "[I;" + String.join((CharSequence)",", bytes) + "]";
        }
        if (base.getType() == NBTType.LONG_ARRAY) {
            NBTLongArray byteArray = (NBTLongArray)base;
            ArrayList<String> bytes = new ArrayList<String>();
            for (long b : byteArray.getValue()) {
                bytes.add(String.valueOf(b));
            }
            return "[L;" + String.join((CharSequence)",", bytes) + "]";
        }
        if (base.getType() == NBTType.BYTE || base.getType() == NBTType.INT || base.getType() == NBTType.LONG || base.getType() == NBTType.FLOAT || base.getType() == NBTType.SHORT || base.getType() == NBTType.DOUBLE) {
            NBTNumber number = (NBTNumber)base;
            return number.getAsNumber().toString();
        }
        if (base.getType() == NBTType.STRING) {
            String val = ((NBTString)base).getValue();
            return "\"" + val.replace("\\", "\\\\").replace("\"", "\\\"") + "\"";
        }
        if (base.getType() == NBTType.END) {
            return "";
        }
        throw new IllegalArgumentException();
    }
}

