/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.reflection;

import com.github.retrooper.packetevents.protocol.entity.data.EntityData;
import com.github.retrooper.packetevents.protocol.entity.data.EntityDataType;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import org.bukkit.entity.Entity;

public class WatcherValue {
    private final MetaIndex metaIndex;
    private final EntityDataType dataType;
    private final int index;
    private boolean bukkitReadable;
    private Object value;

    public WatcherValue(EntityData entityData) {
        this.metaIndex = null;
        this.dataType = entityData.getType();
        this.index = entityData.getIndex();
        this.value = entityData.getValue();
        this.bukkitReadable = false;
    }

    public WatcherValue(MetaIndex index, Object value, boolean bukkitReadable) {
        this.dataType = index.getDataType();
        this.index = index.getIndex();
        this.metaIndex = index;
        this.value = value;
        this.bukkitReadable = bukkitReadable;
    }

    public EntityData getDataValue() {
        return ReflectionManager.getEntityData(this.getMetaIndex(), this.getValue(), this.isBukkitReadable());
    }

    public static List<WatcherValue> getValues(Entity entity) {
        ArrayList<WatcherValue> list = new ArrayList<WatcherValue>();
        for (EntityData data : ReflectionManager.getEntityWatcher(entity)) {
            list.add(new WatcherValue(data));
        }
        return list;
    }

    @Generated
    public MetaIndex getMetaIndex() {
        return this.metaIndex;
    }

    @Generated
    public EntityDataType getDataType() {
        return this.dataType;
    }

    @Generated
    public int getIndex() {
        return this.index;
    }

    @Generated
    public boolean isBukkitReadable() {
        return this.bukkitReadable;
    }

    @Generated
    public Object getValue() {
        return this.value;
    }

    @Generated
    public void setBukkitReadable(boolean bukkitReadable) {
        this.bukkitReadable = bukkitReadable;
    }

    @Generated
    public void setValue(Object value) {
        this.value = value;
    }
}

