/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.watchers.AgeableWatcher;
import me.libraryaddict.disguise.utilities.parser.RandomDefaultValue;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.reflection.annotations.MethodOnlyUsedBy;
import me.libraryaddict.disguise.utilities.reflection.annotations.NmsAddedIn;
import org.bukkit.entity.Panda;

@NmsAddedIn(value=NmsVersion.v1_14)
public class PandaWatcher
extends AgeableWatcher {
    public PandaWatcher(Disguise disguise) {
        super(disguise);
        if (DisguiseConfig.isRandomDisguises()) {
            this.setGenes(ReflectionManager.randomEnum(Panda.Gene.class), ReflectionManager.randomEnum(Panda.Gene.class));
        }
    }

    public Panda.Gene getGene() {
        return this.getMainGene();
    }

    @RandomDefaultValue
    public void setGene(Panda.Gene gene) {
        this.setMainGene(gene);
        this.setHiddenGene(gene);
    }

    public void setGenes(Panda.Gene mainGene, Panda.Gene hiddenGene) {
        this.setData(MetaIndex.PANDA_MAIN_GENE, mainGene);
        this.setData(MetaIndex.PANDA_HIDDEN_GENE, hiddenGene);
        this.sendData(MetaIndex.PANDA_MAIN_GENE, MetaIndex.PANDA_HIDDEN_GENE);
    }

    public Panda.Gene getMainGene() {
        return this.getData(MetaIndex.PANDA_MAIN_GENE);
    }

    @MethodOnlyUsedBy(value={})
    public void setMainGene(Panda.Gene gene) {
        this.sendData(MetaIndex.PANDA_MAIN_GENE, gene);
    }

    public Panda.Gene getHiddenGene() {
        return this.getData(MetaIndex.PANDA_HIDDEN_GENE);
    }

    @MethodOnlyUsedBy(value={})
    public void setHiddenGene(Panda.Gene gene) {
        this.sendData(MetaIndex.PANDA_HIDDEN_GENE, gene);
    }

    public boolean isSneeze() {
        return this.getPandaFlag(2);
    }

    public void setSneeze(boolean value) {
        this.setPandaFlag(2, value);
    }

    public boolean isTumble() {
        return this.getPandaFlag(4);
    }

    public void setTumble(boolean value) {
        this.setPandaFlag(4, value);
    }

    public boolean isSitting() {
        return this.getPandaFlag(8);
    }

    public void setSitting(boolean value) {
        this.setPandaFlag(8, value);
    }

    @Override
    public boolean isUpsideDown() {
        return this.getPandaFlag(16);
    }

    @Override
    public void setUpsideDown(boolean value) {
        this.setPandaFlag(16, value);
    }

    public int getHeadShaking() {
        return this.getHeadShakingTicks();
    }

    public void setHeadShaking(int timeInTicks) {
        this.sendData(MetaIndex.PANDA_HEAD_SHAKING, timeInTicks);
    }

    @Deprecated
    public int getHeadShakingTicks() {
        return this.getData(MetaIndex.PANDA_HEAD_SHAKING);
    }

    private boolean getPandaFlag(int value) {
        return (this.getData(MetaIndex.PANDA_META) & value) != 0;
    }

    private void setPandaFlag(int no, boolean flag) {
        byte b1 = this.getData(MetaIndex.PANDA_META);
        b1 = flag ? (byte)(b1 | no) : (byte)(b1 & ~no);
        this.sendData(MetaIndex.PANDA_META, b1);
    }
}

