/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.packets.packethandlers;

import com.github.retrooper.packetevents.protocol.entity.EntityPositionData;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.packettype.PacketTypeCommon;
import com.github.retrooper.packetevents.util.Vector3d;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityPositionSync;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityRelativeMove;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityRelativeMoveAndRotation;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityRotation;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityStatus;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityTeleport;
import java.util.HashMap;
import java.util.Iterator;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.watchers.GridLockedWatcher;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.packets.IPacketHandler;
import me.libraryaddict.disguise.utilities.packets.LibsPackets;
import org.apache.commons.lang.math.RandomUtils;
import org.bukkit.Location;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class PacketHandlerMovement<T extends PacketWrapper<T>>
implements IPacketHandler<T> {
    private final boolean invalid = LibsPremium.getUserID().matches("\\d+") && Integer.parseInt(LibsPremium.getUserID()) < 2;

    @Override
    public PacketTypeCommon[] getHandledPackets() {
        return new PacketTypeCommon[]{PacketType.Play.Server.ENTITY_RELATIVE_MOVE_AND_ROTATION, PacketType.Play.Server.ENTITY_ROTATION, PacketType.Play.Server.ENTITY_TELEPORT, PacketType.Play.Server.ENTITY_RELATIVE_MOVE, PacketType.Play.Server.ENTITY_POSITION_SYNC};
    }

    @Override
    public void handle(Disguise disguise, LibsPackets<T> packets, Player observer, Entity entity) {
        this.handleMovement(disguise, packets, observer, entity);
        DisguiseUtilities.adjustNamePositions(disguise, packets);
    }

    private void handleMovement(Disguise disguise, LibsPackets<T> packets, Player observer, Entity entity) {
        if (this.invalid && RandomUtils.nextDouble() < 0.1) {
            packets.clear();
            return;
        }
        T sentPacket = packets.getOriginalPacket();
        double yMod = DisguiseUtilities.getYModifier(disguise) + (double)disguise.getWatcher().getYModifier();
        if (disguise.getWatcher() instanceof GridLockedWatcher && ((GridLockedWatcher)((Object)disguise.getWatcher())).isGridLocked()) {
            this.handleGridLock(disguise, packets, entity, (PacketWrapper)sentPacket, yMod);
            return;
        }
        if (disguise.getType() == DisguiseType.RABBIT && (sentPacket instanceof WrapperPlayServerEntityRelativeMove || sentPacket instanceof WrapperPlayServerEntityRelativeMoveAndRotation)) {
            this.handleRabbitHop(packets, observer, entity);
        }
        if (sentPacket instanceof WrapperPlayServerEntityRotation && disguise.getType() == DisguiseType.WITHER_SKULL) {
            packets.clear();
        } else {
            this.handleRemainingMovement(disguise, packets, observer, entity, (PacketWrapper)sentPacket, yMod);
        }
    }

    private void handleRemainingMovement(Disguise disguise, LibsPackets<T> packets, Player observer, Entity entity, PacketWrapper sentPacket, double yMod) {
        if (!(sentPacket instanceof WrapperPlayServerEntityRelativeMove)) {
            WrapperPlayServerEntityRelativeMoveAndRotation rot;
            WrapperPlayServerEntityTeleport cloned;
            WrapperPlayServerEntityTeleport tele;
            packets.clear();
            float yawValue = this.getYaw(disguise, entity, sentPacket);
            float pitchValue = this.getPitch(disguise, entity, sentPacket);
            if (sentPacket instanceof WrapperPlayServerEntityTeleport) {
                tele = (WrapperPlayServerEntityTeleport)sentPacket;
                cloned = new WrapperPlayServerEntityTeleport(tele.getEntityId(), tele.getPosition(), yawValue, pitchValue, tele.isOnGround());
            } else if (sentPacket instanceof WrapperPlayServerEntityRelativeMoveAndRotation) {
                rot = (WrapperPlayServerEntityRelativeMoveAndRotation)sentPacket;
                cloned = new WrapperPlayServerEntityRelativeMoveAndRotation(rot.getEntityId(), rot.getDeltaX(), rot.getDeltaY(), rot.getDeltaZ(), yawValue, pitchValue, rot.isOnGround());
            } else if (sentPacket instanceof WrapperPlayServerEntityRotation) {
                rot = (WrapperPlayServerEntityRotation)sentPacket;
                cloned = new WrapperPlayServerEntityRotation(rot.getEntityId(), yawValue, pitchValue, rot.isOnGround());
            } else if (sentPacket instanceof WrapperPlayServerEntityPositionSync) {
                WrapperPlayServerEntityPositionSync sync = (WrapperPlayServerEntityPositionSync)sentPacket;
                EntityPositionData values = DisguiseUtilities.clone(sync.getValues());
                values.setYaw(yawValue);
                values.setPitch(pitchValue);
                cloned = new WrapperPlayServerEntityPositionSync(sync.getId(), values, sync.isOnGround());
            } else {
                throw new IllegalStateException("Unknown packet " + sentPacket.getClass());
            }
            packets.addPacket((PacketWrapper)cloned);
            if (entity == observer.getVehicle() && AbstractHorse.class.isAssignableFrom(disguise.getType().getEntityClass())) {
                WrapperPlayServerEntityRotation packet = new WrapperPlayServerEntityRotation(DisguiseAPI.getEntityAttachmentId(), yawValue, pitchValue, false);
                packets.addPacket((PacketWrapper)packet);
            } else if (cloned instanceof WrapperPlayServerEntityTeleport && disguise.getType().isArtDisplay()) {
                tele = cloned;
                Location loc = entity.getLocation();
                double data = (loc.getYaw() % 360.0f + 720.0f + 45.0f) / 90.0f % 4.0f;
                if (data % 2.0 == 0.0) {
                    tele.setPosition(new Vector3d(loc.getX(), 0.0, loc.getZ() + data == 0.0 ? -1.0 : 1.0));
                } else {
                    tele.setPosition(new Vector3d(loc.getX() + data == 3.0 ? -1.0 : 1.0, loc.getY(), loc.getZ()));
                }
                double y = DisguiseUtilities.getYModifier(disguise);
                if (y != 0.0) {
                    tele.setPosition(tele.getPosition().add(0.0, y, 0.0));
                }
            } else if (disguise.getType() == DisguiseType.DOLPHIN) {
                if (cloned instanceof WrapperPlayServerEntityTeleport) {
                    cloned.setOnGround(false);
                } else if (cloned instanceof WrapperPlayServerEntityRelativeMoveAndRotation) {
                    ((WrapperPlayServerEntityRelativeMoveAndRotation)cloned).setOnGround(false);
                } else if (cloned instanceof WrapperPlayServerEntityRotation) {
                    ((WrapperPlayServerEntityRotation)cloned).setOnGround(false);
                } else if (cloned instanceof WrapperPlayServerEntityPositionSync) {
                    ((WrapperPlayServerEntityPositionSync)cloned).setOnGround(false);
                }
            }
        } else if (disguise.getType() == DisguiseType.DOLPHIN) {
            packets.clear();
            WrapperPlayServerEntityRelativeMove p = (WrapperPlayServerEntityRelativeMove)sentPacket;
            WrapperPlayServerEntityRelativeMove cloned = new WrapperPlayServerEntityRelativeMove(p.getEntityId(), p.getDeltaX(), p.getDeltaY(), p.getDeltaZ(), false);
            packets.addPacket((PacketWrapper)cloned);
        }
        if (yMod != 0.0) {
            if (sentPacket instanceof WrapperPlayServerEntityTeleport) {
                PacketWrapper packet = packets.getPackets().get(0);
                WrapperPlayServerEntityTeleport tele = (WrapperPlayServerEntityTeleport)packet;
                if (packet == sentPacket) {
                    packet = new WrapperPlayServerEntityTeleport(tele.getEntityId(), tele.getPosition().add(0.0, yMod, 0.0), tele.getYaw(), tele.getPitch(), tele.isOnGround());
                    packets.clear();
                    packets.addPacket(packet);
                } else {
                    tele.setPosition(tele.getPosition().add(0.0, yMod, 0.0));
                }
            } else if (sentPacket instanceof WrapperPlayServerEntityPositionSync) {
                WrapperPlayServerEntityPositionSync sync = (WrapperPlayServerEntityPositionSync)packets.getPackets().get(0);
                if (sync == sentPacket) {
                    sync = new WrapperPlayServerEntityPositionSync(sync.getId(), DisguiseUtilities.clone(sync.getValues()), sync.isOnGround());
                    packets.clear();
                    packets.addPacket((PacketWrapper)sync);
                } else {
                    sync.getValues().setPosition(sync.getValues().getPosition().add(0.0, yMod, 0.0));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRabbitHop(LibsPackets<T> packets, Player observer, Entity entity) {
        PacketHandlerMovement packetHandlerMovement = this;
        synchronized (packetHandlerMovement) {
            long lastHop;
            HashMap<String, Long> rabbitHops;
            if (!entity.getMetadata("LibsRabbitHop").isEmpty()) {
                rabbitHops = (HashMap<String, Long>)((MetadataValue)entity.getMetadata("LibsRabbitHop").get(0)).value();
                Iterator iterator = rabbitHops.entrySet().iterator();
                while (iterator.hasNext()) {
                    if ((Long)iterator.next().getValue() + 500L > System.currentTimeMillis()) continue;
                    iterator.remove();
                }
            } else {
                rabbitHops = new HashMap<String, Long>();
                entity.setMetadata("LibsRabbitHop", (MetadataValue)new FixedMetadataValue((Plugin)LibsDisguises.getInstance(), rabbitHops));
            }
            long l = lastHop = rabbitHops.containsKey(observer.getName()) ? System.currentTimeMillis() - (Long)rabbitHops.get(observer.getName()) : 99999L;
            if (lastHop < 100L || lastHop > 500L) {
                if (lastHop > 500L) {
                    rabbitHops.put(observer.getName(), System.currentTimeMillis());
                }
                packets.addPacket((PacketWrapper)new WrapperPlayServerEntityStatus(entity.getEntityId(), 1));
            }
        }
    }

    private float getYaw(Disguise disguise, Entity entity, PacketWrapper sentPacket) {
        WrapperPlayServerEntityRelativeMoveAndRotation rot;
        float yawValue;
        if (sentPacket instanceof WrapperPlayServerEntityRelativeMove) {
            return 0.0f;
        }
        if (sentPacket instanceof WrapperPlayServerEntityTeleport) {
            WrapperPlayServerEntityTeleport tele = (WrapperPlayServerEntityTeleport)sentPacket;
            yawValue = tele.getYaw();
        } else if (sentPacket instanceof WrapperPlayServerEntityRelativeMoveAndRotation) {
            rot = (WrapperPlayServerEntityRelativeMoveAndRotation)sentPacket;
            yawValue = rot.getYaw();
        } else if (sentPacket instanceof WrapperPlayServerEntityRotation) {
            rot = (WrapperPlayServerEntityRotation)sentPacket;
            yawValue = rot.getYaw();
        } else if (sentPacket instanceof WrapperPlayServerEntityPositionSync) {
            WrapperPlayServerEntityPositionSync sync = (WrapperPlayServerEntityPositionSync)sentPacket;
            yawValue = sync.getValues().getYaw();
        } else {
            throw new IllegalStateException("Didn't handle packet " + sentPacket.getClass());
        }
        Float yawLock = disguise.getWatcher().getYawLock();
        yawValue = yawLock != null ? DisguiseUtilities.getYaw(disguise.getType(), yawLock.floatValue()) : DisguiseUtilities.getYaw(disguise.getType(), entity.getType(), yawValue);
        return yawValue;
    }

    private float getPitch(Disguise disguise, Entity entity, PacketWrapper sentPacket) {
        WrapperPlayServerEntityRelativeMoveAndRotation rot;
        float pitchValue;
        if (sentPacket instanceof WrapperPlayServerEntityRelativeMove) {
            return 0.0f;
        }
        if (sentPacket instanceof WrapperPlayServerEntityTeleport) {
            WrapperPlayServerEntityTeleport tele = (WrapperPlayServerEntityTeleport)sentPacket;
            pitchValue = tele.getPitch();
        } else if (sentPacket instanceof WrapperPlayServerEntityRelativeMoveAndRotation) {
            rot = (WrapperPlayServerEntityRelativeMoveAndRotation)sentPacket;
            pitchValue = rot.getPitch();
        } else if (sentPacket instanceof WrapperPlayServerEntityRotation) {
            rot = (WrapperPlayServerEntityRotation)sentPacket;
            pitchValue = rot.getPitch();
        } else if (sentPacket instanceof WrapperPlayServerEntityPositionSync) {
            WrapperPlayServerEntityPositionSync sync = (WrapperPlayServerEntityPositionSync)sentPacket;
            pitchValue = sync.getValues().getPitch();
        } else {
            throw new IllegalStateException("Didn't handle packet " + sentPacket.getClass());
        }
        Float pitchLock = disguise.getWatcher().getPitchLock();
        pitchValue = pitchLock != null ? DisguiseUtilities.getPitch(disguise.getType(), pitchLock.floatValue()) : DisguiseUtilities.getPitch(disguise.getType(), entity.getType(), pitchValue);
        return pitchValue;
    }

    private void handleGridLock(Disguise disguise, LibsPackets<T> packets, Entity entity, PacketWrapper sentPacket, double yMod) {
        WrapperPlayServerEntityTeleport movePacket;
        packets.clear();
        float pitchValue = this.getPitch(disguise, entity, sentPacket);
        float yawValue = this.getYaw(disguise, entity, sentPacket);
        if (sentPacket instanceof WrapperPlayServerEntityRotation) {
            WrapperPlayServerEntityRotation rot = (WrapperPlayServerEntityRotation)sentPacket;
            if (rot.getYaw() != yawValue || rot.getPitch() != pitchValue) {
                packets.clear();
                packets.addPacket((PacketWrapper)new WrapperPlayServerEntityRotation(rot.getEntityId(), yawValue, pitchValue, rot.isOnGround()));
            }
            return;
        }
        GridLockedWatcher watcher = (GridLockedWatcher)((Object)disguise.getWatcher());
        Location loc = entity.getLocation();
        if (sentPacket instanceof WrapperPlayServerEntityTeleport) {
            WrapperPlayServerEntityTeleport tele = (WrapperPlayServerEntityTeleport)sentPacket;
            double x = GridLockedWatcher.center(loc.getX(), watcher.getWidthX());
            double y = (double)loc.getBlockY() + (loc.getY() % 1.0 >= 0.85 ? 1.0 : (loc.getY() % 1.0 >= 0.35 ? 0.5 : 0.0));
            double z = GridLockedWatcher.center(loc.getZ(), watcher.getWidthZ());
            movePacket = new WrapperPlayServerEntityTeleport(tele.getEntityId(), new Vector3d(x, y + yMod, z), yawValue, pitchValue, tele.isOnGround());
        } else if (sentPacket instanceof WrapperPlayServerEntityPositionSync) {
            WrapperPlayServerEntityPositionSync sync = (WrapperPlayServerEntityPositionSync)sentPacket;
            double x = GridLockedWatcher.center(loc.getX(), watcher.getWidthX());
            double y = (double)loc.getBlockY() + (loc.getY() % 1.0 >= 0.85 ? 1.0 : (loc.getY() % 1.0 >= 0.35 ? 0.5 : 0.0));
            double z = GridLockedWatcher.center(loc.getZ(), watcher.getWidthZ());
            EntityPositionData cloned = DisguiseUtilities.clone(sync.getValues());
            cloned.setPosition(new Vector3d(x, y + yMod, z));
            cloned.setYaw(yawValue);
            cloned.setPitch(pitchValue);
            movePacket = new WrapperPlayServerEntityPositionSync(sync.getId(), cloned, sync.isOnGround());
        } else {
            boolean sameBlock;
            double z;
            double y;
            double x;
            WrapperPlayServerEntityRelativeMoveAndRotation rot;
            float oldYaw = yawValue;
            float oldPitch = pitchValue;
            if (sentPacket instanceof WrapperPlayServerEntityRelativeMoveAndRotation) {
                rot = (WrapperPlayServerEntityRelativeMoveAndRotation)sentPacket;
                x = rot.getDeltaX();
                y = rot.getDeltaY();
                z = rot.getDeltaZ();
                oldYaw = yawValue;
                oldPitch = pitchValue;
            } else if (sentPacket instanceof WrapperPlayServerEntityRelativeMove) {
                rot = (WrapperPlayServerEntityRelativeMove)sentPacket;
                x = rot.getDeltaX();
                y = rot.getDeltaY();
                z = rot.getDeltaZ();
            } else {
                throw new IllegalStateException("Unknown packet " + sentPacket.getClass());
            }
            Location oldLoc = loc.clone().subtract(x, y, z);
            double oldY = (double)oldLoc.getBlockY() + (oldLoc.getY() % 1.0 >= 0.85 ? 1.0 : (oldLoc.getY() % 1.0 >= 0.35 ? 0.5 : 0.0));
            double newY = (double)loc.getBlockY() + (loc.getY() % 1.0 >= 0.85 ? 1.0 : (loc.getY() % 1.0 >= 0.35 ? 0.5 : 0.0));
            double oldX = GridLockedWatcher.center(oldLoc.getX(), watcher.getWidthX());
            double oldZ = GridLockedWatcher.center(oldLoc.getZ(), watcher.getWidthZ());
            double newX = GridLockedWatcher.center(loc.getX(), watcher.getWidthX());
            double newZ = GridLockedWatcher.center(loc.getZ(), watcher.getWidthZ());
            boolean bl = sameBlock = oldX == newX && oldZ == newZ && newY == oldY && oldYaw == yawValue && oldPitch == pitchValue;
            if (sameBlock) {
                return;
            }
            x = newX - oldX;
            y = newY - oldY;
            z = newZ - oldZ;
            if (sentPacket instanceof WrapperPlayServerEntityRelativeMoveAndRotation) {
                WrapperPlayServerEntityRelativeMoveAndRotation rot2 = (WrapperPlayServerEntityRelativeMoveAndRotation)sentPacket;
                movePacket = new WrapperPlayServerEntityRelativeMoveAndRotation(rot2.getEntityId(), x, y, z, yawValue, pitchValue, rot2.isOnGround());
            } else if (sentPacket instanceof WrapperPlayServerEntityRelativeMove) {
                WrapperPlayServerEntityRelativeMove rot3 = (WrapperPlayServerEntityRelativeMove)sentPacket;
                movePacket = new WrapperPlayServerEntityRelativeMove(rot3.getEntityId(), x, y, z, rot3.isOnGround());
            } else {
                throw new IllegalStateException("Unknown packet " + sentPacket.getClass());
            }
        }
        packets.addPacket((PacketWrapper)movePacket);
    }
}

