/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.packets.packetlisteners;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketListenerPriority;
import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.event.SimplePacketListenerAbstract;
import com.github.retrooper.packetevents.event.simple.PacketPlaySendEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.world.Location;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerDestroyEntities;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityPositionSync;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityRelativeMove;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityRelativeMoveAndRotation;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityTeleport;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSetPassengers;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;

public class PacketListenerVehicleMovement
extends SimplePacketListenerAbstract
implements Listener {
    private final Map<UUID, PlayerTracker> trackerMap = new HashMap<UUID, PlayerTracker>();

    public PacketListenerVehicleMovement() {
        super(PacketListenerPriority.LOW);
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        this.trackerMap.remove(event.getPlayer().getUniqueId());
    }

    private void refreshPosition(Player observer, int entityId) {
        this.refreshPosition(observer, entityId, null);
    }

    private void refreshPosition(Player observer, int entityId, PacketWrapper sentPacket) {
        List<PacketWrapper> wrappers;
        Disguise disguise = DisguiseUtilities.getDisguise(observer, entityId);
        if (disguise == null || disguise.getArmorstandIds().length == 0) {
            return;
        }
        Entity entity = disguise.getEntity();
        if (entity == null || !entity.isValid()) {
            return;
        }
        org.bukkit.Location loc = entity.getLocation();
        if (sentPacket == null) {
            sentPacket = new WrapperPlayServerEntityTeleport(entityId, new Location(loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch()), true);
        }
        if ((wrappers = DisguiseUtilities.adjustNamePositions(disguise, Collections.singletonList(sentPacket))) == null) {
            return;
        }
        for (PacketWrapper wrapper : wrappers) {
            PacketEvents.getAPI().getPlayerManager().sendPacketSilently((Object)observer, wrapper);
        }
    }

    private void refreshPassengersRecursive(Map<Integer, int[]> vehicleAndPassengersId, int[] passengers, Map<Integer, Boolean> map) {
        for (int entityId : passengers) {
            if (map.containsKey(entityId)) continue;
            map.put(entityId, true);
            int[] mounted = vehicleAndPassengersId.get(entityId);
            if (mounted == null) continue;
            this.refreshPassengersRecursive(vehicleAndPassengersId, mounted, map);
        }
    }

    private void updatePassengersRecursive(int depth, Player player, PlayerTracker tracker, int[] passengers, PacketWrapper wrapper) {
        if (depth > 15) {
            return;
        }
        for (int entityId : passengers) {
            this.refreshPosition(player, entityId, wrapper);
            int[] newPassengers = (int[])tracker.vehicleAndPassengersId.get(entityId);
            if (newPassengers == null) continue;
            this.updatePassengersRecursive(depth++, player, tracker, newPassengers, wrapper);
        }
    }

    public void onPacketPlaySend(PacketPlaySendEvent event) {
        Player player = (Player)event.getPlayer();
        if (player == null) {
            return;
        }
        if (event.getPacketType() == PacketType.Play.Server.SET_PASSENGERS) {
            WrapperPlayServerSetPassengers packet = event.getLastUsedWrapper() != null ? (WrapperPlayServerSetPassengers)event.getLastUsedWrapper() : new WrapperPlayServerSetPassengers((PacketSendEvent)event);
            PlayerTracker tracker = this.trackerMap.get(player.getUniqueId());
            int[] mountedNow = packet.getPassengers();
            if (tracker == null) {
                if (mountedNow.length == 0) {
                    return;
                }
                tracker = new PlayerTracker();
                this.trackerMap.put(player.getUniqueId(), tracker);
            }
            int[] mountedPrevious = (int[])tracker.vehicleAndPassengersId.get(packet.getEntityId());
            if (packet.getPassengers().length == 0) {
                tracker.vehicleAndPassengersId.remove(packet.getEntityId());
            } else {
                tracker.vehicleAndPassengersId.put(packet.getEntityId(), mountedNow);
            }
            if (mountedPrevious != null) {
                block0: for (int entityId : mountedPrevious) {
                    boolean stillRiding = false;
                    int[] nArray = mountedNow;
                    int n = nArray.length;
                    for (int i = 0; i < n; ++i) {
                        int ridingId = nArray[i];
                        if (entityId == ridingId) continue block0;
                    }
                    this.refreshPosition(player, entityId);
                }
                block2: for (int ridingId : mountedNow) {
                    for (int entityId : mountedNow) {
                        if (entityId == ridingId) continue block2;
                    }
                    this.refreshPosition(player, ridingId);
                }
            } else {
                for (int entityId : mountedNow) {
                    this.refreshPosition(player, entityId);
                }
            }
        } else if (event.getPacketType() == PacketType.Play.Server.DESTROY_ENTITIES) {
            PlayerTracker tracker = this.trackerMap.get(player.getUniqueId());
            if (tracker == null) {
                return;
            }
            int[] ids = event.getLastUsedWrapper() != null ? ((WrapperPlayServerDestroyEntities)event.getLastUsedWrapper()).getEntityIds() : new WrapperPlayServerDestroyEntities((PacketSendEvent)event).getEntityIds();
            HashMap<Integer, Boolean> toRefresh = new HashMap<Integer, Boolean>();
            for (int entityId : ids) {
                toRefresh.put(entityId, false);
            }
            for (int entityId : ids) {
                int[] passengers = (int[])tracker.vehicleAndPassengersId.remove(entityId);
                if (passengers == null) continue;
                this.refreshPassengersRecursive(tracker.vehicleAndPassengersId, passengers, toRefresh);
            }
            Object mountedPrevious = toRefresh.entrySet().iterator();
            while (mountedPrevious.hasNext()) {
                Map.Entry entry = (Map.Entry)mountedPrevious.next();
                if (!((Boolean)entry.getValue()).booleanValue()) continue;
                this.refreshPosition(player, (Integer)entry.getKey());
            }
        } else if (event.getPacketType() == PacketType.Play.Server.ENTITY_TELEPORT || event.getPacketType() == PacketType.Play.Server.ENTITY_RELATIVE_MOVE || event.getPacketType() == PacketType.Play.Server.ENTITY_RELATIVE_MOVE_AND_ROTATION || event.getPacketType() == PacketType.Play.Server.ENTITY_POSITION_SYNC) {
            int entityId;
            PlayerTracker tracker = this.trackerMap.get(player.getUniqueId());
            if (tracker == null || tracker.vehicleAndPassengersId.isEmpty()) {
                return;
            }
            PacketWrapper wrapper = event.getLastUsedWrapper();
            if (wrapper == null) {
                if (event.getPacketType() == PacketType.Play.Server.ENTITY_TELEPORT) {
                    wrapper = new WrapperPlayServerEntityTeleport((PacketSendEvent)event);
                    entityId = ((WrapperPlayServerEntityTeleport)wrapper).getEntityId();
                } else if (event.getPacketType() == PacketType.Play.Server.ENTITY_RELATIVE_MOVE) {
                    wrapper = new WrapperPlayServerEntityRelativeMove((PacketSendEvent)event);
                    entityId = ((WrapperPlayServerEntityRelativeMove)wrapper).getEntityId();
                } else if (event.getPacketType() == PacketType.Play.Server.ENTITY_RELATIVE_MOVE_AND_ROTATION) {
                    wrapper = new WrapperPlayServerEntityRelativeMoveAndRotation((PacketSendEvent)event);
                    entityId = ((WrapperPlayServerEntityRelativeMoveAndRotation)wrapper).getEntityId();
                } else {
                    wrapper = new WrapperPlayServerEntityPositionSync((PacketSendEvent)event);
                    entityId = ((WrapperPlayServerEntityPositionSync)wrapper).getId();
                }
            } else {
                entityId = DisguiseUtilities.getEntityId(wrapper);
            }
            int[] passengers = (int[])tracker.vehicleAndPassengersId.get(entityId);
            if (passengers == null) {
                return;
            }
            this.updatePassengersRecursive(0, player, tracker, passengers, wrapper);
        } else if (event.getPacketType() == PacketType.Play.Server.RESPAWN) {
            this.trackerMap.remove(player.getUniqueId());
        }
    }

    static class PlayerTracker {
        private final Map<Integer, int[]> vehicleAndPassengersId = new HashMap<Integer, int[]>();

        PlayerTracker() {
        }
    }
}

