/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.packets.packetlisteners;

import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.event.SimplePacketListenerAbstract;
import com.github.retrooper.packetevents.event.simple.PacketPlaySendEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.sound.Sound;
import com.github.retrooper.packetevents.protocol.sound.SoundCategory;
import com.github.retrooper.packetevents.protocol.sound.Sounds;
import com.github.retrooper.packetevents.resources.ResourceLocation;
import com.github.retrooper.packetevents.util.Vector3i;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntitySoundEffect;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSoundEffect;
import java.util.ArrayList;
import java.util.Set;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.MobDisguise;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.sounds.SoundGroup;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class PacketListenerSounds
extends SimplePacketListenerAbstract {
    public void onPacketPlaySend(PacketPlaySendEvent event) {
        Sound nSound;
        Sound sound;
        float pitch;
        float volume;
        SoundGroup group;
        Disguise disguise;
        WrapperPlayServerEntitySoundEffect entitySoundEffect;
        WrapperPlayServerSoundEffect soundEffect;
        Player observer;
        block21: {
            if (event.isCancelled()) {
                return;
            }
            if (event.getPacketType() != PacketType.Play.Server.ENTITY_SOUND_EFFECT && event.getPacketType() != PacketType.Play.Server.SOUND_EFFECT) {
                return;
            }
            observer = (Player)event.getPlayer();
            if (observer == null) {
                return;
            }
            soundEffect = null;
            entitySoundEffect = null;
            disguise = null;
            group = null;
            if (event.getPacketType() == PacketType.Play.Server.SOUND_EFFECT) {
                soundEffect = new WrapperPlayServerSoundEffect((PacketSendEvent)event);
                volume = soundEffect.getVolume();
                pitch = soundEffect.getPitch();
                sound = soundEffect.getSound();
                if (sound == null || sound.getSoundId() == null) {
                    event.setLastUsedWrapper(null);
                    return;
                }
                ResourceLocation soundKey = sound.getSoundId();
                Vector3i loc = soundEffect.getEffectPosition();
                for (Set<TargetedDisguise> disguises : new ArrayList<Set<TargetedDisguise>>(DisguiseUtilities.getDisguises().values())) {
                    for (TargetedDisguise entityDisguise : new ArrayList<TargetedDisguise>(disguises)) {
                        Entity entity = entityDisguise.getEntity();
                        if (entity == null || entity.getWorld() != observer.getWorld() || !entityDisguise.canSee(observer)) continue;
                        Location eLoc = entity.getLocation();
                        int[] entCords = new int[]{(int)(eLoc.getX() * 8.0), (int)(eLoc.getY() * 8.0), (int)(eLoc.getZ() * 8.0)};
                        if (Math.abs(loc.getX() - entCords[0]) > 2 || Math.abs(loc.getY() - entCords[1]) > 2 || Math.abs(loc.getZ() - entCords[2]) > 2 || (group = SoundGroup.getGroup(entity.getType().name())) == null || group.getSound(soundKey) == null) continue;
                        disguise = entityDisguise;
                        break block21;
                    }
                }
            } else {
                entitySoundEffect = new WrapperPlayServerEntitySoundEffect((PacketSendEvent)event);
                volume = entitySoundEffect.getVolume();
                pitch = entitySoundEffect.getPitch();
                sound = entitySoundEffect.getSound();
                if (sound == null) {
                    event.setLastUsedWrapper(null);
                    return;
                }
                disguise = DisguiseUtilities.getDisguise(observer, entitySoundEffect.getEntityId());
            }
        }
        if (disguise == null || !disguise.isSoundsReplaced()) {
            return;
        }
        Entity entity = disguise.getEntity();
        if (entity == observer && !disguise.isSelfDisguiseSoundsReplaced()) {
            return;
        }
        if (group == null) {
            group = SoundGroup.getGroup(entity.getType().name());
        }
        if (group == null) {
            return;
        }
        SoundGroup.SoundType soundType = group.getType(sound.getSoundId());
        if (soundType == null) {
            return;
        }
        SoundGroup disguiseSound = SoundGroup.getGroup(disguise);
        if (disguiseSound == null) {
            event.setCancelled(true);
            return;
        }
        ResourceLocation newSound = disguiseSound.getSound(soundType);
        if (newSound == null) {
            event.setCancelled(true);
            return;
        }
        if (volume == group.getDamageAndIdleSoundVolume()) {
            volume = disguiseSound.getDamageAndIdleSoundVolume();
        }
        if (disguise instanceof MobDisguise && entity instanceof LivingEntity && ((MobDisguise)disguise).doesDisguiseAge()) {
            pitch = ((MobDisguise)disguise).isAdult() ? (DisguiseUtilities.random.nextFloat() - DisguiseUtilities.random.nextFloat()) * 0.2f + 1.0f : (DisguiseUtilities.random.nextFloat() - DisguiseUtilities.random.nextFloat()) * 0.2f + 1.4f;
        }
        if ((nSound = Sounds.getByName((String)newSound.toString())) == null) {
            event.setCancelled(true);
            Location loc = entity.getLocation();
            observer.playSound(loc, NmsVersion.v1_16.isSupported() ? newSound.toString() : newSound.getKey(), volume, pitch);
            return;
        }
        SoundCategory soundCat = ReflectionManager.getSoundCategory(disguise.getType());
        if (soundEffect != null) {
            soundEffect.setSound(nSound);
            soundEffect.setVolume(volume);
            soundEffect.setPitch(pitch);
            soundEffect.setSoundCategory(soundCat);
        } else {
            entitySoundEffect.setSound(nSound);
            entitySoundEffect.setVolume(volume);
            entitySoundEffect.setPitch(pitch);
            entitySoundEffect.setSoundCategory(soundCat);
        }
        event.markForReEncode(true);
    }
}

