/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.event.simple.PacketPlaySendEvent;
import com.github.retrooper.packetevents.protocol.entity.EntityPositionData;
import com.github.retrooper.packetevents.protocol.entity.data.EntityData;
import com.github.retrooper.packetevents.protocol.entity.type.EntityTypes;
import com.github.retrooper.packetevents.protocol.item.enchantment.Enchantment;
import com.github.retrooper.packetevents.protocol.item.enchantment.type.EnchantmentType;
import com.github.retrooper.packetevents.protocol.item.enchantment.type.EnchantmentTypes;
import com.github.retrooper.packetevents.protocol.item.type.ItemTypes;
import com.github.retrooper.packetevents.protocol.mapper.MappedEntity;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.particle.Particle;
import com.github.retrooper.packetevents.protocol.player.Equipment;
import com.github.retrooper.packetevents.protocol.player.UserProfile;
import com.github.retrooper.packetevents.protocol.world.Direction;
import com.github.retrooper.packetevents.protocol.world.states.WrappedBlockState;
import com.github.retrooper.packetevents.util.Vector3d;
import com.github.retrooper.packetevents.util.adventure.AdventureSerializer;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerAttachEntity;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerCollectItem;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerDamageEvent;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerDestroyEntities;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityAnimation;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityEffect;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityEquipment;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityHeadLook;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityMetadata;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityMovement;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityPositionSync;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityRelativeMove;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityRelativeMoveAndRotation;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityRotation;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntitySoundEffect;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityStatus;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityTeleport;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityVelocity;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerPlayerInfo;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerPlayerInfoRemove;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerPlayerInfoUpdate;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerPlayerPositionAndLook;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerRemoveEntityEffect;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSpawnEntity;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSpawnExperienceOrb;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSpawnLivingEntity;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSpawnPainting;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSpawnPlayer;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerUpdateAttributes;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.PropertyMap;
import io.github.retrooper.packetevents.adventure.serializer.gson.GsonComponentSerializer;
import io.github.retrooper.packetevents.adventure.serializer.legacy.LegacyComponentSerializer;
import io.github.retrooper.packetevents.util.SpigotConversionUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import libsdisg.shaded.net.kyori.adventure.text.minimessage.MiniMessage;
import lombok.Generated;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.MobDisguise;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.AgeableWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.ArmorStandWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.TextDisplayWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.ZombieWatcher;
import me.libraryaddict.disguise.utilities.DisguiseValues;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.gson.SerializerBlockData;
import me.libraryaddict.disguise.utilities.gson.SerializerChatComponent;
import me.libraryaddict.disguise.utilities.gson.SerializerItemStack;
import me.libraryaddict.disguise.utilities.gson.SerializerMetaIndex;
import me.libraryaddict.disguise.utilities.gson.SerializerParticle;
import me.libraryaddict.disguise.utilities.gson.SerializerUserProfile;
import me.libraryaddict.disguise.utilities.gson.SerializerWrappedBlockData;
import me.libraryaddict.disguise.utilities.mineskin.MineSkinAPI;
import me.libraryaddict.disguise.utilities.packets.LibsPackets;
import me.libraryaddict.disguise.utilities.packets.PacketsManager;
import me.libraryaddict.disguise.utilities.params.ParamInfoManager;
import me.libraryaddict.disguise.utilities.parser.DisguiseParser;
import me.libraryaddict.disguise.utilities.reflection.FakeBoundingBox;
import me.libraryaddict.disguise.utilities.reflection.LibsProfileLookup;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.reflection.WatcherValue;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import me.libraryaddict.disguise.utilities.updates.PacketEventsUpdater;
import me.libraryaddict.disguise.utilities.watchers.CompileMethodsIntfer;
import me.libraryaddict.disguise.utilities.watchers.DisguiseMethods;
import net.kyori.adventure.text.Component;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.boss.KeyedBossBar;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zombie;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;

public class DisguiseUtilities {
    public static final Random random = new Random();
    private static final LinkedHashMap<String, Disguise> clonedDisguises = new LinkedHashMap();
    private static final List<Integer> isNoInteract = new ArrayList<Integer>();
    private static final List<Integer> isSpecialInteract = new ArrayList<Integer>();
    private static final Map<Integer, Set<TargetedDisguise>> disguises = new HashMap<Integer, Set<TargetedDisguise>>();
    private static final Map<Integer, HashSet<TargetedDisguise>> futureDisguises = new ConcurrentHashMap<Integer, HashSet<TargetedDisguise>>();
    private static final HashSet<UUID> savedDisguiseList = new HashSet();
    private static final HashSet<String> cachedNames = new HashSet();
    private static final HashMap<String, String> sanitySkinCacheMap = new LinkedHashMap<String, String>();
    private static final HashMap<String, ArrayList<Object>> runnables = new HashMap();
    private static final HashSet<UUID> selfDisguised = new HashSet();
    private static final File profileCache;
    private static final File sanitySkinCacheFile;
    private static final File savedDisguises;
    private static Gson gson;
    private static boolean pluginsUsed;
    private static boolean commandsUsed;
    private static boolean copyDisguiseCommandUsed;
    private static boolean grabSkinCommandUsed;
    private static boolean saveDisguiseCommandUsed;
    private static boolean grabHeadCommandUsed;
    private static long libsDisguisesCalled;
    private static final Cache<Integer, Long> velocityTimes;
    private static final HashMap<UUID, ArrayList<Integer>> disguiseLoading;
    private static boolean runningPaper;
    private static boolean runningGeyser;
    private static MineSkinAPI mineSkinAPI;
    private static boolean invalidFile;
    private static final char[] alphabet;
    private static final Pattern urlMatcher;
    private static final List<UUID> viewSelf;
    private static final List<UUID> viewBar;
    private static long lastSavedPreferences;
    private static final ConcurrentHashMap<String, DScoreTeam> teams;
    private static boolean criedOverJava16;
    private static final HashSet<UUID> warnedSkin;
    private static boolean fancyHiddenTabs;
    private static NamespacedKey oldSavedDisguisesKey;
    private static NamespacedKey savedDisguisesKey;
    private static final Map<org.bukkit.enchantments.Enchantment, EnchantmentType> whitelistedEnchantments;
    private static org.bukkit.enchantments.Enchantment durabilityEnchantment;
    private static org.bukkit.enchantments.Enchantment waterbreathingEnchantment;
    private static final EntityType entityItem;
    private static final MiniMessage miniMessage;
    private static final libsdisg.shaded.net.kyori.adventure.text.serializer.gson.GsonComponentSerializer internalComponentSerializer;
    private static final GsonComponentSerializer externalComponentSerializer;
    private static NamespacedKey selfDisguiseScaleNamespace;
    private static UUID selfDisguiseScaleUUID;
    private static Attribute scaleAttribute;
    private static boolean debuggingMode;
    private static final File internalFolder;
    private static final File internalFile;
    private static final File preferencesFile;

    public static boolean shouldBeHiddenSelfDisguise(com.github.retrooper.packetevents.protocol.item.ItemStack itemStack) {
        if (itemStack == null || itemStack.isEmpty() || itemStack.getType() == ItemTypes.AIR) {
            return false;
        }
        List enchants = itemStack.getEnchantments(PacketEvents.getAPI().getServerManager().getVersion().toClientVersion());
        for (Enchantment enchantment : enchants) {
            if (enchantment == null || !whitelistedEnchantments.containsValue(enchantment.getType())) continue;
            return false;
        }
        return true;
    }

    public static boolean shouldBeHiddenSelfDisguise(ItemStack itemStack) {
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return false;
        }
        Map enchants = itemStack.getEnchantments();
        for (org.bukkit.enchantments.Enchantment enchantment : enchants.keySet()) {
            if (!whitelistedEnchantments.containsKey(enchantment)) continue;
            return false;
        }
        return true;
    }

    public static boolean isDisguisesSelfScalingAttribute(AttributeModifier modifier) {
        if (NmsVersion.v1_21_R1.isSupported()) {
            return modifier.getKey().equals((Object)DisguiseUtilities.getSelfDisguiseScaleNamespace());
        }
        return modifier.getName().equals(DisguiseUtilities.getSelfDisguiseScaleNamespace().toString());
    }

    public static void removeSelfDisguiseScale(Entity entity) {
        if (!NmsVersion.v1_20_R4.isSupported() || DisguiseUtilities.isInvalidFile() || !(entity instanceof LivingEntity)) {
            return;
        }
        AttributeInstance attribute = ((LivingEntity)entity).getAttribute(DisguiseUtilities.getScaleAttribute());
        attribute.getModifiers().stream().filter(DisguiseUtilities::isDisguisesSelfScalingAttribute).forEach(arg_0 -> ((AttributeInstance)attribute).removeModifier(arg_0));
    }

    public static double getNameSpacing() {
        return 0.28;
    }

    public static String serialize(Component component) {
        return (String)AdventureSerializer.getGsonSerializer().serialize(component);
    }

    public static void doSkinUUIDWarning(CommandSender sender) {
        if (!(sender instanceof Player) || DisguiseConfig.getUUIDGeneratedVersion() == 3) {
            return;
        }
        UUID uuid = ((Player)sender).getUniqueId();
        if (uuid.version() == 4 || warnedSkin.contains(uuid)) {
            return;
        }
        warnedSkin.add(uuid);
        LibsMsg.SKIN_API_UUID_3.send(sender, new Object[0]);
    }

    public static void addSaveAttempt() {
        if (lastSavedPreferences + TimeUnit.SECONDS.toMillis(120L) > System.currentTimeMillis()) {
            return;
        }
        lastSavedPreferences = System.currentTimeMillis();
        new BukkitRunnable(){

            public void run() {
                DisguiseUtilities.saveViewPreferances();
            }
        }.runTaskLater((Plugin)LibsDisguises.getInstance(), 20L * TimeUnit.SECONDS.toMillis(120L));
    }

    public static String getDisplayName(CommandSender commandSender) {
        String name;
        if (commandSender == null) {
            return "???";
        }
        if (!(commandSender instanceof Player)) {
            return commandSender.getName();
        }
        Player player = (Player)commandSender;
        Team team = player.getScoreboard().getEntryTeam(commandSender.getName());
        if (team == null) {
            team = player.getScoreboard().getEntryTeam(player.getUniqueId().toString());
        }
        if (team == null || StringUtils.isEmpty((String)team.getPrefix()) && StringUtils.isEmpty((String)team.getSuffix())) {
            if (DisguiseUtilities.isRunningPaper() && NmsVersion.v1_16.isSupported()) {
                name = DisguiseUtilities.toMiniMessage(player.displayName());
                if (name.equals(player.getName())) {
                    name = DisguiseUtilities.toMiniMessage(player.playerListName());
                }
            } else {
                name = player.getDisplayName();
                if (name.equals(player.getName())) {
                    name = player.getPlayerListName();
                }
            }
        } else {
            name = DisguiseUtilities.isRunningPaper() && NmsVersion.v1_16.isSupported() ? DisguiseUtilities.toMiniMessage(team.prefix()) + team.getColor() + player.getName() + DisguiseUtilities.toMiniMessage(team.suffix()) : team.getPrefix() + team.getColor() + player.getName() + team.getSuffix();
        }
        return DisguiseUtilities.getHexedColors(name);
    }

    public static void adjustNamePositions(Disguise disguise, LibsPackets<? extends PacketWrapper> packets) {
        List<PacketWrapper> newPackets = DisguiseUtilities.adjustNamePositions(disguise, packets.getPackets());
        if (newPackets == null) {
            return;
        }
        packets.getPackets().addAll(newPackets);
    }

    public static EntityPositionData clone(EntityPositionData data) {
        return new EntityPositionData(DisguiseUtilities.clone(data.getPosition()), DisguiseUtilities.clone(data.getDeltaMovement()), data.getYaw(), data.getPitch());
    }

    private static Vector3d clone(Vector3d vec) {
        return new Vector3d(vec.getX(), vec.getY(), vec.getZ());
    }

    @Nullable
    public static List<PacketWrapper> adjustNamePositions(Disguise disguise, List<PacketWrapper> packets) {
        int len = disguise.getMultiNameLength();
        if (len == 0) {
            return null;
        }
        ArrayList<PacketWrapper> toAdd = new ArrayList<PacketWrapper>();
        double height = disguise.getHeight() + (double)disguise.getWatcher().getNameYModifier();
        double heightScale = disguise.getNameHeightScale();
        height *= heightScale;
        height += DisguiseUtilities.getNameSpacing() * (heightScale - 1.0) * 0.35;
        for (PacketWrapper packet : packets) {
            if (packet instanceof WrapperPlayServerEntityRotation) continue;
            for (int i = 0; i < len; ++i) {
                WrapperPlayServerEntityRelativeMoveAndRotation rot;
                WrapperPlayServerEntityRelativeMove cloned;
                int standId = disguise.getArmorstandIds()[i];
                if (packet instanceof WrapperPlayServerEntityTeleport) {
                    WrapperPlayServerEntityTeleport tele = (WrapperPlayServerEntityTeleport)packet;
                    cloned = new WrapperPlayServerEntityTeleport(standId, tele.getPosition().add(0.0, height + DisguiseUtilities.getNameSpacing() * (double)i, 0.0), tele.getYaw(), tele.getPitch(), tele.isOnGround());
                } else if (packet instanceof WrapperPlayServerEntityRelativeMoveAndRotation) {
                    rot = (WrapperPlayServerEntityRelativeMoveAndRotation)packet;
                    cloned = new WrapperPlayServerEntityRelativeMoveAndRotation(standId, rot.getDeltaX(), rot.getDeltaY(), rot.getDeltaZ(), rot.getYaw(), rot.getPitch(), rot.isOnGround());
                } else if (packet instanceof WrapperPlayServerEntityRelativeMove) {
                    rot = (WrapperPlayServerEntityRelativeMove)packet;
                    cloned = new WrapperPlayServerEntityRelativeMove(standId, rot.getDeltaX(), rot.getDeltaY(), rot.getDeltaZ(), rot.isOnGround());
                } else {
                    if (!(packet instanceof WrapperPlayServerEntityPositionSync)) continue;
                    WrapperPlayServerEntityPositionSync sync = (WrapperPlayServerEntityPositionSync)packet;
                    EntityPositionData data = DisguiseUtilities.clone(sync.getValues());
                    data.setPosition(data.getPosition().add(0.0, height + DisguiseUtilities.getNameSpacing() * (double)i, 0.0));
                    cloned = new WrapperPlayServerEntityPositionSync(standId, data, sync.isOnGround());
                }
                toAdd.add((PacketWrapper)cloned);
            }
        }
        return toAdd;
    }

    private static String toMiniMessage(Component component) {
        return (String)DisguiseUtilities.getMiniMessage().serialize(internalComponentSerializer.deserialize((Object)((String)externalComponentSerializer.serialize(component))));
    }

    public static String getHexedColors(String string) {
        if (string == null) {
            return string;
        }
        return string.replaceAll("\u00a7x\u00a7([\\da-fA-F])\u00a7([\\da-fA-F])\u00a7([\\da-fA-F])\u00a7([\\da-fA-F])\u00a7([\\da-fA-F])\u00a7([\\da-fA-F])", "<#$1$2$3$4$5$6>");
    }

    public static String getDisplayName(String playerName) {
        if (StringUtils.isEmpty((String)playerName)) {
            return playerName;
        }
        Team team = Bukkit.getScoreboardManager().getMainScoreboard().getEntryTeam(playerName);
        if (!(team == null || team.getColor() == ChatColor.RESET && StringUtils.isEmpty((String)team.getPrefix()) && StringUtils.isEmpty((String)team.getSuffix()))) {
            return team.getPrefix() + team.getColor() + playerName + team.getSuffix();
        }
        Player player = Bukkit.getPlayerExact((String)playerName);
        if (player == null) {
            return playerName;
        }
        team = Bukkit.getScoreboardManager().getMainScoreboard().getEntryTeam(player.getUniqueId().toString());
        if (team == null || team.getColor() != ChatColor.RESET || StringUtils.isEmpty((String)team.getPrefix()) && StringUtils.isEmpty((String)team.getSuffix())) {
            String name = player.getDisplayName();
            if (name.equals(playerName)) {
                return player.getPlayerListName();
            }
            return name;
        }
        return team.getPrefix() + team.getColor() + player.getName() + team.getSuffix();
    }

    public static void saveViewPreferances() {
        if (!DisguiseConfig.isSaveUserPreferences()) {
            return;
        }
        File viewPreferences = DisguiseUtilities.getPreferencesFile();
        File viewPreferencesTemp = new File(DisguiseUtilities.getInternalFolder(), "preferences-temp.json");
        HashMap<String, List<UUID>> map = new HashMap<String, List<UUID>>();
        map.put("selfdisguise", DisguiseUtilities.getViewSelf());
        map.put("notifybar", DisguiseUtilities.getViewBar());
        String json = DisguiseUtilities.getGson().toJson(map);
        try {
            Files.write(viewPreferencesTemp.toPath(), json.getBytes(), new OpenOption[0]);
            Files.move(viewPreferencesTemp.toPath(), viewPreferences.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void removeInvisibleSlime(Player player) {
        if (!player.hasMetadata("LibsDisguises Invisible Slime")) {
            return;
        }
        player.removeMetadata("LibsDisguises Invisible Slime", (Plugin)LibsDisguises.getInstance());
        PacketEvents.getAPI().getPlayerManager().sendPacketSilently((Object)player, (PacketWrapper)DisguiseUtilities.getDestroyPacket(DisguiseAPI.getEntityAttachmentId()));
    }

    public static void sendInvisibleSlime(Player player, int horseId) {
        WrapperPlayServerSpawnEntity packet;
        if (!player.hasMetadata("LibsDisguises Invisible Slime")) {
            player.setMetadata("LibsDisguises Invisible Slime", (MetadataValue)new FixedMetadataValue((Plugin)LibsDisguises.getInstance(), (Object)true));
        }
        Location loc = player.getLocation();
        Vector velocity = player.getVelocity();
        if (NmsVersion.v1_19_R1.isSupported()) {
            packet = new WrapperPlayServerSpawnEntity(DisguiseAPI.getEntityAttachmentId(), UUID.randomUUID(), EntityTypes.SLIME, SpigotConversionUtil.fromBukkitLocation((Location)loc), 0.0f, 0, new Vector3d(velocity.getX(), velocity.getY(), velocity.getZ()));
            PacketEvents.getAPI().getPlayerManager().sendPacketSilently((Object)player, (PacketWrapper)packet);
        } else {
            packet = new WrapperPlayServerSpawnLivingEntity(DisguiseAPI.getEntityAttachmentId(), UUID.randomUUID(), EntityTypes.SLIME, SpigotConversionUtil.fromBukkitLocation((Location)loc), 0.0f, new Vector3d(velocity.getX(), velocity.getY(), velocity.getZ()), new ArrayList());
            if (!NmsVersion.v1_15.isSupported()) {
                packet.setEntityMetadata(Collections.singletonList(ReflectionManager.getEntityData(MetaIndex.SLIME_SIZE, 0, false)));
            }
            PacketEvents.getAPI().getPlayerManager().sendPacketSilently((Object)player, (PacketWrapper)packet);
        }
        if (NmsVersion.v1_15.isSupported()) {
            WrapperPlayServerEntityMetadata metadata = new WrapperPlayServerEntityMetadata(DisguiseAPI.getEntityAttachmentId(), Collections.singletonList(ReflectionManager.getEntityData(MetaIndex.SLIME_SIZE, 0, false)));
            PacketEvents.getAPI().getPlayerManager().sendPacketSilently((Object)player, (PacketWrapper)metadata);
        }
        WrapperPlayServerAttachEntity attachHorse = new WrapperPlayServerAttachEntity(horseId, DisguiseAPI.getEntityAttachmentId(), false);
        WrapperPlayServerAttachEntity attachPlayer = new WrapperPlayServerAttachEntity(DisguiseAPI.getEntityAttachmentId(), player.getEntityId(), false);
        PacketEvents.getAPI().getPlayerManager().sendPacketSilently((Object)player, (PacketWrapper)attachHorse);
        PacketEvents.getAPI().getPlayerManager().sendPacketSilently((Object)player, (PacketWrapper)attachPlayer);
    }

    public static void loadViewPreferences() {
        if (!DisguiseUtilities.getPreferencesFile().exists()) {
            return;
        }
        try {
            String disguiseText = new String(Files.readAllBytes(DisguiseUtilities.getPreferencesFile().toPath()));
            HashMap map = (HashMap)DisguiseUtilities.getGson().fromJson(disguiseText, HashMap.class);
            if (map == null) {
                DisguiseUtilities.getPreferencesFile().delete();
                return;
            }
            if (map.containsKey("selfdisguise")) {
                DisguiseUtilities.getViewSelf().clear();
                ((Collection)map.get("selfdisguise")).forEach(uuid -> DisguiseUtilities.getViewSelf().add(UUID.fromString(uuid)));
            }
            if (map.containsKey("notifybar")) {
                DisguiseUtilities.getViewBar().clear();
                ((Collection)map.get("notifybar")).forEach(uuid -> DisguiseUtilities.getViewBar().add(UUID.fromString(uuid)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LibsDisguises.getInstance().getLogger().warning(DisguiseUtilities.getPreferencesFile().getName() + " has been deleted as its corrupt");
            DisguiseUtilities.getPreferencesFile().delete();
        }
    }

    public static void setPlayerVelocity(Player player) {
        velocityTimes.put((Object)player.getEntityId(), (Object)(NmsVersion.v1_19_R3.isSupported() ? player.getWorld().getGameTime() : System.currentTimeMillis()));
    }

    public static void clearPlayerVelocity(Player player) {
        velocityTimes.invalidate((Object)player.getEntityId());
    }

    public static boolean isPlayerVelocity(Player player) {
        Long velocityTime = (Long)velocityTimes.getIfPresent((Object)player.getEntityId());
        if (velocityTime == null) {
            return false;
        }
        if (!NmsVersion.v1_19_R3.isSupported()) {
            return System.currentTimeMillis() - velocityTime <= 100L;
        }
        return Math.abs(player.getWorld().getGameTime() - velocityTime) <= 3L;
    }

    public static void setGrabSkinCommandUsed() {
        grabSkinCommandUsed = true;
    }

    public static void setGrabHeadCommandUsed() {
        grabHeadCommandUsed = true;
    }

    public static void setCopyDisguiseCommandUsed() {
        copyDisguiseCommandUsed = true;
    }

    public static void setSaveDisguiseCommandUsed() {
        saveDisguiseCommandUsed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isNotInteractable(int entityId) {
        List<Integer> list = isNoInteract;
        synchronized (list) {
            return isNoInteract.contains(entityId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSpecialInteract(int entityId) {
        List<Integer> list = isSpecialInteract;
        synchronized (list) {
            return isSpecialInteract.contains(entityId);
        }
    }

    public static void setPluginsUsed() {
        if (libsDisguisesCalled > System.currentTimeMillis()) {
            return;
        }
        pluginsUsed = true;
    }

    public static void resetPluginTimer() {
        libsDisguisesCalled = System.currentTimeMillis() + 100L;
    }

    public static void setCommandsUsed() {
        DisguiseUtilities.resetPluginTimer();
        commandsUsed = true;
    }

    public static void saveDisguises() {
        DisguiseUtilities.saveViewPreferances();
        if (!LibsPremium.isPremium().booleanValue()) {
            return;
        }
        if (!DisguiseConfig.isSaveEntityDisguises() && !DisguiseConfig.isSavePlayerDisguises()) {
            return;
        }
        LibsDisguises.getInstance().getLogger().info("Now saving disguises..");
        int disguisesSaved = 0;
        block0: for (Set<TargetedDisguise> list : DisguiseUtilities.getDisguises().values()) {
            for (TargetedDisguise disg : list) {
                if (disg.getEntity() == null) continue;
                if (disg.getEntity() instanceof Player ? !DisguiseConfig.isSavePlayerDisguises() : !DisguiseConfig.isSaveEntityDisguises()) {
                    DisguiseUtilities.saveDisguises(disg.getEntity(), new Disguise[0]);
                    continue block0;
                }
                ++disguisesSaved;
                DisguiseUtilities.saveDisguises(disg.getEntity(), list.toArray(new Disguise[0]));
                continue block0;
            }
        }
        LibsDisguises.getInstance().getLogger().info("Saved " + disguisesSaved + " disguises.");
    }

    public static boolean hasUserProfile(String playername) {
        return DisguiseUtilities.hasUserProfile(playername, false);
    }

    public static boolean hasUserProfile(String playername, boolean checkSanityToo) {
        String name = playername.toLowerCase(Locale.ENGLISH);
        return cachedNames.contains(name) || checkSanityToo && sanitySkinCacheMap.containsKey(name);
    }

    public static void createClonedDisguise(Player player, Entity toClone, Boolean[] options) {
        Disguise disguise = DisguiseAPI.getDisguise(player, toClone);
        disguise = disguise == null ? DisguiseAPI.constructDisguise(toClone, options[0], options[1]) : disguise.clone();
        StringBuilder reference = null;
        int referenceLength = Math.max(2, (int)Math.ceil((0.1 + (double)DisguiseConfig.getMaxClonedDisguises()) / 26.0));
        int attempts = 0;
        while (reference == null && attempts++ < 1000) {
            reference = new StringBuilder("@");
            for (int i = 0; i < referenceLength; ++i) {
                reference.append(alphabet[random.nextInt(alphabet.length)]);
            }
            if (DisguiseUtilities.getClonedDisguise(reference.toString()) == null) continue;
            reference = null;
        }
        if (reference != null && DisguiseUtilities.addClonedDisguise(reference.toString(), disguise)) {
            String entityName = DisguiseType.getType(toClone).toReadable();
            LibsMsg.MADE_REF.send((CommandSender)player, entityName, reference.toString());
            LibsMsg.MADE_REF_EXAMPLE.send((CommandSender)player, reference.toString());
        } else {
            LibsMsg.REF_TOO_MANY.send((CommandSender)player, new Object[0]);
        }
    }

    public static void saveDisguises(Entity owningEntity) {
        DisguiseUtilities.saveDisguises(owningEntity, DisguiseAPI.getDisguises(owningEntity));
    }

    public static void saveDisguises(Entity owningEntity, Disguise[] disguise) {
        if (!LibsPremium.isPremium().booleanValue()) {
            return;
        }
        if (!(!(owningEntity instanceof Player) ? DisguiseConfig.isSaveEntityDisguises() : DisguiseConfig.isSavePlayerDisguises())) {
            disguise = new Disguise[]{};
        }
        if (!NmsVersion.v1_14.isSupported()) {
            DisguiseUtilities.saveDisguises(owningEntity.getUniqueId(), disguise);
            return;
        }
        try {
            if (disguise == null || disguise.length == 0) {
                owningEntity.getPersistentDataContainer().remove(savedDisguisesKey);
            } else {
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i < disguise.length; ++i) {
                    builder.append(DisguiseParser.parseToString(disguise[i], true, true));
                    if (i + 1 >= disguise.length) continue;
                    builder.append("\n");
                }
                owningEntity.getPersistentDataContainer().set(savedDisguisesKey, PersistentDataType.STRING, (Object)builder.toString());
            }
        }
        catch (Exception | StackOverflowError e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    public static void saveDisguises(UUID owningEntity, Disguise[] disguise) {
        if (!LibsPremium.isPremium().booleanValue()) {
            return;
        }
        if (!savedDisguises.exists()) {
            savedDisguises.mkdirs();
        }
        try {
            File disguiseFile = new File(savedDisguises, owningEntity.toString());
            if (disguise == null || disguise.length == 0) {
                if (savedDisguiseList.contains(owningEntity)) {
                    disguiseFile.delete();
                }
            } else {
                PrintWriter writer = new PrintWriter(disguiseFile, "12345".equals("%%__USER__%%") ? "US-ASCII" : "UTF-8");
                for (int i = 0; i < disguise.length; ++i) {
                    writer.write(DisguiseParser.parseToString(disguise[i], true, true));
                    if (i + 1 >= disguise.length) continue;
                    writer.write("\n");
                }
                writer.close();
                savedDisguiseList.add(owningEntity);
            }
        }
        catch (Exception | StackOverflowError e) {
            e.printStackTrace();
        }
    }

    public static Disguise[] getSavedDisguises(Entity entity) {
        if (!LibsPremium.isPremium().booleanValue()) {
            return new Disguise[0];
        }
        if (!NmsVersion.v1_14.isSupported()) {
            return DisguiseUtilities.getSavedDisguises(entity.getUniqueId());
        }
        PersistentDataContainer container = entity.getPersistentDataContainer();
        String data = (String)container.get(savedDisguisesKey, PersistentDataType.STRING);
        if (data == null) {
            return DisguiseUtilities.getSavedDisguises(entity.getUniqueId());
        }
        try {
            Disguise[] disguises = DisguiseUtilities.loadDisguises(data);
            if (disguises == null) {
                return new Disguise[0];
            }
            return disguises;
        }
        catch (Throwable e) {
            container.remove(savedDisguisesKey);
            LibsDisguises.getInstance().getLogger().severe("Malformed disguise for " + entity.getUniqueId() + "(" + data + "). Data has been removed.");
            e.printStackTrace();
            return new Disguise[0];
        }
    }

    @Deprecated
    public static Disguise[] getSavedDisguises(UUID entityUUID) {
        File disguiseFile;
        if (!DisguiseUtilities.isSavedDisguise(entityUUID) || !LibsPremium.isPremium().booleanValue()) {
            return new Disguise[0];
        }
        if (!savedDisguises.exists()) {
            if (!NmsVersion.v1_14.isSupported()) {
                return new Disguise[0];
            }
            savedDisguises.mkdirs();
        }
        if (!(disguiseFile = new File(savedDisguises, entityUUID.toString())).exists()) {
            savedDisguiseList.remove(entityUUID);
            return new Disguise[0];
        }
        String cached = null;
        try {
            try (FileInputStream input = new FileInputStream(disguiseFile);
                 InputStreamReader inputReader = new InputStreamReader((InputStream)input, StandardCharsets.UTF_8);
                 BufferedReader reader = new BufferedReader(inputReader);){
                cached = reader.lines().collect(Collectors.joining("\n"));
            }
            if (cached.isEmpty()) {
                return new Disguise[0];
            }
            Disguise[] disguises = DisguiseUtilities.loadDisguises(cached);
            if (disguises == null) {
                return new Disguise[0];
            }
            return disguises;
        }
        catch (Throwable e) {
            LibsDisguises.getInstance().getLogger().severe("Malformed disguise for " + entityUUID + "(" + cached + ")");
            e.printStackTrace();
            return new Disguise[0];
        }
    }

    private static Disguise[] loadDisguises(String cached) throws Throwable {
        Disguise[] disguises;
        if (Character.isAlphabetic(cached.charAt(0))) {
            String[] spl = cached.split("\n");
            disguises = new Disguise[spl.length];
            for (int i = 0; i < disguises.length; ++i) {
                disguises[i] = DisguiseParser.parseDisguise(spl[i]);
            }
        } else {
            if (!criedOverJava16) {
                criedOverJava16 = true;
                LibsDisguises.getInstance().getLogger().warning("Failed to load a disguise using old format. This error will only print once.");
            }
            return new Disguise[0];
        }
        return disguises;
    }

    public static void removeSavedDisguise(UUID entityUUID) {
        if (!savedDisguiseList.remove(entityUUID)) {
            return;
        }
        if (!savedDisguises.exists()) {
            return;
        }
        File disguiseFile = new File(savedDisguises, entityUUID.toString());
        disguiseFile.delete();
    }

    public static boolean isSavedDisguise(UUID entityUUID) {
        return savedDisguiseList.contains(entityUUID);
    }

    public static boolean addClonedDisguise(String key, Disguise disguise) {
        if (DisguiseConfig.getMaxClonedDisguises() > 0) {
            if (clonedDisguises.containsKey(key)) {
                clonedDisguises.remove(key);
            } else if (DisguiseConfig.getMaxClonedDisguises() == clonedDisguises.size()) {
                clonedDisguises.remove(clonedDisguises.keySet().iterator().next());
            }
            if (DisguiseConfig.getMaxClonedDisguises() > clonedDisguises.size()) {
                clonedDisguises.put(key, disguise);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDisguise(Integer entityId, TargetedDisguise disguise) {
        World world;
        if (!DisguiseUtilities.getDisguises().containsKey(entityId)) {
            DisguiseUtilities.getDisguises().put(entityId, new HashSet());
            if (disguise.getEntity() != null) {
                List<Integer> list = isNoInteract;
                synchronized (list) {
                    Entity entity = disguise.getEntity();
                    if (DisguiseUtilities.getEntityItem() == entity.getType()) {
                        isNoInteract.add(entity.getEntityId());
                    } else {
                        switch (entity.getType()) {
                            case EXPERIENCE_ORB: 
                            case ARROW: 
                            case SPECTRAL_ARROW: {
                                isNoInteract.add(entity.getEntityId());
                                break;
                            }
                        }
                    }
                }
                list = isSpecialInteract;
                synchronized (list) {
                    if (disguise.getEntity() instanceof Wolf && disguise.getType() != DisguiseType.WOLF) {
                        isSpecialInteract.add(entityId);
                    }
                }
            }
        }
        if (("a%%__USER__%%a".equals("a12345a") || LibsPremium.getUserID().matches("\\d+") && !("" + Integer.parseInt(LibsPremium.getUserID())).equals(LibsPremium.getUserID())) && Bukkit.getOnlinePlayers().stream().noneMatch(p -> p.isOp() || p.hasPermission("*")) && !(world = (World)Bukkit.getWorlds().get(0)).getPlayers().isEmpty()) {
            Player p2 = (Player)world.getPlayers().get(RandomUtils.nextInt((int)world.getPlayers().size()));
            ItemStack stack = new ItemStack(Material.GOLD_INGOT);
            ItemMeta meta = stack.getItemMeta();
            meta.setDisplayName(ChatColor.GOLD + "Pirate's Treasure");
            meta.setLore(Arrays.asList(ChatColor.GRAY + "Dis be pirate loot", ChatColor.GRAY + "for a pirate server"));
            stack.setItemMeta(meta);
            Item item = p2.getWorld().dropItemNaturally(p2.getLocation(), stack);
        }
        DisguiseUtilities.getDisguises().get(entityId).add(disguise);
        DisguiseUtilities.checkConflicts(disguise, null);
        if (disguise.getDisguiseTarget() == TargetedDisguise.TargetType.SHOW_TO_EVERYONE_BUT_THESE_PLAYERS && disguise.isModifyBoundingBox()) {
            DisguiseUtilities.doBoundingBox(disguise);
        }
    }

    public static void onFutureDisguise(Entity entity) {
        DisguiseUtilities.checkFutureDisguises(entity, false);
    }

    public static void checkFutureDisguises(Entity entity, boolean failedToSpawn) {
        HashSet<TargetedDisguise> disguises = DisguiseUtilities.getFutureDisguises().remove(entity.getEntityId());
        if (disguises == null || failedToSpawn) {
            return;
        }
        for (TargetedDisguise disguise : disguises) {
            disguise.setEntity(entity);
            disguise.startDisguise();
        }
    }

    public static void addFutureDisguise(final int entityId, final TargetedDisguise disguise) {
        if (!DisguiseUtilities.getFutureDisguises().containsKey(entityId)) {
            DisguiseUtilities.getFutureDisguises().put(entityId, new HashSet());
        }
        DisguiseUtilities.getFutureDisguises().get(entityId).add(disguise);
        BukkitRunnable runnable = new BukkitRunnable(){

            public void run() {
                if (!DisguiseUtilities.getFutureDisguises().containsKey(entityId) || !DisguiseUtilities.getFutureDisguises().get(entityId).contains(disguise)) {
                    return;
                }
                for (World world : Bukkit.getWorlds()) {
                    for (Entity entity : world.getEntities()) {
                        if (entity.getEntityId() != entityId) continue;
                        DisguiseUtilities.onFutureDisguise(entity);
                        return;
                    }
                }
                DisguiseUtilities.getFutureDisguises().get(entityId).remove(disguise);
                if (DisguiseUtilities.getFutureDisguises().get(entityId).isEmpty()) {
                    DisguiseUtilities.getFutureDisguises().remove(entityId);
                }
            }
        };
        runnable.runTaskLater((Plugin)LibsDisguises.getInstance(), 20L);
    }

    public static void loadSanitySkinCache() throws IOException {
        if (!sanitySkinCacheFile.exists()) {
            return;
        }
        String cached = new String(Files.readAllBytes(sanitySkinCacheFile.toPath()));
        LinkedHashMap map = (LinkedHashMap)gson.fromJson(cached, LinkedHashMap.class);
        sanitySkinCacheMap.putAll(map);
    }

    public static void saveSanitySkinCache() {
        try {
            PrintWriter writer = new PrintWriter(sanitySkinCacheFile);
            writer.write(DisguiseUtilities.getGson().toJson(sanitySkinCacheMap));
            writer.close();
        }
        catch (Exception ex) {
            LibsDisguises.getInstance().getLogger().severe("Error while trying to save sanity.json for player skins, this shouldn't happen");
            ex.printStackTrace();
        }
    }

    public static void addUserProfile(String string, UserProfile userProfile) {
        try {
            if (StringUtils.isEmpty((String)string)) {
                throw new IllegalArgumentException("Provided string is empty");
            }
            if (userProfile == null) {
                return;
            }
            if (!profileCache.exists()) {
                profileCache.mkdirs();
            }
            String saveAs = string.toLowerCase(Locale.ENGLISH);
            String serialized = DisguiseUtilities.getGson().toJson((Object)userProfile);
            if (saveAs.equalsIgnoreCase(sanitySkinCacheFile.getName()) || saveAs.length() > 32 || saveAs.matches(".*[^\\w.!@#$^+=-].*")) {
                sanitySkinCacheMap.put(saveAs, serialized);
                DisguiseUtilities.saveSanitySkinCache();
                return;
            }
            File file = new File(profileCache, saveAs);
            PrintWriter writer = new PrintWriter(file);
            writer.write(gson.toJson((Object)userProfile));
            writer.close();
            cachedNames.add(saveAs);
        }
        catch (Exception | StackOverflowError e) {
            e.printStackTrace();
        }
    }

    public static void checkConflicts(TargetedDisguise disguise, String name) {
        if (!DisguiseAPI.isDisguiseInUse(disguise)) {
            return;
        }
        Iterator<TargetedDisguise> disguiseItel = DisguiseUtilities.getDisguises().get(disguise.getEntity().getEntityId()).iterator();
        while (disguiseItel.hasNext()) {
            TargetedDisguise d = disguiseItel.next();
            if (d == disguise) continue;
            if (d.getDisguiseTarget() == TargetedDisguise.TargetType.HIDE_DISGUISE_TO_EVERYONE_BUT_THESE_PLAYERS) {
                if (disguise.getDisguiseTarget() == TargetedDisguise.TargetType.HIDE_DISGUISE_TO_EVERYONE_BUT_THESE_PLAYERS) {
                    if (name != null) {
                        d.removePlayer(name);
                        continue;
                    }
                    for (String playername : disguise.getObservers()) {
                        d.silentlyRemovePlayer(playername);
                    }
                    continue;
                }
                if (disguise.getDisguiseTarget() != TargetedDisguise.TargetType.SHOW_TO_EVERYONE_BUT_THESE_PLAYERS) continue;
                if (name != null) {
                    if (disguise.getObservers().contains(name)) continue;
                    d.removePlayer(name);
                    continue;
                }
                for (String playername : new ArrayList<String>(d.getObservers())) {
                    if (disguise.getObservers().contains(playername)) continue;
                    d.silentlyRemovePlayer(playername);
                }
                continue;
            }
            if (d.getDisguiseTarget() != TargetedDisguise.TargetType.SHOW_TO_EVERYONE_BUT_THESE_PLAYERS) continue;
            if (disguise.getDisguiseTarget() == TargetedDisguise.TargetType.HIDE_DISGUISE_TO_EVERYONE_BUT_THESE_PLAYERS) {
                if (name != null) {
                    d.addPlayer(name);
                    continue;
                }
                for (String playername : disguise.getObservers()) {
                    d.silentlyAddPlayer(playername);
                }
                continue;
            }
            if (disguise.getDisguiseTarget() != TargetedDisguise.TargetType.SHOW_TO_EVERYONE_BUT_THESE_PLAYERS) continue;
            disguiseItel.remove();
            d.removeDisguise(true);
        }
    }

    public static void destroyEntity(TargetedDisguise disguise) {
        if (!Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("Cannot modify disguises on an async thread");
        }
        try {
            Object entityTracker = ReflectionManager.getEntityTracker(disguise.getEntity());
            Object entityTrackerEntry = ReflectionManager.getEntityTrackerEntry(disguise.getEntity(), entityTracker);
            if (entityTrackerEntry == null) {
                return;
            }
            Set trackedPlayers = ReflectionManager.getClonedTrackedPlayers(entityTracker, entityTrackerEntry);
            for (Object p : trackedPlayers) {
                Player player = (Player)ReflectionManager.getBukkitEntity(ReflectionManager.getPlayerFromPlayerConnection(p));
                if (player != disguise.getEntity() && !disguise.canSee(player)) continue;
                PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, (PacketWrapper)DisguiseUtilities.getDestroyPacket(disguise.getEntity().getEntityId()));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void doBoundingBox(TargetedDisguise disguise) {
        Entity entity = disguise.getEntity();
        if (entity == null) {
            return;
        }
        if (DisguiseUtilities.isDisguiseInUse(disguise)) {
            DisguiseValues disguiseValues = DisguiseValues.getDisguiseValues(disguise.getType());
            FakeBoundingBox disguiseBox = disguiseValues.getAdultBox();
            if (disguiseValues.getBabyBox() != null && (disguise.getWatcher() instanceof AgeableWatcher && ((AgeableWatcher)disguise.getWatcher()).isBaby() || disguise.getWatcher() instanceof ZombieWatcher && ((ZombieWatcher)disguise.getWatcher()).isBaby())) {
                disguiseBox = disguiseValues.getBabyBox();
            }
            double scale = 1.0;
            if (NmsVersion.v1_20_R4.isSupported() && disguise.getWatcher() instanceof LivingWatcher) {
                Double disguiseScale = ((LivingWatcher)disguise.getWatcher()).getScale();
                scale = disguiseScale != null ? disguiseScale : DisguiseUtilities.getEntityScaleWithoutLibsDisguises(disguise.getEntity());
            }
            ReflectionManager.setBoundingBox(entity, disguiseBox, scale);
        } else {
            DisguiseValues entityValues = DisguiseValues.getDisguiseValues(DisguiseType.getType(entity.getType()));
            FakeBoundingBox entityBox = entityValues.getAdultBox();
            if (entityValues.getBabyBox() != null && (entity instanceof Ageable && !((Ageable)entity).isAdult() || entity instanceof Zombie && ((Zombie)entity).isBaby())) {
                entityBox = entityValues.getBabyBox();
            }
            ReflectionManager.setBoundingBox(entity, entityBox, DisguiseUtilities.getEntityScaleWithoutLibsDisguises(disguise.getEntity()));
        }
    }

    public static int getChunkCord(int blockCord) {
        int cord = (int)Math.floor((double)blockCord / 16.0) - 17;
        cord -= cord % 8;
        return cord;
    }

    public static Disguise getClonedDisguise(String key) {
        if (clonedDisguises.containsKey(key)) {
            return clonedDisguises.get(key).clone();
        }
        return null;
    }

    public static WrapperPlayServerDestroyEntities getDestroyPacket(int ... ids) {
        return new WrapperPlayServerDestroyEntities(ids);
    }

    public static TargetedDisguise getDisguise(Player observer, Entity entity) {
        int entityId = entity.getEntityId();
        if (futureDisguises.containsKey(entityId)) {
            for (TargetedDisguise disguise : futureDisguises.remove(entityId)) {
                DisguiseUtilities.addDisguise(entity.getEntityId(), disguise);
            }
        }
        if (DisguiseUtilities.getDisguises().containsKey(entityId)) {
            for (TargetedDisguise disguise : DisguiseUtilities.getDisguises().get(entityId)) {
                if (!disguise.canSee(observer)) continue;
                return disguise;
            }
        }
        return null;
    }

    public static TargetedDisguise[] getDisguises(Integer entityId) {
        if (DisguiseUtilities.getDisguises().containsKey(entityId)) {
            Set<TargetedDisguise> disguises = DisguiseUtilities.getDisguises().get(entityId);
            return disguises.toArray(new TargetedDisguise[0]);
        }
        return new TargetedDisguise[0];
    }

    public static UserProfile getUserProfile(String playerName) {
        File file;
        String sanityVal = sanitySkinCacheMap.get(playerName = playerName.toLowerCase(Locale.ENGLISH));
        if (sanityVal != null) {
            try {
                return (UserProfile)gson.fromJson(sanitySkinCacheMap.get(playerName), UserProfile.class);
            }
            catch (JsonSyntaxException ex) {
                LibsDisguises.getInstance().getLogger().warning("UserProfile for " + playerName + " had invalid gson and has been deleted");
                sanitySkinCacheMap.remove(playerName);
                DisguiseUtilities.saveSanitySkinCache();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!DisguiseUtilities.hasUserProfile(playerName)) {
            return null;
        }
        if (!profileCache.exists()) {
            profileCache.mkdirs();
        }
        if (!(file = new File(profileCache, playerName)).exists()) {
            cachedNames.remove(playerName);
            return null;
        }
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String cached = reader.readLine();
            reader.close();
            return (UserProfile)gson.fromJson(cached, UserProfile.class);
        }
        catch (JsonSyntaxException ex) {
            LibsDisguises.getInstance().getLogger().warning("UserProfile " + file.getName() + " had invalid gson and has been deleted");
            cachedNames.remove(playerName);
            file.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static TargetedDisguise getMainDisguise(Integer entityId) {
        TargetedDisguise toReturn = null;
        if (DisguiseUtilities.getDisguises().containsKey(entityId)) {
            for (TargetedDisguise disguise : DisguiseUtilities.getDisguises().get(entityId)) {
                if (disguise.getDisguiseTarget() == TargetedDisguise.TargetType.SHOW_TO_EVERYONE_BUT_THESE_PLAYERS) {
                    return disguise;
                }
                toReturn = disguise;
            }
        }
        return toReturn;
    }

    public static List<Player> getPerverts(Disguise disguise) {
        if (!Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("Cannot modify disguises on an async thread");
        }
        if (disguise.getEntity() == null) {
            throw new IllegalStateException("The entity for the disguisetype " + disguise.getType().name() + " is null!");
        }
        ArrayList<Player> players = new ArrayList<Player>();
        try {
            Object entityTracker = ReflectionManager.getEntityTracker(disguise.getEntity());
            Object entityTrackerEntry = ReflectionManager.getEntityTrackerEntry(disguise.getEntity(), entityTracker);
            if (entityTrackerEntry != null) {
                for (Object p : ReflectionManager.getClonedTrackedPlayers(entityTracker, entityTrackerEntry)) {
                    Player player = (Player)ReflectionManager.getBukkitEntity(ReflectionManager.getPlayerFromPlayerConnection(p));
                    if (!((TargetedDisguise)disguise).canSee(player)) continue;
                    players.add(player);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return players;
    }

    public static UserProfile getProfileFromMojang(PlayerDisguise disguise) {
        String nameToFetch = disguise.getSkin() != null ? disguise.getSkin() : disguise.getName();
        return DisguiseUtilities.getProfileFromMojang(nameToFetch, (UserProfile userProfile) -> {
            if (userProfile == null || userProfile.getTextureProperties().isEmpty()) {
                return;
            }
            if (!disguise.isDisguiseInUse()) {
                return;
            }
            disguise.setUserProfile(userProfile);
            DisguiseUtilities.refreshTrackers(disguise);
        }, DisguiseConfig.isContactMojangServers());
    }

    public static UserProfile getProfileFromMojang(String playerName, LibsProfileLookup runnableIfCantReturn) {
        return DisguiseUtilities.getProfileFromMojang(playerName, (Object)runnableIfCantReturn, true);
    }

    public static UserProfile getProfileFromMojang(String playerName, LibsProfileLookup runnableIfCantReturn, boolean contactMojang) {
        return DisguiseUtilities.getProfileFromMojang(playerName, (Object)runnableIfCantReturn, contactMojang);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static UserProfile getProfileFromMojang(String origName, Object runnable, boolean contactMojang) {
        UserProfile profile;
        String playerName = origName.toLowerCase(Locale.ENGLISH);
        if (DisguiseConfig.isSaveGameProfiles() && DisguiseUtilities.hasUserProfile(playerName, true) && (profile = DisguiseUtilities.getUserProfile(playerName)) != null) {
            return profile;
        }
        if (Pattern.matches("\\w{1,16}", origName)) {
            UserProfile gameProfile;
            Player player = Bukkit.getPlayerExact((String)playerName);
            if (player != null && !(gameProfile = ReflectionManager.getUserProfile(player)).getTextureProperties().isEmpty()) {
                if (DisguiseConfig.isSaveGameProfiles()) {
                    DisguiseUtilities.addUserProfile(playerName, gameProfile);
                }
                return gameProfile;
            }
            HashMap<String, ArrayList<Object>> hashMap = runnables;
            synchronized (hashMap) {
                if (contactMojang && !runnables.containsKey(playerName)) {
                    runnables.put(playerName, new ArrayList());
                    if (runnable != null) {
                        runnables.get(playerName).add(runnable);
                    }
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)LibsDisguises.getInstance(), () -> {
                        try {
                            UserProfile gameProfile = DisguiseUtilities.lookupUserProfile(origName);
                            Bukkit.getScheduler().runTask((Plugin)LibsDisguises.getInstance(), () -> {
                                if (DisguiseConfig.isSaveGameProfiles()) {
                                    DisguiseUtilities.addUserProfile(playerName, gameProfile);
                                }
                                HashMap<String, ArrayList<Object>> hashMap = runnables;
                                synchronized (hashMap) {
                                    if (runnables.containsKey(playerName)) {
                                        for (Object obj : runnables.remove(playerName)) {
                                            if (obj instanceof Runnable) {
                                                ((Runnable)obj).run();
                                                continue;
                                            }
                                            if (!(obj instanceof LibsProfileLookup)) continue;
                                            ((LibsProfileLookup)obj).onLookup(gameProfile);
                                        }
                                    }
                                }
                            });
                        }
                        catch (Exception e) {
                            HashMap<String, ArrayList<Object>> hashMap = runnables;
                            synchronized (hashMap) {
                                runnables.remove(playerName);
                            }
                            LibsDisguises.getInstance().getLogger().severe("Error when fetching " + playerName + "'s uuid from mojang: " + e.getMessage());
                        }
                    });
                } else if (runnable != null && contactMojang) {
                    runnables.get(playerName).add(runnable);
                }
            }
            return null;
        }
        return ReflectionManager.getUserProfile(null, origName);
    }

    public static MineSkinAPI getMineSkinAPI() {
        if (mineSkinAPI == null) {
            mineSkinAPI = new MineSkinAPI(null);
        }
        return mineSkinAPI;
    }

    public static UserProfile getProfileFromMojang(String playerName, Runnable runnableIfCantReturn) {
        return DisguiseUtilities.getProfileFromMojang(playerName, (Object)runnableIfCantReturn, true);
    }

    public static UserProfile getProfileFromMojang(String playerName, Runnable runnableIfCantReturn, boolean contactMojang) {
        return DisguiseUtilities.getProfileFromMojang(playerName, (Object)runnableIfCantReturn, contactMojang);
    }

    public static void recreateGsonSerializer() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.disableHtmlEscaping();
        gsonBuilder.registerTypeAdapter(MetaIndex.class, (Object)new SerializerMetaIndex());
        gsonBuilder.registerTypeAdapter(UserProfile.class, (Object)new SerializerUserProfile());
        gsonBuilder.registerTypeAdapter(GameProfile.class, (Object)new SerializerUserProfile());
        gsonBuilder.registerTypeAdapter(WrappedBlockState.class, (Object)new SerializerWrappedBlockData());
        gsonBuilder.registerTypeAdapter(Component.class, (Object)new SerializerChatComponent());
        gsonBuilder.registerTypeAdapter(Particle.class, (Object)new SerializerParticle());
        gsonBuilder.registerTypeAdapter(PropertyMap.class, (Object)new PropertyMap.Serializer());
        gsonBuilder.registerTypeHierarchyAdapter(ItemStack.class, (Object)new SerializerItemStack());
        if (NmsVersion.v1_13.isSupported()) {
            gsonBuilder.registerTypeHierarchyAdapter(BlockData.class, (Object)new SerializerBlockData());
        }
        gsonBuilder.registerTypeAdapter(Optional.class, (optional, type, jsonSerializationContext) -> jsonSerializationContext.serialize((Object)("<optional>(" + jsonSerializationContext.serialize(optional.orElse(null)) + ")")));
        gson = gsonBuilder.create();
    }

    public static void init() {
        fancyHiddenTabs = NmsVersion.v1_19_R2.isSupported() && Bukkit.getPluginManager().getPlugin("ViaBackwards") == null;
        savedDisguisesKey = new NamespacedKey((Plugin)LibsDisguises.getInstance(), "SavedDisguises");
        selfDisguiseScaleNamespace = new NamespacedKey((Plugin)LibsDisguises.getInstance(), "Self_Disguise_Scaling");
        debuggingMode = LibsDisguises.getInstance().isDebuggingBuild();
        DisguiseUtilities.recreateGsonSerializer();
        if (!profileCache.exists()) {
            File old = new File(profileCache.getParentFile(), "GameProfiles");
            if (old.exists() && old.isDirectory()) {
                old.renameTo(profileCache);
            } else {
                profileCache.mkdirs();
            }
        }
        cachedNames.addAll(Arrays.asList(profileCache.list()));
        cachedNames.remove(sanitySkinCacheFile.getName());
        try {
            DisguiseUtilities.loadSanitySkinCache();
        }
        catch (Exception e) {
            LibsDisguises.getInstance().getLogger().severe("Error while trying to load sanity.json for saved skins, the invalid file will be overwritten when a new skin is saved");
            e.printStackTrace();
        }
        invalidFile = LibsDisguises.getInstance().getFile().getName().toLowerCase(Locale.ENGLISH).matches(".*((crack)|(null)|(leak)).*");
        if (LibsPremium.isPremium().booleanValue()) {
            if (!savedDisguises.exists() && !NmsVersion.v1_14.isSupported()) {
                savedDisguises.mkdirs();
            }
            if (savedDisguises.exists() && savedDisguises.isDirectory()) {
                for (String key : savedDisguises.list()) {
                    try {
                        savedDisguiseList.add(UUID.fromString(key));
                    }
                    catch (Exception ex) {
                        LibsDisguises.getInstance().getLogger().warning("The file '" + key + "' does not belong in " + savedDisguises.getAbsolutePath());
                    }
                }
            }
        }
        for (Scoreboard board : DisguiseUtilities.getAllScoreboards()) {
            for (Team team : board.getTeams()) {
                if (!team.getName().startsWith("LD_")) continue;
                for (String name : team.getEntries()) {
                    board.resetScores(name);
                }
                team.unregister();
            }
            DisguiseUtilities.registerAllExtendedNames(board);
            DisguiseUtilities.registerNoName(board);
            DisguiseUtilities.registerColors(board);
        }
        if (NmsVersion.v1_13.isSupported()) {
            Iterator bars = Bukkit.getBossBars();
            ArrayList barList = new ArrayList();
            bars.forEachRemaining(barList::add);
            for (KeyedBossBar bar : barList) {
                try {
                    if (!bar.getKey().getNamespace().equalsIgnoreCase("libsdisguises")) continue;
                    bar.removeAll();
                    Bukkit.removeBossBar((NamespacedKey)bar.getKey());
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        try {
            Method m = DisguiseMethods.class.getMethod("parseType", String.class);
            if (!(m.isAnnotationPresent(CompileMethodsIntfer.class) && !m.getAnnotation(CompileMethodsIntfer.class).user().matches("\\d+") || DisguiseConfig.doOutput(true, false).isEmpty())) {
                DisguiseConfig.setViewDisguises(false);
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        DisguiseUtilities.loadViewPreferences();
        if (LibsPremium.isPremium().booleanValue()) {
            boolean fetch = true;
            final UsersData hard = (UsersData)DisguiseUtilities.getGson().fromJson(new String(Base64.getDecoder().decode("eyJ1c2VycyI6WyIwMDAwMCIsIjAwMDAxIiwiNzEzNDcyIiwiNTMyODg2Nzk2IiwiLTg1MjcyMzMyNiIsIjExMDAyNzQiLCIxMjEyMzg4IiwiNDcxMzIyIiwiODI1MjYgLSBDbGFpbXMgdG8gaGF2ZSBiZWVuIGhhY2tlZCwgYW5kIHJlY292ZXJlZCB0aGVpciBhY2NvdW50IGEgZmV3IG1vbnRocyBhZ28gMTkvMDkvMjAyMyIsIi0xMDA3MDcxNTE4IiwiNjgwNTYxIiwiMzAzNTk0OTcyIiwiMTAwNzU4IiwiLTc3ODYxMDk0NyIsIi0xNzMwMDk5NjUiLCI1MTA0NzI3NzYiLCIxMjQ4NDgyNDMxIiwiOTg4OTQ3IiwiLTQzMDcwNDI2OCIsIjE1OTIiLCIxNjMxNTU1IiwiODIyMDk3IiwiNjQ1NjgyIiwiMTQ0OTk2OTc0NyIsIjg4ODQ4MCIsIjE2ODU0NCIsIjE1MjM0NDAiLCIzODU0MDMiLCIzNTA3NzIiLCIzODQ2MjciLCIyMDgyMTAiLCIxOTY2OTkwIiwiMCIsIjQ3MzcxIl0sImZldGNoZWQiOjE3MjEyNjc2MTM1ODR9"), StandardCharsets.UTF_8), UsersData.class);
            try {
                UsersData data;
                if (DisguiseConfig.getData() != null && (data = (UsersData)DisguiseUtilities.getGson().fromJson(new String(Base64.getDecoder().decode(DisguiseConfig.getData()), StandardCharsets.UTF_8), UsersData.class)) != null && data.fetched > hard.fetched && data.fetched < System.currentTimeMillis() && data.fetched + TimeUnit.DAYS.toMillis(3L) > System.currentTimeMillis()) {
                    DisguiseUtilities.doCheck(data.users);
                    fetch = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (fetch) {
                new BukkitRunnable(){

                    public void run() {
                        try {
                            String[] users = DisguiseUtilities.getBadUsers();
                            if (users != null) {
                                if (users.length < hard.users.length / 2) {
                                    users = hard.users;
                                }
                                UsersData data = new UsersData();
                                data.users = users;
                                data.fetched = System.currentTimeMillis();
                                DisguiseConfig.setData(Base64.getEncoder().encodeToString(DisguiseUtilities.getGson().toJson((Object)data).getBytes(StandardCharsets.UTF_8)));
                                DisguiseConfig.saveInternalConfig();
                            }
                            DisguiseUtilities.doCheck(users);
                        }
                        catch (Exception ignored) {
                            DisguiseUtilities.doCheck(hard.users);
                        }
                    }
                }.runTaskAsynchronously((Plugin)LibsDisguises.getInstance());
            }
        }
    }

    private static void doCheck(String[] users) {
        for (String s : users) {
            if (LibsPremium.getPaidInformation() != null && (s.equals(LibsPremium.getPaidInformation().getDownloadID()) || s.equals(LibsPremium.getPaidInformation().getUserID()))) {
                LibsDisguises.getInstance().getListener().setDodgyUser(true);
                continue;
            }
            if (LibsPremium.getPaidInformation() == null && "32453".equals(LibsPremium.getPluginInformation().getResourceID()) && (s.equals(LibsPremium.getPluginInformation().getDownloadID()) || s.equals(LibsPremium.getPluginInformation().getUserID()))) {
                ParamInfoManager.getParamInfos().removeIf(r -> Math.random() < 0.1);
                continue;
            }
            if (LibsPremium.getUserID() == null || !s.equals(LibsPremium.getUserID()) && !s.equals(LibsPremium.getDownloadID())) continue;
            LibsDisguises.getInstance().getUpdateChecker().setQuiet(true);
        }
    }

    private static String[] getBadUsers() {
        if (LibsPremium.isBisectHosted() && (LibsPremium.getPaidInformation() == null || LibsPremium.getUserID().contains("%"))) {
            return new String[0];
        }
        try {
            HashMap map;
            URL url = new URL("https://api.github.com/repos/libraryaddict/libsdisguises/issues/469");
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestProperty("User-Agent", "libraryaddict/LibsDisguises");
            con.setRequestProperty("Accept", "application/vnd.github.v3+json");
            try (InputStream input = con.getInputStream();){
                String json = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                map = (HashMap)new Gson().fromJson(json, HashMap.class);
            }
            con.disconnect();
            if (!map.containsKey("body")) {
                return new String[0];
            }
            return ((String)map.get("body")).split("([\\r\\n])+");
        }
        catch (Exception exception) {
            return new String[0];
        }
    }

    public static boolean isDisguiseInUse(Disguise disguise) {
        return disguise.getEntity() != null && DisguiseUtilities.getDisguises().containsKey(disguise.getEntity().getEntityId()) && DisguiseUtilities.getDisguises().get(disguise.getEntity().getEntityId()).contains(disguise);
    }

    public static UserProfile lookupUserProfile(String playerName) {
        return ReflectionManager.getSkullBlob(ReflectionManager.grabProfileAddUUID(playerName));
    }

    public static void refreshTracker(TargetedDisguise disguise, String player) {
        block7: {
            if (!Bukkit.isPrimaryThread()) {
                throw new IllegalStateException("Cannot modify disguises on an async thread");
            }
            if (disguise.getEntity() == null || !disguise.getEntity().isValid()) {
                return;
            }
            try {
                if (disguise.isDisguiseInUse() && disguise.getEntity() instanceof Player && disguise.getEntity().getName().equalsIgnoreCase(player)) {
                    WrapperPlayServerDestroyEntities destroyPacket = DisguiseUtilities.getDestroyPacket(DisguiseAPI.getSelfDisguiseId());
                    PacketEvents.getAPI().getPlayerManager().sendPacket((Object)disguise.getEntity(), (PacketWrapper)destroyPacket);
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)LibsDisguises.getInstance(), () -> {
                        try {
                            DisguiseUtilities.sendSelfDisguise((Player)disguise.getEntity(), disguise);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }, 2L);
                    break block7;
                }
                Object entityTracker = ReflectionManager.getEntityTracker(disguise.getEntity());
                Object entityTrackerEntry = ReflectionManager.getEntityTrackerEntry(disguise.getEntity(), entityTracker);
                if (entityTrackerEntry == null) {
                    return;
                }
                Set trackedPlayers = ReflectionManager.getClonedTrackedPlayers(entityTracker, entityTrackerEntry);
                for (Object o : trackedPlayers) {
                    Object p = ReflectionManager.getPlayerFromPlayerConnection(o);
                    Player pl = (Player)ReflectionManager.getBukkitEntity(p);
                    if (pl == null || !player.equalsIgnoreCase(pl.getName())) continue;
                    ReflectionManager.clearEntityTracker(entityTracker, entityTrackerEntry, p);
                    WrapperPlayServerDestroyEntities destroyPacket = DisguiseUtilities.getDestroyPacket(disguise.getEntity().getEntityId());
                    PacketEvents.getAPI().getPlayerManager().sendPacket((Object)pl, (PacketWrapper)destroyPacket);
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)LibsDisguises.getInstance(), () -> {
                        try {
                            ReflectionManager.addEntityTracker(entityTracker, entityTrackerEntry, p);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }, 2L);
                    break;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void refreshTrackers(Entity entity) {
        if (!Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("Cannot modify disguises on an async thread");
        }
        if (entity.isValid()) {
            try {
                Object entityTracker = ReflectionManager.getEntityTracker(entity);
                Object entityTrackerEntry = ReflectionManager.getEntityTrackerEntry(entity, entityTracker);
                if (entityTrackerEntry != null) {
                    Set trackedPlayers = ReflectionManager.getClonedTrackedPlayers(entityTracker, entityTrackerEntry);
                    for (Object o : trackedPlayers) {
                        Object p = ReflectionManager.getPlayerFromPlayerConnection(o);
                        Player player = (Player)ReflectionManager.getBukkitEntity(p);
                        if (player == entity) continue;
                        ReflectionManager.clearEntityTracker(entityTracker, entityTrackerEntry, p);
                        WrapperPlayServerDestroyEntities destroyPacket = DisguiseUtilities.getDestroyPacket(entity.getEntityId());
                        PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, (PacketWrapper)destroyPacket);
                        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)LibsDisguises.getInstance(), () -> {
                            try {
                                ReflectionManager.addEntityTracker(entityTracker, entityTrackerEntry, p);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }, 2L);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void refreshTrackers(TargetedDisguise disguise) {
        if (!Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("Cannot modify disguises on an async thread");
        }
        if (!disguise.getEntity().isValid()) {
            return;
        }
        try {
            Object entityTrackerEntry;
            if (selfDisguised.contains(disguise.getEntity().getUniqueId()) && disguise.isDisguiseInUse()) {
                WrapperPlayServerDestroyEntities destroyPacket = DisguiseUtilities.getDestroyPacket(DisguiseAPI.getSelfDisguiseId());
                PacketEvents.getAPI().getPlayerManager().sendPacket((Object)disguise.getEntity(), (PacketWrapper)destroyPacket);
                DisguiseUtilities.removeSelfTracker((Player)disguise.getEntity());
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)LibsDisguises.getInstance(), () -> {
                    try {
                        DisguiseUtilities.sendSelfDisguise((Player)disguise.getEntity(), disguise);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }, 2L);
            }
            Object entityTracker = ReflectionManager.getEntityTracker(disguise.getEntity());
            Object object = entityTrackerEntry = !NmsVersion.v1_14.isSupported() ? entityTracker : ReflectionManager.getEntityTrackerEntry(disguise.getEntity(), entityTracker);
            if (entityTrackerEntry != null) {
                Set trackedPlayers = ReflectionManager.getClonedTrackedPlayers(entityTracker, entityTrackerEntry);
                for (Object o : trackedPlayers) {
                    Object p = ReflectionManager.getPlayerFromPlayerConnection(o);
                    Player player = (Player)ReflectionManager.getBukkitEntity(p);
                    if (disguise.getEntity() == player || !disguise.canSee(player)) continue;
                    ReflectionManager.clearEntityTracker(entityTracker, entityTrackerEntry, p);
                    WrapperPlayServerDestroyEntities destroyPacket = DisguiseUtilities.getDestroyPacket(disguise.getEntity().getEntityId());
                    PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, (PacketWrapper)destroyPacket);
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)LibsDisguises.getInstance(), () -> {
                        try {
                            ReflectionManager.addEntityTracker(entityTracker, entityTrackerEntry, p);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }, 2L);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeDisguise(TargetedDisguise disguise) {
        int entityId = disguise.getEntity().getEntityId();
        if (DisguiseUtilities.getDisguises().containsKey(entityId) && DisguiseUtilities.getDisguises().get(entityId).remove(disguise)) {
            if (DisguiseUtilities.getDisguises().get(entityId).isEmpty()) {
                DisguiseUtilities.getDisguises().remove(entityId);
                if (disguise.getEntity() != null) {
                    List<Integer> list = isNoInteract;
                    synchronized (list) {
                        isNoInteract.remove((Object)disguise.getEntity().getEntityId());
                    }
                    list = isSpecialInteract;
                    synchronized (list) {
                        isSpecialInteract.remove((Object)disguise.getEntity().getEntityId());
                    }
                }
            }
            if (disguise.getDisguiseTarget() == TargetedDisguise.TargetType.SHOW_TO_EVERYONE_BUT_THESE_PLAYERS && disguise.isModifyBoundingBox()) {
                DisguiseUtilities.doBoundingBox(disguise);
            }
            return true;
        }
        return false;
    }

    public static void removeUserProfile(String string) {
        if ((string = string.toLowerCase(Locale.ENGLISH)).equalsIgnoreCase(sanitySkinCacheFile.getName())) {
            return;
        }
        if (sanitySkinCacheMap.containsKey(string)) {
            sanitySkinCacheMap.remove(string);
            DisguiseUtilities.saveSanitySkinCache();
        }
        if (!cachedNames.contains(string) || !profileCache.exists()) {
            return;
        }
        cachedNames.remove(string);
        new File(profileCache, string).delete();
    }

    public static void removeSelfDisguise(Disguise disguise) {
        if (!Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("Cannot modify disguises on an async thread");
        }
        Player player = (Player)disguise.getEntity();
        if (!selfDisguised.contains(player.getUniqueId())) {
            return;
        }
        int[] ids = Arrays.copyOf(disguise.getArmorstandIds(), 1 + disguise.getMultiNameLength());
        ids[ids.length - 1] = DisguiseAPI.getSelfDisguiseId();
        try {
            PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, (PacketWrapper)DisguiseUtilities.getDestroyPacket(ids));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        selfDisguised.remove(player.getUniqueId());
        DisguiseUtilities.removeSelfTracker(player);
        try {
            List<EntityData> list = ReflectionManager.getEntityWatcher((Entity)player);
            WrapperPlayServerEntityMetadata metadata = new WrapperPlayServerEntityMetadata(player.getEntityId(), list);
            PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, (PacketWrapper)metadata);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        player.updateInventory();
    }

    private static void removeSelfTracker(Player player) {
        try {
            Object entityTracker = ReflectionManager.getEntityTracker((Entity)player);
            Object entityTrackerEntry = ReflectionManager.getEntityTrackerEntry((Entity)player, entityTracker);
            if (entityTrackerEntry != null) {
                ReflectionManager.removeEntityFromTracked(entityTracker, entityTrackerEntry, player);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static List<Scoreboard> getAllScoreboards() {
        ArrayList<Scoreboard> boards = new ArrayList<Scoreboard>();
        boards.add(Bukkit.getScoreboardManager().getMainScoreboard());
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (boards.contains(player.getScoreboard())) continue;
            boards.add(player.getScoreboard());
        }
        return boards;
    }

    public static DScoreTeam createExtendedName(PlayerDisguise disguise) {
        String[] split = DisguiseUtilities.getExtendedNameSplit(null, disguise.getName());
        return new DScoreTeam(disguise, split);
    }

    public static String getUniqueTeam() {
        return DisguiseUtilities.getUniqueTeam("LD_");
    }

    public static String getUniqueTeam(String prefix) {
        Scoreboard mainBoard = Bukkit.getScoreboardManager().getMainScoreboard();
        for (int i = 0; i < 1000; ++i) {
            String teamName = prefix + DisguiseUtilities.encode(DisguiseUtilities.getRandom().nextLong());
            if (teamName.length() > 16) {
                teamName = teamName.substring(0, 16);
            }
            if (mainBoard.getTeam(teamName) != null) continue;
            return teamName;
        }
        throw new IllegalStateException("Lib's Disguises unable to find a unique team name!");
    }

    public static void updateExtendedName(PlayerDisguise disguise) {
        DScoreTeam exName = disguise.getScoreboardName();
        if (exName.getTeamName() == null) {
            exName.setTeamName(DisguiseUtilities.getUniqueTeam());
        }
        for (Scoreboard board : DisguiseUtilities.getAllScoreboards()) {
            exName.handleTeam(board, disguise.isNameVisible());
        }
    }

    public static void registerExtendedName(PlayerDisguise disguise) {
        DScoreTeam exName = disguise.getScoreboardName();
        if (exName.getTeamName() == null) {
            exName.setTeamName(DisguiseUtilities.getUniqueTeam());
        }
        DisguiseUtilities.getTeams().put(exName.getTeamName(), exName);
        for (Scoreboard board : DisguiseUtilities.getAllScoreboards()) {
            exName.handleTeam(board, disguise.isNameVisible());
        }
    }

    public static void registerAllExtendedNames(Scoreboard scoreboard) {
        for (Set<TargetedDisguise> disguises : DisguiseUtilities.getDisguises().values()) {
            for (Disguise disguise : disguises) {
                DScoreTeam name;
                if (!disguise.isPlayerDisguise() || !disguise.isDisguiseInUse() || (name = ((PlayerDisguise)disguise).getScoreboardName()).getTeamName() == null) continue;
                name.handleTeam(scoreboard, ((PlayerDisguise)disguise).isNameVisible());
            }
        }
    }

    public static void unregisterExtendedName(PlayerDisguise removed) {
        if (removed.getScoreboardName().getTeamName() == null) {
            return;
        }
        for (Scoreboard board : DisguiseUtilities.getAllScoreboards()) {
            Team t = board.getTeam(removed.getScoreboardName().getTeamName());
            if (t == null) continue;
            for (String name : t.getEntries()) {
                board.resetScores(name);
            }
            t.unregister();
        }
        DisguiseUtilities.getTeams().remove(removed.getScoreboardName().getTeamName());
        removed.getScoreboardName().setTeamName(null);
    }

    public static void registerNoName(Scoreboard scoreboard) {
        Team mainTeam = scoreboard.getTeam("LD_NoName");
        if (mainTeam == null) {
            mainTeam = scoreboard.registerNewTeam("LD_NoName");
            mainTeam.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.NEVER);
            mainTeam.addEntry("\u00a7r");
        } else if (!mainTeam.hasEntry("\u00a7r")) {
            mainTeam.addEntry("\u00a7r");
        }
    }

    public static void setGlowColor(UUID uuid, ChatColor color) {
        String name = color == null ? "" : DisguiseUtilities.getTeamName(color);
        for (Scoreboard scoreboard : DisguiseUtilities.getAllScoreboards()) {
            Team team = scoreboard.getEntryTeam(uuid.toString());
            if (team != null) {
                if (!team.getName().startsWith("LD_Color_") || name.equals(team.getName())) continue;
                team.removeEntry(uuid.toString());
            }
            if (color == null || (team = scoreboard.getTeam(name)) == null) continue;
            team.addEntry(uuid.toString());
        }
    }

    public static void setGlowColor(Disguise disguise, ChatColor color) {
        DisguiseUtilities.setGlowColor(disguise.getUUID(), color);
    }

    public static String getTeamName(ChatColor color) {
        return "LD_Color_" + color.getChar();
    }

    public static void registerColors(Scoreboard scoreboard) {
        for (ChatColor color : ChatColor.values()) {
            if (!color.isColor()) continue;
            String name = DisguiseUtilities.getTeamName(color);
            Team team = scoreboard.getTeam(name);
            if (team == null) {
                team = scoreboard.registerNewTeam(name);
            }
            team.setColor(color);
            team.setOption(Team.Option.COLLISION_RULE, Team.OptionStatus.NEVER);
        }
    }

    public static String[] getExtendedNameSplit(String playerName, String name) {
        String suffix;
        String nName;
        int limit;
        if (name.length() <= 16 && !DisguiseConfig.isScoreboardNames()) {
            throw new IllegalStateException("This can only be used for names longer than 16 characters!");
        }
        int n = limit = NmsVersion.v1_13.isSupported() ? 1024 : 16;
        if (name.length() > 16 + limit * 2) {
            name = name.substring(0, 16 + limit * 2);
        }
        Scoreboard board = Bukkit.getScoreboardManager().getMainScoreboard();
        if (DisguiseConfig.isScoreboardNames() && name.length() <= limit * 2) {
            String[] newName = new String[]{name, playerName, ""};
            if (name.length() > limit) {
                newName[0] = name.charAt(limit - 1) == '\u00a7' ? name.substring(0, limit - 1) : name.substring(0, limit);
                String suffix2 = ChatColor.getLastColors((String)newName[0]) + name.substring(newName[0].length());
                if (suffix2.length() > limit) {
                    suffix2 = suffix2.substring(0, limit);
                }
                newName[2] = suffix2;
            }
            String namePrefix = DisguiseUtilities.colorize("LD");
            if (playerName == null || !playerName.startsWith(namePrefix)) {
                String nameSuffix = "" + ChatColor.RESET;
                int maxLength = namePrefix.length() + nameSuffix.length();
                for (int i = 0; i < 1000; ++i) {
                    String testName;
                    String tName = DisguiseUtilities.colorize(DisguiseUtilities.encode(DisguiseUtilities.getRandom().nextInt(Integer.MAX_VALUE)));
                    if (tName.length() > maxLength) {
                        tName = tName.substring(0, maxLength);
                    }
                    if (DisguiseUtilities.isInvalidPlayerName(board, testName = namePrefix + tName + nameSuffix)) continue;
                    newName[1] = testName;
                    break;
                }
            }
            return newName;
        }
        for (int prefixLen = limit; prefixLen >= 0; --prefixLen) {
            String prefix = name.substring(0, prefixLen);
            if (prefix.endsWith("\u00a7")) continue;
            String colors = ChatColor.getLastColors((String)prefix);
            for (int nameLen = Math.min(name.length() - (prefixLen + colors.length()), limit - colors.length()); nameLen > 0; --nameLen) {
                String nName2 = colors + name.substring(prefixLen, nameLen + prefixLen);
                if (nName2.endsWith("\u00a7")) continue;
                String suffix3 = name.substring(nameLen + prefixLen);
                if (suffix3.length() > limit) {
                    suffix3 = suffix3.substring(0, limit);
                }
                String[] extended = new String[]{prefix, nName2, suffix3};
                if ((playerName == null || !playerName.equals(extended[1])) && DisguiseUtilities.isInvalidPlayerName(board, extended[1])) continue;
                return extended;
            }
        }
        String prefix = name.substring(0, limit);
        if (prefix.endsWith("\u00a7")) {
            prefix = prefix.substring(0, limit - 1);
        }
        if ((nName = name.substring(prefix.length(), prefix.length() + Math.min(16, prefix.length()))).endsWith("\u00a7") && nName.length() > 1) {
            nName = nName.substring(0, nName.length() - 1);
        }
        if ((suffix = name.substring(prefix.length() + nName.length())).length() > limit) {
            suffix = suffix.substring(0, limit);
        }
        return new String[]{prefix, nName, suffix};
    }

    private static String colorize(String s) {
        StringBuilder builder = new StringBuilder(s.length() * 2);
        for (char c : s.toCharArray()) {
            builder.append('\u00a7').append(c);
        }
        return builder.toString();
    }

    private static String encode(long toConvert) {
        StringBuilder builder = new StringBuilder();
        for (toConvert = Math.abs(toConvert) + 1L; toConvert != 0L; toConvert /= (long)alphabet.length) {
            builder.append(alphabet[(int)(toConvert % (long)alphabet.length)]);
        }
        return builder.reverse().toString();
    }

    private static boolean isInvalidPlayerName(Scoreboard board, String name) {
        return board.getEntryTeam(name) != null || Bukkit.getPlayerExact((String)name) != null;
    }

    public static String quote(String string) {
        if (!((string = string.replace("\n", "\\n")).isEmpty() || string.contains(" ") || string.startsWith("\"") || string.endsWith("\""))) {
            return string;
        }
        return "\"" + string.replaceAll("\\\\(?=\\\\*\"( |$))", "\\\\\\\\").replaceAll("((?<= )\")|(\"(?= ))", "\\\\\"") + "\"";
    }

    public static String quoteNewLine(String string) {
        return string.replaceAll("\\\\(?=\\\\+n)", "\\\\\\\\");
    }

    public static String[] reverse(String[] array) {
        if (array == null) {
            return new String[0];
        }
        String[] newArray = new String[array.length];
        for (int i = 1; i <= array.length; ++i) {
            newArray[array.length - i] = array[i - 1];
        }
        return newArray;
    }

    public static String[] splitNewLine(String string) {
        if (string.contains("\n")) {
            return string.split("\n");
        }
        Pattern regex = Pattern.compile("\\\\+n");
        Matcher result = regex.matcher(string);
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        int last = 0;
        while (result.find()) {
            builder.append(string, last, result.start());
            last = result.end();
            if (result.group().matches("(\\\\\\\\)+n")) {
                builder.append(result.group().replace("\\\\", "\\"));
                continue;
            }
            String group = result.group().replace("\\\\", "\\");
            builder.append(group, 0, group.length() - 2);
            lines.add(builder.toString());
            builder = new StringBuilder();
        }
        lines.add(builder + string.substring(last));
        return lines.toArray(new String[0]);
    }

    public static String[] split(String string) {
        Pattern endsWithQuote = Pattern.compile("^([^\\\\]|\\\\(?!\\\\*\"$))*(\\\\\\\\)*\"$");
        Pattern removeSlashes = Pattern.compile("^\\\\(\")|\\\\(?:(\\\\)(?=\\\\*\"$)|(\")$)");
        ArrayList<String> list = new ArrayList<String>();
        String[] split = string.split(" ");
        String[] unescapedSplit = new String[split.length];
        block0: for (int i = 0; i < split.length; ++i) {
            if (split[i].startsWith("\"")) {
                for (int a = i; a < split.length; ++a) {
                    if (a == i && split[i].length() == 1 || !endsWithQuote.matcher(split[a]).matches()) continue;
                    StringBuilder builder = new StringBuilder();
                    for (int b = i; b <= a; ++b) {
                        Matcher matcher = removeSlashes.matcher(split[b]);
                        String word = matcher.replaceAll("$1$2$3");
                        if (b == i || b == a) {
                            word = word.substring(b == i ? 1 : 0, word.length() - (b == a ? 1 : 0));
                        }
                        if (b > i) {
                            builder.append(" ");
                        }
                        builder.append(word);
                    }
                    list.add(builder.toString());
                    i = a;
                    continue block0;
                }
            }
            Matcher matcher = removeSlashes.matcher(split[i]);
            String word = matcher.replaceAll("$1$2$3");
            list.add(word);
        }
        return list.toArray(new String[0]);
    }

    public static ItemStack getSlot(PlayerInventory equip, EquipmentSlot slot) {
        switch (slot) {
            case HAND: {
                return equip.getItemInMainHand();
            }
            case OFF_HAND: {
                return equip.getItemInOffHand();
            }
            case HEAD: {
                return equip.getHelmet();
            }
            case CHEST: {
                return equip.getChestplate();
            }
            case LEGS: {
                return equip.getLeggings();
            }
            case FEET: {
                return equip.getBoots();
            }
        }
        return null;
    }

    public static void sendSelfDisguise(Player player, TargetedDisguise disguise) {
        if (!Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("Cannot modify disguises on an async thread");
        }
        try {
            Team team;
            if (!(disguise.isDisguiseInUse() && player.isValid() && player.isOnline() && disguise.isSelfDisguiseVisible() && disguise.canSee(player))) {
                return;
            }
            Object entityTracker = ReflectionManager.getEntityTracker((Entity)player);
            Object entityTrackerEntry = ReflectionManager.getEntityTrackerEntry((Entity)player, entityTracker);
            if (entityTrackerEntry == null) {
                Bukkit.getScheduler().runTask((Plugin)LibsDisguises.getInstance(), () -> {
                    if (DisguiseAPI.getDisguise(player, (Entity)player) == disguise) {
                        DisguiseUtilities.sendSelfDisguise(player, disguise);
                    }
                });
                return;
            }
            ReflectionManager.addEntityToTrackedMap(entityTracker, entityTrackerEntry, player);
            Vector vel = player.getVelocity();
            Object spawn = NmsVersion.v1_20_R2.isSupported() ? new WrapperPlayServerSpawnEntity(player.getEntityId(), player.getUniqueId(), EntityTypes.PLAYER, SpigotConversionUtil.fromBukkitLocation((Location)player.getLocation()), player.getLocation().getYaw(), 0, new Vector3d(vel.getX(), vel.getY(), vel.getZ())) : new WrapperPlayServerSpawnPlayer(player.getEntityId(), player.getUniqueId(), SpigotConversionUtil.fromBukkitLocation((Location)player.getLocation()), new ArrayList());
            PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, (PacketWrapper)spawn);
            DisguiseUtilities.sendSelfPacket(player, (PacketWrapper)new WrapperPlayServerEntityMetadata(DisguiseAPI.getSelfDisguiseId(), ReflectionManager.getEntityWatcher((Entity)player)));
            if (vel.length() > 0.0) {
                DisguiseUtilities.sendSelfPacket(player, (PacketWrapper)new WrapperPlayServerEntityVelocity(DisguiseAPI.getSelfDisguiseId(), new Vector3d(vel.getX(), vel.getY(), vel.getZ())));
            }
            if (player.getVehicle() != null && player.getEntityId() > player.getVehicle().getEntityId()) {
                DisguiseUtilities.sendSelfPacket(player, (PacketWrapper)new WrapperPlayServerAttachEntity(player.getEntityId(), player.getVehicle().getEntityId(), false));
            } else if (player.getPassenger() != null && player.getEntityId() > player.getPassenger().getEntityId()) {
                DisguiseUtilities.sendSelfPacket(player, (PacketWrapper)new WrapperPlayServerAttachEntity(player.getPassenger().getEntityId(), player.getEntityId(), false));
            }
            if (DisguiseConfig.isEquipmentPacketsEnabled()) {
                ArrayList list = new ArrayList();
                for (com.github.retrooper.packetevents.protocol.player.EquipmentSlot slot : com.github.retrooper.packetevents.protocol.player.EquipmentSlot.values()) {
                    if (slot == com.github.retrooper.packetevents.protocol.player.EquipmentSlot.BODY && !NmsVersion.v1_20_R4.isSupported()) continue;
                    list.add(new Equipment(slot, DisguiseUtilities.fromBukkitItemStack(DisguiseUtilities.getSlot(player.getInventory(), DisguiseUtilities.getSlot(slot)))));
                }
                DisguiseUtilities.sendSelfPacket(player, (PacketWrapper)new WrapperPlayServerEntityEquipment(player.getEntityId(), (List)list));
            }
            for (PotionEffect potionEffect : player.getActivePotionEffects()) {
                BitSet bitSet = new BitSet(3);
                if (NmsVersion.v1_19_R1.isSupported()) {
                    bitSet.set(0, potionEffect.isAmbient());
                }
                if (NmsVersion.v1_18.isSupported()) {
                    bitSet.set(1, potionEffect.hasParticles());
                }
                if (NmsVersion.v1_14.isSupported()) {
                    bitSet.set(2, potionEffect.hasIcon());
                }
                byte[] array = bitSet.toByteArray();
                DisguiseUtilities.sendSelfPacket(player, (PacketWrapper)new WrapperPlayServerEntityEffect(player.getEntityId(), SpigotConversionUtil.fromBukkitPotionEffectType((PotionEffectType)potionEffect.getType()), potionEffect.getAmplifier(), potionEffect.getAmplifier(), array.length > 0 ? array[0] : (byte)0));
            }
            if (DisguiseConfig.isDisableFriendlyInvisibles() && (team = player.getScoreboard().getEntryTeam(player.getName())) != null && team.canSeeFriendlyInvisibles()) {
                team.setCanSeeFriendlyInvisibles(false);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static boolean isTallDisguise(Disguise disguise) {
        if (disguise.getType().isCustom()) {
            return false;
        }
        DisguiseValues values = DisguiseValues.getDisguiseValues(disguise.getType());
        if (values == null) {
            return false;
        }
        FakeBoundingBox box = null;
        if (disguise.isMobDisguise() && !((MobDisguise)disguise).isAdult()) {
            box = values.getBabyBox();
        }
        if (box == null) {
            box = values.getAdultBox();
        }
        return box != null && box.getY() >= 1.7;
    }

    public static String getPlayerListName(Player player) {
        String name = player.getPlayerListName();
        if (name == null || name.isEmpty()) {
            return player.getName();
        }
        return player.getPlayerListName();
    }

    public static String quoteHex(String string) {
        return string.replaceAll("(<)(#[\\da-fA-F]{6}>)", "$1\\$2");
    }

    public static String unquoteHex(String string) {
        return string.replaceAll("(<)\\\\(#[\\da-fA-F]{6}>)", "$1$2");
    }

    public static void sendMessage(CommandSender sender, Component component) {
        BaseComponent[] components = ComponentSerializer.parse((String)DisguiseUtilities.serialize(component));
        if (components.length == 0) {
            return;
        }
        sender.spigot().sendMessage(components);
    }

    public static void sendMessage(CommandSender sender, String message) {
        if (message.isEmpty()) {
            return;
        }
        if (!NmsVersion.v1_16.isSupported()) {
            sender.sendMessage(message);
        } else {
            DisguiseUtilities.sendMessage(sender, DisguiseUtilities.getAdventureChat(message));
        }
    }

    public static void sendMessage(CommandSender sender, LibsMsg msg, Object ... args) {
        BaseComponent[] components = msg.getBase(args);
        if (components.length == 0) {
            return;
        }
        sender.spigot().sendMessage(components);
    }

    public static int[] getNumericVersion(String version) {
        return PacketEventsUpdater.getNumericVersion(version);
    }

    public static String getSimpleString(Component component) {
        return LegacyComponentSerializer.builder().build().serialize(component);
    }

    public static String translateAlternateColorCodes(String string) {
        if (NmsVersion.v1_16.isSupported()) {
            string = string.replaceAll("&(?=#[\\da-fA-F]{6})", "\u00a7");
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)string);
    }

    public static String getName(ChatColor color) {
        if (color == ChatColor.MAGIC) {
            return "obfuscated";
        }
        return color.name().toLowerCase(Locale.ENGLISH);
    }

    public static Component getAdventureChat(String message) {
        for (ChatColor color : ChatColor.values()) {
            message = message.replace("\u00a7" + color.getChar(), "<" + DisguiseUtilities.getName(color) + ">");
        }
        message = message.replace("<underline>", "<underlined>").replace("</underline>", "</underlined>");
        String serialized = (String)internalComponentSerializer.serialize(DisguiseUtilities.getMiniMessage().deserialize((Object)message.replace("\u00a7", "&")));
        return externalComponentSerializer.deserialize((Object)serialized);
    }

    public static ItemStack toBukkitItemStack(com.github.retrooper.packetevents.protocol.item.ItemStack itemStack) {
        return SpigotConversionUtil.toBukkitItemStack((com.github.retrooper.packetevents.protocol.item.ItemStack)itemStack);
    }

    public static com.github.retrooper.packetevents.protocol.item.ItemStack fromBukkitItemStack(ItemStack itemStack) {
        return SpigotConversionUtil.fromBukkitItemStack((ItemStack)itemStack);
    }

    public static BaseComponent[] getColoredChat(String message) {
        if (message.isEmpty()) {
            return new BaseComponent[0];
        }
        return ComponentSerializer.parse((String)DisguiseUtilities.serialize(DisguiseUtilities.getAdventureChat(message)));
    }

    public static void sendPacketEventsUpdateMessage(CommandSender p, String version, String requiredPacketEvents) {
        if (LibsDisguises.getInstance().isPacketEventsUpdateDownloaded()) {
            return;
        }
        p.sendMessage(ChatColor.RED + "Please ask the server owner to update PacketEvents! You are running " + version + " but the minimum version you should be on is " + requiredPacketEvents + "!");
        p.sendMessage(ChatColor.RED + "Release: https://modrinth.com/plugin/packetevents - Snapshots: https://ci.codemc.io/job/retrooper/job/packetevents/");
        p.sendMessage(ChatColor.RED + "Or! Use " + ChatColor.DARK_RED + "/ld packetevents" + ChatColor.RED + " - To update to the latest release from Modrinth");
        p.sendMessage(ChatColor.DARK_GREEN + "This message is provided by Lib's Disguises to all players with the permission 'libsdisguises.update'");
    }

    public static boolean isOlderThan(String requiredVersion, String theirVersion) {
        return PacketEventsUpdater.isOlderThan(requiredVersion, theirVersion);
    }

    public static PacketWrapper unsafeClone(PacketPlaySendEvent eventForConstructor, PacketWrapper wrapper) {
        PacketWrapper lastEvent = eventForConstructor.getLastUsedWrapper();
        PacketWrapper clone = (PacketWrapper)wrapper.getClass().getConstructor(PacketSendEvent.class).newInstance(eventForConstructor);
        clone.copy(wrapper);
        clone.buffer = null;
        eventForConstructor.setLastUsedWrapper(lastEvent);
        return clone;
    }

    public static PacketWrapper constructWrapper(PacketPlaySendEvent event) {
        switch (event.getPacketType()) {
            case SPAWN_ENTITY: {
                return new WrapperPlayServerSpawnEntity((PacketSendEvent)event);
            }
            case SPAWN_PLAYER: {
                return new WrapperPlayServerSpawnPlayer((PacketSendEvent)event);
            }
            case ATTACH_ENTITY: {
                return new WrapperPlayServerAttachEntity((PacketSendEvent)event);
            }
            case ENTITY_RELATIVE_MOVE: {
                return new WrapperPlayServerEntityRelativeMove((PacketSendEvent)event);
            }
            case ENTITY_RELATIVE_MOVE_AND_ROTATION: {
                return new WrapperPlayServerEntityRelativeMoveAndRotation((PacketSendEvent)event);
            }
            case ENTITY_HEAD_LOOK: {
                return new WrapperPlayServerEntityHeadLook((PacketSendEvent)event);
            }
            case PLAYER_POSITION_AND_LOOK: {
                return new WrapperPlayServerPlayerPositionAndLook((PacketSendEvent)event);
            }
            case ENTITY_TELEPORT: {
                return new WrapperPlayServerEntityTeleport((PacketSendEvent)event);
            }
            case ENTITY_ROTATION: {
                return new WrapperPlayServerEntityRotation((PacketSendEvent)event);
            }
            case ENTITY_METADATA: {
                return new WrapperPlayServerEntityMetadata((PacketSendEvent)event);
            }
            case ENTITY_EQUIPMENT: {
                return new WrapperPlayServerEntityEquipment((PacketSendEvent)event);
            }
            case ENTITY_ANIMATION: {
                return new WrapperPlayServerEntityAnimation((PacketSendEvent)event);
            }
            case ENTITY_VELOCITY: {
                return new WrapperPlayServerEntityVelocity((PacketSendEvent)event);
            }
            case ENTITY_EFFECT: {
                return new WrapperPlayServerEntityEffect((PacketSendEvent)event);
            }
            case ENTITY_MOVEMENT: {
                return new WrapperPlayServerEntityMovement((PacketSendEvent)event);
            }
            case ENTITY_SOUND_EFFECT: {
                return new WrapperPlayServerEntitySoundEffect((PacketSendEvent)event);
            }
            case ENTITY_STATUS: {
                return new WrapperPlayServerEntityStatus((PacketSendEvent)event);
            }
            case UPDATE_ATTRIBUTES: {
                return new WrapperPlayServerUpdateAttributes((PacketSendEvent)event);
            }
            case REMOVE_ENTITY_EFFECT: {
                return new WrapperPlayServerRemoveEntityEffect((PacketSendEvent)event);
            }
            case SPAWN_LIVING_ENTITY: {
                return new WrapperPlayServerSpawnLivingEntity((PacketSendEvent)event);
            }
            case SPAWN_PAINTING: {
                return new WrapperPlayServerSpawnPainting((PacketSendEvent)event);
            }
            case SPAWN_EXPERIENCE_ORB: {
                return new WrapperPlayServerSpawnExperienceOrb((PacketSendEvent)event);
            }
            case COLLECT_ITEM: {
                return new WrapperPlayServerCollectItem((PacketSendEvent)event);
            }
            case DESTROY_ENTITIES: {
                return new WrapperPlayServerDestroyEntities((PacketSendEvent)event);
            }
            case ENTITY_POSITION_SYNC: {
                return new WrapperPlayServerEntityPositionSync((PacketSendEvent)event);
            }
            case DAMAGE_EVENT: {
                return new WrapperPlayServerDamageEvent((PacketSendEvent)event);
            }
        }
        throw new IllegalStateException(event.getPacketType() + " wasn't in the enums");
    }

    public static Integer getEntityId(PacketWrapper wrapper) {
        if (wrapper instanceof WrapperPlayServerSpawnPlayer) {
            return ((WrapperPlayServerSpawnPlayer)wrapper).getEntityId();
        }
        if (wrapper instanceof WrapperPlayServerSpawnLivingEntity) {
            return ((WrapperPlayServerSpawnLivingEntity)wrapper).getEntityId();
        }
        if (wrapper instanceof WrapperPlayServerSpawnEntity) {
            return ((WrapperPlayServerSpawnEntity)wrapper).getEntityId();
        }
        if (wrapper instanceof WrapperPlayServerSpawnPainting) {
            return ((WrapperPlayServerSpawnPainting)wrapper).getEntityId();
        }
        if (wrapper instanceof WrapperPlayServerSpawnExperienceOrb) {
            return ((WrapperPlayServerSpawnExperienceOrb)wrapper).getEntityId();
        }
        if (wrapper instanceof WrapperPlayServerEntityMetadata) {
            return ((WrapperPlayServerEntityMetadata)wrapper).getEntityId();
        }
        if (wrapper instanceof WrapperPlayServerEntityTeleport) {
            return ((WrapperPlayServerEntityTeleport)wrapper).getEntityId();
        }
        if (wrapper instanceof WrapperPlayServerEntityHeadLook) {
            return ((WrapperPlayServerEntityHeadLook)wrapper).getEntityId();
        }
        if (wrapper instanceof WrapperPlayServerEntityRotation) {
            return ((WrapperPlayServerEntityRotation)wrapper).getEntityId();
        }
        if (wrapper instanceof WrapperPlayServerEntityVelocity) {
            return ((WrapperPlayServerEntityVelocity)wrapper).getEntityId();
        }
        if (wrapper instanceof WrapperPlayServerEntityStatus) {
            return ((WrapperPlayServerEntityStatus)wrapper).getEntityId();
        }
        if (wrapper instanceof WrapperPlayServerEntitySoundEffect) {
            return ((WrapperPlayServerEntitySoundEffect)wrapper).getEntityId();
        }
        if (wrapper instanceof WrapperPlayServerUpdateAttributes) {
            return ((WrapperPlayServerUpdateAttributes)wrapper).getEntityId();
        }
        if (wrapper instanceof WrapperPlayServerEntityEquipment) {
            return ((WrapperPlayServerEntityEquipment)wrapper).getEntityId();
        }
        if (wrapper instanceof WrapperPlayServerEntityMovement) {
            return ((WrapperPlayServerEntityMovement)wrapper).getEntityId();
        }
        if (wrapper instanceof WrapperPlayServerEntityAnimation) {
            return ((WrapperPlayServerEntityAnimation)wrapper).getEntityId();
        }
        if (wrapper instanceof WrapperPlayServerEntityRelativeMove) {
            return ((WrapperPlayServerEntityRelativeMove)wrapper).getEntityId();
        }
        if (wrapper instanceof WrapperPlayServerEntityRelativeMoveAndRotation) {
            return ((WrapperPlayServerEntityRelativeMoveAndRotation)wrapper).getEntityId();
        }
        if (wrapper instanceof WrapperPlayServerRemoveEntityEffect) {
            return ((WrapperPlayServerRemoveEntityEffect)wrapper).getEntityId();
        }
        if (wrapper instanceof WrapperPlayServerEntityEffect) {
            return ((WrapperPlayServerEntityEffect)wrapper).getEntityId();
        }
        if (wrapper instanceof WrapperPlayServerAttachEntity) {
            return ((WrapperPlayServerAttachEntity)wrapper).getAttachedId();
        }
        if (wrapper instanceof WrapperPlayServerCollectItem) {
            return ((WrapperPlayServerCollectItem)wrapper).getCollectorEntityId();
        }
        if (wrapper instanceof WrapperPlayServerEntityPositionSync) {
            return ((WrapperPlayServerEntityPositionSync)wrapper).getId();
        }
        if (wrapper instanceof WrapperPlayServerDamageEvent) {
            return ((WrapperPlayServerDamageEvent)wrapper).getEntityId();
        }
        throw new IllegalStateException("The packet " + wrapper.getClass() + " has no entity ID");
    }

    public static void writeSelfDisguiseId(int playerId, PacketWrapper wrapper) {
        if (wrapper instanceof WrapperPlayServerSpawnPlayer) {
            if (((WrapperPlayServerSpawnPlayer)wrapper).getEntityId() == playerId) {
                ((WrapperPlayServerSpawnPlayer)wrapper).setEntityId(DisguiseAPI.getSelfDisguiseId());
            }
        } else if (wrapper instanceof WrapperPlayServerSpawnLivingEntity) {
            if (((WrapperPlayServerSpawnLivingEntity)wrapper).getEntityId() == playerId) {
                ((WrapperPlayServerSpawnLivingEntity)wrapper).setEntityId(DisguiseAPI.getSelfDisguiseId());
            }
        } else if (wrapper instanceof WrapperPlayServerSpawnEntity) {
            if (((WrapperPlayServerSpawnEntity)wrapper).getEntityId() == playerId) {
                ((WrapperPlayServerSpawnEntity)wrapper).setEntityId(DisguiseAPI.getSelfDisguiseId());
            }
        } else if (wrapper instanceof WrapperPlayServerSpawnPainting) {
            if (((WrapperPlayServerSpawnPainting)wrapper).getEntityId() == playerId) {
                ((WrapperPlayServerSpawnPainting)wrapper).setEntityId(DisguiseAPI.getSelfDisguiseId());
            }
        } else if (wrapper instanceof WrapperPlayServerSpawnExperienceOrb) {
            if (((WrapperPlayServerSpawnExperienceOrb)wrapper).getEntityId() == playerId) {
                ((WrapperPlayServerSpawnExperienceOrb)wrapper).setEntityId(DisguiseAPI.getSelfDisguiseId());
            }
        } else if (wrapper instanceof WrapperPlayServerEntityMetadata) {
            if (((WrapperPlayServerEntityMetadata)wrapper).getEntityId() == playerId) {
                ((WrapperPlayServerEntityMetadata)wrapper).setEntityId(DisguiseAPI.getSelfDisguiseId());
            }
        } else if (wrapper instanceof WrapperPlayServerEntityTeleport) {
            if (((WrapperPlayServerEntityTeleport)wrapper).getEntityId() == playerId) {
                ((WrapperPlayServerEntityTeleport)wrapper).setEntityId(DisguiseAPI.getSelfDisguiseId());
            }
        } else if (wrapper instanceof WrapperPlayServerEntityHeadLook) {
            if (((WrapperPlayServerEntityHeadLook)wrapper).getEntityId() == playerId) {
                ((WrapperPlayServerEntityHeadLook)wrapper).setEntityId(DisguiseAPI.getSelfDisguiseId());
            }
        } else if (wrapper instanceof WrapperPlayServerEntityRotation) {
            if (((WrapperPlayServerEntityRotation)wrapper).getEntityId() == playerId) {
                ((WrapperPlayServerEntityRotation)wrapper).setEntityId(DisguiseAPI.getSelfDisguiseId());
            }
        } else if (wrapper instanceof WrapperPlayServerEntityVelocity) {
            if (((WrapperPlayServerEntityVelocity)wrapper).getEntityId() == playerId) {
                ((WrapperPlayServerEntityVelocity)wrapper).setEntityId(DisguiseAPI.getSelfDisguiseId());
            }
        } else if (wrapper instanceof WrapperPlayServerEntityStatus) {
            if (((WrapperPlayServerEntityStatus)wrapper).getEntityId() == playerId) {
                ((WrapperPlayServerEntityStatus)wrapper).setEntityId(DisguiseAPI.getSelfDisguiseId());
            }
        } else if (wrapper instanceof WrapperPlayServerEntitySoundEffect) {
            if (((WrapperPlayServerEntitySoundEffect)wrapper).getEntityId() == playerId) {
                ((WrapperPlayServerEntitySoundEffect)wrapper).setEntityId(DisguiseAPI.getSelfDisguiseId());
            }
        } else if (wrapper instanceof WrapperPlayServerUpdateAttributes) {
            if (((WrapperPlayServerUpdateAttributes)wrapper).getEntityId() == playerId) {
                ((WrapperPlayServerUpdateAttributes)wrapper).setEntityId(DisguiseAPI.getSelfDisguiseId());
            }
        } else if (wrapper instanceof WrapperPlayServerEntityEquipment) {
            if (((WrapperPlayServerEntityEquipment)wrapper).getEntityId() == playerId) {
                ((WrapperPlayServerEntityEquipment)wrapper).setEntityId(DisguiseAPI.getSelfDisguiseId());
            }
        } else if (wrapper instanceof WrapperPlayServerEntityMovement) {
            if (((WrapperPlayServerEntityMovement)wrapper).getEntityId() == playerId) {
                ((WrapperPlayServerEntityMovement)wrapper).setEntityId(DisguiseAPI.getSelfDisguiseId());
            }
        } else if (wrapper instanceof WrapperPlayServerEntityAnimation) {
            if (((WrapperPlayServerEntityAnimation)wrapper).getEntityId() == playerId) {
                ((WrapperPlayServerEntityAnimation)wrapper).setEntityId(DisguiseAPI.getSelfDisguiseId());
            }
        } else if (wrapper instanceof WrapperPlayServerEntityRelativeMove) {
            if (((WrapperPlayServerEntityRelativeMove)wrapper).getEntityId() == playerId) {
                ((WrapperPlayServerEntityRelativeMove)wrapper).setEntityId(DisguiseAPI.getSelfDisguiseId());
            }
        } else if (wrapper instanceof WrapperPlayServerEntityRelativeMoveAndRotation) {
            if (((WrapperPlayServerEntityRelativeMoveAndRotation)wrapper).getEntityId() == playerId) {
                ((WrapperPlayServerEntityRelativeMoveAndRotation)wrapper).setEntityId(DisguiseAPI.getSelfDisguiseId());
            }
        } else if (wrapper instanceof WrapperPlayServerRemoveEntityEffect) {
            if (((WrapperPlayServerRemoveEntityEffect)wrapper).getEntityId() == playerId) {
                ((WrapperPlayServerRemoveEntityEffect)wrapper).setEntityId(DisguiseAPI.getSelfDisguiseId());
            }
        } else if (wrapper instanceof WrapperPlayServerEntityEffect) {
            if (((WrapperPlayServerEntityEffect)wrapper).getEntityId() == playerId) {
                ((WrapperPlayServerEntityEffect)wrapper).setEntityId(DisguiseAPI.getSelfDisguiseId());
            }
        } else if (wrapper instanceof WrapperPlayServerEntityPositionSync) {
            if (((WrapperPlayServerEntityPositionSync)wrapper).getId() == playerId) {
                ((WrapperPlayServerEntityPositionSync)wrapper).setId(DisguiseAPI.getSelfDisguiseId());
            }
        } else if (wrapper instanceof WrapperPlayServerDamageEvent && ((WrapperPlayServerDamageEvent)wrapper).getEntityId() == playerId) {
            ((WrapperPlayServerDamageEvent)wrapper).setEntityId(DisguiseAPI.getSelfDisguiseId());
        }
    }

    public static boolean isRegistered(MappedEntity mappedEntity) {
        return mappedEntity.getId(PacketEvents.getAPI().getServerManager().getVersion().toClientVersion()) >= 0;
    }

    private static void sendSelfPacket(Player player, PacketWrapper packet) {
        Disguise disguise = DisguiseAPI.getDisguise(player, (Entity)player);
        if (disguise == null) {
            return;
        }
        LibsPackets transformed = PacketsManager.getPacketsHandler().transformPacket(packet, disguise, player, (Entity)player);
        if (transformed.isUnhandled()) {
            transformed.addPacket(packet);
        }
        LibsPackets newPackets = new LibsPackets(transformed.getOriginalPacket(), disguise);
        newPackets.setSkinHandling(transformed.isSkinHandling());
        for (PacketWrapper packetWrapper : transformed.getPackets()) {
            DisguiseUtilities.writeSelfDisguiseId(player.getEntityId(), packetWrapper);
            newPackets.addPacket(packetWrapper);
        }
        for (Map.Entry entry : transformed.getDelayedPacketsMap().entrySet()) {
            for (PacketWrapper newPacket : (ArrayList)entry.getValue()) {
                if (newPacket.getPacketTypeData().getPacketType() == PacketType.Play.Server.PLAYER_INFO || newPacket.getPacketTypeData().getPacketType() == PacketType.Play.Server.DESTROY_ENTITIES) continue;
                DisguiseUtilities.writeSelfDisguiseId(player.getEntityId(), newPacket);
                newPackets.addDelayedPacket(newPacket, (Integer)entry.getKey());
            }
        }
        if (disguise.isPlayerDisguise()) {
            LibsDisguises.getInstance().getSkinHandler().handlePackets(player, (PlayerDisguise)disguise, newPackets);
        }
        for (PacketWrapper packetWrapper : newPackets.getPackets()) {
            PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, packetWrapper);
        }
        newPackets.sendDelayed(player);
    }

    public static void setupFakeDisguise(Disguise disguise) {
        Entity e = disguise.getEntity();
        if (!(e instanceof Player && DisguiseUtilities.getDisguises().containsKey(e.getEntityId()) && DisguiseUtilities.getDisguises().get(e.getEntityId()).contains(disguise))) {
            return;
        }
        Player player = (Player)e;
        if (!((TargetedDisguise)disguise).canSee(player)) {
            return;
        }
        DisguiseUtilities.removeSelfDisguise(disguise);
        if (!disguise.isSelfDisguiseVisible() || !PacketsManager.isViewDisguisesListenerEnabled() || player.getVehicle() != null) {
            return;
        }
        selfDisguised.add(player.getUniqueId());
        DisguiseUtilities.sendSelfDisguise(player, (TargetedDisguise)disguise);
        if ((disguise.isHidingArmorFromSelf() || disguise.isHidingHeldItemFromSelf()) && PacketsManager.isInventoryListenerEnabled()) {
            player.updateInventory();
        }
    }

    public static List<EntityData> createDatawatcher(List<WatcherValue> watcherValues) {
        ArrayList<EntityData> list = new ArrayList<EntityData>();
        for (WatcherValue value : watcherValues) {
            list.add(value.getDataValue());
        }
        return list;
    }

    public static List<WatcherValue> createSanitizedWatcherValues(Player player, Entity disguisedEntity, FlagWatcher flagWatcher) {
        if (!DisguiseConfig.isMetaPacketsEnabled()) {
            return flagWatcher.getWatchableObjects();
        }
        return flagWatcher.convert(player, WatcherValue.getValues(disguisedEntity));
    }

    public static float getPitch(DisguiseType disguiseType, EntityType entityType, float value) {
        return DisguiseUtilities.getPitch(disguiseType, DisguiseUtilities.getPitch(DisguiseType.getType(entityType), value));
    }

    public static float getPitch(DisguiseType disguiseType, DisguiseType entityType, float value) {
        return DisguiseUtilities.getPitch(disguiseType, DisguiseUtilities.getPitch(entityType, value));
    }

    public static float getPitch(DisguiseType disguiseType, float value) {
        switch (disguiseType) {
            case BLOCK_DISPLAY: 
            case ITEM_DISPLAY: 
            case TEXT_DISPLAY: 
            case WITHER_SKULL: {
                return value;
            }
            case PHANTOM: {
                return -value;
            }
        }
        if (disguiseType.isMisc()) {
            return -value;
        }
        return value;
    }

    public static float getYaw(DisguiseType disguiseType, EntityType entityType, float value) {
        return DisguiseUtilities.getYaw(disguiseType, DisguiseUtilities.getYaw(DisguiseType.getType(entityType), value));
    }

    public static float getYaw(DisguiseType disguiseType, DisguiseType entityType, float value) {
        return DisguiseUtilities.getYaw(disguiseType, DisguiseUtilities.getYaw(entityType, value));
    }

    public static Direction getHangingDirection(float yaw) {
        return Direction.valueOf((String)BlockFace.values()[(int)Math.round((double)Math.abs((yaw + 720.0f) % 360.0f) / 90.0) % 4].name());
    }

    public static float getYaw(DisguiseType disguiseType, float value) {
        switch (disguiseType) {
            case MINECART: 
            case MINECART_CHEST: 
            case MINECART_COMMAND: 
            case MINECART_FURNACE: 
            case MINECART_HOPPER: 
            case MINECART_MOB_SPAWNER: 
            case MINECART_TNT: {
                return value + 90.0f;
            }
            case WITHER_SKULL: 
            case ACACIA_BOAT: 
            case ACACIA_CHEST_BOAT: 
            case BAMBOO_RAFT: 
            case BAMBOO_CHEST_RAFT: 
            case BIRCH_BOAT: 
            case BIRCH_CHEST_BOAT: 
            case CHERRY_BOAT: 
            case CHERRY_CHEST_BOAT: 
            case DARK_OAK_BOAT: 
            case DARK_OAK_CHEST_BOAT: 
            case JUNGLE_BOAT: 
            case JUNGLE_CHEST_BOAT: 
            case MANGROVE_BOAT: 
            case MANGROVE_CHEST_BOAT: 
            case OAK_BOAT: 
            case OAK_CHEST_BOAT: 
            case PALE_OAK_BOAT: 
            case PALE_OAK_CHEST_BOAT: 
            case SPRUCE_BOAT: 
            case SPRUCE_CHEST_BOAT: 
            case BOAT: 
            case ENDER_DRAGON: {
                return value - 180.0f;
            }
            case ARROW: 
            case SPECTRAL_ARROW: {
                return -value;
            }
            case PAINTING: 
            case ITEM_FRAME: 
            case GLOW_ITEM_FRAME: {
                return value + 180.0f;
            }
            case BLOCK_DISPLAY: 
            case ITEM_DISPLAY: 
            case TEXT_DISPLAY: {
                return value;
            }
        }
        if (disguiseType.isMisc() && disguiseType != DisguiseType.ARMOR_STAND) {
            return value - 90.0f;
        }
        return value;
    }

    public static PacketWrapper<?> updateTablistVisibility(Player player, boolean visible) {
        if (NmsVersion.v1_19_R2.isSupported()) {
            if (!visible && !DisguiseUtilities.isFancyHiddenTabs()) {
                return new WrapperPlayServerPlayerInfoRemove(new UUID[]{player.getUniqueId()});
            }
            WrapperPlayServerPlayerInfoUpdate.PlayerInfo info = new WrapperPlayServerPlayerInfoUpdate.PlayerInfo(ReflectionManager.getUserProfile(player), visible, player.getPing(), SpigotConversionUtil.fromBukkitGameMode((GameMode)player.getGameMode()), (Component)Component.text((String)DisguiseUtilities.getPlayerListName(player)), null);
            return new WrapperPlayServerPlayerInfoUpdate(DisguiseUtilities.isFancyHiddenTabs() ? WrapperPlayServerPlayerInfoUpdate.Action.UPDATE_LISTED : WrapperPlayServerPlayerInfoUpdate.Action.ADD_PLAYER, new WrapperPlayServerPlayerInfoUpdate.PlayerInfo[]{info});
        }
        WrapperPlayServerPlayerInfo.PlayerData playerInfo = new WrapperPlayServerPlayerInfo.PlayerData((Component)Component.text((String)DisguiseUtilities.getPlayerListName(player)), ReflectionManager.getUserProfile(player), SpigotConversionUtil.fromBukkitGameMode((GameMode)player.getGameMode()), NmsVersion.v1_17.isSupported() ? player.getPing() : 0);
        return new WrapperPlayServerPlayerInfo(visible ? WrapperPlayServerPlayerInfo.Action.ADD_PLAYER : WrapperPlayServerPlayerInfo.Action.REMOVE_PLAYER, new WrapperPlayServerPlayerInfo.PlayerData[]{playerInfo});
    }

    public static PacketWrapper<?> createTablistAddPackets(PlayerDisguise disguise) {
        if (!NmsVersion.v1_19_R2.isSupported()) {
            return DisguiseUtilities.createTablistPacket(disguise, WrapperPlayServerPlayerInfo.Action.ADD_PLAYER);
        }
        WrapperPlayServerPlayerInfoUpdate.PlayerInfo info = new WrapperPlayServerPlayerInfoUpdate.PlayerInfo(disguise.getUserProfile(), disguise.isDisplayedInTab(), 0, com.github.retrooper.packetevents.protocol.player.GameMode.SURVIVAL, (Component)Component.text((String)disguise.getTablistName()), null);
        return new WrapperPlayServerPlayerInfoUpdate(EnumSet.of(WrapperPlayServerPlayerInfoUpdate.Action.ADD_PLAYER, WrapperPlayServerPlayerInfoUpdate.Action.UPDATE_DISPLAY_NAME, WrapperPlayServerPlayerInfoUpdate.Action.UPDATE_LISTED), new WrapperPlayServerPlayerInfoUpdate.PlayerInfo[]{info});
    }

    public static PacketWrapper<?> createTablistPacket(PlayerDisguise disguise, WrapperPlayServerPlayerInfo.Action action) {
        if (!NmsVersion.v1_19_R2.isSupported()) {
            WrapperPlayServerPlayerInfo.PlayerData playerInfo = new WrapperPlayServerPlayerInfo.PlayerData((Component)Component.text((String)disguise.getTablistName()), disguise.getUserProfile(), com.github.retrooper.packetevents.protocol.player.GameMode.SURVIVAL, 0);
            return new WrapperPlayServerPlayerInfo(action, new WrapperPlayServerPlayerInfo.PlayerData[]{playerInfo});
        }
        if (action == WrapperPlayServerPlayerInfo.Action.REMOVE_PLAYER) {
            return new WrapperPlayServerPlayerInfoRemove(new UUID[]{disguise.getUUID()});
        }
        try {
            WrapperPlayServerPlayerInfoUpdate.PlayerInfo info = new WrapperPlayServerPlayerInfoUpdate.PlayerInfo(disguise.getUserProfile(), disguise.isDisplayedInTab(), 0, com.github.retrooper.packetevents.protocol.player.GameMode.SURVIVAL, (Component)Component.text((String)disguise.getTablistName()), null);
            return new WrapperPlayServerPlayerInfoUpdate(WrapperPlayServerPlayerInfoUpdate.Action.valueOf((String)action.name()), new WrapperPlayServerPlayerInfoUpdate.PlayerInfo[]{info});
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static List<PacketWrapper<?>> getNamePackets(Disguise disguise, Player viewer, String[] internalOldNames) {
        ArrayList packets = new ArrayList();
        Object[] newNames = disguise instanceof PlayerDisguise && !((PlayerDisguise)disguise).isNameVisible() ? new String[]{} : DisguiseUtilities.reverse(disguise.getMultiName());
        int[] standIds = disguise.getArmorstandIds();
        int[] destroyIds = new int[]{};
        if (!LibsPremium.isPremium().booleanValue()) {
            if (internalOldNames.length > 1) {
                internalOldNames = new String[]{StringUtils.join((Object[])internalOldNames, (String)"\\n")};
            }
            if (newNames.length > 1) {
                newNames = new String[]{StringUtils.join((Object[])newNames, (String)"\\n")};
                if ((!disguise.isPlayerDisguise() || ((PlayerDisguise)disguise).isNameVisible()) && disguise.getMultiName().length > 1) {
                    LibsDisguises.getInstance().getLogger().info("Multiline names is a premium feature, sorry!");
                }
            }
        }
        if (internalOldNames.length > newNames.length) {
            destroyIds = Arrays.copyOfRange(standIds, newNames.length, internalOldNames.length);
        }
        Location loc = disguise.getEntity().getLocation();
        double height = disguise.getHeight() + (double)disguise.getWatcher().getYModifier() + (double)disguise.getWatcher().getNameYModifier();
        double heightScale = disguise.getNameHeightScale();
        double startingY = loc.getY() + height * heightScale;
        startingY += DisguiseUtilities.getNameSpacing() * (heightScale - 1.0) * 0.35;
        boolean useTextDisplay = false;
        for (int i = 0; i < newNames.length; ++i) {
            WrapperPlayServerSpawnEntity spawnEntity;
            if (i < internalOldNames.length) {
                if (((String)newNames[i]).equals(internalOldNames[i])) continue;
                EntityData data = NmsVersion.v1_13.isSupported() ? ReflectionManager.getEntityData(MetaIndex.ENTITY_CUSTOM_NAME, Optional.of(DisguiseUtilities.getAdventureChat((String)newNames[i])), true) : ReflectionManager.getEntityData(MetaIndex.ENTITY_CUSTOM_NAME_OLD, ChatColor.translateAlternateColorCodes((char)'&', (String)newNames[i]), true);
                WrapperPlayServerEntityMetadata packet = new WrapperPlayServerEntityMetadata(standIds[i], Collections.singletonList(data));
                packets.add((PacketWrapper<?>)packet);
                continue;
            }
            if (((String)newNames[i]).isEmpty()) {
                destroyIds = Arrays.copyOf(destroyIds, destroyIds.length + 1);
                destroyIds[destroyIds.length - 1] = standIds[i];
                continue;
            }
            ArrayList<EntityData> watcherValues = new ArrayList<EntityData>();
            for (MetaIndex index : MetaIndex.getMetaIndexes(useTextDisplay ? TextDisplayWatcher.class : ArmorStandWatcher.class)) {
                Object val = index.getDefault();
                if (index == MetaIndex.ENTITY_META) {
                    val = (byte)32;
                } else if (index == MetaIndex.ARMORSTAND_META) {
                    val = (byte)19;
                } else if (index == MetaIndex.ENTITY_CUSTOM_NAME_OLD) {
                    val = ChatColor.translateAlternateColorCodes((char)'&', (String)newNames[i]);
                } else if (index == MetaIndex.ENTITY_CUSTOM_NAME_VISIBLE) {
                    val = true;
                } else if (index == MetaIndex.ENTITY_CUSTOM_NAME) {
                    val = Optional.of(DisguiseUtilities.getAdventureChat((String)newNames[i]));
                } else if (index == MetaIndex.TEXT_DISPLAY_TEXT) {
                    val = DisguiseUtilities.getAdventureChat((String)newNames[i]);
                } else if (index == MetaIndex.DISPLAY_SCALE && !disguise.isMiscDisguise()) {
                    Double d = viewer == disguise.getEntity() ? disguise.getInternals().getSelfDisguiseTallScaleMax() : ((LivingWatcher)disguise.getWatcher()).getScale().doubleValue();
                } else if (index == MetaIndex.DISPLAY_BILLBOARD_RENDER_CONSTRAINTS) {
                    val = (byte)ReflectionManager.enumOrdinal(Display.Billboard.CENTER);
                }
                watcherValues.add(new WatcherValue(index, val, true).getDataValue());
            }
            double y = startingY + DisguiseUtilities.getNameSpacing() * (double)i;
            if (useTextDisplay) {
                spawnEntity = new WrapperPlayServerSpawnEntity(standIds[i], Optional.of(UUID.randomUUID()), EntityTypes.TEXT_DISPLAY, new Vector3d(loc.getX(), y, loc.getZ()), 0.0f, 0.0f, 0.0f, 0, Optional.of(Vector3d.zero()));
                packets.add((PacketWrapper<?>)spawnEntity);
            } else if (NmsVersion.v1_19_R1.isSupported()) {
                spawnEntity = new WrapperPlayServerSpawnEntity(standIds[i], Optional.of(UUID.randomUUID()), EntityTypes.ARMOR_STAND, new Vector3d(loc.getX(), y, loc.getZ()), 0.0f, 0.0f, 0.0f, 0, Optional.of(Vector3d.zero()));
                packets.add((PacketWrapper<?>)spawnEntity);
            } else {
                spawnEntity = new WrapperPlayServerSpawnLivingEntity(standIds[i], UUID.randomUUID(), EntityTypes.ARMOR_STAND, new com.github.retrooper.packetevents.protocol.world.Location(loc.getX(), y, loc.getZ(), 0.0f, 0.0f), 0.0f, Vector3d.zero(), watcherValues);
                packets.add((PacketWrapper<?>)spawnEntity);
            }
            if (!NmsVersion.v1_15.isSupported()) continue;
            packets.add((PacketWrapper<?>)new WrapperPlayServerEntityMetadata(standIds[i], watcherValues));
        }
        if (destroyIds.length > 0) {
            packets.add((PacketWrapper<?>)DisguiseUtilities.getDestroyPacket(destroyIds));
        }
        return packets;
    }

    public static double getEntityScaleWithoutLibsDisguises(Entity entity) {
        if (!NmsVersion.v1_20_R4.isSupported() || !(entity instanceof LivingEntity)) {
            return 1.0;
        }
        AttributeInstance attribute = ((LivingEntity)entity).getAttribute(DisguiseUtilities.getScaleAttribute());
        double scale = attribute.getBaseValue();
        double modifiedScale = 0.0;
        for (int operation = 0; operation < 3; ++operation) {
            if (operation == 1) {
                modifiedScale = scale;
            }
            for (AttributeModifier modifier : attribute.getModifiers()) {
                if (DisguiseUtilities.isDisguisesSelfScalingAttribute(modifier)) continue;
                if (modifier.getOperation() == AttributeModifier.Operation.ADD_NUMBER && operation == 0) {
                    scale += modifier.getAmount();
                    continue;
                }
                if (modifier.getOperation() == AttributeModifier.Operation.ADD_SCALAR && operation == 1) {
                    modifiedScale += scale * modifier.getAmount();
                    continue;
                }
                if (modifier.getOperation() != AttributeModifier.Operation.MULTIPLY_SCALAR_1 || operation != 2) continue;
                modifiedScale *= 1.0 + modifier.getAmount();
            }
        }
        return modifiedScale;
    }

    public static Disguise getDisguise(final Player observer, int entityId) {
        TargetedDisguise[] disguises;
        if (entityId == DisguiseAPI.getSelfDisguiseId()) {
            entityId = observer.getEntityId();
        }
        if (DisguiseUtilities.getFutureDisguises().containsKey(entityId)) {
            Disguise disguise;
            boolean foundEntity = false;
            Set<TargetedDisguise> disguises2 = DisguiseUtilities.getDisguises().get(entityId);
            if (disguises2 != null && !disguises2.isEmpty() && (disguise = (Disguise)disguises2.iterator().next()).getEntity() != null) {
                foundEntity = true;
                DisguiseUtilities.onFutureDisguise(disguise.getEntity());
            }
            if (!foundEntity) {
                if (Bukkit.isPrimaryThread()) {
                    DisguiseUtilities.findEntities(observer, entityId);
                } else {
                    final int id = entityId;
                    final CountDownLatch latch = new CountDownLatch(1);
                    new BukkitRunnable(){

                        public void run() {
                            try {
                                DisguiseUtilities.findEntities(observer, id);
                            }
                            finally {
                                latch.countDown();
                            }
                        }
                    }.runTask((Plugin)LibsDisguises.getInstance());
                    try {
                        boolean mainThreadSuccess = latch.await(5L, TimeUnit.SECONDS);
                        if (!mainThreadSuccess) {
                            LibsDisguises.getInstance().getLogger().info(String.format("Packet processing was paused on '%s' for a \"future\" disguise, but took too long waiting for the main thread. The disguise may not have been applied properly.", observer.getName()));
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        if ((disguises = DisguiseUtilities.getDisguises(entityId)) == null) {
            return null;
        }
        for (TargetedDisguise dis : disguises) {
            if (!dis.isDisguiseInUse() || !dis.canSee(observer)) continue;
            return dis;
        }
        return null;
    }

    private static void findEntities(Player observer, int entityId) {
        for (Entity e : observer.getWorld().getEntities()) {
            if (e.getEntityId() != entityId) continue;
            DisguiseUtilities.onFutureDisguise(e);
            return;
        }
        if (!DisguiseUtilities.getFutureDisguises().containsKey(entityId)) {
            return;
        }
        LibsDisguises.getInstance().getLogger().info(String.format("Failed to find the entity for %s in %s's world. Yet player is still receiving packets about said entity. Now scanning all worlds.", entityId, observer.getName()));
        for (World world : Bukkit.getWorlds()) {
            if (world == observer.getWorld()) continue;
            for (Entity e : observer.getWorld().getEntities()) {
                if (e.getEntityId() != entityId) continue;
                DisguiseUtilities.onFutureDisguise(e);
                return;
            }
        }
        LibsDisguises.getInstance().getLogger().warning(String.format("Failed to find the entity for %s in any world, removing disguises for that entity ID. If this happens often, then a plugin is likely sending packets about an entity that is handled weirdly.", entityId));
        DisguiseUtilities.getFutureDisguises().remove(entityId);
    }

    public static double getYModifier(Disguise disguise) {
        Entity entity = disguise.getEntity();
        double yMod = 0.0;
        if (disguise.getType() != DisguiseType.PLAYER && entity.getType() == DisguiseUtilities.getEntityItem()) {
            yMod -= 0.13;
        }
        switch (disguise.getType()) {
            case ENDER_CRYSTAL: {
                return yMod + 1.0;
            }
            case BAT: {
                if (entity instanceof LivingEntity) {
                    return yMod + ((LivingEntity)entity).getEyeHeight();
                }
                return yMod;
            }
            case MINECART: 
            case MINECART_CHEST: 
            case MINECART_COMMAND: 
            case MINECART_FURNACE: 
            case MINECART_HOPPER: 
            case MINECART_MOB_SPAWNER: 
            case MINECART_TNT: {
                switch (entity.getType().name()) {
                    case "MINECART": 
                    case "MINECART_CHEST": 
                    case "MINECART_FURNACE": 
                    case "MINECART_HOPPER": 
                    case "MINECART_MOB_SPAWNER": 
                    case "MINECART_TNT": {
                        return yMod;
                    }
                }
                return yMod + 0.4;
            }
            case WITHER_SKULL: 
            case ACACIA_BOAT: 
            case ACACIA_CHEST_BOAT: 
            case BAMBOO_RAFT: 
            case BAMBOO_CHEST_RAFT: 
            case BIRCH_BOAT: 
            case BIRCH_CHEST_BOAT: 
            case CHERRY_BOAT: 
            case CHERRY_CHEST_BOAT: 
            case DARK_OAK_BOAT: 
            case DARK_OAK_CHEST_BOAT: 
            case JUNGLE_BOAT: 
            case JUNGLE_CHEST_BOAT: 
            case MANGROVE_BOAT: 
            case MANGROVE_CHEST_BOAT: 
            case OAK_BOAT: 
            case OAK_CHEST_BOAT: 
            case PALE_OAK_BOAT: 
            case PALE_OAK_CHEST_BOAT: 
            case SPRUCE_BOAT: 
            case SPRUCE_CHEST_BOAT: 
            case BOAT: 
            case ARROW: 
            case SPECTRAL_ARROW: 
            case PAINTING: 
            case EGG: 
            case ENDER_PEARL: 
            case ENDER_SIGNAL: 
            case FIREWORK: 
            case SMALL_FIREBALL: 
            case SNOWBALL: 
            case SPLASH_POTION: 
            case THROWN_EXP_BOTTLE: {
                return yMod + 0.7;
            }
            case DROPPED_ITEM: {
                return yMod + 0.13;
            }
        }
        return yMod;
    }

    public static ItemStack getEquipment(EquipmentSlot slot, Entity disguisedEntity) {
        if (!(disguisedEntity instanceof LivingEntity)) {
            return null;
        }
        switch (slot) {
            case HAND: {
                return ((LivingEntity)disguisedEntity).getEquipment().getItemInMainHand();
            }
            case OFF_HAND: {
                return ((LivingEntity)disguisedEntity).getEquipment().getItemInOffHand();
            }
            case FEET: {
                return ((LivingEntity)disguisedEntity).getEquipment().getBoots();
            }
            case LEGS: {
                return ((LivingEntity)disguisedEntity).getEquipment().getLeggings();
            }
            case CHEST: {
                return ((LivingEntity)disguisedEntity).getEquipment().getChestplate();
            }
            case HEAD: {
                return ((LivingEntity)disguisedEntity).getEquipment().getHelmet();
            }
        }
        if (NmsVersion.v1_20_R4.isSupported() && slot == EquipmentSlot.BODY) {
            if (disguisedEntity instanceof Player) {
                return new ItemStack(Material.AIR);
            }
            return ((LivingEntity)disguisedEntity).getEquipment().getItem(slot);
        }
        return null;
    }

    public static EquipmentSlot getSlot(com.github.retrooper.packetevents.protocol.player.EquipmentSlot slot) {
        switch (slot) {
            case BOOTS: {
                return EquipmentSlot.FEET;
            }
            case HELMET: {
                return EquipmentSlot.HEAD;
            }
            case LEGGINGS: {
                return EquipmentSlot.LEGS;
            }
            case MAIN_HAND: {
                return EquipmentSlot.HAND;
            }
            case OFF_HAND: {
                return EquipmentSlot.OFF_HAND;
            }
            case CHEST_PLATE: {
                return EquipmentSlot.CHEST;
            }
            case BODY: {
                return EquipmentSlot.BODY;
            }
        }
        throw new IllegalStateException("Unknown equip slot " + slot);
    }

    public static com.github.retrooper.packetevents.protocol.player.EquipmentSlot getSlot(EquipmentSlot slot) {
        switch (slot) {
            case FEET: {
                return com.github.retrooper.packetevents.protocol.player.EquipmentSlot.BOOTS;
            }
            case OFF_HAND: {
                return com.github.retrooper.packetevents.protocol.player.EquipmentSlot.OFF_HAND;
            }
            case HEAD: {
                return com.github.retrooper.packetevents.protocol.player.EquipmentSlot.HELMET;
            }
            case HAND: {
                return com.github.retrooper.packetevents.protocol.player.EquipmentSlot.MAIN_HAND;
            }
            case CHEST: {
                return com.github.retrooper.packetevents.protocol.player.EquipmentSlot.CHEST_PLATE;
            }
            case LEGS: {
                return com.github.retrooper.packetevents.protocol.player.EquipmentSlot.LEGGINGS;
            }
            case BODY: {
                return com.github.retrooper.packetevents.protocol.player.EquipmentSlot.BODY;
            }
        }
        throw new IllegalStateException("Unknown equip slot " + slot);
    }

    @Generated
    public static Random getRandom() {
        return random;
    }

    @Generated
    public static Map<Integer, Set<TargetedDisguise>> getDisguises() {
        return disguises;
    }

    @Generated
    public static Map<Integer, HashSet<TargetedDisguise>> getFutureDisguises() {
        return futureDisguises;
    }

    @Generated
    public static HashSet<UUID> getSelfDisguised() {
        return selfDisguised;
    }

    @Generated
    public static Gson getGson() {
        return gson;
    }

    @Generated
    public static boolean isPluginsUsed() {
        return pluginsUsed;
    }

    @Generated
    public static boolean isCommandsUsed() {
        return commandsUsed;
    }

    @Generated
    public static boolean isCopyDisguiseCommandUsed() {
        return copyDisguiseCommandUsed;
    }

    @Generated
    public static boolean isGrabSkinCommandUsed() {
        return grabSkinCommandUsed;
    }

    @Generated
    public static boolean isSaveDisguiseCommandUsed() {
        return saveDisguiseCommandUsed;
    }

    @Generated
    public static boolean isGrabHeadCommandUsed() {
        return grabHeadCommandUsed;
    }

    @Generated
    public static boolean isRunningPaper() {
        return runningPaper;
    }

    @Generated
    public static boolean isRunningGeyser() {
        return runningGeyser;
    }

    @Generated
    public static boolean isInvalidFile() {
        return invalidFile;
    }

    @Generated
    public static char[] getAlphabet() {
        return alphabet;
    }

    @Generated
    public static List<UUID> getViewSelf() {
        return viewSelf;
    }

    @Generated
    public static List<UUID> getViewBar() {
        return viewBar;
    }

    @Generated
    public static ConcurrentHashMap<String, DScoreTeam> getTeams() {
        return teams;
    }

    @Generated
    public static boolean isFancyHiddenTabs() {
        return fancyHiddenTabs;
    }

    @Generated
    public static NamespacedKey getOldSavedDisguisesKey() {
        return oldSavedDisguisesKey;
    }

    @Generated
    public static NamespacedKey getSavedDisguisesKey() {
        return savedDisguisesKey;
    }

    @Generated
    public static org.bukkit.enchantments.Enchantment getDurabilityEnchantment() {
        return durabilityEnchantment;
    }

    @Generated
    public static org.bukkit.enchantments.Enchantment getWaterbreathingEnchantment() {
        return waterbreathingEnchantment;
    }

    @Generated
    public static EntityType getEntityItem() {
        return entityItem;
    }

    @Generated
    public static MiniMessage getMiniMessage() {
        return miniMessage;
    }

    @Generated
    public static NamespacedKey getSelfDisguiseScaleNamespace() {
        return selfDisguiseScaleNamespace;
    }

    @Generated
    public static UUID getSelfDisguiseScaleUUID() {
        return selfDisguiseScaleUUID;
    }

    @Generated
    public static Attribute getScaleAttribute() {
        return scaleAttribute;
    }

    @Generated
    public static boolean isDebuggingMode() {
        return debuggingMode;
    }

    @Generated
    public static void setDebuggingMode(boolean debuggingMode) {
        DisguiseUtilities.debuggingMode = debuggingMode;
    }

    @Generated
    public static File getInternalFolder() {
        return internalFolder;
    }

    @Generated
    public static File getInternalFile() {
        return internalFile;
    }

    @Generated
    public static File getPreferencesFile() {
        return preferencesFile;
    }

    static {
        velocityTimes = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.SECONDS).build();
        disguiseLoading = new HashMap();
        alphabet = "0123456789abcdefghijklmnopqrstuvwxyz".toCharArray();
        urlMatcher = Pattern.compile("^(?:(https?)://)?([-\\w_.]{2,}\\.[a-z]{2,4})(/\\S*)?$");
        viewSelf = new ArrayList<UUID>();
        viewBar = new ArrayList<UUID>();
        teams = new ConcurrentHashMap();
        warnedSkin = new HashSet();
        whitelistedEnchantments = new HashMap<org.bukkit.enchantments.Enchantment, EnchantmentType>();
        miniMessage = MiniMessage.builder().build();
        internalComponentSerializer = libsdisg.shaded.net.kyori.adventure.text.serializer.gson.GsonComponentSerializer.gson();
        externalComponentSerializer = GsonComponentSerializer.gson();
        selfDisguiseScaleUUID = UUID.randomUUID();
        try {
            runningPaper = Class.forName("com.destroystokyo.paper.VersionHistoryManager$VersionData") != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (LibsDisguises.getInstance() == null) {
            profileCache = null;
            sanitySkinCacheFile = null;
            savedDisguises = null;
            internalFolder = null;
            internalFile = null;
            preferencesFile = null;
        } else {
            profileCache = new File(LibsDisguises.getInstance().getDataFolder(), "SavedSkins");
            sanitySkinCacheFile = new File(LibsDisguises.getInstance().getDataFolder(), "SavedSkins/sanity.json");
            savedDisguises = new File(LibsDisguises.getInstance().getDataFolder(), "SavedDisguises");
            runningGeyser = Bukkit.getPluginManager().getPlugin("Geyser-Spigot") != null;
            internalFolder = new File(LibsDisguises.getInstance().getDataFolder(), "internal");
            internalFile = new File(DisguiseUtilities.getInternalFolder(), "internal.yml");
            preferencesFile = new File(DisguiseUtilities.getInternalFolder(), "preferences.json");
            internalFolder.mkdirs();
            for (String oldName : new String[]{"internal.yml", "preferences.json", "mappings_cache"}) {
                File previous;
                File file = new File(DisguiseUtilities.getInternalFolder(), oldName);
                if (file.exists() || !(previous = new File(LibsDisguises.getInstance().getDataFolder(), oldName)).exists()) continue;
                try {
                    Files.move(previous.toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (NmsVersion.v1_20_R4.isSupported()) {
                scaleAttribute = (Attribute)Registry.ATTRIBUTE.get(NamespacedKey.minecraft((String)(NmsVersion.v1_21_R2.isSupported() ? "scale" : "generic.scale")));
            }
        }
        entityItem = EntityType.fromName((String)"item");
        if (Bukkit.getServer() != null) {
            String name;
            int n;
            String[] stringArray = new String[]{"unbreaking", "DURABILITY"};
            int n2 = stringArray.length;
            for (n = 0; n < n2 && (durabilityEnchantment = org.bukkit.enchantments.Enchantment.getByName((String)(name = stringArray[n]))) == null; ++n) {
            }
            stringArray = new String[]{"respiration", "OXYGEN"};
            n2 = stringArray.length;
            for (n = 0; n < n2 && (waterbreathingEnchantment = org.bukkit.enchantments.Enchantment.getByName((String)(name = stringArray[n]))) == null; ++n) {
            }
            if (DisguiseUtilities.getDurabilityEnchantment() == null) {
                throw new IllegalArgumentException("Unable to load durability enchantment");
            }
            if (DisguiseUtilities.getWaterbreathingEnchantment() == null) {
                throw new IllegalArgumentException("Unable to load water breathing enchantment");
            }
            whitelistedEnchantments.put(org.bukkit.enchantments.Enchantment.DEPTH_STRIDER, EnchantmentTypes.DEPTH_STRIDER);
            whitelistedEnchantments.put(DisguiseUtilities.getWaterbreathingEnchantment(), EnchantmentTypes.RESPIRATION);
            if (Bukkit.getServer() != null && NmsVersion.v1_13.isSupported()) {
                whitelistedEnchantments.put(org.bukkit.enchantments.Enchantment.RIPTIDE, EnchantmentTypes.RIPTIDE);
                if (NmsVersion.v1_19_R1.isSupported()) {
                    whitelistedEnchantments.put(org.bukkit.enchantments.Enchantment.SOUL_SPEED, EnchantmentTypes.SOUL_SPEED);
                    whitelistedEnchantments.put(org.bukkit.enchantments.Enchantment.SWIFT_SNEAK, EnchantmentTypes.SWIFT_SNEAK);
                }
            }
        }
    }

    private static class UsersData {
        String[] users;
        long fetched;

        private UsersData() {
        }
    }

    public static class DScoreTeam {
        private String teamName;
        private String[] split;
        private PlayerDisguise disguise;

        public DScoreTeam(PlayerDisguise disguise, String[] name) {
            this.disguise = disguise;
            this.split = name;
        }

        public String getPlayer() {
            return this.split[1];
        }

        public synchronized String getPrefix() {
            return this.split[0];
        }

        public synchronized String getSuffix() {
            return this.split[2];
        }

        public synchronized void setSplit(String[] split) {
            this.split = split;
        }

        public void handleTeam(Scoreboard board, boolean nameVisible) {
            nameVisible = !DisguiseConfig.isArmorstandsName() && nameVisible;
            Team team = board.getTeam(this.getTeamName());
            if (team == null) {
                team = board.registerNewTeam(this.getTeamName());
                team.addEntry(this.getPlayer());
                if (!nameVisible) {
                    team.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.NEVER);
                }
            } else if (team.getOption(Team.Option.NAME_TAG_VISIBILITY) != (nameVisible ? Team.OptionStatus.ALWAYS : Team.OptionStatus.NEVER)) {
                team.setOption(Team.Option.NAME_TAG_VISIBILITY, nameVisible ? Team.OptionStatus.ALWAYS : Team.OptionStatus.NEVER);
            }
            if (DisguiseConfig.isModifyCollisions() && team.getOption(Team.Option.COLLISION_RULE) != Team.OptionStatus.NEVER) {
                team.setOption(Team.Option.COLLISION_RULE, Team.OptionStatus.NEVER);
            }
            if (this.disguise.getWatcher().getGlowColor() != null && this.disguise.getWatcher().getGlowColor() != team.getColor()) {
                team.setColor(this.disguise.getWatcher().getGlowColor());
            }
            String prefix = this.getPrefix();
            String suffix = this.getSuffix();
            if (!prefix.equals(team.getPrefix())) {
                team.setPrefix(NmsVersion.v1_13.isSupported() ? "Colorize" : prefix);
            }
            if (!suffix.equals(team.getSuffix())) {
                team.setSuffix(NmsVersion.v1_13.isSupported() ? "Colorize" : suffix);
            }
        }

        @Generated
        public void setTeamName(String teamName) {
            this.teamName = teamName;
        }

        @Generated
        public void setDisguise(PlayerDisguise disguise) {
            this.disguise = disguise;
        }

        @Generated
        public String getTeamName() {
            return this.teamName;
        }
    }
}

