/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.protocol.attribute.Attributes;
import com.github.retrooper.packetevents.protocol.particle.Particle;
import com.github.retrooper.packetevents.protocol.particle.data.ParticleColorData;
import com.github.retrooper.packetevents.protocol.particle.data.ParticleData;
import com.github.retrooper.packetevents.protocol.particle.type.ParticleTypes;
import com.github.retrooper.packetevents.util.Vector3i;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerUpdateAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.annotations.MethodGroupType;
import me.libraryaddict.disguise.utilities.reflection.annotations.MethodOnlyUsedBy;
import me.libraryaddict.disguise.utilities.reflection.annotations.NmsAddedIn;
import me.libraryaddict.disguise.utilities.reflection.annotations.NmsRemovedIn;
import org.bukkit.Color;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffectType;

public class LivingWatcher
extends FlagWatcher {
    private double maxHealth;
    private boolean maxHealthSet;
    private HashSet<String> potionEffects = new HashSet();
    private boolean[] modifiedLivingAnimations = new boolean[3];
    private Double viewScale;
    private boolean isScaleSet;

    public LivingWatcher(Disguise disguise) {
        super(disguise);
    }

    @Override
    public LivingWatcher clone(Disguise disguise) {
        LivingWatcher clone = (LivingWatcher)super.clone(disguise);
        clone.potionEffects = (HashSet)this.potionEffects.clone();
        clone.maxHealth = this.maxHealth;
        clone.maxHealthSet = this.maxHealthSet;
        clone.modifiedLivingAnimations = Arrays.copyOf(this.modifiedLivingAnimations, this.modifiedLivingAnimations.length);
        clone.viewScale = this.viewScale;
        return clone;
    }

    @NmsAddedIn(value=NmsVersion.v1_20_R4)
    public Double getScale() {
        return this.viewScale;
    }

    @NmsAddedIn(value=NmsVersion.v1_20_R4)
    public void setScale(Double viewScale) {
        if (!NmsVersion.v1_20_R4.isSupported()) {
            return;
        }
        if (viewScale != null) {
            if (viewScale < 0.0) {
                viewScale = 0.0;
            } else if (viewScale > 100.0) {
                viewScale = 100.0;
            }
        }
        this.viewScale = viewScale;
        if (this.getDisguise() == null || !this.getDisguise().isDisguiseInUse() || this.getDisguise().getWatcher() != this) {
            return;
        }
        this.updateNameHeight();
        double scaleToSend = this.getScale() != null ? this.getScale() : DisguiseUtilities.getEntityScaleWithoutLibsDisguises(this.getDisguise().getEntity());
        Entity entity = this.getDisguise().getEntity();
        for (Player player : DisguiseUtilities.getPerverts(this.getDisguise())) {
            double toSend = player == entity && this.getDisguise().isTallSelfDisguisesScaling() ? Math.min(this.getDisguise().getInternals().getSelfDisguiseTallScaleMax(), scaleToSend) : scaleToSend;
            WrapperPlayServerUpdateAttributes.Property property = new WrapperPlayServerUpdateAttributes.Property(Attributes.GENERIC_SCALE, toSend, new ArrayList());
            WrapperPlayServerUpdateAttributes packet = new WrapperPlayServerUpdateAttributes(player == this.getDisguise().getEntity() ? DisguiseAPI.getSelfDisguiseId() : this.getDisguise().getEntity().getEntityId(), Collections.singletonList(property));
            if (player == this.getDisguise().getEntity()) {
                PacketEvents.getAPI().getPlayerManager().sendPacketSilently((Object)player, (PacketWrapper)packet);
                continue;
            }
            PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, (PacketWrapper)packet);
        }
    }

    @NmsAddedIn(value=NmsVersion.v1_14)
    public Vector3i getBedPosition() {
        return this.getData(MetaIndex.LIVING_BED_POSITION).orElse(null);
    }

    @NmsAddedIn(value=NmsVersion.v1_14)
    public void setBedPosition(Vector3i blockPosition) {
        Optional<Object> optional = blockPosition != null ? Optional.of(blockPosition) : Optional.empty();
        this.sendData(MetaIndex.LIVING_BED_POSITION, optional);
    }

    public float getHealth() {
        return this.getData(MetaIndex.LIVING_HEALTH).floatValue();
    }

    public void setHealth(float health) {
        this.sendData(MetaIndex.LIVING_HEALTH, Float.valueOf(health));
    }

    private boolean getHandFlag(int byteValue) {
        return (this.getData(MetaIndex.LIVING_META) & 1 << byteValue) != 0;
    }

    private void setHandFlag(int byteValue, boolean flag) {
        byte b0 = this.getData(MetaIndex.LIVING_META);
        this.modifiedLivingAnimations[byteValue] = true;
        b0 = flag ? (byte)(b0 | 1 << byteValue) : (byte)(b0 & ~(1 << byteValue));
        this.sendData(MetaIndex.LIVING_META, b0);
    }

    private boolean isMainHandUsed() {
        return !this.getHandFlag(1);
    }

    private void setHandInUse(boolean mainHand) {
        if (this.isMainHandUsed() == mainHand) {
            return;
        }
        this.setHandFlag(1, !mainHand);
    }

    @Override
    @NmsAddedIn(value=NmsVersion.v1_13)
    public boolean isMainHandRaised() {
        return this.isMainHandUsed() && this.getHandFlag(0);
    }

    @Override
    @NmsAddedIn(value=NmsVersion.v1_13)
    @MethodOnlyUsedBy(value={}, group=MethodGroupType.HOLDABLE)
    public void setMainHandRaised(boolean setRightClicking) {
        this.setHandInUse(true);
        this.setHandFlag(0, setRightClicking);
    }

    @NmsAddedIn(value=NmsVersion.v1_13)
    public boolean isOffhandRaised() {
        return !this.isMainHandUsed() && this.getHandFlag(0);
    }

    @NmsAddedIn(value=NmsVersion.v1_13)
    @MethodOnlyUsedBy(value={}, group=MethodGroupType.HOLDABLE)
    public void setOffhandRaised(boolean setLeftClicking) {
        this.setHandInUse(false);
        this.setHandFlag(0, setLeftClicking);
    }

    @NmsAddedIn(value=NmsVersion.v1_13)
    public boolean isSpinning() {
        return this.getHandFlag(2);
    }

    @NmsAddedIn(value=NmsVersion.v1_13)
    public void setSpinning(boolean setSpinning) {
        this.setHandFlag(2, setSpinning);
    }

    public void setMaxHealth(double newHealth) {
        this.maxHealth = newHealth;
        this.maxHealthSet = true;
        if (!this.getDisguise().isDisguiseInUse() || this.getDisguise().getWatcher() != this) {
            return;
        }
        for (Player player : DisguiseUtilities.getPerverts(this.getDisguise())) {
            WrapperPlayServerUpdateAttributes.Property property = new WrapperPlayServerUpdateAttributes.Property(Attributes.GENERIC_MAX_HEALTH, this.getMaxHealth(), new ArrayList());
            WrapperPlayServerUpdateAttributes packet = new WrapperPlayServerUpdateAttributes(player == this.getDisguise().getEntity() ? DisguiseAPI.getSelfDisguiseId() : this.getDisguise().getEntity().getEntityId(), Collections.singletonList(property));
            if (player == this.getDisguise().getEntity()) {
                PacketEvents.getAPI().getPlayerManager().sendPacketSilently((Object)player, (PacketWrapper)packet);
                continue;
            }
            PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, (PacketWrapper)packet);
        }
    }

    public boolean isPotionParticlesAmbient() {
        return this.getData(MetaIndex.LIVING_POTION_AMBIENT);
    }

    public void setPotionParticlesAmbient(boolean particles) {
        this.sendData(MetaIndex.LIVING_POTION_AMBIENT, particles);
    }

    @NmsAddedIn(value=NmsVersion.v1_20_R4)
    public void addParticle(Particle<? extends ParticleData> particle) {
        this.getData(MetaIndex.LIVING_PARTICLES).add(particle);
        this.sendData(MetaIndex.LIVING_PARTICLES);
    }

    @SafeVarargs
    @NmsAddedIn(value=NmsVersion.v1_20_R4)
    public final void removeParticles(Particle<? extends ParticleData> ... particles) {
        for (Particle<? extends ParticleData> particle : particles) {
            this.getData(MetaIndex.LIVING_PARTICLES).remove(particle);
        }
        this.sendData(MetaIndex.LIVING_PARTICLES);
    }

    @NmsAddedIn(value=NmsVersion.v1_20_R4)
    public List<Particle<? extends ParticleData>> getParticles() {
        return Collections.unmodifiableList(this.getData(MetaIndex.LIVING_PARTICLES));
    }

    public Color getParticlesColor() {
        if (!NmsVersion.v1_20_R4.isSupported()) {
            return Color.fromRGB((int)this.getData(MetaIndex.LIVING_POTIONS));
        }
        return this.getData(MetaIndex.LIVING_PARTICLES).stream().filter(p -> p.getType() == ParticleTypes.ENTITY_EFFECT).findAny().map(p -> Color.fromRGB((int)((ParticleColorData)p.getData()).getColor())).orElse(Color.BLACK);
    }

    public void setParticlesColor(Color color) {
        this.potionEffects.clear();
        if (NmsVersion.v1_20_R4.isSupported()) {
            ArrayList<Particle> particles = new ArrayList<Particle>((Collection)this.getData(MetaIndex.LIVING_PARTICLES));
            particles.removeIf(d -> d.getType() == ParticleTypes.ENTITY_EFFECT);
            particles.add(new Particle(ParticleTypes.ENTITY_EFFECT, (ParticleData)new ParticleColorData(color.asRGB())));
            this.sendData(MetaIndex.LIVING_PARTICLES, particles);
        } else {
            this.sendData(MetaIndex.LIVING_POTIONS, color.asRGB());
        }
    }

    private int getPotions() {
        if (this.potionEffects.isEmpty()) {
            return 0;
        }
        ArrayList<Color> colors = new ArrayList<Color>();
        for (String typeId : this.potionEffects) {
            Color color;
            PotionEffectType type = PotionEffectType.getByName((String)typeId);
            if (type == null || (color = type.getColor()) == null) continue;
            colors.add(color);
        }
        if (colors.isEmpty()) {
            return 0;
        }
        Color color = (Color)colors.remove(0);
        return color.mixColors(colors.toArray(new Color[0])).asRGB();
    }

    @Deprecated
    public boolean hasPotionEffect(PotionEffectType type) {
        return this.potionEffects.contains(type.getName());
    }

    @Deprecated
    public PotionEffectType[] getPotionEffects() {
        PotionEffectType[] effects = new PotionEffectType[this.potionEffects.size()];
        int i = 0;
        for (String potionEffect : this.potionEffects) {
            PotionEffectType type = PotionEffectType.getByName((String)potionEffect);
            effects[i++] = type;
        }
        return effects;
    }

    @Deprecated
    @NmsRemovedIn(value=NmsVersion.v1_20_R4)
    public void addPotionEffect(PotionEffectType potionEffect) {
        if (!this.hasPotionEffect(potionEffect)) {
            this.potionEffects.add(potionEffect.getName());
        }
        this.sendPotionEffects();
    }

    @Deprecated
    @NmsRemovedIn(value=NmsVersion.v1_20_R4)
    public void removePotionEffect(PotionEffectType potionEffect) {
        if (this.hasPotionEffect(potionEffect)) {
            this.potionEffects.remove(potionEffect.getName());
        }
        this.sendPotionEffects();
    }

    private void sendPotionEffects() {
        this.sendData(MetaIndex.LIVING_POTIONS, this.getPotions());
    }

    public int getArrowsSticking() {
        return this.getData(MetaIndex.LIVING_ARROWS);
    }

    @MethodOnlyUsedBy(value={DisguiseType.PLAYER})
    public void setArrowsSticking(int arrowsNo) {
        this.sendData(MetaIndex.LIVING_ARROWS, Math.max(0, Math.min(127, arrowsNo)));
    }

    @Override
    protected byte addEntityAnimations(MetaIndex index, byte originalValue, byte entityValue) {
        if (index != MetaIndex.LIVING_META) {
            return super.addEntityAnimations(index, originalValue, entityValue);
        }
        for (int i = 0; i < 3; ++i) {
            if ((entityValue & 1 << i) == 0 || this.modifiedLivingAnimations[i]) continue;
            originalValue = (byte)(originalValue | 1 << i);
        }
        return originalValue;
    }

    @Override
    @Deprecated
    @NmsAddedIn(value=NmsVersion.v1_12)
    public boolean isRightClicking() {
        return this.isMainHandRaised();
    }

    @Override
    @Deprecated
    @NmsAddedIn(value=NmsVersion.v1_12)
    @MethodOnlyUsedBy(value={}, group=MethodGroupType.HOLDABLE)
    public void setRightClicking(boolean rightClicking) {
        this.setMainHandRaised(rightClicking);
    }

    @Generated
    public double getMaxHealth() {
        return this.maxHealth;
    }

    @Generated
    public boolean isMaxHealthSet() {
        return this.maxHealthSet;
    }

    @Generated
    public boolean[] getModifiedLivingAnimations() {
        return this.modifiedLivingAnimations;
    }
}

