/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.packets;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketListenerCommon;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import java.util.ArrayList;
import lombok.Generated;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.packets.PacketsHandler;
import me.libraryaddict.disguise.utilities.packets.packetlisteners.PacketListenerClientCustomPayload;
import me.libraryaddict.disguise.utilities.packets.packetlisteners.PacketListenerClientInteract;
import me.libraryaddict.disguise.utilities.packets.packetlisteners.PacketListenerEntityDestroy;
import me.libraryaddict.disguise.utilities.packets.packetlisteners.PacketListenerInventory;
import me.libraryaddict.disguise.utilities.packets.packetlisteners.PacketListenerMain;
import me.libraryaddict.disguise.utilities.packets.packetlisteners.PacketListenerScoreboardTeam;
import me.libraryaddict.disguise.utilities.packets.packetlisteners.PacketListenerSounds;
import me.libraryaddict.disguise.utilities.packets.packetlisteners.PacketListenerTabList;
import me.libraryaddict.disguise.utilities.packets.packetlisteners.PacketListenerVehicleMovement;
import me.libraryaddict.disguise.utilities.packets.packetlisteners.PacketListenerViewSelfDisguise;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class PacketsManager {
    private static final PacketListenerClientInteract clientInteractEntityListener = new PacketListenerClientInteract();
    private static final PacketListenerTabList tablistListener = new PacketListenerTabList();
    private static final PacketListenerClientCustomPayload customPayload = new PacketListenerClientCustomPayload();
    private static PacketListenerInventory inventoryListener;
    private static boolean inventoryListenerEnabled;
    private static PacketListenerMain mainListener;
    private static PacketListenerSounds soundsListener;
    private static boolean soundsListenerEnabled;
    private static PacketListenerViewSelfDisguise viewDisguisesListener;
    private static boolean viewDisguisesListenerEnabled;
    private static PacketsHandler packetsHandler;
    private static boolean initialListenersRegistered;

    public static void addPacketListeners() {
        if (!initialListenersRegistered) {
            PacketEvents.getAPI().getEventManager().registerListener((PacketListenerCommon)clientInteractEntityListener);
            PacketEvents.getAPI().getEventManager().registerListener((PacketListenerCommon)tablistListener);
            if (DisguiseConfig.isLoginPayloadPackets()) {
                PacketEvents.getAPI().getEventManager().registerListener((PacketListenerCommon)customPayload);
            }
            PacketListenerVehicleMovement vehicleMovement = new PacketListenerVehicleMovement();
            Bukkit.getPluginManager().registerEvents((Listener)vehicleMovement, (Plugin)LibsDisguises.getInstance());
            PacketEvents.getAPI().getEventManager().registerListener((PacketListenerCommon)vehicleMovement);
            initialListenersRegistered = true;
            PacketEvents.getAPI().getSettings().fullStackTrace(true);
        }
        PacketsManager.setupMainPacketsListener();
    }

    public static void init() {
        soundsListener = new PacketListenerSounds();
        viewDisguisesListener = new PacketListenerViewSelfDisguise();
        inventoryListener = new PacketListenerInventory();
        packetsHandler = new PacketsHandler();
    }

    public static boolean isHearDisguisesEnabled() {
        return soundsListenerEnabled;
    }

    public static void setInventoryListenerEnabled(boolean enabled) {
        if (PacketsManager.isInventoryListenerEnabled() == enabled || inventoryListener == null) {
            return;
        }
        inventoryListenerEnabled = enabled;
        if (inventoryListenerEnabled) {
            PacketEvents.getAPI().getEventManager().registerListener((PacketListenerCommon)inventoryListener);
        } else {
            PacketEvents.getAPI().getEventManager().unregisterListener((PacketListenerCommon)inventoryListener);
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            Disguise disguise = DisguiseAPI.getDisguise(player, (Entity)player);
            if (disguise == null || !PacketsManager.isViewDisguisesListenerEnabled() || !disguise.isSelfDisguiseVisible() || !disguise.isHideArmorFromSelf() && !disguise.isHideHeldItemFromSelf()) continue;
            player.updateInventory();
        }
    }

    public static void setHearDisguisesListener(boolean enabled) {
        if (soundsListenerEnabled == enabled) {
            return;
        }
        soundsListenerEnabled = enabled;
        if (soundsListenerEnabled) {
            PacketEvents.getAPI().getEventManager().registerListener((PacketListenerCommon)soundsListener);
        } else {
            PacketEvents.getAPI().getEventManager().unregisterListener((PacketListenerCommon)soundsListener);
        }
    }

    public static void setupMainPacketsListener() {
        if (!initialListenersRegistered) {
            return;
        }
        if (mainListener != null) {
            PacketEvents.getAPI().getEventManager().unregisterListener((PacketListenerCommon)mainListener);
        }
        PacketsManager.getPacketsHandler().registerPacketHandlers();
        ArrayList<PacketType.Play.Server> packetsToListen = new ArrayList<PacketType.Play.Server>();
        if (!NmsVersion.v1_20_R2.isSupported()) {
            packetsToListen.add(PacketType.Play.Server.SPAWN_PLAYER);
        }
        packetsToListen.add(PacketType.Play.Server.SPAWN_EXPERIENCE_ORB);
        packetsToListen.add(PacketType.Play.Server.SPAWN_ENTITY);
        if (!NmsVersion.v1_19_R1.isSupported()) {
            packetsToListen.add(PacketType.Play.Server.SPAWN_LIVING_ENTITY);
            packetsToListen.add(PacketType.Play.Server.SPAWN_PAINTING);
        }
        packetsToListen.add(PacketType.Play.Server.ENTITY_METADATA);
        if (DisguiseConfig.isCollectPacketsEnabled()) {
            packetsToListen.add(PacketType.Play.Server.COLLECT_ITEM);
        }
        if (DisguiseConfig.isMiscDisguisesForLivingEnabled()) {
            packetsToListen.add(PacketType.Play.Server.UPDATE_ATTRIBUTES);
        }
        if (DisguiseConfig.isMovementPacketsEnabled()) {
            packetsToListen.add(PacketType.Play.Server.ENTITY_MOVEMENT);
            packetsToListen.add(PacketType.Play.Server.ENTITY_RELATIVE_MOVE_AND_ROTATION);
            packetsToListen.add(PacketType.Play.Server.ENTITY_HEAD_LOOK);
            packetsToListen.add(PacketType.Play.Server.ENTITY_TELEPORT);
            packetsToListen.add(PacketType.Play.Server.ENTITY_RELATIVE_MOVE);
            packetsToListen.add(PacketType.Play.Server.ENTITY_VELOCITY);
            packetsToListen.add(PacketType.Play.Server.ATTACH_ENTITY);
            packetsToListen.add(PacketType.Play.Server.ENTITY_POSITION_SYNC);
        }
        if (DisguiseConfig.isEquipmentPacketsEnabled()) {
            packetsToListen.add(PacketType.Play.Server.ENTITY_EQUIPMENT);
        }
        if (DisguiseConfig.isAnimationPacketsEnabled()) {
            packetsToListen.add(PacketType.Play.Server.ENTITY_ANIMATION);
        }
        if (DisguiseConfig.isEntityStatusPacketsEnabled()) {
            packetsToListen.add(PacketType.Play.Server.ENTITY_STATUS);
        }
        mainListener = new PacketListenerMain(packetsToListen);
        PacketEvents.getAPI().getEventManager().registerListener((PacketListenerCommon)mainListener);
        PacketEvents.getAPI().getEventManager().registerListener((PacketListenerCommon)new PacketListenerEntityDestroy());
        if (NmsVersion.v1_13.isSupported() && DisguiseConfig.getPlayerNameType().isScoreboardPacketListenerNeeded()) {
            PacketEvents.getAPI().getEventManager().registerListener((PacketListenerCommon)new PacketListenerScoreboardTeam());
        }
    }

    public static void setViewDisguisesListener(boolean enabled) {
        if (viewDisguisesListenerEnabled == enabled) {
            return;
        }
        viewDisguisesListenerEnabled = enabled;
        if (viewDisguisesListenerEnabled) {
            PacketEvents.getAPI().getEventManager().registerListener((PacketListenerCommon)viewDisguisesListener);
        } else {
            PacketEvents.getAPI().getEventManager().unregisterListener((PacketListenerCommon)viewDisguisesListener);
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            Disguise disguise = DisguiseAPI.getDisguise(player, (Entity)player);
            if (disguise == null || !disguise.isSelfDisguiseVisible()) continue;
            if (enabled) {
                DisguiseUtilities.setupFakeDisguise(disguise);
            } else {
                DisguiseUtilities.removeSelfDisguise(disguise);
            }
            if (!inventoryListenerEnabled || !disguise.isHidingArmorFromSelf() && !disguise.isHidingHeldItemFromSelf()) continue;
            player.updateInventory();
        }
    }

    @Generated
    public static boolean isInventoryListenerEnabled() {
        return inventoryListenerEnabled;
    }

    @Generated
    public static boolean isViewDisguisesListenerEnabled() {
        return viewDisguisesListenerEnabled;
    }

    @Generated
    public static PacketsHandler getPacketsHandler() {
        return packetsHandler;
    }

    @Generated
    public static boolean isInitialListenersRegistered() {
        return initialListenersRegistered;
    }
}

