/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import com.github.retrooper.packetevents.protocol.entity.pose.EntityPose;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.watchers.AbstractHorseWatcher;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.reflection.annotations.MethodDescription;
import me.libraryaddict.disguise.utilities.reflection.annotations.NmsAddedIn;

public class CamelWatcher
extends AbstractHorseWatcher {
    public CamelWatcher(Disguise disguise) {
        super(disguise);
    }

    private int getPoseTransitionTime(EntityPose pose) {
        switch (pose) {
            case SITTING: {
                return 40;
            }
            case STANDING: {
                return 52;
            }
        }
        return 0;
    }

    public boolean isDashing() {
        return this.getData(MetaIndex.CAMEL_DASHING);
    }

    @MethodDescription(value="Is this Camel dashing?")
    public void setDashing(boolean dashing) {
        this.sendData(MetaIndex.CAMEL_DASHING, dashing);
    }

    @NmsAddedIn(value=NmsVersion.v1_19_R3)
    public void setSitting(boolean sitting) {
        this.setEntityPose(sitting ? EntityPose.SITTING : EntityPose.STANDING);
    }

    @NmsAddedIn(value=NmsVersion.v1_19_R3)
    public boolean isSitting() {
        return this.getEntityPose() == EntityPose.SITTING;
    }

    @Override
    @NmsAddedIn(value=NmsVersion.v1_14)
    public void setEntityPose(EntityPose entityPose) {
        long time;
        EntityPose oldPose = this.getEntityPose();
        super.setEntityPose(entityPose);
        if (!NmsVersion.v1_19_R3.isSupported() || oldPose == entityPose) {
            return;
        }
        if (this.getDisguise() != null && this.getDisguise().isDisguiseInUse() && this.getDisguise().getEntity() != null) {
            time = ReflectionManager.getGameTime(this.getDisguise().getEntity());
            if (entityPose == EntityPose.SITTING) {
                time = -time;
            }
        } else {
            time = entityPose == EntityPose.SITTING ? 1000000000L : 0L;
        }
        this.sendData(MetaIndex.CAMEL_LAST_POSE_CHANGED, time);
    }

    @Override
    @NmsAddedIn(value=NmsVersion.v1_14)
    public EntityPose getEntityPose() {
        return super.getEntityPose();
    }
}

