/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.reflection;

import com.github.retrooper.packetevents.protocol.nbt.NBT;
import com.github.retrooper.packetevents.protocol.nbt.NBTByteArray;
import com.github.retrooper.packetevents.protocol.nbt.NBTCompound;
import com.github.retrooper.packetevents.protocol.nbt.NBTIntArray;
import com.github.retrooper.packetevents.protocol.nbt.NBTList;
import com.github.retrooper.packetevents.protocol.nbt.NBTLongArray;
import com.github.retrooper.packetevents.protocol.nbt.NBTNumber;
import com.github.retrooper.packetevents.protocol.nbt.NBTString;
import com.github.retrooper.packetevents.protocol.nbt.NBTType;
import java.util.ArrayList;
import java.util.List;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import org.apache.commons.lang.StringUtils;
import org.bukkit.inventory.ItemStack;

public class ItemStackSerializer {
    public static List<String> serialize(ItemStack item) {
        String asString;
        NBTCompound nbt;
        if (!ReflectionManager.isCraftItem(item) && item.hasItemMeta()) {
            item = ReflectionManager.getCraftItem(item);
        }
        ArrayList<String> mcArray = new ArrayList<String>();
        String type = ReflectionManager.getItemName(item.getType());
        if (item.hasItemMeta() && NmsVersion.v1_13.isSupported()) {
            if (ReflectionManager.getNmsReflection() != null) {
                String asString2 = ReflectionManager.getNmsReflection().getDataAsString(item);
                if (asString2 != null && asString2.length() > 2) {
                    type = type + ItemStackSerializer.stripSpacesFromString(asString2);
                }
            } else {
                nbt = DisguiseUtilities.fromBukkitItemStack(item).getNBT();
                if (nbt != null && (asString = ItemStackSerializer.serialize((NBT)nbt)).length() > 2) {
                    type = type + asString;
                }
            }
        }
        mcArray.add(type);
        if (item.getAmount() != 1) {
            mcArray.add(String.valueOf(item.getAmount()));
        }
        if (!NmsVersion.v1_13.isSupported()) {
            if (item.getDurability() != 0) {
                mcArray.add(String.valueOf(item.getDurability()));
            }
            if (item.hasItemMeta() && (nbt = DisguiseUtilities.fromBukkitItemStack(item).getNBT()) != null && (asString = ItemStackSerializer.serialize((NBT)nbt)).length() > 2) {
                mcArray.add(ItemStackSerializer.serialize((NBT)nbt));
            }
        }
        return mcArray;
    }

    private static String stripSpacesFromString(String string) {
        StringBuilder result = new StringBuilder();
        boolean inQuote = false;
        boolean escaped = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (escaped) {
                result.append(c);
                escaped = false;
            } else if (c == '\\') {
                escaped = true;
            } else if (c == '\"') {
                inQuote = !inQuote;
            } else if (!inQuote && c == ' ') continue;
            result.append(c);
        }
        return result.toString();
    }

    public static String serialize(NBT base) {
        return ItemStackSerializer.serialize(0, base);
    }

    private static String serialize(int depth, NBT base) {
        if (base.getType() == NBTType.COMPOUND) {
            StringBuilder builder = new StringBuilder();
            builder.append("{");
            for (String key : ((NBTCompound)base).getTagNames()) {
                NBT nbt = ((NBTCompound)base).getTagOrThrow(key);
                String val = ItemStackSerializer.serialize(depth + 1, nbt);
                if (depth == 0 && val.matches("0(\\.0)?")) continue;
                if (builder.length() > 1) {
                    builder.append(",");
                }
                builder.append(key).append(":").append(val);
            }
            builder.append("}");
            return builder.toString();
        }
        if (base.getType() == NBTType.LIST) {
            ArrayList<String> serialized = new ArrayList<String>();
            for (NBT something : ((NBTList)base).getTags()) {
                serialized.add(ItemStackSerializer.serialize(depth + 1, something));
            }
            return "[" + StringUtils.join(serialized, (String)",") + "]";
        }
        if (base.getType() == NBTType.BYTE_ARRAY) {
            NBTByteArray byteArray = (NBTByteArray)base;
            ArrayList<String> bytes = new ArrayList<String>();
            for (byte b : byteArray.getValue()) {
                bytes.add(String.valueOf(b));
            }
            return "[B;" + String.join((CharSequence)",", bytes) + "]";
        }
        if (base.getType() == NBTType.INT_ARRAY) {
            NBTIntArray byteArray = (NBTIntArray)base;
            ArrayList<String> bytes = new ArrayList<String>();
            for (int b : byteArray.getValue()) {
                bytes.add(String.valueOf(b));
            }
            return "[I;" + String.join((CharSequence)",", bytes) + "]";
        }
        if (base.getType() == NBTType.LONG_ARRAY) {
            NBTLongArray byteArray = (NBTLongArray)base;
            ArrayList<String> bytes = new ArrayList<String>();
            for (long b : byteArray.getValue()) {
                bytes.add(String.valueOf(b));
            }
            return "[L;" + String.join((CharSequence)",", bytes) + "]";
        }
        if (base.getType() == NBTType.BYTE || base.getType() == NBTType.INT || base.getType() == NBTType.LONG || base.getType() == NBTType.FLOAT || base.getType() == NBTType.SHORT || base.getType() == NBTType.DOUBLE) {
            NBTNumber number = (NBTNumber)base;
            return number.getAsNumber().toString();
        }
        if (base.getType() == NBTType.STRING) {
            String val = ((NBTString)base).getValue();
            return "\"" + val.replace("\\", "\\\\").replace("\"", "\\\"") + "\"";
        }
        if (base.getType() == NBTType.END) {
            return "";
        }
        throw new IllegalArgumentException();
    }
}

