/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.packets.packethandlers;

import com.github.retrooper.packetevents.protocol.attribute.Attributes;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.packettype.PacketTypeCommon;
import com.github.retrooper.packetevents.protocol.player.Equipment;
import com.github.retrooper.packetevents.protocol.player.EquipmentSlot;
import com.github.retrooper.packetevents.protocol.world.Direction;
import com.github.retrooper.packetevents.protocol.world.Location;
import com.github.retrooper.packetevents.protocol.world.PaintingType;
import com.github.retrooper.packetevents.util.Vector3d;
import com.github.retrooper.packetevents.util.Vector3i;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerCamera;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityEquipment;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityMetadata;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityRotation;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityStatus;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityTeleport;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityVelocity;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerHeldItemChange;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSpawnEntity;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSpawnExperienceOrb;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSpawnLivingEntity;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSpawnPainting;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSpawnPlayer;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerUpdateAttributes;
import io.github.retrooper.packetevents.util.SpigotConversionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.MiscDisguise;
import me.libraryaddict.disguise.disguisetypes.ModdedDisguise;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.FallingBlockWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.DisguiseValues;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.listeners.PlayerSkinHandler;
import me.libraryaddict.disguise.utilities.packets.IPacketHandler;
import me.libraryaddict.disguise.utilities.packets.LibsPackets;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.reflection.WatcherValue;
import org.bukkit.Material;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class PacketHandlerSpawn
implements IPacketHandler {
    @Override
    public PacketTypeCommon[] getHandledPackets() {
        ArrayList<PacketType.Play.Server> packets = new ArrayList<PacketType.Play.Server>();
        if (!NmsVersion.v1_20_R2.isSupported()) {
            packets.add(PacketType.Play.Server.SPAWN_PLAYER);
        }
        packets.add(PacketType.Play.Server.SPAWN_EXPERIENCE_ORB);
        packets.add(PacketType.Play.Server.SPAWN_ENTITY);
        if (!NmsVersion.v1_19_R1.isSupported()) {
            packets.add(PacketType.Play.Server.SPAWN_LIVING_ENTITY);
            packets.add(PacketType.Play.Server.SPAWN_PAINTING);
        }
        return packets.toArray(new PacketTypeCommon[0]);
    }

    public void handle(Disguise disguise, LibsPackets packets, Player observer, Entity entity) {
        packets.clear();
        if (disguise.getType() == DisguiseType.UNKNOWN) {
            return;
        }
        this.constructSpawnPackets(observer, packets, entity);
    }

    private void constructSpawnPackets(Player observer, LibsPackets packets, Entity disguisedEntity) {
        int entityId;
        Disguise disguise;
        block54: {
            block53: {
                float pitch;
                disguise = packets.getDisguise();
                Vector loc = disguisedEntity.getLocation().toVector();
                loc.setY(loc.getY() + DisguiseUtilities.getYModifier(disguise) + (double)disguise.getWatcher().getYModifier());
                Float pitchLock = DisguiseConfig.isMovementPacketsEnabled() ? disguise.getWatcher().getPitchLock() : null;
                Float yawLock = DisguiseConfig.isMovementPacketsEnabled() ? disguise.getWatcher().getYawLock() : null;
                entityId = observer == disguisedEntity ? DisguiseAPI.getSelfDisguiseId() : disguisedEntity.getEntityId();
                float yaw = yawLock == null ? disguisedEntity.getLocation().getYaw() : yawLock.floatValue();
                float f = pitch = pitchLock == null ? disguisedEntity.getLocation().getPitch() : pitchLock.floatValue();
                if (DisguiseConfig.isMovementPacketsEnabled()) {
                    yaw = yawLock != null ? DisguiseUtilities.getYaw(disguise.getType(), yaw) : DisguiseUtilities.getYaw(disguise.getType(), DisguiseType.getType(disguisedEntity.getType()), yaw);
                    pitch = pitchLock != null ? DisguiseUtilities.getPitch(disguise.getType(), pitch) : DisguiseUtilities.getPitch(disguise.getType(), DisguiseType.getType(disguisedEntity.getType()), pitch);
                }
                Location pLoc = new Location(loc.getX(), loc.getY(), loc.getZ(), yaw, pitch);
                boolean inLineOfSight = true;
                if (disguise.getType() == DisguiseType.EXPERIENCE_ORB) {
                    WrapperPlayServerSpawnExperienceOrb spawnOrb = new WrapperPlayServerSpawnExperienceOrb(entityId, loc.getX(), loc.getY() + 0.06, loc.getZ(), 1);
                    packets.addPacket((PacketWrapper)spawnOrb);
                } else if (!NmsVersion.v1_19_R1.isSupported() && disguise.getType() == DisguiseType.PAINTING) {
                    int id = ((MiscDisguise)disguise).getData();
                    PaintingType paintingType = PaintingType.getById((int)id);
                    Direction direction = DisguiseUtilities.getHangingDirection(yaw);
                    WrapperPlayServerSpawnPainting spawnPainting = new WrapperPlayServerSpawnPainting(entityId, disguise.getUUID(), paintingType, new Vector3i(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()), direction);
                    packets.addPacket((PacketWrapper)spawnPainting);
                    WrapperPlayServerEntityTeleport teleportPainting = new WrapperPlayServerEntityTeleport(entityId, pLoc, disguisedEntity.isOnGround());
                    packets.addPacket((PacketWrapper)teleportPainting);
                } else if (disguise.getType().isPlayer()) {
                    PacketWrapper spawnPlayer;
                    PlayerSkinHandler.PlayerSkin skin;
                    PlayerDisguise playerDisguise = (PlayerDisguise)disguise;
                    boolean visibleOrNewCompat = playerDisguise.isNameVisible() || DisguiseConfig.isScoreboardNames();
                    double dist = observer.getLocation().toVector().distanceSquared(disguisedEntity.getLocation().toVector());
                    boolean bl = inLineOfSight = DisguiseUtilities.isFancyHiddenTabs() || observer == disguisedEntity || disguisedEntity.getPassengers().contains(observer) || dist > 2500.0 || observer.getLocation().add(observer.getLocation().getDirection().normalize()).toVector().distanceSquared(disguisedEntity.getLocation().toVector()) - dist < 0.3;
                    if (DisguiseUtilities.isFancyHiddenTabs() || !playerDisguise.isDisplayedInTab() || !playerDisguise.isNameVisible()) {
                        packets.addPacket(DisguiseUtilities.createTablistAddPackets(playerDisguise));
                        skin = LibsDisguises.getInstance().getSkinHandler().addPlayerSkin(observer, playerDisguise);
                        skin.setDoTabList(!DisguiseUtilities.isFancyHiddenTabs());
                        if (LibsPremium.getPaidInformation() != null && !LibsPremium.getPaidInformation().getBuildNumber().matches("#?\\d+")) {
                            skin.getSleptPackets().computeIfAbsent(0, a -> new ArrayList()).add(new WrapperPlayServerHeldItemChange(0));
                        }
                    } else {
                        skin = LibsDisguises.getInstance().getSkinHandler().addPlayerSkin(observer, playerDisguise);
                        skin.setDoTabList(false);
                    }
                    skin.setSleepPackets(!inLineOfSight);
                    packets.setSkinHandling(true);
                    if (NmsVersion.v1_20_R2.isSupported()) {
                        spawnPlayer = this.constructLivingPacket(observer, packets, disguisedEntity, loc, pitch, yaw);
                    } else {
                        Location spawnAt = inLineOfSight ? pLoc : SpigotConversionUtil.fromBukkitLocation((org.bukkit.Location)observer.getLocation().add(observer.getLocation().getDirection().normalize().multiply(10)));
                        spawnPlayer = new WrapperPlayServerSpawnPlayer(entityId, playerDisguise.getUUID(), spawnAt, new ArrayList());
                        packets.addPacket(spawnPlayer);
                    }
                    List<WatcherValue> watcherValues = !inLineOfSight ? Collections.singletonList(new WatcherValue(MetaIndex.ENTITY_META, (byte)32, true)) : DisguiseUtilities.createSanitizedWatcherValues(observer, disguisedEntity, disguise.getWatcher());
                    if (NmsVersion.v1_15.isSupported()) {
                        WrapperPlayServerEntityMetadata metaPacket = ReflectionManager.getMetadataPacket(entityId, watcherValues);
                        packets.addPacket((PacketWrapper)metaPacket);
                    } else if (spawnPlayer instanceof WrapperPlayServerSpawnLivingEntity) {
                        ((WrapperPlayServerSpawnLivingEntity)spawnPlayer).setEntityMetadata(DisguiseUtilities.createDatawatcher(watcherValues));
                    } else if (spawnPlayer instanceof WrapperPlayServerSpawnPlayer) {
                        ((WrapperPlayServerSpawnPlayer)spawnPlayer).setEntityMetadata(DisguiseUtilities.createDatawatcher(watcherValues));
                    }
                } else if (disguise.isMobDisguise() || disguise.getType() == DisguiseType.ARMOR_STAND) {
                    PacketWrapper spawnEntity = this.constructLivingPacket(observer, packets, disguisedEntity, loc, pitch, yaw);
                    List<WatcherValue> watcherValues = DisguiseUtilities.createSanitizedWatcherValues(observer, disguisedEntity, disguise.getWatcher());
                    if (NmsVersion.v1_15.isSupported()) {
                        WrapperPlayServerEntityMetadata metaPacket = ReflectionManager.getMetadataPacket(entityId, watcherValues);
                        packets.addPacket((PacketWrapper)metaPacket);
                    } else {
                        ((WrapperPlayServerSpawnLivingEntity)spawnEntity).setEntityMetadata(DisguiseUtilities.createDatawatcher(watcherValues));
                    }
                } else if (disguise.getType().isMisc()) {
                    int data = ((MiscDisguise)disguise).getData();
                    double x = loc.getX();
                    double y = loc.getY();
                    double z = loc.getZ();
                    if (disguise.getType() == DisguiseType.FALLING_BLOCK) {
                        data = ((FallingBlockWatcher)disguise.getWatcher()).getBlockCombinedId();
                        if (((FallingBlockWatcher)disguise.getWatcher()).isGridLocked()) {
                            double yMod = disguise.getWatcher().getYModifier();
                            x = (double)loc.getBlockX() + 0.5;
                            y = Math.floor(y -= yMod) + yMod + (y % 1.0 >= 0.85 ? 1.0 : (y % 1.0 >= 0.35 ? 0.5 : 0.0));
                            z = (double)loc.getBlockZ() + 0.5;
                        }
                    } else if (disguise.getType() == DisguiseType.FISHING_HOOK && data == -1) {
                        data = observer.getEntityId();
                    } else if (disguise.getType().isArtDisplay()) {
                        data = DisguiseUtilities.getHangingDirection(yaw).ordinal();
                    }
                    com.github.retrooper.packetevents.protocol.entity.type.EntityType entityType = this.getEntityType(disguise);
                    Vector vec = disguisedEntity.getVelocity();
                    WrapperPlayServerSpawnEntity spawnEntity = new WrapperPlayServerSpawnEntity(entityId, Optional.of(disguise.getUUID()), entityType, new Vector3d(x, y, z), pitch, yaw, yaw, data, Optional.of(new Vector3d(vec.getX(), vec.getY(), vec.getZ())));
                    packets.addPacket((PacketWrapper)spawnEntity);
                    if (NmsVersion.v1_19_R2.isSupported()) {
                        List<WatcherValue> watcherValues = DisguiseUtilities.createSanitizedWatcherValues(observer, disguisedEntity, disguise.getWatcher());
                        WrapperPlayServerEntityMetadata metaPacket = ReflectionManager.getMetadataPacket(entityId, watcherValues);
                        packets.addPacket((PacketWrapper)metaPacket);
                    }
                    if (DisguiseType.getType(disguisedEntity) != disguise.getType()) {
                        spawnEntity.setVelocity(Optional.of(new Vector3d(0.0, 0.0, 0.0)));
                        if (disguise.getType() == DisguiseType.DROPPED_ITEM) {
                            WrapperPlayServerEntityVelocity velocity = new WrapperPlayServerEntityVelocity(entityId, new Vector3d(0.0, 0.0, 0.0));
                            packets.addPacket((PacketWrapper)velocity);
                        }
                    }
                    if (disguise.getType() == DisguiseType.ITEM_FRAME) {
                        if (data % 2 == 0) {
                            spawnEntity.setPosition(new Vector3d(loc.getX(), 0.0, loc.getZ() + (double)data == 0.0 ? -1.0 : 1.0));
                        } else {
                            spawnEntity.setPosition(new Vector3d(loc.getX() + (double)data == 3.0 ? -1.0 : 1.0, loc.getY(), loc.getZ()));
                        }
                    }
                }
                if (packets.getPackets().size() <= 1 || disguise.isPlayerDisguise()) {
                    WrapperPlayServerEntityRotation rotateHead = new WrapperPlayServerEntityRotation(entityId, yaw, pitch, disguisedEntity.isOnGround());
                    if (!DisguiseUtilities.isRunningPaper()) {
                        packets.addPacket((PacketWrapper)rotateHead);
                    } else {
                        packets.addDelayedPacket((PacketWrapper)rotateHead, 10);
                    }
                }
                if (disguise.getType() == DisguiseType.EVOKER_FANGS) {
                    packets.addPacket((PacketWrapper)new WrapperPlayServerEntityStatus(entityId, 4));
                }
                if (disguise.getWatcher() instanceof LivingWatcher) {
                    ArrayList<WrapperPlayServerUpdateAttributes.Property> attributes = new ArrayList<WrapperPlayServerUpdateAttributes.Property>();
                    if (NmsVersion.v1_20_R4.isSupported()) {
                        Double scale = ((LivingWatcher)disguise.getWatcher()).getScale();
                        if (observer == disguisedEntity && disguise.isTallSelfDisguisesScaling()) {
                            if (scale == null) {
                                scale = DisguiseUtilities.getEntityScaleWithoutLibsDisguises((Entity)observer);
                            }
                            attributes.add(new WrapperPlayServerUpdateAttributes.Property(Attributes.GENERIC_SCALE, Math.min(disguise.getInternals().getSelfDisguiseTallScaleMax(), scale), new ArrayList()));
                        } else if (scale != null) {
                            attributes.add(new WrapperPlayServerUpdateAttributes.Property(Attributes.GENERIC_SCALE, scale.doubleValue(), new ArrayList()));
                        }
                    }
                    if (DisguiseConfig.isMiscDisguisesForLivingEnabled()) {
                        double health = ((LivingWatcher)disguise.getWatcher()).isMaxHealthSet() ? ((LivingWatcher)disguise.getWatcher()).getMaxHealth() : (DisguiseConfig.isMaxHealthDeterminedByDisguisedEntity() && disguisedEntity instanceof Damageable ? ((Damageable)disguisedEntity).getMaxHealth() : DisguiseValues.getDisguiseValues(disguise.getType()).getMaxHealth());
                        attributes.add(new WrapperPlayServerUpdateAttributes.Property(Attributes.GENERIC_MAX_HEALTH, health, new ArrayList()));
                    }
                    if (!attributes.isEmpty()) {
                        packets.addPacket((PacketWrapper)new WrapperPlayServerUpdateAttributes(entityId, attributes));
                    }
                }
                if (!disguise.isPlayerDisguise()) break block53;
                if (!inLineOfSight) break block54;
            }
            DisguiseUtilities.getNamePackets(disguise, observer, new String[0]).forEach(packets::addPacket);
        }
        if (DisguiseConfig.isEquipmentPacketsEnabled()) {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                if (slot == EquipmentSlot.BODY && !NmsVersion.v1_20_R4.isSupported()) continue;
                org.bukkit.inventory.EquipmentSlot bSlot = DisguiseUtilities.getSlot(slot);
                ItemStack itemToSend = disguise.getWatcher().getItemStack(bSlot);
                if (itemToSend == null ? (itemToSend = DisguiseUtilities.getEquipment(bSlot, disguisedEntity)) == null || itemToSend.getType() == Material.AIR : itemToSend.getType() == Material.AIR) continue;
                WrapperPlayServerEntityEquipment packet = new WrapperPlayServerEntityEquipment(entityId, Collections.singletonList(new Equipment(slot, DisguiseUtilities.fromBukkitItemStack(itemToSend))));
                packets.addDelayedPacket((PacketWrapper)packet);
            }
        }
        if (disguisedEntity != observer && observer.getSpectatorTarget() == disguisedEntity) {
            WrapperPlayServerCamera camera = new WrapperPlayServerCamera(entityId);
            packets.addPacket((PacketWrapper)camera);
        }
    }

    private PacketWrapper constructLivingPacket(Player observer, LibsPackets packets, Entity disguisedEntity, Vector loc, float pitch, float yaw) {
        Disguise disguise = packets.getDisguise();
        Vector vec = disguisedEntity.getVelocity();
        if (disguise.getType() == DisguiseType.SQUID && disguisedEntity.getType() != EntityType.SQUID) {
            vec = new Vector();
        }
        com.github.retrooper.packetevents.protocol.entity.type.EntityType entityType = this.getEntityType(disguise);
        int entityId = observer == disguisedEntity ? DisguiseAPI.getSelfDisguiseId() : disguisedEntity.getEntityId();
        Location location = new Location(loc.getX(), loc.getY(), loc.getZ(), yaw, pitch);
        Object spawnEntity = NmsVersion.v1_19_R1.isSupported() ? new WrapperPlayServerSpawnEntity(entityId, disguise.getUUID(), entityType, location, yaw, 0, new Vector3d(vec.getX(), vec.getY(), vec.getZ())) : new WrapperPlayServerSpawnLivingEntity(entityId, disguise.getUUID(), entityType, location, pitch, new Vector3d(vec.getX(), vec.getY(), vec.getZ()), new ArrayList());
        packets.addPacket((PacketWrapper)spawnEntity);
        return spawnEntity;
    }

    private com.github.retrooper.packetevents.protocol.entity.type.EntityType getEntityType(Disguise disguise) {
        if (disguise.getType().isCustom()) {
            return ((ModdedDisguise)disguise).getModdedEntity().getPacketEntityType();
        }
        return disguise.getType().getPacketEntityType();
    }
}

