/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.protocol.attribute.Attributes;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerDestroyEntities;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerPlayerInfo;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerUpdateAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.DisguiseInternals;
import me.libraryaddict.disguise.disguisetypes.DisguiseRunnable;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.MobDisguise;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.AbstractHorseWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.AgeableWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.BoatWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.SheepWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.ZombieWatcher;
import me.libraryaddict.disguise.events.DisguiseEvent;
import me.libraryaddict.disguise.events.UndisguiseEvent;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.parser.AutoGeneratedValue;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.KeyedBossBar;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public abstract class Disguise {
    private transient boolean disguiseInUse;
    private final DisguiseType disguiseType;
    private transient BukkitRunnable runnable;
    private transient Entity entity;
    private boolean hearSelfDisguise = DisguiseConfig.isSelfDisguisesSoundsReplaced();
    private boolean hideArmorFromSelf = DisguiseConfig.isHidingArmorFromSelf();
    private boolean hideHeldItemFromSelf = DisguiseConfig.isHidingHeldItemFromSelf();
    private boolean keepDisguiseOnPlayerDeath = DisguiseConfig.isKeepDisguiseOnPlayerDeath();
    private boolean modifyBoundingBox = DisguiseConfig.isModifyBoundingBox();
    private boolean playerHiddenFromTab = DisguiseConfig.isHideDisguisedPlayers();
    private boolean replaceSounds = DisguiseConfig.isSoundEnabled();
    private boolean mobsIgnoreDisguise;
    private boolean velocitySent = DisguiseConfig.isVelocitySent();
    private boolean viewSelfDisguise = DisguiseConfig.isViewDisguises() && DisguiseConfig.isViewSelfDisguisesDefault();
    private DisguiseConfig.NotifyBar notifyBar = DisguiseConfig.getNotifyBar();
    private BarColor bossBarColor = DisguiseConfig.getBossBarColor();
    private BarStyle bossBarStyle = DisguiseConfig.getBossBarStyle();
    private FlagWatcher watcher;
    protected long disguiseExpires;
    private final LinkedHashMap<String, Object> customData = new LinkedHashMap();
    private String disguiseName;
    private boolean customDisguiseName = false;
    private boolean tallDisguisesVisible = DisguiseConfig.isTallSelfDisguises();
    private String[] multiName = new String[0];
    private transient int[] armorstandIds = new int[0];
    private boolean dynamicName;
    private String soundGroup;
    private UUID uuid = ReflectionManager.getRandomUUID();
    private boolean scalePlayerToDisguise = DisguiseConfig.isScaleSelfDisguises();
    private boolean tallSelfDisguisesScaling = DisguiseConfig.isTallSelfDisguisesScaling();
    private final DisguiseInternals internals;

    public Disguise(DisguiseType disguiseType) {
        this.disguiseType = disguiseType;
        this.disguiseName = disguiseType.toReadable();
        this.internals = new DisguiseInternals<Disguise>(this);
    }

    public HashMap<String, Object> getCustomData() {
        return this.customData;
    }

    public UUID getUUID() {
        if (!(this.isPlayerDisguise() && DisguiseConfig.isUniquePlayerDisguiseUUIDs() || DisguiseConfig.isRandomUUIDS() || this.getEntity() == null)) {
            return this.getEntity().getUniqueId();
        }
        if (this.uuid == null) {
            this.uuid = ReflectionManager.getRandomUUID();
        }
        return this.uuid;
    }

    public int getMultiNameLength() {
        return this.multiName.length;
    }

    @AutoGeneratedValue
    public void setDisguiseName(String name) {
        this.disguiseName = name;
    }

    private int[] getInternalArmorstandIds() {
        if (this.armorstandIds == null) {
            this.armorstandIds = new int[0];
        }
        return this.armorstandIds;
    }

    public String[] getMultiName() {
        return DisguiseUtilities.reverse(this.multiName);
    }

    public void setMultiName(String ... name) {
        if (name.length == 1 && name[0].isEmpty()) {
            name = new String[]{};
        }
        for (int i = 0; i < name.length; ++i) {
            name[i] = DisguiseUtilities.getHexedColors(name[i]);
        }
        name = DisguiseUtilities.reverse(name);
        Object[] oldName = this.multiName;
        this.multiName = name;
        if (Arrays.equals(oldName, name)) {
            return;
        }
        if (!this.isDisguiseInUse()) {
            return;
        }
        this.sendArmorStands((String[])oldName);
    }

    public abstract double getHeight();

    public double getNameHeightScale() {
        if (!NmsVersion.v1_20_R4.isSupported() || this.isMiscDisguise()) {
            return 1.0;
        }
        Double watcherScale = this.getWatcher() instanceof LivingWatcher ? ((LivingWatcher)this.getWatcher()).getScale() : null;
        double finalScale = watcherScale != null ? watcherScale.doubleValue() : this.getInternals().getEntityScaleWithoutLibsDisguises();
        if (finalScale < 0.06) {
            finalScale = 0.06;
        } else if (finalScale > 16.0) {
            finalScale = 16.0;
        }
        return finalScale;
    }

    protected void sendArmorStands(String[] oldName) {
        if (!this.isDisguiseInUse()) {
            return;
        }
        this.adjustTallSelfDisguiseScale();
        for (Player player : DisguiseUtilities.getPerverts(this)) {
            if (!DisguiseUtilities.isFancyHiddenTabs() && this.isPlayerDisguise() && LibsDisguises.getInstance().getSkinHandler().isSleeping(player, (PlayerDisguise)this)) continue;
            List<PacketWrapper<?>> packets = DisguiseUtilities.getNamePackets(this, player, oldName);
            for (PacketWrapper<?> packet : packets) {
                PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, packet);
            }
        }
    }

    public int[] getArmorstandIds() {
        if (this.getMultiNameLength() > this.getInternalArmorstandIds().length) {
            int oldLen = this.armorstandIds.length;
            this.armorstandIds = Arrays.copyOf(this.armorstandIds, this.getMultiNameLength());
            for (int i = oldLen; i < this.armorstandIds.length; ++i) {
                this.armorstandIds[i] = ReflectionManager.getNewEntityId();
            }
        }
        return this.armorstandIds;
    }

    public void addCustomData(String key, Object data) {
        this.customData.put(key, data);
    }

    public boolean hasCustomData(String key) {
        return this.customData.containsKey(key);
    }

    public Object getCustomData(String key) {
        return this.customData.get(key);
    }

    public abstract Disguise clone();

    protected void clone(Disguise disguise) {
        disguise.setDisguiseName(this.getDisguiseName());
        disguise.setCustomDisguiseName(this.isCustomDisguiseName());
        disguise.setTallDisguisesVisible(this.isTallDisguisesVisible());
        disguise.setReplaceSounds(this.isSoundsReplaced());
        disguise.setViewSelfDisguise(this.isSelfDisguiseVisible());
        disguise.setHearSelfDisguise(this.isSelfDisguiseSoundsReplaced());
        disguise.setHideArmorFromSelf(this.isHidingArmorFromSelf());
        disguise.setHideHeldItemFromSelf(this.isHidingHeldItemFromSelf());
        disguise.setVelocitySent(this.isVelocitySent());
        disguise.setModifyBoundingBox(this.isModifyBoundingBox());
        disguise.multiName = Arrays.copyOf(this.multiName, this.multiName.length);
        disguise.setDynamicName(this.isDynamicName());
        disguise.setSoundGroup(this.getSoundGroup());
        disguise.notifyBar = this.getNotifyBar();
        disguise.bossBarColor = this.getBossBarColor();
        disguise.bossBarStyle = this.getBossBarStyle();
        disguise.setExpires(this.getExpires());
        if (this.getWatcher() != null) {
            disguise.setWatcher(this.getWatcher().clone(disguise));
        }
        disguise.createDisguise();
    }

    protected void createDisguise() {
        if (this.getType().getEntityType() == null) {
            throw new RuntimeException("DisguiseType " + (Object)((Object)this.getType()) + " was used in a futile attempt to construct a disguise, but this Minecraft version does not have that entity");
        }
        boolean isAdult = true;
        if (this instanceof MobDisguise) {
            isAdult = ((MobDisguise)this).isAdult();
        }
        if (this.getWatcher() == null) {
            try {
                this.setWatcher(this.getType().getWatcherClass().getConstructor(Disguise.class).newInstance(this));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (this.getWatcher().getDisguise() != this) {
            this.getWatcher().setDisguise((TargetedDisguise)this);
        }
        if (!isAdult) {
            if (this.getWatcher() instanceof AgeableWatcher) {
                ((AgeableWatcher)this.getWatcher()).setBaby(true);
            } else if (this.getWatcher() instanceof ZombieWatcher) {
                ((ZombieWatcher)this.getWatcher()).setBaby(true);
            }
        }
    }

    public boolean isDisguiseExpired() {
        return DisguiseConfig.isDynamicExpiry() ? this.disguiseExpires == 1L : this.disguiseExpires > 0L && this.disguiseExpires < System.currentTimeMillis();
    }

    public long getExpires() {
        return this.disguiseExpires;
    }

    public void setExpires(long timeToExpire) {
        this.disguiseExpires = timeToExpire;
        if (this.isDisguiseExpired()) {
            this.removeDisguise();
        }
    }

    private void removeBossBar() {
        KeyedBossBar bossBar = Bukkit.getBossBar((NamespacedKey)this.getInternals().getBossBar());
        if (bossBar == null) {
            return;
        }
        bossBar.removeAll();
        Bukkit.removeBossBar((NamespacedKey)this.getInternals().getBossBar());
    }

    public void setNotifyBar(DisguiseConfig.NotifyBar bar) {
        if (this.getNotifyBar() == bar) {
            return;
        }
        if (this.getNotifyBar() == DisguiseConfig.NotifyBar.BOSS_BAR) {
            this.removeBossBar();
        }
        this.notifyBar = bar;
        this.makeBossBar();
    }

    public void setBossBarColor(BarColor color) {
        if (this.getBossBarColor() == color) {
            return;
        }
        this.bossBarColor = color;
        this.makeBossBar();
    }

    public void setBossBarStyle(BarStyle style) {
        if (this.getBossBarStyle() == style) {
            return;
        }
        this.bossBarStyle = style;
        this.makeBossBar();
    }

    public void setBossBar(BarColor color, BarStyle style) {
        this.bossBarColor = color;
        this.bossBarStyle = style;
        this.setNotifyBar(DisguiseConfig.NotifyBar.BOSS_BAR);
    }

    private void makeBossBar() {
        if (this.getNotifyBar() != DisguiseConfig.NotifyBar.BOSS_BAR || !NmsVersion.v1_13.isSupported() || !(this.getEntity() instanceof Player)) {
            return;
        }
        if (this.getEntity().hasPermission("libsdisguises.noactionbar") || DisguiseAPI.getDisguise(this.getEntity()) != this) {
            return;
        }
        if (!DisguiseAPI.isNotifyBarShown(this.getEntity())) {
            return;
        }
        this.removeBossBar();
        KeyedBossBar bar = Bukkit.createBossBar((NamespacedKey)this.getInternals().getBossBar(), (String)BaseComponent.toLegacyText((BaseComponent[])LibsMsg.ACTION_BAR_MESSAGE.getBase(this.getDisguiseName())), (BarColor)this.getBossBarColor(), (BarStyle)this.getBossBarStyle(), (BarFlag[])new BarFlag[0]);
        bar.setProgress(1.0);
        bar.addPlayer((Player)this.getEntity());
    }

    public boolean isUpsideDown() {
        return this.getWatcher() != null && this.getWatcher().isUpsideDown();
    }

    public Disguise setUpsideDown(boolean upsideDown) {
        this.getWatcher().setUpsideDown(upsideDown);
        return this;
    }

    protected void doPeriodicTick() {
        if (this.getNotifyBar() == DisguiseConfig.NotifyBar.ACTION_BAR && this.getEntity() instanceof Player && DisguiseAPI.isNotifyBarShown(this.getEntity()) && !this.getEntity().hasPermission("libsdisguises.noactionbar") && DisguiseAPI.getDisguise(this.getEntity()) == this) {
            ((Player)this.getEntity()).spigot().sendMessage(ChatMessageType.ACTION_BAR, LibsMsg.ACTION_BAR_MESSAGE.getBase(this.getDisguiseName()));
        }
        if (this.isDynamicName()) {
            String name = this.getEntity() instanceof Player ? DisguiseUtilities.translateAlternateColorCodes(DisguiseUtilities.getDisplayName((CommandSender)this.getEntity())) : this.getEntity().getCustomName();
            if (name == null) {
                name = "";
            }
            if (this.isPlayerDisguise()) {
                if (!((PlayerDisguise)this).getName().equals(name)) {
                    ((PlayerDisguise)this).setName(name);
                }
            } else {
                this.getWatcher().setCustomName(name);
            }
        }
    }

    private void createRunnable() {
        if (this.runnable != null && !this.runnable.isCancelled()) {
            this.runnable.cancel();
        }
        TargetedDisguise disguise = (TargetedDisguise)this;
        this.runnable = new DisguiseRunnable(this);
        this.runnable.runTaskTimer((Plugin)LibsDisguises.getInstance(), 1L, 1L);
    }

    public Disguise setEntity(Entity entity) {
        if (this.getEntity() != null) {
            if (this.getEntity() == entity) {
                return this;
            }
            throw new RuntimeException("This disguise is already in use! Try .clone()");
        }
        if (this.isMiscDisguise() && !DisguiseConfig.isMiscDisguisesForLivingEnabled() && entity instanceof LivingEntity) {
            throw new RuntimeException("Cannot disguise a living entity with a misc disguise. Reenable MiscDisguisesForLiving in the config to do this");
        }
        this.entity = entity;
        if (entity != null) {
            this.setupWatcher();
        }
        if (this.getEntity() instanceof Player && this.isSelfDisguiseVisible() && !this.isTallDisguisesVisible() && this.isTallDisguise()) {
            if (this.isTallSelfDisguisesScaling() && NmsVersion.v1_20_R4.isSupported() && this.canScaleDisguise()) {
                this.adjustTallSelfDisguiseScale();
            } else {
                this.setSelfDisguiseVisible(false);
            }
        }
        return this;
    }

    private boolean isTallDisguise() {
        return DisguiseUtilities.isTallDisguise(this);
    }

    protected boolean canScaleDisguise() {
        return NmsVersion.v1_20_R4.isSupported() && !this.isMiscDisguise() && this.getType() != DisguiseType.ENDER_DRAGON;
    }

    public void setScalePlayerToDisguise(boolean scalePlayerToDisguise) {
        this.scalePlayerToDisguise = scalePlayerToDisguise;
        this.adjustTallSelfDisguiseScale();
    }

    public void setTallSelfDisguisesScaling(boolean tallSelfDisguisesScaling) {
        if (!NmsVersion.v1_20_R4.isSupported()) {
            return;
        }
        this.tallSelfDisguisesScaling = tallSelfDisguisesScaling;
        this.adjustTallSelfDisguiseScale();
    }

    protected void adjustTallSelfDisguiseScale() {
        if (!this.canScaleDisguise() || !this.isDisguiseInUse() || this.getEntity() == null) {
            return;
        }
        double playerScaleWithoutLibsDisguises = this.getInternals().getEntityScaleWithoutLibsDisguises();
        double naturalHeightOfDisguise = this.getHeight();
        double increasedNaturalHeightOfDisguise = this.getHeight() * this.getNameHeightScale();
        if (DisguiseUtilities.isTallDisguise(this)) {
            increasedNaturalHeightOfDisguise *= 1.2;
        }
        double scalerToMakePlayerSeePerspective = 1.0;
        if (this.isScalePlayerToDisguise()) {
            scalerToMakePlayerSeePerspective = naturalHeightOfDisguise / (1.8 * playerScaleWithoutLibsDisguises);
            scalerToMakePlayerSeePerspective = Math.min(scalerToMakePlayerSeePerspective, DisguiseConfig.getScaleSelfDisguisesMax());
            scalerToMakePlayerSeePerspective = Math.max(scalerToMakePlayerSeePerspective, DisguiseConfig.getScaleSelfDisguisesMin());
        }
        double prevPersonalDisguiseScaleMax = this.getInternals().getSelfDisguiseTallScaleMax();
        double newPersonalDisguiseScaleMax = 1.2 * scalerToMakePlayerSeePerspective / increasedNaturalHeightOfDisguise;
        this.getInternals().setSelfDisguiseTallScaleMax(newPersonalDisguiseScaleMax);
        this.adjustSelfDisguiseScale(prevPersonalDisguiseScaleMax, newPersonalDisguiseScaleMax, playerScaleWithoutLibsDisguises, scalerToMakePlayerSeePerspective);
    }

    private void adjustSelfDisguiseScale(double prevPersonalDisguiseScaleMax, double newPersonalDisguiseScaleMax, double playerScaleWithoutLibsDisguises, double personalPlayerScaleAttribute) {
        if (!(this.isDisguiseInUse() && this.getEntity() instanceof Player && this.canScaleDisguise() && ((TargetedDisguise)this).canSee((Player)this.getEntity()))) {
            return;
        }
        if (prevPersonalDisguiseScaleMax != newPersonalDisguiseScaleMax && this.isSelfDisguiseVisible() && this.isTallSelfDisguisesScaling()) {
            double scaleToSend = ((LivingWatcher)this.getWatcher()).getScale() != null ? ((LivingWatcher)this.getWatcher()).getScale() : playerScaleWithoutLibsDisguises;
            if (this.isScalePlayerToDisguise()) {
                scaleToSend = Math.min(scaleToSend, newPersonalDisguiseScaleMax);
            }
            WrapperPlayServerUpdateAttributes.Property property = new WrapperPlayServerUpdateAttributes.Property(Attributes.GENERIC_SCALE, scaleToSend, new ArrayList());
            WrapperPlayServerUpdateAttributes packet = new WrapperPlayServerUpdateAttributes(DisguiseAPI.getSelfDisguiseId(), Collections.singletonList(property));
            PacketEvents.getAPI().getPlayerManager().sendPacket((Object)this.getEntity(), (PacketWrapper)packet);
        }
        AttributeInstance attribute = ((Player)this.getEntity()).getAttribute(DisguiseUtilities.getScaleAttribute());
        AttributeModifier modifier = attribute.getModifiers().stream().filter(a -> a.getKey().equals((Object)DisguiseUtilities.getSelfDisguiseScaleNamespace())).findAny().orElse(null);
        if (!this.isScalePlayerToDisguise() || personalPlayerScaleAttribute == 1.0 || this.isPlayerDisguise()) {
            if (modifier != null) {
                attribute.removeModifier(modifier);
            }
        } else if (this.isScalePlayerToDisguise() && DisguiseConfig.isScaleSelfDisguises()) {
            personalPlayerScaleAttribute -= 1.0;
            if (modifier != null) {
                if (modifier.getAmount() == personalPlayerScaleAttribute && modifier.getOperation() == AttributeModifier.Operation.MULTIPLY_SCALAR_1) {
                    return;
                }
                attribute.removeModifier(modifier);
            }
            AttributeModifier newModifier = NmsVersion.v1_21_R1.isSupported() ? new AttributeModifier(DisguiseUtilities.getSelfDisguiseScaleNamespace(), personalPlayerScaleAttribute, AttributeModifier.Operation.MULTIPLY_SCALAR_1, EquipmentSlotGroup.ANY) : new AttributeModifier(DisguiseUtilities.getSelfDisguiseScaleUUID(), DisguiseUtilities.getSelfDisguiseScaleNamespace().toString(), personalPlayerScaleAttribute, AttributeModifier.Operation.MULTIPLY_SCALAR_1, EquipmentSlotGroup.ANY);
            attribute.addModifier(newModifier);
        }
    }

    public DisguiseType getType() {
        return this.disguiseType;
    }

    @Deprecated
    public Disguise setWatcher(FlagWatcher newWatcher) {
        if (!this.getType().getWatcherClass().isInstance(newWatcher)) {
            throw new IllegalArgumentException((newWatcher == null ? "null" : newWatcher.getClass().getSimpleName()) + " is not a instance of " + this.getType().getWatcherClass().getSimpleName() + " for DisguiseType " + this.getType().name());
        }
        this.watcher = newWatcher;
        if (this.getEntity() != null) {
            this.setupWatcher();
        }
        return this;
    }

    public boolean isHidePlayer() {
        return this.playerHiddenFromTab;
    }

    public void setHidePlayer(boolean hidePlayerInTab) {
        if (this.isDisguiseInUse()) {
            throw new IllegalStateException("Cannot set this while disguise is in use!");
        }
        this.playerHiddenFromTab = hidePlayerInTab;
    }

    @Deprecated
    public boolean isHidingArmorFromSelf() {
        return this.hideArmorFromSelf;
    }

    @Deprecated
    public boolean isHidingHeldItemFromSelf() {
        return this.hideHeldItemFromSelf;
    }

    public Disguise setHideArmorFromSelf(boolean hideArmor) {
        this.hideArmorFromSelf = hideArmor;
        if (this.getEntity() instanceof Player) {
            ((Player)this.getEntity()).updateInventory();
        }
        return this;
    }

    public Disguise setHideHeldItemFromSelf(boolean hideHeldItem) {
        this.hideHeldItemFromSelf = hideHeldItem;
        if (this.getEntity() instanceof Player) {
            ((Player)this.getEntity()).updateInventory();
        }
        return this;
    }

    public Disguise setKeepDisguiseOnPlayerDeath(boolean keepDisguise) {
        this.keepDisguiseOnPlayerDeath = keepDisguise;
        return this;
    }

    public boolean isMiscDisguise() {
        return false;
    }

    public boolean isMobDisguise() {
        return false;
    }

    public Disguise setModifyBoundingBox(boolean modifyBox) {
        if (this.isModifyBoundingBox() != modifyBox) {
            this.modifyBoundingBox = modifyBox;
            if (DisguiseUtilities.isDisguiseInUse(this)) {
                DisguiseUtilities.doBoundingBox((TargetedDisguise)this);
            }
        }
        return this;
    }

    public boolean isPlayerDisguise() {
        return false;
    }

    public boolean isCustomDisguise() {
        return false;
    }

    public boolean isRemoveDisguiseOnDeath() {
        return this.getEntity() == null || (this.getEntity() instanceof Player ? !this.isKeepDisguiseOnPlayerDeath() : this.getEntity().isDead() || !this.getEntity().isValid());
    }

    @Deprecated
    public boolean isSelfDisguiseSoundsReplaced() {
        return this.hearSelfDisguise;
    }

    public boolean isSelfDisguiseVisible() {
        return DisguiseConfig.isViewDisguises() && this.viewSelfDisguise;
    }

    public void setSelfDisguiseVisible(boolean selfDisguiseVisible) {
        this.setViewSelfDisguise(selfDisguiseVisible);
    }

    public boolean isSoundsReplaced() {
        return this.replaceSounds;
    }

    public Disguise setVelocitySent(boolean sendVelocity) {
        this.velocitySent = sendVelocity;
        return this;
    }

    public boolean removeDisguise() {
        return this.removeDisguise(false);
    }

    public boolean removeDisguise(CommandSender sender) {
        return this.removeDisguise(sender, false);
    }

    public boolean removeDisguise(boolean disguiseBeingReplaced) {
        return this.removeDisguise(null, disguiseBeingReplaced);
    }

    public boolean removeDisguise(CommandSender sender, boolean disguiseBeingReplaced) {
        PlayerDisguise disguise;
        if (!this.isDisguiseInUse()) {
            return false;
        }
        UndisguiseEvent event = new UndisguiseEvent(sender, this.entity, this, disguiseBeingReplaced);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled() && this.getEntity() != null && Bukkit.getWorlds().contains(this.getEntity().getWorld()) && (!(this.getEntity() instanceof Player) || ((Player)this.getEntity()).isOnline())) {
            return false;
        }
        this.disguiseInUse = false;
        if (this.runnable != null) {
            this.runnable.cancel();
            this.runnable = null;
        }
        if (this.getEntity() == null) {
            Map<Integer, HashSet<TargetedDisguise>> future = DisguiseUtilities.getFutureDisguises();
            DisguiseUtilities.getFutureDisguises().keySet().removeIf(id -> ((HashSet)future.get(id)).remove(this) && ((HashSet)future.get(id)).isEmpty());
            return true;
        }
        if (NmsVersion.v1_20_R4.isSupported()) {
            DisguiseUtilities.removeSelfDisguiseScale(this.getEntity());
        }
        if (this instanceof PlayerDisguise && (disguise = (PlayerDisguise)this).isDisplayedInTab()) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!((TargetedDisguise)this).canSee(player)) continue;
                PacketWrapper<?> deleteTab = DisguiseUtilities.createTablistPacket(disguise, WrapperPlayServerPlayerInfo.Action.REMOVE_PLAYER);
                PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, deleteTab);
            }
        }
        if (this.getInternalArmorstandIds().length > 0) {
            for (Player player : this.getEntity().getWorld().getPlayers()) {
                WrapperPlayServerDestroyEntities packet = DisguiseUtilities.getDestroyPacket(this.getInternalArmorstandIds());
                PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, (PacketWrapper)packet);
            }
        }
        if (!this.isPlayerDisguise()) {
            DisguiseUtilities.setGlowColor(this, null);
        }
        if (LibsPremium.getPluginInformation().isPremium() && LibsDisguises.getInstance().getBuildNumber() < 1360 && System.currentTimeMillis() % 4L == 1L) {
            this.getWatcher().setEntityFlag(3, true);
        }
        if (DisguiseUtilities.removeDisguise((TargetedDisguise)this) && !disguiseBeingReplaced) {
            if (this.getEntity() instanceof Player) {
                DisguiseUtilities.removeSelfDisguise(this);
            }
            if (this.getEntity().isValid()) {
                DisguiseUtilities.refreshTrackers((TargetedDisguise)this);
            } else {
                DisguiseUtilities.destroyEntity((TargetedDisguise)this);
            }
        }
        if (this.isHidePlayer() && this.getEntity() instanceof Player && ((Player)this.getEntity()).isOnline()) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!((TargetedDisguise)this).canSee(player)) continue;
                PacketWrapper<?> addTab = DisguiseUtilities.updateTablistVisibility((Player)this.getEntity(), true);
                PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, addTab);
            }
        }
        for (String meta : new String[]{"LastDisguise", "LD-LastAttacked", "forge_mods", "LibsRabbitHop", "ld_loggedin"}) {
            this.getEntity().removeMetadata(meta, (Plugin)LibsDisguises.getInstance());
        }
        if (DisguiseConfig.getPvPTimer() > 0.0 && this.getEntity() instanceof Player) {
            this.getEntity().setMetadata("LastDisguise", (MetadataValue)new FixedMetadataValue((Plugin)LibsDisguises.getInstance(), (Object)System.currentTimeMillis()));
        }
        if (NmsVersion.v1_13.isSupported()) {
            this.removeBossBar();
        }
        DisguiseUtilities.saveDisguises(this.getEntity());
        return true;
    }

    public Disguise setHearSelfDisguise(boolean hearSelfDisguise) {
        this.hearSelfDisguise = hearSelfDisguise;
        return this;
    }

    public Disguise setReplaceSounds(boolean areSoundsReplaced) {
        this.replaceSounds = areSoundsReplaced;
        return this;
    }

    private void setupWatcher() {
        if (this.getWatcher() == null) {
            this.createDisguise();
        }
        ArrayList<MetaIndex> disguiseFlags = MetaIndex.getMetaIndexes(this.getType().getWatcherClass());
        ArrayList<MetaIndex> entityFlags = MetaIndex.getMetaIndexes(DisguiseType.getType(this.getEntity().getType()).getWatcherClass());
        for (MetaIndex flag : entityFlags) {
            if (disguiseFlags.contains(flag)) continue;
            MetaIndex backup = null;
            for (MetaIndex flagType : disguiseFlags) {
                if (flagType.getIndex() != flag.getIndex()) continue;
                backup = flagType;
            }
            this.getWatcher().setBackupValue(flag, backup == null ? null : backup.getDefault());
        }
        if (!(!(this.getEntity() instanceof Player) || this.getWatcher().hasCustomName() || this.isUpsideDown() || this.getWatcher() instanceof SheepWatcher && ((SheepWatcher)this.getWatcher()).isRainbowWool())) {
            this.getWatcher().setInteralCustomName("");
            this.getWatcher().setInternalCustomNameVisible(false);
        }
        if ((this.getEntity() instanceof Boat || this.getEntity() instanceof AbstractHorse || this.getEntity() instanceof Item || this.getEntity() instanceof FallingBlock) && (this.getWatcher() instanceof BoatWatcher || this.getWatcher() instanceof AbstractHorseWatcher || this.getEntity() instanceof Item || this.getEntity() instanceof FallingBlock)) {
            this.getWatcher().setNoGravity(!this.getEntity().hasGravity());
        } else {
            this.getWatcher().setNoGravity(true);
        }
    }

    @Deprecated
    public Disguise setViewSelfDisguise(boolean viewSelfDisguise) {
        if (viewSelfDisguise && !this.isTallDisguisesVisible() && this.isTallDisguise()) {
            if (this.isTallSelfDisguisesScaling() && NmsVersion.v1_20_R4.isSupported() && this.canScaleDisguise() && !this.isPlayerDisguise()) {
                this.adjustTallSelfDisguiseScale();
            } else {
                viewSelfDisguise = false;
            }
        }
        if (this.isSelfDisguiseVisible() == viewSelfDisguise || !DisguiseConfig.isViewDisguises()) {
            return this;
        }
        this.viewSelfDisguise = viewSelfDisguise;
        if (this.getEntity() instanceof Player && DisguiseAPI.getDisguise((Player)this.getEntity(), this.getEntity()) == this) {
            if (this.isSelfDisguiseVisible()) {
                DisguiseUtilities.setupFakeDisguise(this);
            } else {
                DisguiseUtilities.removeSelfDisguise(this);
            }
        }
        return this;
    }

    public boolean startDisguise() {
        return this.startDisguise(null);
    }

    public boolean startDisguise(CommandSender commandSender) {
        PlayerDisguise disguise;
        if (this.isDisguiseInUse() || this.isDisguiseExpired()) {
            return false;
        }
        if (this.getEntity() == null) {
            throw new IllegalStateException("No entity is assigned to this disguise!");
        }
        if (this.multiName == null) {
            this.multiName = new String[0];
        }
        if (LibsPremium.getUserID().equals("12345") || LibsPremium.getPaidInformation() != null && LibsPremium.getPaidInformation().getUserID().equals("0") || !LibsMsg.OWNED_BY.getRaw().contains("'")) {
            ((TargetedDisguise)this).setDisguiseTarget(TargetedDisguise.TargetType.HIDE_DISGUISE_TO_EVERYONE_BUT_THESE_PLAYERS);
            if (this.getEntity() instanceof Player) {
                ((TargetedDisguise)this).addPlayer((Player)this.getEntity());
            }
            for (Entity ent : this.getEntity().getNearbyEntities(4.0, 4.0, 4.0)) {
                if (!(ent instanceof Player)) continue;
                ((TargetedDisguise)this).addPlayer((Player)ent);
            }
        }
        DisguiseUtilities.setPluginsUsed();
        DisguiseEvent event = new DisguiseEvent(commandSender, this.entity, this);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        if (!(!this.isDynamicName() || this.isPlayerDisguise() && ((PlayerDisguise)this).getName().equals("<Inherit>"))) {
            String name = this.getEntity() instanceof Player ? DisguiseUtilities.translateAlternateColorCodes(DisguiseUtilities.getDisplayName((CommandSender)this.getEntity())) : this.getEntity().getCustomName();
            if (name == null) {
                name = "";
            }
            this.getWatcher().setCustomName(name);
        }
        this.disguiseInUse = true;
        if (!DisguiseUtilities.isInvalidFile()) {
            this.createRunnable();
        }
        if (this instanceof PlayerDisguise && (disguise = (PlayerDisguise)this).isDisplayedInTab()) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!((TargetedDisguise)this).canSee(player)) continue;
                PacketWrapper<?> addTab = DisguiseUtilities.createTablistAddPackets(disguise);
                PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, addTab);
            }
        }
        DisguiseUtilities.addDisguise(this.entity.getEntityId(), (TargetedDisguise)this);
        if (!this.isPlayerDisguise()) {
            DisguiseUtilities.setGlowColor(this, this.getWatcher().getGlowColor());
        }
        if (this.isSelfDisguiseVisible() && this.getEntity() instanceof Player) {
            DisguiseUtilities.removeSelfDisguise(this);
        }
        DisguiseUtilities.refreshTrackers((TargetedDisguise)this);
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)LibsDisguises.getInstance(), () -> DisguiseUtilities.setupFakeDisguise(this), 2L);
        if (this.isHidePlayer() && this.getEntity() instanceof Player) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!((TargetedDisguise)this).canSee(player)) continue;
                PacketWrapper<?> removeTab = DisguiseUtilities.updateTablistVisibility((Player)this.getEntity(), false);
                PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, removeTab);
            }
        }
        if (!this.entity.isOp() && new Random().nextBoolean() && (!LibsMsg.OWNED_BY.getRaw().contains("'") || "%%__USER__%%".equals("12345") || "%%__USER__%%".equals("1592"))) {
            this.setExpires(DisguiseConfig.isDynamicExpiry() ? 4800L : System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(330L));
        }
        this.makeBossBar();
        DisguiseUtilities.saveDisguises(this.getEntity());
        this.adjustTallSelfDisguiseScale();
        return true;
    }

    public boolean stopDisguise() {
        return this.removeDisguise();
    }

    @Generated
    public boolean isDisguiseInUse() {
        return this.disguiseInUse;
    }

    @Generated
    public Entity getEntity() {
        return this.entity;
    }

    @Generated
    public boolean isHearSelfDisguise() {
        return this.hearSelfDisguise;
    }

    @Generated
    public boolean isHideArmorFromSelf() {
        return this.hideArmorFromSelf;
    }

    @Generated
    public boolean isHideHeldItemFromSelf() {
        return this.hideHeldItemFromSelf;
    }

    @Generated
    public boolean isKeepDisguiseOnPlayerDeath() {
        return this.keepDisguiseOnPlayerDeath;
    }

    @Generated
    public boolean isModifyBoundingBox() {
        return this.modifyBoundingBox;
    }

    @Generated
    public void setMobsIgnoreDisguise(boolean mobsIgnoreDisguise) {
        this.mobsIgnoreDisguise = mobsIgnoreDisguise;
    }

    @Generated
    public boolean isMobsIgnoreDisguise() {
        return this.mobsIgnoreDisguise;
    }

    @Generated
    public boolean isVelocitySent() {
        return this.velocitySent;
    }

    @Generated
    public DisguiseConfig.NotifyBar getNotifyBar() {
        return this.notifyBar;
    }

    @Generated
    public BarColor getBossBarColor() {
        return this.bossBarColor;
    }

    @Generated
    public BarStyle getBossBarStyle() {
        return this.bossBarStyle;
    }

    @Generated
    public FlagWatcher getWatcher() {
        return this.watcher;
    }

    @Generated
    public String getDisguiseName() {
        return this.disguiseName;
    }

    @Generated
    public boolean isCustomDisguiseName() {
        return this.customDisguiseName;
    }

    @Generated
    public void setCustomDisguiseName(boolean customDisguiseName) {
        this.customDisguiseName = customDisguiseName;
    }

    @Generated
    public boolean isTallDisguisesVisible() {
        return this.tallDisguisesVisible;
    }

    @Generated
    public void setTallDisguisesVisible(boolean tallDisguisesVisible) {
        this.tallDisguisesVisible = tallDisguisesVisible;
    }

    @Generated
    public boolean isDynamicName() {
        return this.dynamicName;
    }

    @Generated
    public void setDynamicName(boolean dynamicName) {
        this.dynamicName = dynamicName;
    }

    @Generated
    public String getSoundGroup() {
        return this.soundGroup;
    }

    @Generated
    public void setSoundGroup(String soundGroup) {
        this.soundGroup = soundGroup;
    }

    @Generated
    public boolean isScalePlayerToDisguise() {
        return this.scalePlayerToDisguise;
    }

    @Generated
    public boolean isTallSelfDisguisesScaling() {
        return this.tallSelfDisguisesScaling;
    }

    @Generated
    public DisguiseInternals getInternals() {
        return this.internals;
    }
}

