/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.config.ConfigLoader;
import me.libraryaddict.disguise.utilities.modded.ModdedEntity;
import me.libraryaddict.disguise.utilities.modded.ModdedManager;
import me.libraryaddict.disguise.utilities.packets.PacketsManager;
import me.libraryaddict.disguise.utilities.parser.DisguiseParseException;
import me.libraryaddict.disguise.utilities.parser.DisguiseParser;
import me.libraryaddict.disguise.utilities.parser.DisguisePerm;
import me.libraryaddict.disguise.utilities.parser.DisguisePermissions;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import me.libraryaddict.disguise.utilities.translations.TranslateType;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarStyle;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class DisguiseConfig {
    private static HashMap<DisguisePerm, String> customDisguises = new HashMap();
    private static UpdatesBranch updatesBranch = UpdatesBranch.SAME_BUILDS;
    private static boolean addEntityAnimations;
    private static boolean animationPacketsEnabled;
    private static boolean catDyeable;
    private static boolean collectPacketsEnabled;
    private static boolean disableFriendlyInvisibles;
    private static boolean disabledInvisibility;
    private static boolean disguiseBlownWhenAttacked;
    private static boolean disguiseBlownWhenAttacking;
    private static boolean dynamicExpiry;
    private static boolean entityStatusPacketsEnabled;
    private static boolean equipmentPacketsEnabled;
    private static boolean explicitDisguisePermissions;
    private static boolean hideDisguisedPlayers;
    private static boolean hidingArmorFromSelf;
    private static boolean hidingCreativeEquipmentFromSelf;
    private static boolean hidingHeldItemFromSelf;
    private static boolean horseSaddleable;
    private static boolean keepDisguiseOnPlayerDeath;
    private static boolean llamaCarpetable;
    private static boolean maxHealthDeterminedByDisguisedEntity;
    private static boolean metaPacketsEnabled;
    private static boolean miscDisguisesForLivingEnabled;
    private static boolean modifyBoundingBox;
    private static boolean modifyCollisions;
    private static boolean monstersIgnoreDisguises;
    private static boolean movementPacketsEnabled;
    private static boolean nameAboveHeadAlwaysVisible;
    private static boolean nameOfPlayerShownAboveDisguise;
    private static boolean playerHideArmor;
    private static boolean saveEntityDisguises;
    private static boolean saveGameProfiles;
    private static boolean savePlayerDisguises;
    private static boolean selfDisguisesSoundsReplaced;
    private static boolean sheepDyeable;
    private static boolean showDisguisedPlayersInTab;
    private static boolean stopShulkerDisguisesFromMoving;
    private static boolean undisguiseOnWorldChange;
    private static boolean updateGameProfiles;
    private static boolean useTranslations;
    private static boolean velocitySent;
    private static boolean viewDisguises;
    private static boolean warnScoreboardConflict;
    private static boolean witherSkullPacketsEnabled;
    private static boolean wolfDyeable;
    private static int disguiseCloneExpire;
    private static int disguiseEntityExpire;
    private static int maxClonedDisguises;
    private static int uuidGeneratedVersion;
    private static boolean disablePvP;
    private static boolean disablePvE;
    private static double pvPTimer;
    private static boolean retaliationCombat;
    private static NotifyBar notifyBar;
    private static BarStyle bossBarStyle;
    private static BarColor bossBarColor;
    private static PermissionDefault commandVisibility;
    private static int tablistRemoveDelay;
    private static boolean usingReleaseBuild;
    private static boolean bisectHosted;
    private static String savedServerIp;
    private static Boolean autoUpdate;
    private static boolean notifyUpdate;
    private static BukkitTask updaterTask;
    private static boolean tallSelfDisguises;
    private static boolean tallSelfDisguisesScaling;
    private static PlayerNameType playerNameType;
    private static boolean overrideCustomNames;
    private static boolean randomDisguises;
    private static boolean loginPayloadPackets;
    private static boolean saveUserPreferences;
    private static long lastUpdateRequest;
    private static boolean hittingRateLimit;
    private static boolean copyPlayerTeamInfo;
    private static String nameAboveDisguise;
    private static int playerDisguisesSkinExpiresMove;
    private static boolean viewSelfDisguisesDefault;
    private static String lastGithubUpdateETag;
    private static String lastPluginUpdateVersion;
    private static boolean contactMojangServers;
    private static int disguiseRadiusMax;
    private static String data;
    private static boolean randomUUIDS;
    private static List<DisguiseType> disabledDisguises;
    private static List<String> disabledMethods;
    private static boolean neverUpdatePacketEvents;
    private static boolean removeDisguiseBlockPlace;
    private static boolean removeDisguiseBlockBreak;
    private static boolean scaleSelfDisguises;
    private static double scaleSelfDisguisesMin;
    private static double scaleSelfDisguisesMax;
    private static boolean uniquePlayerDisguiseUUIDs;
    private static boolean hideDeathMessages;

    public static boolean isArmorstandsName() {
        return DisguiseConfig.getPlayerNameType() == PlayerNameType.ARMORSTANDS;
    }

    public static boolean isExtendedNames() {
        return DisguiseConfig.getPlayerNameType() == PlayerNameType.EXTENDED;
    }

    public static boolean isAutoUpdate() {
        if (DisguiseConfig.getAutoUpdate() == null) {
            autoUpdate = LibsDisguises.getInstance().getConfig().getBoolean("AutoUpdate");
        }
        return DisguiseConfig.getAutoUpdate();
    }

    public static void setAutoUpdate(boolean update) {
        if (DisguiseConfig.isAutoUpdate() == update) {
            return;
        }
        autoUpdate = update;
        DisguiseConfig.doUpdaterTask();
    }

    public static void setNotifyUpdate(boolean update) {
        if (DisguiseConfig.isNotifyUpdate() == update) {
            return;
        }
        notifyUpdate = update;
        DisguiseConfig.doUpdaterTask();
    }

    public static void setLastUpdateRequest(long lastRequest) {
        if (lastRequest <= DisguiseConfig.getLastUpdateRequest()) {
            return;
        }
        lastUpdateRequest = lastRequest;
        DisguiseConfig.saveInternalConfig();
    }

    private static void doUpdaterTask() {
        boolean startTask;
        if (LibsDisguises.getInstance() == null || !LibsDisguises.getInstance().isEnabled()) {
            return;
        }
        boolean bl = DisguiseConfig.isAutoUpdate() || DisguiseConfig.isNotifyUpdate() || "1592".equals((LibsPremium.getPaidInformation() == null ? LibsPremium.getPluginInformation() : LibsPremium.getPaidInformation()).getUserID()) ? true : (startTask = false);
        if (!LibsDisguises.getInstance().isJenkins()) {
            return;
        }
        if (updaterTask == null != startTask) {
            return;
        }
        if (!startTask) {
            updaterTask.cancel();
            updaterTask = null;
            return;
        }
        int timer = (int)(TimeUnit.HOURS.toSeconds(DisguiseConfig.isHittingRateLimit() ? 36L : 12L) * 20L);
        long timeSinceLast = (System.currentTimeMillis() - DisguiseConfig.getLastUpdateRequest()) / 50L;
        timeSinceLast = Math.max(36000L, (long)timer - timeSinceLast);
        updaterTask = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)LibsDisguises.getInstance(), () -> LibsDisguises.getInstance().getUpdateChecker().doAutoUpdateCheck(), timeSinceLast, (long)timer);
    }

    public static void setUsingReleaseBuilds(boolean useReleaseBuilds) {
        if (useReleaseBuilds == DisguiseConfig.isUsingReleaseBuild()) {
            return;
        }
        usingReleaseBuild = useReleaseBuilds;
        DisguiseConfig.saveInternalConfig();
    }

    public static void setHittingRateLimit(boolean hitRateLimit) {
        if (hitRateLimit == DisguiseConfig.isHittingRateLimit()) {
            return;
        }
        hittingRateLimit = hitRateLimit;
        DisguiseConfig.saveInternalConfig();
        DisguiseConfig.doUpdaterTask();
    }

    public static void setBisectHosted(boolean isBisectHosted, String serverIP) {
        if (DisguiseConfig.isBisectHosted() == isBisectHosted && DisguiseConfig.getSavedServerIp().equals(serverIP)) {
            return;
        }
        bisectHosted = isBisectHosted;
        savedServerIp = serverIP;
        DisguiseConfig.saveInternalConfig();
    }

    public static void loadInternalConfig() {
        File internalFile = new File(LibsDisguises.getInstance().getDataFolder(), "internal.yml");
        if (!internalFile.exists()) {
            DisguiseConfig.saveInternalConfig();
        }
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)internalFile);
        bisectHosted = configuration.getBoolean("Bisect-Hosted", DisguiseConfig.isBisectHosted());
        savedServerIp = configuration.getString("Server-IP", DisguiseConfig.getSavedServerIp());
        usingReleaseBuild = configuration.getBoolean("ReleaseBuild", DisguiseConfig.isUsingReleaseBuild());
        lastUpdateRequest = configuration.getLong("LastUpdateRequest", 0L);
        hittingRateLimit = configuration.getBoolean("HittingRateLimit", false);
        lastGithubUpdateETag = configuration.getString("LastGithubETag", null);
        lastPluginUpdateVersion = configuration.getString("LastPluginVersion", null);
        data = configuration.getString("Data", null);
        if (!(configuration.contains("Bisect-Hosted") && configuration.contains("Server-IP") && configuration.contains("ReleaseBuild"))) {
            DisguiseConfig.saveInternalConfig();
        }
    }

    public static void saveInternalConfig() {
        File internalFile = new File(LibsDisguises.getInstance().getDataFolder(), "internal.yml");
        String internalConfig = ReflectionManager.getResourceAsString(LibsDisguises.getInstance().getFile(), "internal.yml");
        for (Object s : new Object[]{DisguiseConfig.isBisectHosted(), DisguiseConfig.getSavedServerIp(), DisguiseConfig.isUsingReleaseBuild(), DisguiseConfig.getLastUpdateRequest(), DisguiseConfig.isHittingRateLimit(), DisguiseConfig.getLastGithubUpdateETag(), DisguiseConfig.getLastPluginUpdateVersion(), DisguiseConfig.getData()}) {
            internalConfig = internalConfig.replaceFirst("%data%", "" + s);
        }
        internalFile.delete();
        try {
            internalFile.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try (PrintWriter writer = new PrintWriter(internalFile, "UTF-8");){
            writer.write(internalConfig);
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public static void setCommandVisibility(PermissionDefault permissionDefault) {
        if (permissionDefault == null || DisguiseConfig.getCommandVisibility() == permissionDefault) {
            return;
        }
        commandVisibility = permissionDefault;
        for (Permission perm : LibsDisguises.getInstance().getDescription().getPermissions()) {
            if (!perm.getName().startsWith("libsdisguises.seecmd")) continue;
            perm.setDefault(DisguiseConfig.getCommandVisibility());
        }
    }

    private DisguiseConfig() {
    }

    public static int getUUIDGeneratedVersion() {
        return uuidGeneratedVersion;
    }

    public static void setUUIDGeneratedVersion(int uuidVersion) {
        uuidGeneratedVersion = uuidVersion;
    }

    public static Map.Entry<DisguisePerm, Disguise> getCustomDisguise(String disguise) {
        if (!Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("Custom Disguises should not be called async!");
        }
        Map.Entry<DisguisePerm, String> entry = DisguiseConfig.getRawCustomDisguise(disguise);
        if (entry == null) {
            return null;
        }
        try {
            return new AbstractMap.SimpleEntry<DisguisePerm, Disguise>(entry.getKey(), DisguiseParser.parseDisguise(entry.getValue()));
        }
        catch (Throwable e) {
            LibsDisguises.getInstance().getLogger().warning("Error when attempting to grab the custom disguise " + disguise);
            e.printStackTrace();
            return null;
        }
    }

    public static Map.Entry<DisguisePerm, Disguise> getCustomDisguise(Entity target, String disguise) throws Throwable {
        if (!Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("Custom Disguises should not be called async!");
        }
        Map.Entry<DisguisePerm, String> entry = DisguiseConfig.getRawCustomDisguise(disguise);
        if (entry == null) {
            return null;
        }
        return new AbstractMap.SimpleEntry<DisguisePerm, Disguise>(entry.getKey(), DisguiseParser.parseDisguise((CommandSender)Bukkit.getConsoleSender(), target, entry.getValue()));
    }

    public static Map.Entry<DisguisePerm, Disguise> getCustomDisguise(CommandSender invoker, Entity target, String disguise) throws Throwable {
        if (!Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("Custom Disguises should not be called async!");
        }
        Map.Entry<DisguisePerm, String> entry = DisguiseConfig.getRawCustomDisguise(disguise);
        if (entry == null) {
            return null;
        }
        return new AbstractMap.SimpleEntry<DisguisePerm, Disguise>(entry.getKey(), DisguiseParser.parseDisguise(invoker, target, entry.getValue()));
    }

    public static boolean isScoreboardNames() {
        return DisguiseConfig.getPlayerNameType() != PlayerNameType.VANILLA;
    }

    public static void removeCustomDisguise(String disguise) {
        for (DisguisePerm entry : customDisguises.keySet()) {
            String name = entry.toReadable();
            if (!name.equalsIgnoreCase(disguise) && !name.replaceAll("_", "").equalsIgnoreCase(disguise)) continue;
            customDisguises.remove(entry);
            break;
        }
    }

    public static Map.Entry<DisguisePerm, String> getRawCustomDisguise(String disguise) {
        for (Map.Entry<DisguisePerm, String> entry : customDisguises.entrySet()) {
            String name = entry.getKey().toReadable();
            if (!name.equalsIgnoreCase(disguise) && !name.replaceAll("_", "").equalsIgnoreCase(disguise)) continue;
            return entry;
        }
        return null;
    }

    public static void setUseTranslations(boolean setUseTranslations) {
        useTranslations = setUseTranslations;
        TranslateType.refreshTranslations();
    }

    private static ConfigLoader getConfig() {
        ConfigLoader configLoader = new ConfigLoader();
        configLoader.saveMissingConfigs();
        return configLoader;
    }

    public static ConfigLoader loadPreConfig() {
        ConfigLoader configLoader = DisguiseConfig.getConfig();
        DisguiseConfig.loadPreConfig(configLoader);
        return configLoader;
    }

    private static ConfigurationSection loadPreConfig(ConfigLoader configLoader) {
        YamlConfiguration config = configLoader.load();
        DisguiseConfig.setAddEntityAnimations(config.getBoolean("AddEntityAnimations"));
        DisguiseConfig.setDisguiseCloneExpire(config.getInt("DisguiseCloneExpire"));
        DisguiseConfig.setDisguiseEntityExpire(config.getInt("DisguiseEntityExpire"));
        DisguiseConfig.setDynamicExpiry(config.getBoolean("DynamicExpiry"));
        DisguiseConfig.setHideDisguisedPlayers(config.getBoolean("HideDisguisedPlayersFromTab"));
        DisguiseConfig.setPlayerHideArmor(config.getBoolean("PlayerHideArmor"));
        DisguiseConfig.setTallSelfDisguises(config.getBoolean("TallSelfDisguises"));
        DisguiseConfig.setTallSelfDisguisesScaling(config.getBoolean("TallSelfDisguisesScaling"));
        DisguiseConfig.setRandomDisguises(config.getBoolean("RandomDisguiseOptions"));
        DisguiseConfig.setViewDisguises(config.getBoolean("ViewSelfDisguises"));
        DisguiseConfig.setViewSelfDisguisesDefault(config.getBoolean("ViewSelfDisguisesDefault"));
        DisguiseConfig.setScaleSelfDisguises(config.getBoolean("SelfDisguisesScaling"));
        DisguiseConfig.setScaleSelfDisguisesMin(config.getDouble("SelfDisguisesScaleMin"));
        DisguiseConfig.setScaleSelfDisguisesMax(config.getDouble("SelfDisguisesScaleMax"));
        DisguiseConfig.setSelfDisguisesSoundsReplaced(config.getBoolean("HearSelfDisguise"));
        DisguiseConfig.setShowDisguisedPlayersInTab(config.getBoolean("ShowPlayerDisguisesInTab"));
        DisguiseConfig.setVelocitySent(config.getBoolean("SendVelocity"));
        DisguiseConfig.setNeverUpdatePacketEvents(config.getBoolean("NeverUpdatePacketEvents", config.getBoolean("NeverUpdateProtocolLib", false)));
        DisguiseConfig.setAutoUpdate(config.getBoolean("AutoUpdate"));
        if (Bukkit.getPluginManager().getPlugin("packetevents") == null) {
            return config;
        }
        DisguiseConfig.setHideHeldItemFromSelf(config.getBoolean("RemoveHeldItem"));
        DisguiseConfig.setHideArmorFromSelf(config.getBoolean("RemoveArmor"));
        return config;
    }

    public static void loadConfig() {
        int missingConfigs;
        ArrayList<String> returns;
        boolean verbose;
        PermissionDefault commandVisibility;
        ConfigLoader configLoader = DisguiseConfig.getConfig();
        ConfigurationSection config = DisguiseConfig.loadPreConfig(configLoader);
        DisguiseConfig.loadModdedDisguiseTypes();
        File skinsFolder = new File(LibsDisguises.getInstance().getDataFolder(), "Skins");
        if (!skinsFolder.exists()) {
            skinsFolder.mkdir();
            File explain = new File(skinsFolder, "README");
            try {
                explain.createNewFile();
                try (PrintWriter out = new PrintWriter(explain);){
                    out.println("This folder is used to store .png files for uploading with the /savedisguise or /grabskin commands");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        PacketsManager.setViewDisguisesListener(true);
        DisguiseConfig.setAnimationPacketsEnabled(config.getBoolean("PacketsEnabled.Animation"));
        DisguiseConfig.setCatDyeable(config.getBoolean("DyeableCat"));
        DisguiseConfig.setCollectPacketsEnabled(config.getBoolean("PacketsEnabled.Collect"));
        DisguiseConfig.setDisableFriendlyInvisibles(config.getBoolean("Scoreboard.DisableFriendlyInvisibles"));
        DisguiseConfig.setDisabledInvisibility(config.getBoolean("DisableInvisibility"));
        DisguiseConfig.setDisablePvP(config.getBoolean("DisablePvP"));
        DisguiseConfig.setDisablePvE(config.getBoolean("DisablePvE"));
        DisguiseConfig.setPvPTimer(config.getDouble("PvPTimer"));
        DisguiseConfig.setDisguiseBlownWhenAttacked(config.getBoolean("BlowDisguisesWhenAttacked"));
        DisguiseConfig.setDisguiseBlownWhenAttacking(config.getBoolean("BlowDisguisesWhenAttacking"));
        DisguiseConfig.setEntityStatusPacketsEnabled(config.getBoolean("PacketsEnabled.EntityStatus"));
        DisguiseConfig.setEquipmentPacketsEnabled(config.getBoolean("PacketsEnabled.Equipment"));
        DisguiseConfig.setExplicitDisguisePermissions(config.getBoolean("Permissions.ExplicitDisguises"));
        DisguiseConfig.setHidingCreativeEquipmentFromSelf(config.getBoolean("RemoveCreativeEquipment"));
        DisguiseConfig.setHorseSaddleable(config.getBoolean("SaddleableHorse"));
        DisguiseConfig.setKeepDisguiseOnPlayerDeath(config.getBoolean("KeepDisguises.PlayerDeath"));
        DisguiseConfig.setLlamaCarpetable(config.getBoolean("CarpetableLlama"));
        DisguiseConfig.setMaxClonedDisguises(config.getInt("DisguiseCloneSize"));
        DisguiseConfig.setMaxHealthDeterminedByDisguisedEntity(config.getBoolean("MaxHealthDeterminedByEntity"));
        DisguiseConfig.setMetaPacketsEnabled(config.getBoolean("PacketsEnabled.Metadata"));
        DisguiseConfig.setLoginPayloadPackets(config.getBoolean("PacketsEnabled.LoginPayload"));
        DisguiseConfig.setMiscDisguisesForLivingEnabled(config.getBoolean("MiscDisguisesForLiving"));
        DisguiseConfig.setModifyBoundingBox(config.getBoolean("ModifyBoundingBox"));
        DisguiseConfig.setModifyCollisions(config.getBoolean("Scoreboard.Collisions"));
        DisguiseConfig.setMonstersIgnoreDisguises(config.getBoolean("MonstersIgnoreDisguises"));
        DisguiseConfig.setMovementPacketsEnabled(config.getBoolean("PacketsEnabled.Movement"));
        DisguiseConfig.setNameAboveHeadAlwaysVisible(config.getBoolean("NameAboveHeadAlwaysVisible"));
        DisguiseConfig.setNameOfPlayerShownAboveDisguise(config.getBoolean("ShowNamesAboveDisguises"));
        DisguiseConfig.setNameAboveDisguise(config.getString("NameAboveDisguise"));
        DisguiseConfig.setRetaliationCombat(config.getBoolean("RetaliationCombat"));
        DisguiseConfig.setSaveGameProfiles(config.getBoolean("SaveGameProfiles"));
        DisguiseConfig.setSavePlayerDisguises(config.getBoolean("SaveDisguises.Players"));
        DisguiseConfig.setSaveEntityDisguises(config.getBoolean("SaveDisguises.Entities"));
        DisguiseConfig.setSheepDyeable(config.getBoolean("DyeableSheep"));
        DisguiseConfig.setStopShulkerDisguisesFromMoving(config.getBoolean("StopShulkerDisguisesFromMoving", true));
        DisguiseConfig.setUUIDGeneratedVersion(config.getInt("UUIDVersion"));
        DisguiseConfig.setUndisguiseOnWorldChange(config.getBoolean("UndisguiseOnWorldChange"));
        DisguiseConfig.setUpdateGameProfiles(config.getBoolean("UpdateGameProfiles"));
        DisguiseConfig.setUseTranslations(config.getBoolean("Translations"));
        DisguiseConfig.setWarnScoreboardConflict(config.getBoolean("Scoreboard.WarnConflict"));
        DisguiseConfig.setCopyPlayerTeamInfo(config.getBoolean("Scoreboard.CopyPlayerTeamInfo"));
        DisguiseConfig.setWitherSkullPacketsEnabled(config.getBoolean("PacketsEnabled.WitherSkull"));
        DisguiseConfig.setWolfDyeable(config.getBoolean("DyeableWolf"));
        DisguiseConfig.setTablistRemoveDelay(config.getInt("TablistRemoveDelay"));
        DisguiseConfig.setOverrideCustomNames(config.getBoolean("OverrideCustomNames"));
        DisguiseConfig.setSaveUserPreferences(config.getBoolean("SaveUserPreferences"));
        DisguiseConfig.setPlayerDisguisesSkinExpiresMove(config.getInt("PlayerDisguisesTablistExpiresMove"));
        DisguiseConfig.setContactMojangServers(config.getBoolean("ContactMojangServers"));
        DisguiseConfig.setDisguiseRadiusMax(config.getInt("DisguiseRadiusMax"));
        DisguiseConfig.setRandomUUIDS(config.getBoolean("RandomUUIDs"));
        DisguiseConfig.setRemoveDisguiseBlockBreak(config.getBoolean("UndisguiseOnBlockBreak"));
        DisguiseConfig.setRemoveDisguiseBlockPlace(config.getBoolean("UndisguiseOnBlockPlace"));
        String apiKey = config.getString("MineSkinAPIKey");
        DisguiseConfig.setSoundsEnabled(config.getBoolean("DisguiseSounds"));
        DisguiseConfig.setUniquePlayerDisguiseUUIDs(config.getBoolean("UniquePlayerUUID"));
        DisguiseConfig.setHideDeathMessages(config.getBoolean("HideDeathMessages"));
        if (apiKey != null && apiKey.matches("[a-zA-Z\\d]{8,}")) {
            DisguiseUtilities.getMineSkinAPI().setApiKey(apiKey);
        } else if (apiKey != null && apiKey.length() > 8) {
            LibsDisguises.getInstance().getLogger().warning("API Key provided for MineSkin does not appear to be in a valid format!");
        }
        if (!LibsPremium.isPremium().booleanValue() && (DisguiseConfig.isSavePlayerDisguises() || DisguiseConfig.isSaveEntityDisguises())) {
            LibsDisguises.getInstance().getLogger().warning("You must purchase the plugin to use saved disguises!");
        }
        try {
            DisguiseConfig.setPlayerNameType(PlayerNameType.valueOf(config.getString("PlayerNames").toUpperCase(Locale.ENGLISH)));
        }
        catch (Exception ex) {
            LibsDisguises.getInstance().getLogger().warning("Cannot parse '" + config.getString("PlayerNames") + "' to a valid option for PlayerNames");
        }
        try {
            DisguiseConfig.setNotifyBar(NotifyBar.valueOf(config.getString("NotifyBar").toUpperCase(Locale.ENGLISH)));
            if (DisguiseConfig.getNotifyBar() == NotifyBar.BOSS_BAR && !NmsVersion.v1_13.isSupported()) {
                LibsDisguises.getInstance().getLogger().warning("BossBars hasn't been implemented properly in 1.12 due to api restrictions, falling back to ACTION_BAR");
                DisguiseConfig.setNotifyBar(NotifyBar.ACTION_BAR);
            }
        }
        catch (Exception ex) {
            LibsDisguises.getInstance().getLogger().warning("Cannot parse '" + config.getString("NotifyBar") + "' to a valid option for NotifyBar");
        }
        try {
            DisguiseConfig.setBossBarColor(BarColor.valueOf((String)config.getString("BossBarColor").toUpperCase(Locale.ENGLISH)));
        }
        catch (Exception ex) {
            LibsDisguises.getInstance().getLogger().warning("Cannot parse '" + config.getString("BossBarColor") + "' to a valid option for BossBarColor");
        }
        try {
            DisguiseConfig.setBossBarStyle(BarStyle.valueOf((String)config.getString("BossBarStyle").toUpperCase(Locale.ENGLISH)));
        }
        catch (Exception ex) {
            LibsDisguises.getInstance().getLogger().warning("Cannot parse '" + config.getString("BossBarStyle") + "' to a valid option for BossBarStyle");
        }
        try {
            DisguiseConfig.setUpdatesBranch(UpdatesBranch.valueOf(config.getString("UpdatesBranch").toUpperCase(Locale.ENGLISH)));
        }
        catch (Exception ex) {
            LibsDisguises.getInstance().getLogger().warning("Cannot parse '" + config.getString("UpdatesBranch") + "' to a valid option for UpdatesBranch");
        }
        try {
            DisguiseConfig.setDisabledDisguises(config.getStringList("DisabledDisguises").stream().map(s -> DisguiseType.valueOf(s.toUpperCase(Locale.ENGLISH))).collect(Collectors.toList()));
        }
        catch (Exception ex) {
            LibsDisguises.getInstance().getLogger().warning("Cannot load 'DisabledDisguises' in features.yml, invalid disguise types provided?");
        }
        DisguiseConfig.setDisabledMethods(config.getStringList("DisabledMethods").stream().map(s -> s.toLowerCase(Locale.ENGLISH)).collect(Collectors.toList()));
        String seeCommands = config.getString("Permissions.SeeCommands");
        PermissionDefault permissionDefault = commandVisibility = seeCommands == null ? null : PermissionDefault.getByName((String)seeCommands);
        if (commandVisibility == null) {
            LibsDisguises.getInstance().getLogger().warning("Invalid option '" + config.getString("Permissions.SeeCommands") + "' for Permissions.SeeCommands when loading config!");
        } else {
            DisguiseConfig.setCommandVisibility(commandVisibility);
        }
        DisguiseConfig.loadCustomDisguises();
        if ("%%__USER__%%".equals("12345") && DisguiseConfig.getCustomDisguises().size() > 10) {
            DisguiseConfig.setSoundsEnabled(false);
            Iterator<Map.Entry<DisguisePerm, String>> itel = DisguiseConfig.getCustomDisguises().entrySet().iterator();
            boolean i = false;
            while (itel.hasNext()) {
                itel.next();
                if (!new Random().nextBoolean()) continue;
                itel.remove();
            }
        }
        if (config.contains("VerboseConfig")) {
            verbose = config.getBoolean("VerboseConfig");
        } else {
            LibsDisguises.getInstance().getLogger().info("As 'VerboseConfig' hasn't been set, it is assumed true. Set it in your config to remove these messages!");
            verbose = true;
        }
        boolean changed = config.getBoolean("ChangedConfig");
        if ((verbose || changed) && !(returns = DisguiseConfig.doOutput(config, changed, verbose)).isEmpty()) {
            LibsDisguises.getInstance().getLogger().info("This is not an error! Now outputting " + (verbose ? "missing " : "") + (changed ? (verbose ? "and " : "") + "changed/invalid " : "") + "config values");
            for (String v : returns) {
                LibsDisguises.getInstance().getLogger().info(v);
            }
        }
        if ((missingConfigs = DisguiseConfig.doOutput(config, false, true).size()) > 0) {
            if (config.getBoolean("UpdateConfig", true)) {
                configLoader.saveDefaultConfigs();
                LibsDisguises.getInstance().getLogger().info("Config has been auto-updated!");
            } else if (!verbose) {
                LibsDisguises.getInstance().getLogger().warning("Your config is missing " + missingConfigs + " options! Please consider regenerating your config!");
                LibsDisguises.getInstance().getLogger().info("You can also add the missing entries yourself! Try '/libsdisguises config'");
            }
        } else {
            LibsDisguises.getInstance().getLogger().info("Config is up to date!");
        }
        if (LibsPremium.isPremium().booleanValue() && !LibsPremium.isBisectHosted() && LibsPremium.getPaidInformation() != null && LibsPremium.getPaidInformation().getSize() < 666L) {
            DisguiseConfig.setDisablePvE(true);
        }
    }

    public static void loadModdedDisguiseTypes() {
        File disguisesFile = new File(LibsDisguises.getInstance().getDataFolder(), "configs/disguises.yml");
        if (!disguisesFile.exists()) {
            return;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)disguisesFile);
        if (!config.contains("Custom-Entities")) {
            return;
        }
        ArrayList<String> channels = new ArrayList<String>();
        for (String name : config.getConfigurationSection("Custom-Entities").getKeys(false)) {
            try {
                String requireMessage;
                if (!name.matches("\\w+")) {
                    LibsDisguises.getInstance().getLogger().severe("Invalid modded disguise name '" + name + "'");
                    continue;
                }
                ConfigurationSection section = config.getConfigurationSection("Custom-Entities." + name);
                if (!section.contains("Name")) {
                    LibsDisguises.getInstance().getLogger().severe("No mod:entity 'Name' provided for '" + name + "'");
                    continue;
                }
                String key = section.getString("Name");
                if (!key.contains(":") || key.contains(".")) {
                    LibsDisguises.getInstance().getLogger().severe("Invalid modded name '" + key + "' in disguises.yml!");
                    continue;
                }
                boolean register = section.getBoolean("Register", true);
                boolean living = section.getString("Type", "LIVING").equalsIgnoreCase("LIVING");
                String type = section.getString("Type");
                String mod = section.getString("Mod");
                String[] version = mod == null || !section.contains("Version") ? null : section.getString("Version").split(",");
                String string = requireMessage = mod == null ? null : section.getString("Required");
                if (section.contains("Channels")) {
                    for (String s : section.getString("Channels").split(",")) {
                        if (!s.contains("|")) {
                            s = s + "|";
                            LibsDisguises.getInstance().getLogger().severe("No channel version declared for " + s);
                        }
                        channels.add(s);
                    }
                }
                if (requireMessage != null) {
                    requireMessage = DisguiseUtilities.translateAlternateColorCodes(requireMessage);
                }
                ModdedEntity entity = new ModdedEntity(null, null, name, living, mod, version, requireMessage, 0);
                if (ModdedManager.getModdedEntity(name) != null) {
                    LibsDisguises.getInstance().getLogger().info("Modded entity " + name + " has already been " + (register ? "registered" : "added"));
                    continue;
                }
                ModdedManager.registerModdedEntity(new NamespacedKey(key.substring(0, key.indexOf(":")), key.substring(key.indexOf(":") + 1)), entity, register);
                LibsDisguises.getInstance().getLogger().info("Modded entity " + name + " has been " + (register ? "registered" : "added"));
            }
            catch (Exception ex) {
                LibsDisguises.getInstance().getLogger().severe("Error while trying to register modded entity " + name);
                ex.printStackTrace();
            }
        }
        new ModdedManager(channels);
    }

    public static ArrayList<String> doOutput(boolean informChangedUnknown, boolean informMissing) {
        return DisguiseConfig.doOutput((ConfigurationSection)new ConfigLoader().load(), informChangedUnknown, informMissing);
    }

    public static ArrayList<String> doOutput(ConfigurationSection config, boolean informChangedUnknown, boolean informMissing) {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        ConfigurationSection defaultSection = config.getDefaultSection();
        if (defaultSection == null) {
            defaultSection = new ConfigLoader().loadDefaults();
        }
        ArrayList<String> returns = new ArrayList<String>();
        for (String string : defaultSection.getKeys(true)) {
            if (defaultSection.isConfigurationSection(string)) continue;
            configs.put(string, defaultSection.get(string));
        }
        for (String string : config.getKeys(true)) {
            if (config.isConfigurationSection(string)) continue;
            if (!configs.containsKey(string)) {
                if (!informChangedUnknown) continue;
                returns.add("Unknown config option '" + string + ": " + config.get(string) + "'");
                continue;
            }
            if (!configs.get(string).equals(config.get(string)) && informChangedUnknown) {
                returns.add("Modified config: '" + string + ": " + config.get(string) + "'");
            }
            configs.remove(string);
        }
        if (informMissing) {
            for (Map.Entry entry : configs.entrySet()) {
                returns.add("Missing '" + (String)entry.getKey() + ": " + entry.getValue() + "'");
            }
        }
        return returns;
    }

    static void loadCustomDisguises() {
        customDisguises.clear();
        File disguisesFile = new File(LibsDisguises.getInstance().getDataFolder(), "configs/disguises.yml");
        if (!disguisesFile.exists()) {
            return;
        }
        YamlConfiguration disguisesConfig = YamlConfiguration.loadConfiguration((File)disguisesFile);
        ConfigurationSection section = disguisesConfig.getConfigurationSection("Disguises");
        if (section == null) {
            return;
        }
        int failedCustomDisguises = 0;
        for (String key : section.getKeys(false)) {
            String toParse = section.getString(key);
            if (!NmsVersion.v1_13.isSupported() && key.equals("libraryaddict")) {
                toParse = toParse.replace("GOLDEN_BOOTS,GOLDEN_LEGGINGS,GOLDEN_CHESTPLATE,GOLDEN_HELMET", "GOLD_BOOTS,GOLD_LEGGINGS,GOLD_CHESTPLATE,GOLD_HELMET");
            }
            try {
                DisguiseConfig.addCustomDisguise(key, toParse);
            }
            catch (Exception e) {
                ++failedCustomDisguises;
                if (e instanceof DisguiseParseException) {
                    if (e.getMessage() != null) {
                        LibsDisguises.getInstance().getLogger().severe(e.getMessage());
                    }
                    if (e.getCause() == null) continue;
                    e.printStackTrace();
                    continue;
                }
                e.printStackTrace();
            }
        }
        if (failedCustomDisguises > 0) {
            LibsDisguises.getInstance().getLogger().warning("Failed to load " + failedCustomDisguises + " custom disguises");
        }
        LibsDisguises.getInstance().getLogger().info("Loaded " + customDisguises.size() + " custom disguise" + (customDisguises.size() == 1 ? "" : "s"));
        DisguisePermissions.onReload();
    }

    public static void addCustomDisguise(String disguiseName, String toParse) throws DisguiseParseException {
        if (!Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("Custom Disguises should not be called async!");
        }
        if (DisguiseConfig.getRawCustomDisguise(toParse) != null) {
            throw new DisguiseParseException(LibsMsg.CUSTOM_DISGUISE_NAME_CONFLICT, disguiseName);
        }
        try {
            String[] disguiseArgs = DisguiseUtilities.split(toParse);
            Disguise disguise = DisguiseParser.parseTestDisguise((CommandSender)Bukkit.getConsoleSender(), "disguise", disguiseArgs, DisguiseParser.getPermissions((CommandSender)Bukkit.getConsoleSender(), "disguise"));
            DisguisePerm perm = new DisguisePerm(disguise.getType(), disguiseName);
            customDisguises.put(perm, toParse);
            LibsDisguises.getInstance().getLogger().info("Loaded custom disguise " + disguiseName);
            DisguisePermissions.onReload();
        }
        catch (DisguiseParseException e) {
            throw new DisguiseParseException(LibsMsg.ERROR_LOADING_CUSTOM_DISGUISE, disguiseName, e.getMessage() == null ? "" : ": " + e.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new DisguiseParseException(LibsMsg.ERROR_LOADING_CUSTOM_DISGUISE, disguiseName, "");
        }
    }

    public static boolean isSoundEnabled() {
        return PacketsManager.isHearDisguisesEnabled();
    }

    public static void setAnimationPacketsEnabled(boolean enabled) {
        if (enabled == DisguiseConfig.isAnimationPacketsEnabled()) {
            return;
        }
        animationPacketsEnabled = enabled;
        PacketsManager.setupMainPacketsListener();
    }

    public static void setCollectPacketsEnabled(boolean enabled) {
        if (enabled == DisguiseConfig.isCollectPacketsEnabled()) {
            return;
        }
        collectPacketsEnabled = enabled;
        PacketsManager.setupMainPacketsListener();
    }

    public static void setEntityStatusPacketsEnabled(boolean enabled) {
        if (enabled == DisguiseConfig.isEntityStatusPacketsEnabled()) {
            return;
        }
        entityStatusPacketsEnabled = enabled;
        PacketsManager.setupMainPacketsListener();
    }

    public static void setEquipmentPacketsEnabled(boolean enabled) {
        if (enabled == DisguiseConfig.isEquipmentPacketsEnabled()) {
            return;
        }
        equipmentPacketsEnabled = enabled;
        PacketsManager.setupMainPacketsListener();
    }

    public static void setHideArmorFromSelf(boolean hideArmor) {
        hidingArmorFromSelf = hideArmor;
        DisguiseConfig.updateInventoryListener();
    }

    public static void setHideHeldItemFromSelf(boolean hideHelditem) {
        hidingHeldItemFromSelf = hideHelditem;
        DisguiseConfig.updateInventoryListener();
    }

    private static void updateInventoryListener() {
        PacketsManager.setInventoryListenerEnabled(DisguiseConfig.isHidingHeldItemFromSelf() || DisguiseConfig.isHidingArmorFromSelf());
    }

    public static void setMiscDisguisesForLivingEnabled(boolean enabled) {
        if (enabled == DisguiseConfig.isMiscDisguisesForLivingEnabled()) {
            return;
        }
        miscDisguisesForLivingEnabled = enabled;
        PacketsManager.setupMainPacketsListener();
    }

    public static void setMovementPacketsEnabled(boolean enabled) {
        if (enabled == DisguiseConfig.isMovementPacketsEnabled()) {
            return;
        }
        movementPacketsEnabled = enabled;
        PacketsManager.setupMainPacketsListener();
    }

    public static void setSoundsEnabled(boolean isSoundsEnabled) {
        PacketsManager.setHearDisguisesListener(isSoundsEnabled);
    }

    @Generated
    public static HashMap<DisguisePerm, String> getCustomDisguises() {
        return customDisguises;
    }

    @Generated
    public static void setCustomDisguises(HashMap<DisguisePerm, String> customDisguises) {
        DisguiseConfig.customDisguises = customDisguises;
    }

    @Generated
    public static UpdatesBranch getUpdatesBranch() {
        return updatesBranch;
    }

    @Generated
    public static void setUpdatesBranch(UpdatesBranch updatesBranch) {
        DisguiseConfig.updatesBranch = updatesBranch;
    }

    @Generated
    public static boolean isAddEntityAnimations() {
        return addEntityAnimations;
    }

    @Generated
    public static void setAddEntityAnimations(boolean addEntityAnimations) {
        DisguiseConfig.addEntityAnimations = addEntityAnimations;
    }

    @Generated
    public static boolean isAnimationPacketsEnabled() {
        return animationPacketsEnabled;
    }

    @Generated
    public static boolean isCatDyeable() {
        return catDyeable;
    }

    @Generated
    public static void setCatDyeable(boolean catDyeable) {
        DisguiseConfig.catDyeable = catDyeable;
    }

    @Generated
    public static boolean isCollectPacketsEnabled() {
        return collectPacketsEnabled;
    }

    @Generated
    public static boolean isDisableFriendlyInvisibles() {
        return disableFriendlyInvisibles;
    }

    @Generated
    public static void setDisableFriendlyInvisibles(boolean disableFriendlyInvisibles) {
        DisguiseConfig.disableFriendlyInvisibles = disableFriendlyInvisibles;
    }

    @Generated
    public static boolean isDisabledInvisibility() {
        return disabledInvisibility;
    }

    @Generated
    public static void setDisabledInvisibility(boolean disabledInvisibility) {
        DisguiseConfig.disabledInvisibility = disabledInvisibility;
    }

    @Generated
    public static boolean isDisguiseBlownWhenAttacked() {
        return disguiseBlownWhenAttacked;
    }

    @Generated
    public static void setDisguiseBlownWhenAttacked(boolean disguiseBlownWhenAttacked) {
        DisguiseConfig.disguiseBlownWhenAttacked = disguiseBlownWhenAttacked;
    }

    @Generated
    public static boolean isDisguiseBlownWhenAttacking() {
        return disguiseBlownWhenAttacking;
    }

    @Generated
    public static void setDisguiseBlownWhenAttacking(boolean disguiseBlownWhenAttacking) {
        DisguiseConfig.disguiseBlownWhenAttacking = disguiseBlownWhenAttacking;
    }

    @Generated
    public static boolean isDynamicExpiry() {
        return dynamicExpiry;
    }

    @Generated
    public static void setDynamicExpiry(boolean dynamicExpiry) {
        DisguiseConfig.dynamicExpiry = dynamicExpiry;
    }

    @Generated
    public static boolean isEntityStatusPacketsEnabled() {
        return entityStatusPacketsEnabled;
    }

    @Generated
    public static boolean isEquipmentPacketsEnabled() {
        return equipmentPacketsEnabled;
    }

    @Generated
    public static boolean isExplicitDisguisePermissions() {
        return explicitDisguisePermissions;
    }

    @Generated
    public static void setExplicitDisguisePermissions(boolean explicitDisguisePermissions) {
        DisguiseConfig.explicitDisguisePermissions = explicitDisguisePermissions;
    }

    @Generated
    public static boolean isHideDisguisedPlayers() {
        return hideDisguisedPlayers;
    }

    @Generated
    public static void setHideDisguisedPlayers(boolean hideDisguisedPlayers) {
        DisguiseConfig.hideDisguisedPlayers = hideDisguisedPlayers;
    }

    @Generated
    public static boolean isHidingArmorFromSelf() {
        return hidingArmorFromSelf;
    }

    @Generated
    public static void setHidingArmorFromSelf(boolean hidingArmorFromSelf) {
        DisguiseConfig.hidingArmorFromSelf = hidingArmorFromSelf;
    }

    @Generated
    public static boolean isHidingCreativeEquipmentFromSelf() {
        return hidingCreativeEquipmentFromSelf;
    }

    @Generated
    public static void setHidingCreativeEquipmentFromSelf(boolean hidingCreativeEquipmentFromSelf) {
        DisguiseConfig.hidingCreativeEquipmentFromSelf = hidingCreativeEquipmentFromSelf;
    }

    @Generated
    public static boolean isHidingHeldItemFromSelf() {
        return hidingHeldItemFromSelf;
    }

    @Generated
    public static void setHidingHeldItemFromSelf(boolean hidingHeldItemFromSelf) {
        DisguiseConfig.hidingHeldItemFromSelf = hidingHeldItemFromSelf;
    }

    @Generated
    public static boolean isHorseSaddleable() {
        return horseSaddleable;
    }

    @Generated
    public static void setHorseSaddleable(boolean horseSaddleable) {
        DisguiseConfig.horseSaddleable = horseSaddleable;
    }

    @Generated
    public static boolean isKeepDisguiseOnPlayerDeath() {
        return keepDisguiseOnPlayerDeath;
    }

    @Generated
    public static void setKeepDisguiseOnPlayerDeath(boolean keepDisguiseOnPlayerDeath) {
        DisguiseConfig.keepDisguiseOnPlayerDeath = keepDisguiseOnPlayerDeath;
    }

    @Generated
    public static boolean isLlamaCarpetable() {
        return llamaCarpetable;
    }

    @Generated
    public static void setLlamaCarpetable(boolean llamaCarpetable) {
        DisguiseConfig.llamaCarpetable = llamaCarpetable;
    }

    @Generated
    public static boolean isMaxHealthDeterminedByDisguisedEntity() {
        return maxHealthDeterminedByDisguisedEntity;
    }

    @Generated
    public static void setMaxHealthDeterminedByDisguisedEntity(boolean maxHealthDeterminedByDisguisedEntity) {
        DisguiseConfig.maxHealthDeterminedByDisguisedEntity = maxHealthDeterminedByDisguisedEntity;
    }

    @Generated
    public static boolean isMetaPacketsEnabled() {
        return metaPacketsEnabled;
    }

    @Generated
    public static void setMetaPacketsEnabled(boolean metaPacketsEnabled) {
        DisguiseConfig.metaPacketsEnabled = metaPacketsEnabled;
    }

    @Generated
    public static boolean isMiscDisguisesForLivingEnabled() {
        return miscDisguisesForLivingEnabled;
    }

    @Generated
    public static boolean isModifyBoundingBox() {
        return modifyBoundingBox;
    }

    @Generated
    public static void setModifyBoundingBox(boolean modifyBoundingBox) {
        DisguiseConfig.modifyBoundingBox = modifyBoundingBox;
    }

    @Generated
    public static boolean isModifyCollisions() {
        return modifyCollisions;
    }

    @Generated
    public static void setModifyCollisions(boolean modifyCollisions) {
        DisguiseConfig.modifyCollisions = modifyCollisions;
    }

    @Generated
    public static boolean isMonstersIgnoreDisguises() {
        return monstersIgnoreDisguises;
    }

    @Generated
    public static void setMonstersIgnoreDisguises(boolean monstersIgnoreDisguises) {
        DisguiseConfig.monstersIgnoreDisguises = monstersIgnoreDisguises;
    }

    @Generated
    public static boolean isMovementPacketsEnabled() {
        return movementPacketsEnabled;
    }

    @Generated
    public static boolean isNameAboveHeadAlwaysVisible() {
        return nameAboveHeadAlwaysVisible;
    }

    @Generated
    public static void setNameAboveHeadAlwaysVisible(boolean nameAboveHeadAlwaysVisible) {
        DisguiseConfig.nameAboveHeadAlwaysVisible = nameAboveHeadAlwaysVisible;
    }

    @Generated
    public static boolean isNameOfPlayerShownAboveDisguise() {
        return nameOfPlayerShownAboveDisguise;
    }

    @Generated
    public static void setNameOfPlayerShownAboveDisguise(boolean nameOfPlayerShownAboveDisguise) {
        DisguiseConfig.nameOfPlayerShownAboveDisguise = nameOfPlayerShownAboveDisguise;
    }

    @Generated
    public static boolean isPlayerHideArmor() {
        return playerHideArmor;
    }

    @Generated
    public static void setPlayerHideArmor(boolean playerHideArmor) {
        DisguiseConfig.playerHideArmor = playerHideArmor;
    }

    @Generated
    public static boolean isSaveEntityDisguises() {
        return saveEntityDisguises;
    }

    @Generated
    public static void setSaveEntityDisguises(boolean saveEntityDisguises) {
        DisguiseConfig.saveEntityDisguises = saveEntityDisguises;
    }

    @Generated
    public static boolean isSaveGameProfiles() {
        return saveGameProfiles;
    }

    @Generated
    public static void setSaveGameProfiles(boolean saveGameProfiles) {
        DisguiseConfig.saveGameProfiles = saveGameProfiles;
    }

    @Generated
    public static boolean isSavePlayerDisguises() {
        return savePlayerDisguises;
    }

    @Generated
    public static void setSavePlayerDisguises(boolean savePlayerDisguises) {
        DisguiseConfig.savePlayerDisguises = savePlayerDisguises;
    }

    @Generated
    public static boolean isSelfDisguisesSoundsReplaced() {
        return selfDisguisesSoundsReplaced;
    }

    @Generated
    public static void setSelfDisguisesSoundsReplaced(boolean selfDisguisesSoundsReplaced) {
        DisguiseConfig.selfDisguisesSoundsReplaced = selfDisguisesSoundsReplaced;
    }

    @Generated
    public static boolean isSheepDyeable() {
        return sheepDyeable;
    }

    @Generated
    public static void setSheepDyeable(boolean sheepDyeable) {
        DisguiseConfig.sheepDyeable = sheepDyeable;
    }

    @Generated
    public static boolean isShowDisguisedPlayersInTab() {
        return showDisguisedPlayersInTab;
    }

    @Generated
    public static void setShowDisguisedPlayersInTab(boolean showDisguisedPlayersInTab) {
        DisguiseConfig.showDisguisedPlayersInTab = showDisguisedPlayersInTab;
    }

    @Generated
    public static boolean isStopShulkerDisguisesFromMoving() {
        return stopShulkerDisguisesFromMoving;
    }

    @Generated
    public static void setStopShulkerDisguisesFromMoving(boolean stopShulkerDisguisesFromMoving) {
        DisguiseConfig.stopShulkerDisguisesFromMoving = stopShulkerDisguisesFromMoving;
    }

    @Generated
    public static boolean isUndisguiseOnWorldChange() {
        return undisguiseOnWorldChange;
    }

    @Generated
    public static void setUndisguiseOnWorldChange(boolean undisguiseOnWorldChange) {
        DisguiseConfig.undisguiseOnWorldChange = undisguiseOnWorldChange;
    }

    @Generated
    public static boolean isUpdateGameProfiles() {
        return updateGameProfiles;
    }

    @Generated
    public static void setUpdateGameProfiles(boolean updateGameProfiles) {
        DisguiseConfig.updateGameProfiles = updateGameProfiles;
    }

    @Generated
    public static boolean isUseTranslations() {
        return useTranslations;
    }

    @Generated
    public static boolean isVelocitySent() {
        return velocitySent;
    }

    @Generated
    public static void setVelocitySent(boolean velocitySent) {
        DisguiseConfig.velocitySent = velocitySent;
    }

    @Generated
    public static boolean isViewDisguises() {
        return viewDisguises;
    }

    @Generated
    public static void setViewDisguises(boolean viewDisguises) {
        DisguiseConfig.viewDisguises = viewDisguises;
    }

    @Generated
    public static boolean isWarnScoreboardConflict() {
        return warnScoreboardConflict;
    }

    @Generated
    public static void setWarnScoreboardConflict(boolean warnScoreboardConflict) {
        DisguiseConfig.warnScoreboardConflict = warnScoreboardConflict;
    }

    @Generated
    public static boolean isWitherSkullPacketsEnabled() {
        return witherSkullPacketsEnabled;
    }

    @Generated
    public static void setWitherSkullPacketsEnabled(boolean witherSkullPacketsEnabled) {
        DisguiseConfig.witherSkullPacketsEnabled = witherSkullPacketsEnabled;
    }

    @Generated
    public static boolean isWolfDyeable() {
        return wolfDyeable;
    }

    @Generated
    public static void setWolfDyeable(boolean wolfDyeable) {
        DisguiseConfig.wolfDyeable = wolfDyeable;
    }

    @Generated
    public static int getDisguiseCloneExpire() {
        return disguiseCloneExpire;
    }

    @Generated
    public static void setDisguiseCloneExpire(int disguiseCloneExpire) {
        DisguiseConfig.disguiseCloneExpire = disguiseCloneExpire;
    }

    @Generated
    public static int getDisguiseEntityExpire() {
        return disguiseEntityExpire;
    }

    @Generated
    public static void setDisguiseEntityExpire(int disguiseEntityExpire) {
        DisguiseConfig.disguiseEntityExpire = disguiseEntityExpire;
    }

    @Generated
    public static int getMaxClonedDisguises() {
        return maxClonedDisguises;
    }

    @Generated
    public static void setMaxClonedDisguises(int maxClonedDisguises) {
        DisguiseConfig.maxClonedDisguises = maxClonedDisguises;
    }

    @Generated
    public static boolean isDisablePvP() {
        return disablePvP;
    }

    @Generated
    public static void setDisablePvP(boolean disablePvP) {
        DisguiseConfig.disablePvP = disablePvP;
    }

    @Generated
    public static boolean isDisablePvE() {
        return disablePvE;
    }

    @Generated
    public static void setDisablePvE(boolean disablePvE) {
        DisguiseConfig.disablePvE = disablePvE;
    }

    @Generated
    public static double getPvPTimer() {
        return pvPTimer;
    }

    @Generated
    public static void setPvPTimer(double pvPTimer) {
        DisguiseConfig.pvPTimer = pvPTimer;
    }

    @Generated
    public static boolean isRetaliationCombat() {
        return retaliationCombat;
    }

    @Generated
    public static void setRetaliationCombat(boolean retaliationCombat) {
        DisguiseConfig.retaliationCombat = retaliationCombat;
    }

    @Generated
    public static NotifyBar getNotifyBar() {
        return notifyBar;
    }

    @Generated
    public static void setNotifyBar(NotifyBar notifyBar) {
        DisguiseConfig.notifyBar = notifyBar;
    }

    @Generated
    public static BarStyle getBossBarStyle() {
        return bossBarStyle;
    }

    @Generated
    public static void setBossBarStyle(BarStyle bossBarStyle) {
        DisguiseConfig.bossBarStyle = bossBarStyle;
    }

    @Generated
    public static BarColor getBossBarColor() {
        return bossBarColor;
    }

    @Generated
    public static void setBossBarColor(BarColor bossBarColor) {
        DisguiseConfig.bossBarColor = bossBarColor;
    }

    @Generated
    public static PermissionDefault getCommandVisibility() {
        return commandVisibility;
    }

    @Generated
    public static int getTablistRemoveDelay() {
        return tablistRemoveDelay;
    }

    @Generated
    public static void setTablistRemoveDelay(int tablistRemoveDelay) {
        DisguiseConfig.tablistRemoveDelay = tablistRemoveDelay;
    }

    @Generated
    public static boolean isUsingReleaseBuild() {
        return usingReleaseBuild;
    }

    @Generated
    public static boolean isBisectHosted() {
        return bisectHosted;
    }

    @Generated
    public static String getSavedServerIp() {
        return savedServerIp;
    }

    @Generated
    public static Boolean getAutoUpdate() {
        return autoUpdate;
    }

    @Generated
    public static boolean isNotifyUpdate() {
        return notifyUpdate;
    }

    @Generated
    public static boolean isTallSelfDisguises() {
        return tallSelfDisguises;
    }

    @Generated
    public static boolean isTallSelfDisguisesScaling() {
        return tallSelfDisguisesScaling;
    }

    @Generated
    public static void setTallSelfDisguises(boolean tallSelfDisguises) {
        DisguiseConfig.tallSelfDisguises = tallSelfDisguises;
    }

    @Generated
    public static void setTallSelfDisguisesScaling(boolean tallSelfDisguisesScaling) {
        DisguiseConfig.tallSelfDisguisesScaling = tallSelfDisguisesScaling;
    }

    @Generated
    public static PlayerNameType getPlayerNameType() {
        return playerNameType;
    }

    @Generated
    public static void setPlayerNameType(PlayerNameType playerNameType) {
        DisguiseConfig.playerNameType = playerNameType;
    }

    @Generated
    public static boolean isOverrideCustomNames() {
        return overrideCustomNames;
    }

    @Generated
    public static void setOverrideCustomNames(boolean overrideCustomNames) {
        DisguiseConfig.overrideCustomNames = overrideCustomNames;
    }

    @Generated
    public static boolean isRandomDisguises() {
        return randomDisguises;
    }

    @Generated
    public static void setRandomDisguises(boolean randomDisguises) {
        DisguiseConfig.randomDisguises = randomDisguises;
    }

    @Generated
    public static boolean isLoginPayloadPackets() {
        return loginPayloadPackets;
    }

    @Generated
    public static void setLoginPayloadPackets(boolean loginPayloadPackets) {
        DisguiseConfig.loginPayloadPackets = loginPayloadPackets;
    }

    @Generated
    public static boolean isSaveUserPreferences() {
        return saveUserPreferences;
    }

    @Generated
    public static void setSaveUserPreferences(boolean saveUserPreferences) {
        DisguiseConfig.saveUserPreferences = saveUserPreferences;
    }

    @Generated
    public static long getLastUpdateRequest() {
        return lastUpdateRequest;
    }

    @Generated
    public static boolean isHittingRateLimit() {
        return hittingRateLimit;
    }

    @Generated
    public static boolean isCopyPlayerTeamInfo() {
        return copyPlayerTeamInfo;
    }

    @Generated
    public static void setCopyPlayerTeamInfo(boolean copyPlayerTeamInfo) {
        DisguiseConfig.copyPlayerTeamInfo = copyPlayerTeamInfo;
    }

    @Generated
    public static String getNameAboveDisguise() {
        return nameAboveDisguise;
    }

    @Generated
    public static void setNameAboveDisguise(String nameAboveDisguise) {
        DisguiseConfig.nameAboveDisguise = nameAboveDisguise;
    }

    @Generated
    public static int getPlayerDisguisesSkinExpiresMove() {
        return playerDisguisesSkinExpiresMove;
    }

    @Generated
    public static void setPlayerDisguisesSkinExpiresMove(int playerDisguisesSkinExpiresMove) {
        DisguiseConfig.playerDisguisesSkinExpiresMove = playerDisguisesSkinExpiresMove;
    }

    @Generated
    public static boolean isViewSelfDisguisesDefault() {
        return viewSelfDisguisesDefault;
    }

    @Generated
    public static void setViewSelfDisguisesDefault(boolean viewSelfDisguisesDefault) {
        DisguiseConfig.viewSelfDisguisesDefault = viewSelfDisguisesDefault;
    }

    @Generated
    public static String getLastGithubUpdateETag() {
        return lastGithubUpdateETag;
    }

    @Generated
    public static void setLastGithubUpdateETag(String lastGithubUpdateETag) {
        DisguiseConfig.lastGithubUpdateETag = lastGithubUpdateETag;
    }

    @Generated
    public static String getLastPluginUpdateVersion() {
        return lastPluginUpdateVersion;
    }

    @Generated
    public static void setLastPluginUpdateVersion(String lastPluginUpdateVersion) {
        DisguiseConfig.lastPluginUpdateVersion = lastPluginUpdateVersion;
    }

    @Generated
    public static boolean isContactMojangServers() {
        return contactMojangServers;
    }

    @Generated
    public static void setContactMojangServers(boolean contactMojangServers) {
        DisguiseConfig.contactMojangServers = contactMojangServers;
    }

    @Generated
    public static int getDisguiseRadiusMax() {
        return disguiseRadiusMax;
    }

    @Generated
    protected static void setDisguiseRadiusMax(int disguiseRadiusMax) {
        DisguiseConfig.disguiseRadiusMax = disguiseRadiusMax;
    }

    @Generated
    public static String getData() {
        return data;
    }

    @Generated
    public static void setData(String data) {
        DisguiseConfig.data = data;
    }

    @Generated
    public static boolean isRandomUUIDS() {
        return randomUUIDS;
    }

    @Generated
    public static void setRandomUUIDS(boolean randomUUIDS) {
        DisguiseConfig.randomUUIDS = randomUUIDS;
    }

    @Generated
    public static List<DisguiseType> getDisabledDisguises() {
        return disabledDisguises;
    }

    @Generated
    public static void setDisabledDisguises(List<DisguiseType> disabledDisguises) {
        DisguiseConfig.disabledDisguises = disabledDisguises;
    }

    @Generated
    public static List<String> getDisabledMethods() {
        return disabledMethods;
    }

    @Generated
    public static void setDisabledMethods(List<String> disabledMethods) {
        DisguiseConfig.disabledMethods = disabledMethods;
    }

    @Generated
    public static boolean isNeverUpdatePacketEvents() {
        return neverUpdatePacketEvents;
    }

    @Generated
    public static void setNeverUpdatePacketEvents(boolean neverUpdatePacketEvents) {
        DisguiseConfig.neverUpdatePacketEvents = neverUpdatePacketEvents;
    }

    @Generated
    public static boolean isRemoveDisguiseBlockPlace() {
        return removeDisguiseBlockPlace;
    }

    @Generated
    public static boolean isRemoveDisguiseBlockBreak() {
        return removeDisguiseBlockBreak;
    }

    @Generated
    public static void setRemoveDisguiseBlockPlace(boolean removeDisguiseBlockPlace) {
        DisguiseConfig.removeDisguiseBlockPlace = removeDisguiseBlockPlace;
    }

    @Generated
    public static void setRemoveDisguiseBlockBreak(boolean removeDisguiseBlockBreak) {
        DisguiseConfig.removeDisguiseBlockBreak = removeDisguiseBlockBreak;
    }

    @Generated
    public static boolean isScaleSelfDisguises() {
        return scaleSelfDisguises;
    }

    @Generated
    public static void setScaleSelfDisguises(boolean scaleSelfDisguises) {
        DisguiseConfig.scaleSelfDisguises = scaleSelfDisguises;
    }

    @Generated
    public static double getScaleSelfDisguisesMin() {
        return scaleSelfDisguisesMin;
    }

    @Generated
    public static void setScaleSelfDisguisesMin(double scaleSelfDisguisesMin) {
        DisguiseConfig.scaleSelfDisguisesMin = scaleSelfDisguisesMin;
    }

    @Generated
    public static double getScaleSelfDisguisesMax() {
        return scaleSelfDisguisesMax;
    }

    @Generated
    public static void setScaleSelfDisguisesMax(double scaleSelfDisguisesMax) {
        DisguiseConfig.scaleSelfDisguisesMax = scaleSelfDisguisesMax;
    }

    @Generated
    public static boolean isUniquePlayerDisguiseUUIDs() {
        return uniquePlayerDisguiseUUIDs;
    }

    @Generated
    public static void setUniquePlayerDisguiseUUIDs(boolean uniquePlayerDisguiseUUIDs) {
        DisguiseConfig.uniquePlayerDisguiseUUIDs = uniquePlayerDisguiseUUIDs;
    }

    @Generated
    public static boolean isHideDeathMessages() {
        return hideDeathMessages;
    }

    @Generated
    public static void setHideDeathMessages(boolean hideDeathMessages) {
        DisguiseConfig.hideDeathMessages = hideDeathMessages;
    }

    static {
        notifyBar = NotifyBar.ACTION_BAR;
        bossBarStyle = BarStyle.SOLID;
        bossBarColor = BarColor.GREEN;
        commandVisibility = PermissionDefault.TRUE;
        usingReleaseBuild = true;
        bisectHosted = true;
        savedServerIp = "";
        playerNameType = PlayerNameType.TEAMS;
        disabledDisguises = new ArrayList<DisguiseType>();
        disabledMethods = new ArrayList<String>();
    }

    public static enum PlayerNameType {
        VANILLA,
        EXTENDED,
        TEAMS,
        ARMORSTANDS;


        public boolean isTeams() {
            return this == TEAMS || this == EXTENDED;
        }

        public boolean isDisplayNameCopy() {
            return this != VANILLA && this != EXTENDED;
        }

        public boolean isScoreboardPacketListenerNeeded() {
            return this == EXTENDED || this == TEAMS;
        }
    }

    public static enum NotifyBar {
        NONE,
        BOSS_BAR,
        ACTION_BAR;

    }

    public static enum UpdatesBranch {
        SAME_BUILDS,
        SNAPSHOTS,
        RELEASES;

    }
}

