/*
 * Decompiled with CFR 0.152.
 */
package me.devnatan.inventoryframework.component;

import java.util.Set;
import me.devnatan.inventoryframework.Ref;
import me.devnatan.inventoryframework.VirtualView;
import me.devnatan.inventoryframework.component.ComponentComposition;
import me.devnatan.inventoryframework.component.InteractionHandler;
import me.devnatan.inventoryframework.context.IFContext;
import me.devnatan.inventoryframework.context.IFSlotRenderContext;
import me.devnatan.inventoryframework.state.State;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnmodifiableView;

public interface Component
extends VirtualView {
    @ApiStatus.Internal
    public String getKey();

    @NotNull
    public VirtualView getRoot();

    public int getPosition();

    public boolean isContainedWithin(int var1);

    public boolean intersects(@NotNull Component var1);

    public InteractionHandler getInteractionHandler();

    public void render(@NotNull IFSlotRenderContext var1);

    public void updated(@NotNull IFSlotRenderContext var1);

    public void clear(@NotNull IFContext var1);

    public @UnmodifiableView Set<State<?>> getWatchingStates();

    public boolean isVisible();

    @ApiStatus.Internal
    public void setVisible(boolean var1);

    @ApiStatus.Internal
    public boolean isManagedExternally();

    public boolean shouldRender(IFContext var1);

    public void update();

    public static boolean intersects(@NotNull Component component, @NotNull Component other) {
        if (component instanceof ComponentComposition) {
            return Component.intersects(other, component);
        }
        if (other instanceof ComponentComposition) {
            for (Component otherChildren : (ComponentComposition)other) {
                if (!otherChildren.intersects(component)) continue;
                return true;
            }
        }
        return other.isContainedWithin(component.getPosition());
    }

    @ApiStatus.Experimental
    public Ref<Component> getReference();

    @ApiStatus.Experimental
    public void forceUpdate();

    @ApiStatus.Experimental
    public void show();

    @ApiStatus.Experimental
    public void hide();
}

