/*
 * Decompiled with CFR 0.152.
 */
package me.devnatan.inventoryframework;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import me.devnatan.inventoryframework.ViewConfigBuilder;
import me.devnatan.inventoryframework.ViewType;
import me.devnatan.inventoryframework.context.IFContext;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@VisibleForTesting
@ApiStatus.NonExtendable
public class ViewConfig {
    public static final Option<Boolean> CANCEL_ON_CLICK = ViewConfig.createOption("cancel-on-click", true);
    public static final Option<Boolean> CANCEL_ON_PICKUP = ViewConfig.createOption("cancel-on-pickup", true);
    public static final Option<Boolean> CANCEL_ON_DROP = ViewConfig.createOption("cancel-on-drop", true);
    public static final Option<Boolean> CANCEL_ON_DRAG = ViewConfig.createOption("cancel-on-drag", true);
    private final Object title;
    private final int size;
    private final ViewType type;
    private final Map<Option<?>, Object> options;
    private final String[] layout;
    private final Set<Modifier> modifiers;
    private final long updateIntervalInTicks;
    private final long interactionDelayInMillis;
    private final boolean transitiveInitialData;

    public ViewConfig(Object title, int size, ViewType type, Map<Option<?>, Object> options, String[] layout, Set<Modifier> modifiers, long updateIntervalInTicks, long interactionDelayInMillis, boolean transitiveInitialData) {
        this.title = title;
        this.size = size;
        this.type = type;
        this.options = options;
        this.layout = layout;
        this.modifiers = modifiers;
        this.updateIntervalInTicks = updateIntervalInTicks;
        this.interactionDelayInMillis = interactionDelayInMillis;
        this.transitiveInitialData = transitiveInitialData;
    }

    public Object getTitle() {
        return this.title;
    }

    public int getSize() {
        return this.size;
    }

    public ViewType getType() {
        return this.type;
    }

    public Map<Option<?>, Object> getOptions() {
        return this.options;
    }

    public String[] getLayout() {
        return this.layout;
    }

    public Set<Modifier> getModifiers() {
        return this.modifiers;
    }

    public long getUpdateIntervalInTicks() {
        return this.updateIntervalInTicks;
    }

    public long getInteractionDelayInMillis() {
        return this.interactionDelayInMillis;
    }

    public boolean isTransitiveInitialData() {
        return this.transitiveInitialData;
    }

    @VisibleForTesting
    public <T> T getOptionValue(@NotNull Option<T> option) {
        for (Map.Entry<Option<?>, Object> entry : this.getOptions().entrySet()) {
            Option<?> other = entry.getKey();
            if (!other.name().equals(option.name())) continue;
            return (T)entry.getValue();
        }
        throw new IllegalArgumentException("Unknown option: " + option);
    }

    @VisibleForTesting
    public <T> boolean isOptionSet(@NotNull Option<T> option) {
        for (Map.Entry<Option<?>, Object> entry : this.getOptions().entrySet()) {
            Option<?> other = entry.getKey();
            Object definedValue = entry.getValue();
            if (!other.name().equals(option.name()) || !Objects.equals(definedValue, other.defaultValue())) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    public <T> boolean isOptionSet(@NotNull Option<T> option, T value) {
        for (Map.Entry<Option<?>, Object> entry : this.getOptions().entrySet()) {
            Option<?> other = entry.getKey();
            Object definedValue = entry.getValue();
            if (!other.name().equals(option.name()) || !Objects.equals(definedValue, value)) continue;
            return true;
        }
        return false;
    }

    public static <T> Option<T> createOption(@NotNull String name, @NotNull T defaultValue) {
        return new OptionImpl<T>(name, defaultValue);
    }

    @ApiStatus.Internal
    @VisibleForTesting
    public ViewConfig merge(ViewConfig other) {
        if (other == null) {
            return this;
        }
        return new ViewConfig(this.merge(other, ViewConfig::getTitle, Objects::nonNull), this.merge(other, ViewConfig::getSize, value -> value != 0), this.merge(other, ViewConfig::getType), this.merge(other, ViewConfig::getOptions, value -> value != null && !value.isEmpty()), this.merge(other, ViewConfig::getLayout), this.merge(other, ViewConfig::getModifiers, value -> value != null && !value.isEmpty()), this.merge(other, ViewConfig::getUpdateIntervalInTicks, value -> value != 0L), this.merge(other, ViewConfig::getInteractionDelayInMillis, value -> value != 0L), this.merge(other, ViewConfig::isTransitiveInitialData));
    }

    private <T> T merge(ViewConfig other, Function<ViewConfig, T> retriever) {
        return (T)this.merge(other, retriever, Objects::nonNull);
    }

    private <T> T merge(ViewConfig other, Function<ViewConfig, T> retriever, Function<T, Boolean> mergeCondition) {
        T value = retriever.apply(other);
        if (!mergeCondition.apply(value).booleanValue()) {
            return retriever.apply(this);
        }
        return value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ViewConfig that = (ViewConfig)o;
        return this.getSize() == that.getSize() && this.getUpdateIntervalInTicks() == that.getUpdateIntervalInTicks() && this.getInteractionDelayInMillis() == that.getInteractionDelayInMillis() && Objects.equals(this.getTitle(), that.getTitle()) && Objects.equals(this.getType(), that.getType()) && Objects.equals(this.getOptions(), that.getOptions()) && Arrays.equals(this.getLayout(), that.getLayout()) && Objects.equals(this.getModifiers(), that.getModifiers()) && this.isTransitiveInitialData() == that.isTransitiveInitialData();
    }

    public int hashCode() {
        int result = Objects.hash(this.getTitle(), this.getSize(), this.getType(), this.getOptions(), this.getModifiers(), this.getUpdateIntervalInTicks(), this.getInteractionDelayInMillis(), this.isTransitiveInitialData());
        result = 31 * result + Arrays.hashCode(this.getLayout());
        return result;
    }

    public String toString() {
        return "ViewConfig{title=" + this.title + ", size=" + this.size + ", type=" + this.type + ", options=" + this.options + ", layout=" + Arrays.toString(this.layout) + ", modifiers=" + this.modifiers + ", updateIntervalInTicks=" + this.updateIntervalInTicks + ", interactionDelayInMillis=" + this.interactionDelayInMillis + ", transitiveInitialData=" + this.transitiveInitialData + "}";
    }

    private static final class OptionImpl<T>
    implements Option<T> {
        private static final List<String> registeredNames = new ArrayList<String>();
        private final String name;
        private final T defaultValue;

        OptionImpl(@NotNull String name, T defaultValue) {
            if (registeredNames.contains(name)) {
                throw new IllegalStateException(String.format("Option %s already registered", name));
            }
            this.name = name;
            this.defaultValue = defaultValue;
        }

        @Override
        @NotNull
        public String name() {
            return this.name;
        }

        @Override
        @Nullable
        public T defaultValue() {
            return this.defaultValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OptionImpl option = (OptionImpl)o;
            return Objects.equals(this.name, option.name) && Objects.equals(this.defaultValue, option.defaultValue);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.defaultValue);
        }

        public String toString() {
            return "OptionImpl{name='" + this.name + '\'' + ", defaultValue=" + this.defaultValue + '}';
        }
    }

    public static interface Option<T> {
        @NotNull
        public String name();

        @Nullable
        public T defaultValue();
    }

    @FunctionalInterface
    public static interface Modifier {
        public void apply(@NotNull ViewConfigBuilder var1, @NotNull IFContext var2);
    }
}

