/**
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at
 * https://javaserverfaces.dev.java.net/CDDL.html or
 * legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permission and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * [Name of File] [ver.__] [Date]
 * 
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */
package javax.faces.component.html;

import java.io.IOException;
import java.util.List;
import java.util.ArrayList;

import javax.faces.context.FacesContext;
import javax.el.MethodExpression;
import javax.el.ValueExpression;


/*
 * ******* GENERATED CODE - DO NOT EDIT *******
 */


/**
 * <p>Represents an HTML <code>form</code> element.  Child input components
 * will be submitted unless they have been disabled.</p>
 * <p>By default, the <code>rendererType</code> property must be set to "<code>javax.faces.Form</code>".
 * This value can be changed by calling the <code>setRendererType()</code> method.</p>
 */
public class HtmlForm extends javax.faces.component.UIForm {



    public HtmlForm() {
        super();
        setRendererType("javax.faces.Form");
    }


    /**
     * <p>The standard component type for this component.</p>
     */
    public static final String COMPONENT_TYPE = "javax.faces.HtmlForm";


    private java.lang.String accept;

    /**
     * <p>Return the value of the <code>accept</code> property.</p>
     * <p>Contents: List of content types that a server processing this form
     * will handle correctly
     */
    public java.lang.String getAccept() {
        if (null != this.accept) {
            return this.accept;
        }
        ValueExpression _ve = getValueExpression("accept");
        if (_ve != null) {
            return (java.lang.String) _ve.getValue(getFacesContext().getELContext());
        } else {
            return null;
        }
    }

    /**
     * <p>Set the value of the <code>accept</code> property.</p>
     */
    public void setAccept(java.lang.String accept) {
        this.accept = accept;
    }


    private java.lang.String acceptcharset;

    /**
     * <p>Return the value of the <code>acceptcharset</code> property.</p>
     * <p>Contents: List of character encodings for input data
     * that are accepted by the server processing
     * this form.
     */
    public java.lang.String getAcceptcharset() {
        if (null != this.acceptcharset) {
            return this.acceptcharset;
        }
        ValueExpression _ve = getValueExpression("acceptcharset");
        if (_ve != null) {
            return (java.lang.String) _ve.getValue(getFacesContext().getELContext());
        } else {
            return null;
        }
    }

    /**
     * <p>Set the value of the <code>acceptcharset</code> property.</p>
     */
    public void setAcceptcharset(java.lang.String acceptcharset) {
        this.acceptcharset = acceptcharset;
    }


    private java.lang.String dir;

    /**
     * <p>Return the value of the <code>dir</code> property.</p>
     * <p>Contents: Direction indication for text that does not inherit directionality.
     * Valid values are "LTR" (left-to-right) and "RTL" (right-to-left).
     */
    public java.lang.String getDir() {
        if (null != this.dir) {
            return this.dir;
        }
        ValueExpression _ve = getValueExpression("dir");
        if (_ve != null) {
            return (java.lang.String) _ve.getValue(getFacesContext().getELContext());
        } else {
            return null;
        }
    }

    /**
     * <p>Set the value of the <code>dir</code> property.</p>
     */
    public void setDir(java.lang.String dir) {
        this.dir = dir;
    }


    private java.lang.String enctype = "application/x-www-form-urlencoded";

    /**
     * <p>Return the value of the <code>enctype</code> property.</p>
     * <p>Contents: Content type used to submit the form to the server.  If not
     * specified, the default value is
     * "application/x-www-form-urlencoded".
     */
    public java.lang.String getEnctype() {
        if (null != this.enctype) {
            return this.enctype;
        }
        ValueExpression _ve = getValueExpression("enctype");
        if (_ve != null) {
            return (java.lang.String) _ve.getValue(getFacesContext().getELContext());
        } else {
            return null;
        }
    }

    /**
     * <p>Set the value of the <code>enctype</code> property.</p>
     */
    public void setEnctype(java.lang.String enctype) {
        this.enctype = enctype;
    }


    private java.lang.String lang;

    /**
     * <p>Return the value of the <code>lang</code> property.</p>
     * <p>Contents: Code describing the language used in the generated markup
     * for this component.
     */
    public java.lang.String getLang() {
        if (null != this.lang) {
            return this.lang;
        }
        ValueExpression _ve = getValueExpression("lang");
        if (_ve != null) {
            return (java.lang.String) _ve.getValue(getFacesContext().getELContext());
        } else {
            return null;
        }
    }

    /**
     * <p>Set the value of the <code>lang</code> property.</p>
     */
    public void setLang(java.lang.String lang) {
        this.lang = lang;
    }


    private java.lang.String onclick;

    /**
     * <p>Return the value of the <code>onclick</code> property.</p>
     * <p>Contents: Javascript code executed when a pointer button is
     * clicked over this element.
     */
    public java.lang.String getOnclick() {
        if (null != this.onclick) {
            return this.onclick;
        }
        ValueExpression _ve = getValueExpression("onclick");
        if (_ve != null) {
            return (java.lang.String) _ve.getValue(getFacesContext().getELContext());
        } else {
            return null;
        }
    }

    /**
     * <p>Set the value of the <code>onclick</code> property.</p>
     */
    public void setOnclick(java.lang.String onclick) {
        this.onclick = onclick;
    }


    private java.lang.String ondblclick;

    /**
     * <p>Return the value of the <code>ondblclick</code> property.</p>
     * <p>Contents: Javascript code executed when a pointer button is
     * double clicked over this element.
     */
    public java.lang.String getOndblclick() {
        if (null != this.ondblclick) {
            return this.ondblclick;
        }
        ValueExpression _ve = getValueExpression("ondblclick");
        if (_ve != null) {
            return (java.lang.String) _ve.getValue(getFacesContext().getELContext());
        } else {
            return null;
        }
    }

    /**
     * <p>Set the value of the <code>ondblclick</code> property.</p>
     */
    public void setOndblclick(java.lang.String ondblclick) {
        this.ondblclick = ondblclick;
    }


    private java.lang.String onkeydown;

    /**
     * <p>Return the value of the <code>onkeydown</code> property.</p>
     * <p>Contents: Javascript code executed when a key is
     * pressed down over this element.
     */
    public java.lang.String getOnkeydown() {
        if (null != this.onkeydown) {
            return this.onkeydown;
        }
        ValueExpression _ve = getValueExpression("onkeydown");
        if (_ve != null) {
            return (java.lang.String) _ve.getValue(getFacesContext().getELContext());
        } else {
            return null;
        }
    }

    /**
     * <p>Set the value of the <code>onkeydown</code> property.</p>
     */
    public void setOnkeydown(java.lang.String onkeydown) {
        this.onkeydown = onkeydown;
    }


    private java.lang.String onkeypress;

    /**
     * <p>Return the value of the <code>onkeypress</code> property.</p>
     * <p>Contents: Javascript code executed when a key is
     * pressed and released over this element.
     */
    public java.lang.String getOnkeypress() {
        if (null != this.onkeypress) {
            return this.onkeypress;
        }
        ValueExpression _ve = getValueExpression("onkeypress");
        if (_ve != null) {
            return (java.lang.String) _ve.getValue(getFacesContext().getELContext());
        } else {
            return null;
        }
    }

    /**
     * <p>Set the value of the <code>onkeypress</code> property.</p>
     */
    public void setOnkeypress(java.lang.String onkeypress) {
        this.onkeypress = onkeypress;
    }


    private java.lang.String onkeyup;

    /**
     * <p>Return the value of the <code>onkeyup</code> property.</p>
     * <p>Contents: Javascript code executed when a key is
     * released over this element.
     */
    public java.lang.String getOnkeyup() {
        if (null != this.onkeyup) {
            return this.onkeyup;
        }
        ValueExpression _ve = getValueExpression("onkeyup");
        if (_ve != null) {
            return (java.lang.String) _ve.getValue(getFacesContext().getELContext());
        } else {
            return null;
        }
    }

    /**
     * <p>Set the value of the <code>onkeyup</code> property.</p>
     */
    public void setOnkeyup(java.lang.String onkeyup) {
        this.onkeyup = onkeyup;
    }


    private java.lang.String onmousedown;

    /**
     * <p>Return the value of the <code>onmousedown</code> property.</p>
     * <p>Contents: Javascript code executed when a pointer button is
     * pressed down over this element.
     */
    public java.lang.String getOnmousedown() {
        if (null != this.onmousedown) {
            return this.onmousedown;
        }
        ValueExpression _ve = getValueExpression("onmousedown");
        if (_ve != null) {
            return (java.lang.String) _ve.getValue(getFacesContext().getELContext());
        } else {
            return null;
        }
    }

    /**
     * <p>Set the value of the <code>onmousedown</code> property.</p>
     */
    public void setOnmousedown(java.lang.String onmousedown) {
        this.onmousedown = onmousedown;
    }


    private java.lang.String onmousemove;

    /**
     * <p>Return the value of the <code>onmousemove</code> property.</p>
     * <p>Contents: Javascript code executed when a pointer button is
     * moved within this element.
     */
    public java.lang.String getOnmousemove() {
        if (null != this.onmousemove) {
            return this.onmousemove;
        }
        ValueExpression _ve = getValueExpression("onmousemove");
        if (_ve != null) {
            return (java.lang.String) _ve.getValue(getFacesContext().getELContext());
        } else {
            return null;
        }
    }

    /**
     * <p>Set the value of the <code>onmousemove</code> property.</p>
     */
    public void setOnmousemove(java.lang.String onmousemove) {
        this.onmousemove = onmousemove;
    }


    private java.lang.String onmouseout;

    /**
     * <p>Return the value of the <code>onmouseout</code> property.</p>
     * <p>Contents: Javascript code executed when a pointer button is
     * moved away from this element.
     */
    public java.lang.String getOnmouseout() {
        if (null != this.onmouseout) {
            return this.onmouseout;
        }
        ValueExpression _ve = getValueExpression("onmouseout");
        if (_ve != null) {
            return (java.lang.String) _ve.getValue(getFacesContext().getELContext());
        } else {
            return null;
        }
    }

    /**
     * <p>Set the value of the <code>onmouseout</code> property.</p>
     */
    public void setOnmouseout(java.lang.String onmouseout) {
        this.onmouseout = onmouseout;
    }


    private java.lang.String onmouseover;

    /**
     * <p>Return the value of the <code>onmouseover</code> property.</p>
     * <p>Contents: Javascript code executed when a pointer button is
     * moved onto this element.
     */
    public java.lang.String getOnmouseover() {
        if (null != this.onmouseover) {
            return this.onmouseover;
        }
        ValueExpression _ve = getValueExpression("onmouseover");
        if (_ve != null) {
            return (java.lang.String) _ve.getValue(getFacesContext().getELContext());
        } else {
            return null;
        }
    }

    /**
     * <p>Set the value of the <code>onmouseover</code> property.</p>
     */
    public void setOnmouseover(java.lang.String onmouseover) {
        this.onmouseover = onmouseover;
    }


    private java.lang.String onmouseup;

    /**
     * <p>Return the value of the <code>onmouseup</code> property.</p>
     * <p>Contents: Javascript code executed when a pointer button is
     * released over this element.
     */
    public java.lang.String getOnmouseup() {
        if (null != this.onmouseup) {
            return this.onmouseup;
        }
        ValueExpression _ve = getValueExpression("onmouseup");
        if (_ve != null) {
            return (java.lang.String) _ve.getValue(getFacesContext().getELContext());
        } else {
            return null;
        }
    }

    /**
     * <p>Set the value of the <code>onmouseup</code> property.</p>
     */
    public void setOnmouseup(java.lang.String onmouseup) {
        this.onmouseup = onmouseup;
    }


    private java.lang.String onreset;

    /**
     * <p>Return the value of the <code>onreset</code> property.</p>
     * <p>Contents: Javascript code executed when this form is reset.
     */
    public java.lang.String getOnreset() {
        if (null != this.onreset) {
            return this.onreset;
        }
        ValueExpression _ve = getValueExpression("onreset");
        if (_ve != null) {
            return (java.lang.String) _ve.getValue(getFacesContext().getELContext());
        } else {
            return null;
        }
    }

    /**
     * <p>Set the value of the <code>onreset</code> property.</p>
     */
    public void setOnreset(java.lang.String onreset) {
        this.onreset = onreset;
    }


    private java.lang.String onsubmit;

    /**
     * <p>Return the value of the <code>onsubmit</code> property.</p>
     * <p>Contents: Javascript code executed when this form is submitted.
     */
    public java.lang.String getOnsubmit() {
        if (null != this.onsubmit) {
            return this.onsubmit;
        }
        ValueExpression _ve = getValueExpression("onsubmit");
        if (_ve != null) {
            return (java.lang.String) _ve.getValue(getFacesContext().getELContext());
        } else {
            return null;
        }
    }

    /**
     * <p>Set the value of the <code>onsubmit</code> property.</p>
     */
    public void setOnsubmit(java.lang.String onsubmit) {
        this.onsubmit = onsubmit;
    }


    private java.lang.String style;

    /**
     * <p>Return the value of the <code>style</code> property.</p>
     * <p>Contents: CSS style(s) to be applied when this component is rendered.
     */
    public java.lang.String getStyle() {
        if (null != this.style) {
            return this.style;
        }
        ValueExpression _ve = getValueExpression("style");
        if (_ve != null) {
            return (java.lang.String) _ve.getValue(getFacesContext().getELContext());
        } else {
            return null;
        }
    }

    /**
     * <p>Set the value of the <code>style</code> property.</p>
     */
    public void setStyle(java.lang.String style) {
        this.style = style;
    }


    private java.lang.String styleClass;

    /**
     * <p>Return the value of the <code>styleClass</code> property.</p>
     * <p>Contents: Space-separated list of CSS style class(es) to be applied when
     * this element is rendered.  This value must be passed through
     * as the "class" attribute on generated markup.
     */
    public java.lang.String getStyleClass() {
        if (null != this.styleClass) {
            return this.styleClass;
        }
        ValueExpression _ve = getValueExpression("styleClass");
        if (_ve != null) {
            return (java.lang.String) _ve.getValue(getFacesContext().getELContext());
        } else {
            return null;
        }
    }

    /**
     * <p>Set the value of the <code>styleClass</code> property.</p>
     */
    public void setStyleClass(java.lang.String styleClass) {
        this.styleClass = styleClass;
    }


    private java.lang.String target;

    /**
     * <p>Return the value of the <code>target</code> property.</p>
     * <p>Contents: Name of a frame where the response
     * retrieved after this form submit is to
     * be displayed.
     */
    public java.lang.String getTarget() {
        if (null != this.target) {
            return this.target;
        }
        ValueExpression _ve = getValueExpression("target");
        if (_ve != null) {
            return (java.lang.String) _ve.getValue(getFacesContext().getELContext());
        } else {
            return null;
        }
    }

    /**
     * <p>Set the value of the <code>target</code> property.</p>
     */
    public void setTarget(java.lang.String target) {
        this.target = target;
    }


    private java.lang.String title;

    /**
     * <p>Return the value of the <code>title</code> property.</p>
     * <p>Contents: Advisory title information about markup elements generated
     * for this component.
     */
    public java.lang.String getTitle() {
        if (null != this.title) {
            return this.title;
        }
        ValueExpression _ve = getValueExpression("title");
        if (_ve != null) {
            return (java.lang.String) _ve.getValue(getFacesContext().getELContext());
        } else {
            return null;
        }
    }

    /**
     * <p>Set the value of the <code>title</code> property.</p>
     */
    public void setTitle(java.lang.String title) {
        this.title = title;
    }


    private Object[] _values;

    public Object saveState(FacesContext _context) {
        if (_values == null) {
            _values = new Object[22];
        }
        _values[0] = super.saveState(_context);
        _values[1] = accept;
        _values[2] = acceptcharset;
        _values[3] = dir;
        _values[4] = enctype;
        _values[5] = lang;
        _values[6] = onclick;
        _values[7] = ondblclick;
        _values[8] = onkeydown;
        _values[9] = onkeypress;
        _values[10] = onkeyup;
        _values[11] = onmousedown;
        _values[12] = onmousemove;
        _values[13] = onmouseout;
        _values[14] = onmouseover;
        _values[15] = onmouseup;
        _values[16] = onreset;
        _values[17] = onsubmit;
        _values[18] = style;
        _values[19] = styleClass;
        _values[20] = target;
        _values[21] = title;
        return _values;
}


    public void restoreState(FacesContext _context, Object _state) {
        _values = (Object[]) _state;
        super.restoreState(_context, _values[0]);
        this.accept = (java.lang.String) _values[1];
        this.acceptcharset = (java.lang.String) _values[2];
        this.dir = (java.lang.String) _values[3];
        this.enctype = (java.lang.String) _values[4];
        this.lang = (java.lang.String) _values[5];
        this.onclick = (java.lang.String) _values[6];
        this.ondblclick = (java.lang.String) _values[7];
        this.onkeydown = (java.lang.String) _values[8];
        this.onkeypress = (java.lang.String) _values[9];
        this.onkeyup = (java.lang.String) _values[10];
        this.onmousedown = (java.lang.String) _values[11];
        this.onmousemove = (java.lang.String) _values[12];
        this.onmouseout = (java.lang.String) _values[13];
        this.onmouseover = (java.lang.String) _values[14];
        this.onmouseup = (java.lang.String) _values[15];
        this.onreset = (java.lang.String) _values[16];
        this.onsubmit = (java.lang.String) _values[17];
        this.style = (java.lang.String) _values[18];
        this.styleClass = (java.lang.String) _values[19];
        this.target = (java.lang.String) _values[20];
        this.title = (java.lang.String) _values[21];
    }


}
