/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.test;

import it.unimi.dsi.lang.MutableString;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class MutableStringReplaceSpeedTest {
    private MutableStringReplaceSpeedTest() {
    }

    public static void main(String[] arg) throws IOException {
        String line;
        String target = null;
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        MutableString ms = new MutableString();
        while ((line = br.readLine()) != null) {
            ms.append("\n").append(line);
        }
        target = ms.toString();
        String searchString = arg[0];
        if (searchString.length() != 1) {
            throw new IllegalArgumentException();
        }
        char searchChar = new MutableString(arg[0]).charAt(0);
        String replaceString = arg[1];
        MutableString replace = new MutableString(replaceString);
        int n = Integer.parseInt(arg[2]);
        int k = 10;
        while (k-- != 0) {
            System.out.println();
            MutableString s = new MutableString(target).compact();
            long start = -System.nanoTime();
            int i = n;
            while (i-- != 0) {
                s.replace(searchChar, replace);
            }
            System.out.println("Called replace() " + n + " times on a compact string in " + (start += System.nanoTime()) + " ns (" + (double)start / (double)n + " ns/call)");
            s = new MutableString(target).loose();
            start = -System.nanoTime();
            i = n;
            while (i-- != 0) {
                s.replace(searchChar, replace);
            }
            System.out.println("Called replace() " + n + " times on a loose string in " + (start += System.nanoTime()) + " ns (" + (double)start / (double)n + " ns/call)");
            StringBuilder sb = new StringBuilder(target);
            start = -System.nanoTime();
            int i2 = n;
            while (i2-- != 0) {
                int j = sb.length();
                while ((j = sb.lastIndexOf(searchString, j)) != -1) {
                    sb.replace(j, j + 1, replaceString);
                    --j;
                }
            }
            System.out.println("Called replace() " + n + " times on a string builder in " + (start += System.nanoTime()) + " ns (" + (double)start / (double)n + " ns/call)");
            assert (sb.length() == s.length());
            assert (s.toString().equals(sb.toString()));
            String st = new String(target);
            start = -System.nanoTime();
            i2 = n;
            while (i2-- != 0) {
                st = st.replaceAll(searchString, replaceString);
            }
            System.out.println("Called replaceAll() " + n + " times on a string in " + (start += System.nanoTime()) + " ns (" + (double)start / (double)n + " ns/call)");
            assert (sb.length() == st.length());
            assert (st.equals(sb.toString()));
        }
    }
}

