/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.stat;

import it.unimi.dsi.Util;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.util.SplitMix64Random;
import java.util.Random;

public class Ziggurat {
    private final Random random;
    private static double[] x;
    private static double[] x53;
    private static double[] y;
    private static double[] h;
    private static double[] h53;
    private static long[] threshold;

    public Ziggurat() {
        this.random = new SplitMix64Random();
    }

    public Ziggurat(Random random) {
        this.random = random;
    }

    public double nextDouble() {
        double candidate;
        int block;
        do {
            long r;
            long discreteCandidate;
            if ((discreteCandidate = (r = this.random.nextLong()) >>> 11) < threshold[block = (int)(r & 0xFFL)]) {
                return (double)discreteCandidate * x53[block];
            }
            if (block == 0) {
                return x[1] - Math.log(this.random.nextDouble());
            }
            candidate = (double)discreteCandidate * x53[block];
        } while (!(y[block] + (double)(this.random.nextLong() >>> 11) * h53[block] < Math.exp(-candidate)));
        return candidate;
    }

    public static void main(String[] arg) {
        Ziggurat ziggurat = new Ziggurat(new SplitMix64Random());
        long time = -System.currentTimeMillis();
        int n = Integer.parseInt(arg[0]);
        double sum = 0.0;
        int numExp = 100;
        int exponentBits = 6;
        int maxExponent = 2;
        int minExponent = -61;
        int t = numExp;
        while (t-- != 0) {
            int x = Integer.MAX_VALUE;
            int k = n;
            while (k-- != 0) {
                x = Math.min(x, Math.max(Math.min(2, Fast.approximateLog2(ziggurat.nextDouble())), -61));
            }
            sum += Fast.pow2(x);
        }
        System.err.println(1000000.0 * (double)(time + System.currentTimeMillis()) / (double)(n * numExp) + " ns/gen");
        System.out.println((double)numExp / sum + " (" + Util.format(100.0 * ((double)numExp / sum - (double)n) / (double)n) + "%)");
    }

    static {
        int i;
        x = new double[257];
        x53 = new double[257];
        y = new double[257];
        h = new double[257];
        h53 = new double[257];
        threshold = new long[257];
        double area = 0.003949659822581572;
        Ziggurat.x[0] = 8.697117470134886;
        Ziggurat.y[0] = 0.0;
        Ziggurat.h[0] = 0.003949659822581572 / x[0];
        for (i = 1; i < 256; ++i) {
            Ziggurat.y[i] = y[i - 1] + h[i - 1];
            Ziggurat.x[i] = -Math.log(y[i]);
            Ziggurat.h[i] = 0.003949659822581572 / x[i];
        }
        for (i = 1; i < 256; ++i) {
            Ziggurat.threshold[i] = Math.round(9.007199254740992E15 * x[i + 1] / x[i]);
        }
        for (i = 0; i < 256; ++i) {
            Ziggurat.x53[i] = x[i] / 9.007199254740992E15;
            Ziggurat.h53[i] = h[i] / 9.007199254740992E15;
        }
        Ziggurat.y[256] = 1.0;
    }
}

