/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.bits;

import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.BitVectors;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.fastutil.BigList;
import it.unimi.dsi.fastutil.Size64;
import it.unimi.dsi.fastutil.booleans.AbstractBooleanBigList;
import it.unimi.dsi.fastutil.longs.AbstractLongBigList;
import it.unimi.dsi.fastutil.longs.AbstractLongSortedSet;
import it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import it.unimi.dsi.fastutil.longs.LongBigList;
import it.unimi.dsi.fastutil.longs.LongBigListIterator;
import it.unimi.dsi.fastutil.longs.LongComparator;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSortedSet;
import java.io.Serializable;
import java.util.NoSuchElementException;

public abstract class AbstractBitVector
extends AbstractBooleanBigList
implements BitVector {
    protected void ensureRestrictedIndex(long index) {
        if (index < 0L) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is negative");
        }
        if (index >= this.length()) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to length (" + this.length() + ")");
        }
    }

    protected void ensureIndex(long index) {
        if (index < 0L) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is negative");
        }
        if (index > this.length()) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than length (" + this.length() + ")");
        }
    }

    public void set(int index) {
        this.set(index, true);
    }

    public void clear(int index) {
        this.set(index, false);
    }

    public void flip(int index) {
        this.set(index, !this.getBoolean(index));
    }

    @Override
    public void set(long index) {
        this.set(index, true);
    }

    @Override
    public void clear(long index) {
        this.set(index, false);
    }

    @Override
    public void flip(long index) {
        this.set(index, !this.getBoolean(index));
    }

    @Override
    public void fill(boolean value) {
        long i = this.length();
        while (i-- != 0L) {
            this.set(i, value);
        }
    }

    @Override
    public void fill(int value) {
        this.fill(value != 0);
    }

    @Override
    public void flip() {
        long i = this.length();
        while (i-- != 0L) {
            this.flip(i);
        }
    }

    @Override
    public void fill(long from, long to, boolean value) {
        BitVectors.ensureFromTo(this.length(), from, to);
        long i = to;
        while (i-- != from) {
            this.set(i, value);
        }
    }

    @Override
    public void fill(long from, long to, int value) {
        this.fill(from, to, value != 0);
    }

    @Override
    public void flip(long from, long to) {
        BitVectors.ensureFromTo(this.length(), from, to);
        long i = to;
        while (i-- != from) {
            this.flip(i);
        }
    }

    @Override
    public int getInt(long index) {
        return this.getBoolean(index) ? 1 : 0;
    }

    @Override
    public long getLong(long from, long to) {
        if (to - from > 64L) {
            throw new IllegalArgumentException("Range too large for a long: [" + from + ".." + to + ")");
        }
        long result = 0L;
        for (long i = from; i < to; ++i) {
            if (!this.getBoolean(i)) continue;
            result |= 1L << (int)(i - from);
        }
        return result;
    }

    public boolean getBoolean(int index) {
        return this.getBoolean(index);
    }

    public boolean removeBoolean(int index) {
        return this.removeBoolean((long)index);
    }

    public boolean set(int index, boolean value) {
        return this.set((long)index, value);
    }

    public void add(int index, boolean value) {
        this.add((long)index, value);
    }

    public boolean removeBoolean(long index) {
        throw new UnsupportedOperationException();
    }

    public boolean set(long index, boolean value) {
        throw new UnsupportedOperationException();
    }

    public void add(long index, boolean value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(long index, int value) {
        this.set(index, value != 0);
    }

    @Override
    public void add(long index, int value) {
        this.add(index, value != 0);
    }

    public boolean add(boolean value) {
        this.add(this.length(), value);
        return true;
    }

    @Override
    public void add(int value) {
        this.add(value != 0);
    }

    @Override
    public BitVector append(long value, int k) {
        for (int i = 0; i < k; ++i) {
            this.add((value & 1L << i) != 0L);
        }
        return this;
    }

    @Override
    public BitVector append(BitVector bv) {
        long i;
        long length = bv.length();
        long l = length & 0xFFFFFFFFFFFFFFC0L;
        for (i = 0L; i < l; i += 64L) {
            this.append(bv.getLong(i, i + 64L), 64);
        }
        if (i < length) {
            this.append(bv.getLong(i, length), (int)(length - i));
        }
        return this;
    }

    @Override
    public BitVector copy() {
        return this.copy(0L, this.length());
    }

    @Override
    public BitVector copy(long from, long to) {
        long i;
        BitVectors.ensureFromTo(this.length(), from, to);
        long length = to - from;
        long l = length & 0xFFFFFFFFFFFFFFC0L;
        long[] bits = new long[LongArrayBitVector.words(length)];
        for (i = 0L; i < l; i += 64L) {
            bits[LongArrayBitVector.word((long)i)] = this.getLong(from + i, from + i + 64L);
        }
        if (i < length) {
            bits[LongArrayBitVector.word((long)i)] = this.getLong(from + i, to);
        }
        return LongArrayBitVector.wrap(bits, length);
    }

    @Override
    public BitVector fast() {
        return this.copy();
    }

    @Override
    public long count() {
        long c = 0L;
        long i = this.length();
        while (i-- != 0L) {
            c += (long)this.getInt(i);
        }
        return c;
    }

    @Override
    public long firstOne() {
        return this.nextOne(0L);
    }

    @Override
    public long lastOne() {
        return this.previousOne(this.length());
    }

    @Override
    public long firstZero() {
        return this.nextZero(0L);
    }

    @Override
    public long lastZero() {
        return this.previousZero(this.length());
    }

    @Override
    public long nextOne(long index) {
        long length = this.length();
        for (long i = index; i < length; ++i) {
            if (!this.getBoolean(i)) continue;
            return i;
        }
        return -1L;
    }

    @Override
    public long previousOne(long index) {
        long i = index;
        while (i-- != 0L) {
            if (!this.getBoolean(i)) continue;
            return i;
        }
        return -1L;
    }

    @Override
    public long nextZero(long index) {
        long length = this.length();
        for (long i = index; i < length; ++i) {
            if (this.getBoolean(i)) continue;
            return i;
        }
        return -1L;
    }

    @Override
    public long previousZero(long index) {
        long i = index;
        while (i-- != 0L) {
            if (this.getBoolean(i)) continue;
            return i;
        }
        return -1L;
    }

    @Override
    public long longestCommonPrefixLength(BitVector v) {
        long w1;
        long w0;
        long i;
        long minLength = Math.min(this.length(), v.length());
        long l = minLength & 0xFFFFFFFFFFFFFFC0L;
        for (i = 0L; i < l; i += 64L) {
            w0 = this.getLong(i, i + 64L);
            if (w0 == (w1 = v.getLong(i, i + 64L))) continue;
            return i + (long)Long.numberOfTrailingZeros(w0 ^ w1);
        }
        w0 = this.getLong(i, minLength);
        if (w0 != (w1 = v.getLong(i, minLength))) {
            return i + (long)Long.numberOfTrailingZeros(w0 ^ w1);
        }
        return minLength;
    }

    @Override
    public boolean isPrefix(BitVector v) {
        return this.longestCommonPrefixLength(v) == this.length();
    }

    @Override
    public boolean isProperPrefix(BitVector v) {
        return this.isPrefix(v) && this.length() < v.length();
    }

    @Override
    public BitVector and(BitVector v) {
        long i = Math.min(this.length(), v.length());
        while (i-- != 0L) {
            if (v.getBoolean(i)) continue;
            this.clear(i);
        }
        return this;
    }

    @Override
    public BitVector or(BitVector v) {
        long i = Math.min(this.length(), v.length());
        while (i-- != 0L) {
            if (!v.getBoolean(i)) continue;
            this.set(i);
        }
        return this;
    }

    @Override
    public BitVector xor(BitVector v) {
        long i = Math.min(this.length(), v.length());
        while (i-- != 0L) {
            if (!v.getBoolean(i)) continue;
            this.flip(i);
        }
        return this;
    }

    @Override
    @Deprecated
    public int size() {
        long length = this.length();
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("The number of bits of this bit vector (" + length + ") exceeds Integer.MAX_INT");
        }
        return (int)length;
    }

    public long size64() {
        return this.length();
    }

    public void clear() {
        this.length(0L);
    }

    @Override
    public BitVector replace(BitVector bv) {
        this.clear();
        long fullBits = bv.length() & 0xFFFFFFFFFFFFFFC0L;
        for (long i = 0L; i < fullBits; i += 64L) {
            this.append(bv.getLong(i, i + 64L), 64);
        }
        if (!LongArrayBitVector.round(bv.length())) {
            this.append(bv.getLong(fullBits, bv.length()), (int)(bv.length() - fullBits));
        }
        return this;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BitVector)) {
            return false;
        }
        BitVector v = (BitVector)o;
        long length = this.length();
        if (length != v.length()) {
            return false;
        }
        long fullLength = length & 0xFFFFFFFFFFFFFFC0L;
        for (long i = 0L; i < fullLength; i += 64L) {
            if (this.getLong(i, i + 64L) == v.getLong(i, i + 64L)) continue;
            return false;
        }
        return this.getLong(fullLength, length) == v.getLong(fullLength, length);
    }

    @Override
    public boolean equals(BitVector v, long start, long end) {
        long startFull = start & 0xFFFFFFFFFFFFFFC0L;
        long endFull = end & 0xFFFFFFFFFFFFFFC0L;
        int startBit = LongArrayBitVector.bit(start);
        int endBit = LongArrayBitVector.bit(end);
        if (startFull == endFull) {
            return ((this.getLong(startFull, Math.min(this.length(), startFull + 64L)) ^ v.getLong(startFull, Math.min(v.length(), startFull + 64L))) & (1L << endBit - startBit) - 1L << startBit) == 0L;
        }
        if (((this.getLong(startFull, startFull + 64L) ^ v.getLong(startFull, startFull += 64L)) & -1L << startBit) != 0L) {
            return false;
        }
        while (startFull < endFull) {
            if (this.getLong(startFull, startFull + 64L) == v.getLong(startFull, startFull += 64L)) continue;
            return false;
        }
        return ((this.getLong(startFull, Math.min(this.length(), startFull + 64L)) ^ v.getLong(startFull, Math.min(v.length(), startFull + 64L))) & (1L << endBit) - 1L) == 0L;
    }

    @Override
    public int hashCode() {
        long length = this.length();
        long fullLength = length & 0xFFFFFFFFFFFFFFC0L;
        long h = 0x9E3779B97F4A7C13L ^ length;
        for (long i = 0L; i < fullLength; i += 64L) {
            h ^= (h << 5) + this.getLong(i, i + 64L) + (h >>> 2);
        }
        if (length != fullLength) {
            h ^= (h << 5) + this.getLong(fullLength, length) + (h >>> 2);
        }
        return (int)(h >>> 32 ^ h);
    }

    @Override
    public long[] bits() {
        long[] bits = new long[LongArrayBitVector.words(this.length())];
        long length = this.length();
        for (long i = 0L; i < length; ++i) {
            if (!this.getBoolean(i)) continue;
            int n = LongArrayBitVector.word(i);
            bits[n] = bits[n] | 1L << (int)i;
        }
        return bits;
    }

    @Override
    public BitVector length(long newLength) {
        long length = this.length();
        if (length < newLength) {
            long i = newLength - length;
            while (i-- != 0L) {
                this.add(false);
            }
        } else {
            long i = length;
            while (i-- != newLength) {
                this.removeBoolean(i);
            }
        }
        return this;
    }

    public void size(long newSize) {
        this.length(newSize);
    }

    @Override
    public LongSortedSet asLongSet() {
        return new LongSetView(this, 0L, Long.MAX_VALUE);
    }

    @Override
    public LongBigList asLongBigList(int width) {
        return new LongBigListView(this, width);
    }

    @Override
    public BitVector subVector(long from, long to) {
        return new SubBitVector(this, from, to);
    }

    @Override
    public BitVector subVector(long from) {
        return this.subVector(from, this.length());
    }

    public int compareTo(BigList<? extends Boolean> list) {
        if (list instanceof BitVector) {
            return this.compareTo((BitVector)list);
        }
        return super.compareTo(list);
    }

    public int compareTo(BitVector v) {
        long xor;
        long w1;
        long w0;
        long i;
        long minLength = Math.min(this.length(), v.length());
        long l = minLength & 0xFFFFFFFFFFFFFFC0L;
        for (i = 0L; i < l; i += 64L) {
            w0 = this.getLong(i, i + 64L);
            xor = w0 ^ (w1 = v.getLong(i, i + 64L));
            if (xor == 0L) continue;
            return (xor & -xor & w0) == 0L ? -1 : 1;
        }
        w0 = this.getLong(i, minLength);
        xor = w0 ^ (w1 = v.getLong(i, minLength));
        if (xor != 0L) {
            return (xor & -xor & w0) == 0L ? -1 : 1;
        }
        return Long.signum(this.length() - v.length());
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        long size = this.size64();
        for (long i = 0L; i < size; ++i) {
            s.append(this.getInt(i));
        }
        return s.toString();
    }

    public static class LongSetView
    extends AbstractLongSortedSet
    implements LongSet,
    Serializable,
    Size64 {
        protected final BitVector bitVector;
        private static final long serialVersionUID = 1L;
        private final long from;
        private final long to;

        public LongSetView(BitVector bitVector, long from, long to) {
            if (from > to) {
                throw new IllegalArgumentException("Start index (" + from + ") is greater than end index (" + to + ")");
            }
            this.bitVector = bitVector;
            this.from = from;
            this.to = to;
        }

        public boolean contains(long index) {
            if (index < 0L) {
                throw new IllegalArgumentException("The provided index (" + index + ") is negative");
            }
            if (index < this.from || index >= this.to) {
                return false;
            }
            return index < this.bitVector.length() && this.bitVector.getBoolean(index);
        }

        public boolean add(long index) {
            if (index < 0L) {
                throw new IllegalArgumentException("The provided index (" + index + ") is negative");
            }
            if (index < this.from || index >= this.to) {
                return false;
            }
            long length = this.bitVector.length();
            if (index >= length) {
                this.bitVector.length(index + 1L);
            }
            boolean oldValue = this.bitVector.getBoolean(index);
            this.bitVector.set(index);
            return !oldValue;
        }

        public boolean remove(long index) {
            long length = this.bitVector.length();
            if (index >= length) {
                return false;
            }
            boolean oldValue = this.bitVector.getBoolean(index);
            this.bitVector.clear(index);
            return oldValue;
        }

        public void clear() {
            this.bitVector.clear();
        }

        public long size64() {
            return this.bitVector.count();
        }

        @Deprecated
        public int size() {
            long size = this.bitVector.subVector(this.from, Math.min(this.to, this.bitVector.length())).count();
            if (size > Integer.MAX_VALUE) {
                throw new IllegalStateException("Set is too large to return an integer size");
            }
            return (int)size;
        }

        public LongBidirectionalIterator iterator() {
            return this.iterator(0L);
        }

        public LongBidirectionalIterator iterator(long from) {
            return new LongSetViewIterator(from);
        }

        public long firstLong() {
            return this.bitVector.nextOne(this.from);
        }

        public long lastLong() {
            return this.bitVector.previousOne(Math.min(this.bitVector.length(), this.to));
        }

        public LongComparator comparator() {
            return null;
        }

        public LongSortedSet headSet(long to) {
            return to < this.to ? new LongSetView(this.bitVector, this.from, to) : this;
        }

        public LongSortedSet tailSet(long from) {
            return from > this.from ? new LongSetView(this.bitVector, from, this.to) : this;
        }

        public LongSortedSet subSet(long from, long to) {
            to = to < this.to ? to : this.to;
            long l = from = from > this.from ? from : this.from;
            if (from == this.from && to == this.to) {
                return this;
            }
            return new LongSetView(this.bitVector, from, to);
        }

        private final class LongSetViewIterator
        implements LongBidirectionalIterator {
            long pos;
            long last = -1L;
            long nextPos = -1L;
            long prevPos = -1L;

            private LongSetViewIterator(long from) {
                this.pos = from;
            }

            public boolean hasNext() {
                if (this.nextPos == -1L && this.pos < LongSetView.this.bitVector.length()) {
                    this.nextPos = LongSetView.this.bitVector.nextOne(this.pos);
                }
                return this.nextPos != -1L;
            }

            public boolean hasPrevious() {
                if (this.prevPos == -1L && this.pos > 0L) {
                    this.prevPos = LongSetView.this.bitVector.previousOne(this.pos);
                }
                return this.prevPos != -1L;
            }

            public long nextLong() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.nextPos;
                this.pos = this.nextPos + 1L;
                this.nextPos = -1L;
                return this.last;
            }

            public long previousLong() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.pos = this.prevPos;
                this.prevPos = -1L;
                this.last = this.pos;
                return this.last;
            }

            public void remove() {
                if (this.last == -1L) {
                    throw new IllegalStateException();
                }
                LongSetView.this.bitVector.clear(this.last);
            }
        }
    }

    public static class LongBigListView
    extends AbstractLongBigList
    implements LongBigList,
    Serializable {
        private static final long serialVersionUID = 1L;
        protected final BitVector bitVector;
        protected final int width;
        protected final long fullMask;

        public LongBigListView(BitVector bitVector, int width) {
            this.width = width;
            this.bitVector = bitVector;
            this.fullMask = width == 64 ? -1L : (1L << width) - 1L;
        }

        @Deprecated
        public int size() {
            long length = this.length();
            if (length > Integer.MAX_VALUE) {
                throw new IllegalStateException("The number of elements of this bit list (" + length + ") exceeds Integer.MAX_INT");
            }
            return (int)length;
        }

        public long size64() {
            return this.width == 0 ? 0L : this.bitVector.length() / (long)this.width;
        }

        @Deprecated
        public long length() {
            return this.size64();
        }

        public void size(long newSize) {
            this.bitVector.length(newSize * (long)this.width);
        }

        @Deprecated
        public LongBigList length(long newSize) {
            this.size(newSize);
            return this;
        }

        public LongBigListIterator listIterator() {
            return new LongBigListIteratorView();
        }

        public void add(int index, long value) {
            this.add((long)index, value);
        }

        public void add(long index, long value) {
            if (this.width != 64 && value > this.fullMask) {
                throw new IllegalArgumentException();
            }
            for (int i = 0; i < this.width; ++i) {
                this.bitVector.add((value & 1L << i) != 0L);
            }
        }

        public long getLong(long index) {
            long start = index * (long)this.width;
            return this.bitVector.getLong(start, start + (long)this.width);
        }

        public long getLong(int index) {
            return this.getLong((long)index);
        }

        public long removeLong(long index) {
            throw new UnsupportedOperationException();
        }

        public long set(long index, long value) {
            if (this.width != 64 && value > this.fullMask) {
                throw new IllegalArgumentException();
            }
            long oldValue = this.getLong(index);
            long start = index * (long)this.width;
            int i = this.width;
            while (i-- != 0) {
                this.bitVector.set((long)i + start, (value & 1L << i) != 0L);
            }
            return oldValue;
        }

        public LongBigList subList(long from, long to) {
            return this.bitVector.subVector(from * (long)this.width, to * (long)this.width).asLongBigList(this.width);
        }

        private final class LongBigListIteratorView
        implements LongBigListIterator {
            private long pos = 0L;

            private LongBigListIteratorView() {
            }

            public boolean hasNext() {
                return this.pos < LongBigListView.this.length();
            }

            public boolean hasPrevious() {
                return this.pos > 0L;
            }

            public long nextLong() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return LongBigListView.this.getLong(this.pos++);
            }

            public long previousLong() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                return LongBigListView.this.getLong(--this.pos);
            }

            public long nextIndex() {
                return this.pos;
            }

            public long previousIndex() {
                return this.pos - 1L;
            }
        }
    }

    public static class SubBitVector
    extends AbstractBitVector
    implements BitVector {
        protected final BitVector bitVector;
        protected long from;
        protected long to;

        public SubBitVector(BitVector l, long from, long to) {
            BitVectors.ensureFromTo(l.length(), from, to);
            this.from = from;
            this.to = to;
            this.bitVector = l;
        }

        public boolean getBoolean(long index) {
            this.ensureIndex(index);
            return this.bitVector.getBoolean(this.from + index);
        }

        @Override
        public int getInt(long index) {
            return this.getBoolean(index) ? 1 : 0;
        }

        @Override
        public boolean set(long index, boolean value) {
            this.ensureIndex(index);
            return this.bitVector.set(this.from + index, value);
        }

        @Override
        public void set(long index, int value) {
            this.set(index, value != 0);
        }

        @Override
        public void add(long index, boolean value) {
            this.ensureIndex(index);
            this.bitVector.add(this.from + index, value);
            ++this.to;
        }

        @Override
        public void add(long index, int value) {
            this.add(index, value != 0);
            ++this.to;
        }

        @Override
        public void add(int value) {
            this.bitVector.add(this.to++, value);
        }

        @Override
        public boolean removeBoolean(long index) {
            this.ensureIndex(index);
            --this.to;
            return this.bitVector.removeBoolean(this.from + index);
        }

        @Override
        public BitVector copy(long from, long to) {
            BitVectors.ensureFromTo(this.length(), from, to);
            return this.bitVector.copy(this.from + from, this.from + to);
        }

        @Override
        public BitVector subVector(long from, long to) {
            BitVectors.ensureFromTo(this.length(), from, to);
            return new SubBitVector(this.bitVector, this.from + from, this.from + to);
        }

        @Override
        public long getLong(long from, long to) {
            BitVectors.ensureFromTo(this.length(), from, to);
            return this.bitVector.getLong(from + this.from, to + this.from);
        }

        @Override
        public long length() {
            return this.to - this.from;
        }

        @Override
        public long size64() {
            return this.length();
        }
    }
}

