/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.big.util;

import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.Util;
import it.unimi.dsi.big.util.FrontCodedStringBigList;
import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.io.TextIO;
import it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongIterators;
import it.unimi.dsi.fastutil.objects.AbstractObjectBigList;
import it.unimi.dsi.fastutil.objects.ObjectBigListIterator;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.util.PermutedFrontCodedStringList;
import java.io.IOException;
import java.io.Serializable;

public class PermutedFrontCodedStringBigList
extends AbstractObjectBigList<CharSequence>
implements Serializable {
    public static final long serialVersionUID = 1L;
    protected final FrontCodedStringBigList frontCodedStringBigList;
    protected final long[][] permutation;

    public PermutedFrontCodedStringBigList(FrontCodedStringBigList frontCodedStringBihList, long[][] permutation) {
        if (frontCodedStringBihList.size64() != BigArrays.length((long[][])permutation)) {
            throw new IllegalArgumentException("The front-coded string big list contains " + frontCodedStringBihList.size64() + " strings, but the permutation is on " + BigArrays.length((long[][])permutation) + " elements.");
        }
        this.frontCodedStringBigList = frontCodedStringBihList;
        this.permutation = permutation;
    }

    public MutableString get(long index) {
        return this.frontCodedStringBigList.get(BigArrays.get((long[][])this.permutation, (long)index));
    }

    public void get(long index, MutableString s) {
        this.frontCodedStringBigList.get(BigArrays.get((long[][])this.permutation, (long)index), s);
    }

    public long size64() {
        return this.frontCodedStringBigList.size64();
    }

    public ObjectBigListIterator<CharSequence> listIterator(long k) {
        return new ObjectBigListIterator<CharSequence>(){
            final LongBidirectionalIterator i;
            long p;
            {
                this.i = LongIterators.fromTo((long)0L, (long)PermutedFrontCodedStringBigList.this.frontCodedStringBigList.size64());
                this.p = 0L;
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public boolean hasPrevious() {
                return this.i.hasPrevious();
            }

            public CharSequence next() {
                ++this.p;
                return PermutedFrontCodedStringBigList.this.frontCodedStringBigList.get(BigArrays.get((long[][])PermutedFrontCodedStringBigList.this.permutation, (long)this.i.nextLong()));
            }

            public CharSequence previous() {
                --this.p;
                return PermutedFrontCodedStringBigList.this.frontCodedStringBigList.get(BigArrays.get((long[][])PermutedFrontCodedStringBigList.this.permutation, (long)this.i.previousLong()));
            }

            public long nextIndex() {
                return this.p;
            }

            public long previousIndex() {
                return this.p - 1L;
            }
        };
    }

    public static void main(String[] arg) throws IOException, ClassNotFoundException, JSAPException {
        long[][] permutation;
        SimpleJSAP jsap = new SimpleJSAP(PermutedFrontCodedStringList.class.getName(), "Builds a permuted front-coded list of strings using a given front-coded string list and a permutation (either in text or binary format).", new Parameter[]{new Switch("invert", 'i', "invert", "Invert permutation before creating the permuted list."), new Switch("text", 't', "text", "The permutation is a text file."), new UnflaggedOption("list", (StringParser)JSAP.STRING_PARSER, true, "A front-coded string big list."), new UnflaggedOption("permutation", (StringParser)JSAP.STRING_PARSER, true, "A permutation for the indices of the list (longs in DataInput format, unless you specify --text)."), new UnflaggedOption("permutedList", (StringParser)JSAP.STRING_PARSER, true, "A the filename for the resulting permuted big list.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        String permutationFile = jsapResult.getString("permutation");
        long[][] lArray = permutation = jsapResult.userSpecified("text") ? LongIterators.unwrapBig((LongIterator)TextIO.asLongIterator((CharSequence)permutationFile)) : BinIO.loadLongsBig((CharSequence)permutationFile);
        if (jsapResult.getBoolean("invert")) {
            Util.invertPermutationInPlace(permutation);
        }
        BinIO.storeObject((Object)new PermutedFrontCodedStringBigList((FrontCodedStringBigList)BinIO.loadObject((CharSequence)jsapResult.getString("list")), permutation), (CharSequence)jsapResult.getString("permutedList"));
    }
}

