/**
 * <p>Miscellaneaous utility classes.
 * 
 * <h2>Pseudorandom number generators</h2>
 * 
 * <p>We provide a number of fast, high-quality PRNGs with different features. As a general review:
 * <ul>
 * <li>{@link it.unimi.dsi.util.SplitMix64Random SplitMix64Random} is the fastest generator, but it has a relatively short period (2<sup>64</sup>) so it should
 * not be used to generate very long sequences (the rule of thumb to have a period greater than the square of the length of the sequence you want to generate).
 * It is a non-splittable version of Java 8's <a href="http://docs.oracle.com/javase/8/docs/api/java/util/SplittableRandom.html"><code>SplittableRandom</code></a>.
 * <li>{@link it.unimi.dsi.util.XorShift128PlusRandom XorShift128PlusRandom} is a fast-as-light, all-purpose top-quality generator. It is slightly slower than {@link it.unimi.dsi.util.SplitMix64Random SplitMix64Random}, 
 * but its period (2<sup>128</sup> &minus; 1) is sufficient for any single-thread application. 
 * <li>{@link it.unimi.dsi.util.XorShift1024StarRandom XorShift1024StarRandom} is fast and provides a long period (2<sup>1024</sup> &minus; 1) for massive parallel computations.
 * </ul>
 * 
 * <p>Both {@link it.unimi.dsi.util.XorShift128PlusRandom XorShift128PlusRandom} and {@link it.unimi.dsi.util.XorShift1024StarRandom XorShift1024StarRandom}
 * provide <em>{@linkplain it.unimi.dsi.util.XorShift128PlusRandom#jump() jump functions}</em> which make it possible to generate long non-overlapping sequences.
 *
 * <p>A table summarizing timings is provided below. Note that we test several different method parameters to show
 * the large gap between full 64-bit generators and <a href="http://docs.oracle.com/javase/7/docs/api/java/util/concurrent/ThreadLocalRandom.html"><code>ThreadLocalRandom</code></a>.
 *  
 * <CENTER><TABLE SUMMARY="Timings in nanoseconds for several generators" BORDER=1>
 * <TR><TH>
 * <TH><a href="http://docs.oracle.com/javase/7/docs/api/java/util/concurrent/ThreadLocalRandom.html"><code>ThreadLocalRandom</code></a>
 * <TH><a href="http://docs.oracle.com/javase/8/docs/api/java/util/SplittableRandom.html"><code>SplittableRandom</code></a>
 * <TH>{@link it.unimi.dsi.util.SplitMix64RandomGenerator SplitMix64RandomGenerator}
 * <TH>{@link it.unimi.dsi.util.XorShift128PlusRandom XorShift128PlusRandom}
 * <TH>{@link it.unimi.dsi.util.XorShift1024StarRandom XorShift1024StarRandom}
 * <TR><TD>	nextInt()	<TD>1.72<TD>1.26<TD>1.17<TD>1.47<TD>2.18
 * <TR><TD>	nextLong()	<TD>1.66<TD>1.25<TD>1.19<TD>1.35<TD>2.07
 * <TR><TD>	nextDouble()	<TD>2.07<TD>2.07<TD>1.54<TD>1.55<TD>2.21
 * <TR><TD>	nextInt(1000000)	<TD>2.85<TD>2.66<TD>2.23<TD>2.83<TD>3.31
 * <TR><TD>	nextInt(2^29+2^28)	<TD>7.44<TD>7.04<TD>2.69<TD>3.14<TD>3.60
 * <TR><TD>	nextInt(2^30)	<TD>1.80<TD>1.38<TD>1.60<TD>2.39<TD>2.83
 * <TR><TD>	nextInt(2^30+1)	<TD>14.98<TD>13.52<TD>2.40<TD>2.96<TD>3.33
 * <TR><TD>	nextInt(2^30+2^29)	<TD>7.36<TD>6.86<TD>2.52<TD>3.01<TD>3.52
 * <TR><TD>	nextLong(1000000000000)	<TD>2.68<TD>2.62<TD>2.74<TD>2.71<TD>3.70
 * <TR><TD>	nextLong(2^62+1)	<TD>14.95<TD>14.09<TD>14.54<TD>12.90<TD>15.35
 * </TABLE></CENTER>
 * 
 * <p>Unfortunately, we have no way to control the optimizations performed
 * by the JVM. In C, for example, we use 
 * <code>gcc</code>'s <code>-fno-move-loop-invariants</code> and <code>-fno-unroll-loops</code> options. These
 * options are essential to get a sensible result: without them, the
 * optimizer can move outside the testing loop constant loads (e.g.,
 * multiplicative constants). <code>SplittableRandom</code> and {@link it.unimi.dsi.util.SplitMix64RandomGenerator SplitMix64RandomGenerator}
 * are particularly advantaged in this respect, as they contain three large constants whose
 * load can be moved outside the testing loop. The best advice is always that of measuring
 * the speed of your application with different generators.
 *
 * <p>The quality of all generators we provide is very high: for instance, they perform better than <code>WELL1024a</code> 
 * or <code>MT19937</code> (AKA the Mersenne Twister) in the <a href="http://www.iro.umontreal.ca/~simardr/testu01/tu01.html">TestU01</a> BigCrush test suite.
 * In particular, {@link it.unimi.dsi.util.SplitMix64Random SplitMix64Random}, {@link it.unimi.dsi.util.XorShift128PlusRandom XorShift128PlusRandom} and {@link it.unimi.dsi.util.XorShift1024StarRandom XorShift1024StarRandom} pass BigCrush. 
 * More details can be found on the <a href="http://xorshift.di.unimi.it/"><code>xorshift*</code>/<code>xorshift+</code> generators and the PRNG shootout</a> page.
 * 
 * <p>For each generator, we provide a version that extends {@link java.util.Random}, overriding (as usual) the {@link java.util.Random#next(int) next(int)} method. Nonetheless,
 * since the generators are all inherently 64-bit also {@link java.util.Random#nextInt() nextInt()}, {@link java.util.Random#nextFloat() nextFloat()},
 * {@link java.util.Random#nextLong() nextLong()}, {@link java.util.Random#nextDouble() nextDouble()}, {@link java.util.Random#nextBoolean() nextBoolean()}
 * and {@link java.util.Random#nextBytes(byte[]) nextBytes(byte[])} have been overridden for speed (preserving, of course, {@link java.util.Random}'s semantics).
 * In particular, {@link java.util.Random#nextDouble() nextDouble()} and {@link java.util.Random#nextFloat() nextFloat()} 
 * use a multiplication-free conversion.
 * 
 * <p>If you do not need an instance of {@link java.util.Random}, or if you need a {@link org.apache.commons.math3.random.RandomGenerator} to use
 * with <a href="http://commons.apache.org/math/">Commons Math</a>, there is for each generator a corresponding {@link org.apache.commons.math3.random.RandomGenerator RandomGenerator}
 * implementation, which indeed we suggest to use in general if you do not need a generator implementing {@link java.util.Random}. 
 */

package it.unimi.dsi.util;
