/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.test.local.util;

import io.rxmicro.logger.Logger;
import io.rxmicro.logger.LoggerFactory;

public final class Safes {
    private static final Logger LOGGER = LoggerFactory.getLogger(Safes.class);

    public static <T> void safeInvoke(T instance, Consumer<T> consumer) {
        if (instance != null) {
            try {
                consumer.accept(instance);
            }
            catch (Throwable throwable) {
                LOGGER.warn(throwable, "Can't safe invoke: ?", (Object)throwable.getMessage());
            }
        }
    }

    private Safes() {
    }

    public static interface Consumer<T> {
        public void accept(T var1) throws Throwable;
    }
}

