/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.test.local.util;

import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Set;

public final class Mocks {
    private static final Set<String> MOCK_ANNOTATIONS = Set.of("org.mockito.Mock");
    private static final String[] MOCK_NAME_FRAGMENTS = new String[]{"$MockitoMock$"};

    public static boolean isMock(AnnotatedElement annotatedElement) {
        return Arrays.stream(annotatedElement.getAnnotations()).map(a -> a.annotationType().getName()).anyMatch(MOCK_ANNOTATIONS::contains);
    }

    public static boolean isMock(Object instance) {
        return Arrays.stream(MOCK_NAME_FRAGMENTS).anyMatch(f -> instance.getClass().getName().contains((CharSequence)f));
    }

    private Mocks() {
    }
}

