/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.test.local.util;

import io.rxmicro.common.util.Formats;
import io.rxmicro.test.local.InvalidTestConfigException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Optional;

public final class Annotations {
    public static <T extends Annotation> T getRequiredAnnotation(Class<?> testClass, Class<T> annotationClass) {
        return (T)((Annotation)Optional.ofNullable(testClass.getAnnotation(annotationClass)).orElseThrow(() -> {
            throw new InvalidTestConfigException("'?' test class must be annotated by '@?' annotation", testClass.getName(), annotationClass.getName());
        }));
    }

    public static <T extends Annotation> T getPresentOrDefaultAnnotation(AnnotatedElement annotatedElement, Class<T> annotationClass) {
        return (T)Optional.ofNullable(annotatedElement.getAnnotation(annotationClass)).orElseGet(() -> Annotations.defaultAnnotationInstance(annotationClass));
    }

    public static <T extends Annotation> T defaultAnnotationInstance(Class<T> annotationClass) {
        return (T)((Annotation)Proxy.newProxyInstance(annotationClass.getClassLoader(), new Class[]{annotationClass}, new AnnotationInvocationHandler<T>(annotationClass)));
    }

    private Annotations() {
    }

    private static final class AnnotationInvocationHandler<T>
    implements InvocationHandler {
        private final Class<T> annotationClass;

        private AnnotationInvocationHandler(Class<T> annotationClass) {
            this.annotationClass = annotationClass;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws InvocationTargetException, IllegalAccessException {
            if ("toString".equals(method.getName()) && method.getParameterCount() == 0) {
                return Formats.format((String)"? Proxy", (Object[])new Object[]{this.annotationClass.getSimpleName()});
            }
            if (method.getDeclaringClass() == Object.class) {
                return method.invoke((Object)this, args);
            }
            return method.getDefaultValue();
        }
    }
}

