/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.test.local.model;

import io.rxmicro.common.util.Requires;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class TestModel {
    private final Class<?> testClass;
    private final Class<?> testedComponentClass;
    private final List<Field> staticConfigs;
    private final List<Field> instanceConfigs;
    private final List<Field> blockingHttpClients;
    private final List<Field> systemOuts;
    private final List<Field> systemErrs;
    private final List<Field> testedComponents;
    private final List<Field> userCreatedComponents;
    private final List<Field> beanComponents;
    private final List<Field> restClients;
    private final List<Field> repositories;
    private final List<Field> mongoDataBases;
    private final List<Field> sqlConnectionPools;
    private final List<Field> httpClientFactories;

    private TestModel(Class<?> testClass, Class<?> testedComponentClass, List<Field> staticConfigs, List<Field> instanceConfigs, List<Field> blockingHttpClients, List<Field> systemOuts, List<Field> systemErrs, List<Field> testedComponents, List<Field> userCreatedComponents, List<Field> beanComponents, List<Field> restClients, List<Field> repositories, List<Field> mongoDataBases, List<Field> sqlConnectionPools, List<Field> httpClientFactories) {
        this.testClass = testClass;
        this.staticConfigs = staticConfigs;
        this.instanceConfigs = instanceConfigs;
        this.blockingHttpClients = blockingHttpClients;
        this.systemOuts = systemOuts;
        this.testedComponentClass = testedComponentClass;
        this.systemErrs = systemErrs;
        this.testedComponents = testedComponents;
        this.userCreatedComponents = userCreatedComponents;
        this.beanComponents = beanComponents;
        this.restClients = restClients;
        this.repositories = repositories;
        this.mongoDataBases = mongoDataBases;
        this.sqlConnectionPools = sqlConnectionPools;
        this.httpClientFactories = httpClientFactories;
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    public List<Field> getStaticConfigs() {
        return this.staticConfigs;
    }

    public boolean isStaticConfigsPresent() {
        return !this.staticConfigs.isEmpty();
    }

    public List<Field> getInstanceConfigs() {
        return this.instanceConfigs;
    }

    public boolean isInstanceConfigsPresent() {
        return !this.instanceConfigs.isEmpty();
    }

    public List<Field> getBlockingHttpClients() {
        return this.blockingHttpClients;
    }

    public List<Field> getSystemOuts() {
        return this.systemOuts;
    }

    public List<Field> getSystemErrs() {
        return this.systemErrs;
    }

    public List<Field> getTestedComponents() {
        return this.testedComponents;
    }

    public Optional<Class<?>> getTestedComponentClass() {
        return Optional.ofNullable(this.testedComponentClass);
    }

    public List<Field> getUserCreatedComponents() {
        return this.userCreatedComponents;
    }

    public List<Field> getBeanComponents() {
        return this.beanComponents;
    }

    public List<Field> getRestClients() {
        return this.restClients;
    }

    public List<Field> getRepositories() {
        return this.repositories;
    }

    public List<Field> getMongoDataBases() {
        return this.mongoDataBases;
    }

    public List<Field> getSqlConnectionPools() {
        return this.sqlConnectionPools;
    }

    public List<Field> getHttpClientFactories() {
        return this.httpClientFactories;
    }

    public Set<Field> getMockTestFields() {
        return Stream.of(this.staticConfigs.stream(), this.instanceConfigs.stream(), this.testedComponents.stream(), this.userCreatedComponents.stream(), this.beanComponents.stream(), this.restClients.stream(), this.repositories.stream(), this.mongoDataBases.stream(), this.sqlConnectionPools.stream(), this.httpClientFactories.stream()).flatMap(Function.identity()).collect(Collectors.toSet());
    }

    public static final class Builder {
        private final Class<?> testClass;
        private final List<Field> staticConfigs = new ArrayList<Field>(2);
        private final List<Field> instanceConfigs = new ArrayList<Field>(1);
        private final List<Field> blockingHttpClients = new ArrayList<Field>(1);
        private final List<Field> systemOuts = new ArrayList<Field>(1);
        private final List<Field> systemErrs = new ArrayList<Field>(1);
        private final List<Field> testedComponents = new ArrayList<Field>(1);
        private final List<Field> userCreatedComponents = new ArrayList<Field>(5);
        private final List<Field> beanComponents = new ArrayList<Field>(5);
        private final List<Field> restClients = new ArrayList<Field>(1);
        private final List<Field> repositories = new ArrayList<Field>(1);
        private final List<Field> mongoDataBases = new ArrayList<Field>(1);
        private final List<Field> sqlConnectionPools = new ArrayList<Field>(1);
        private final List<Field> httpClientFactories = new ArrayList<Field>(1);
        private Class<?> testedComponentClass;

        public Builder(Class<?> testClass) {
            this.testClass = (Class)Requires.require(testClass);
        }

        public void setTestedComponentClass(Class<?> testedComponentClass) {
            this.testedComponentClass = (Class)Requires.require(testedComponentClass);
        }

        public void addStaticConfig(Field field) {
            this.staticConfigs.add(field);
        }

        public void addInstanceConfig(Field field) {
            this.instanceConfigs.add(field);
        }

        public void addBlockingHttpClient(Field field) {
            this.blockingHttpClients.add(field);
        }

        public void addSystemOut(Field field) {
            this.systemOuts.add(field);
        }

        public void addSystemErr(Field field) {
            this.systemErrs.add(field);
        }

        public void addTestedComponent(Field field) {
            this.testedComponents.add(field);
        }

        public void addBeanComponent(Field field) {
            this.beanComponents.add(field);
        }

        public void addUserCreatedComponent(Field field) {
            this.userCreatedComponents.add(field);
        }

        public void addRestClient(Field field) {
            this.restClients.add(field);
        }

        public void addRepository(Field field) {
            this.repositories.add(field);
        }

        public void addMongoDatabase(Field field) {
            this.mongoDataBases.add(field);
        }

        public void addSqlConnectionPool(Field field) {
            this.sqlConnectionPools.add(field);
        }

        public void addHttpClientFactory(Field field) {
            this.httpClientFactories.add(field);
        }

        public TestModel build() {
            return new TestModel(this.testClass, this.testedComponentClass, this.staticConfigs, this.instanceConfigs, this.blockingHttpClients, this.systemOuts, this.systemErrs, this.testedComponents, this.userCreatedComponents, this.beanComponents, this.restClients, this.repositories, this.mongoDataBases, this.sqlConnectionPools, this.httpClientFactories);
        }
    }
}

