/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.test.local.component.validator;

import io.rxmicro.http.ProtocolSchema;
import io.rxmicro.rest.server.detail.component.AbstractRestController;
import io.rxmicro.test.local.BlockingHttpClientConfig;
import io.rxmicro.test.local.InvalidTestConfigException;
import io.rxmicro.test.local.component.RxMicroTestExtensions;
import io.rxmicro.test.local.component.validator.CommonTestValidator;
import io.rxmicro.test.local.model.TestModel;
import io.rxmicro.test.local.util.GeneratedClasses;
import java.lang.annotation.Annotation;
import java.util.Set;

public final class RestBasedMicroServiceTestValidator
extends CommonTestValidator {
    private final Set<Class<? extends Annotation>> supportedTestAnnotations;

    public RestBasedMicroServiceTestValidator(Set<Class<? extends Annotation>> supportedTestAnnotations) {
        this.supportedTestAnnotations = supportedTestAnnotations;
    }

    public void validate(TestModel testModel, Class<?> ... restControllerClasses) {
        this.validate(testModel);
        for (Class<?> restControllerClass : restControllerClasses) {
            if (GeneratedClasses.isClassGenerated(restControllerClass, "?.$$?", AbstractRestController.class)) continue;
            throw new InvalidTestConfigException("'?' is not REST controller class or the the RxMicro Annotation Processor does not generate wrapper for '?' class. Set valid REST controller class for the REST based micro service test: '?' or recompile the project with activated RxMicro Annotation Processor! Read more at https://docs.rxmicro.io/latest/user-guide/quick-start.html#compiling_the_project", restControllerClass.getName(), restControllerClass.getName(), testModel.getTestClass().getName());
        }
    }

    public void validate(TestModel testModel, BlockingHttpClientConfig config) {
        if (!"localhost".equals(config.getHost())) {
            throw new InvalidTestConfigException("For REST based micro service tests HTTP server host must be 'localhost' only! Fix setting for ? test class!", testModel.getTestClass().getName());
        }
        if (config.getSchema() != ProtocolSchema.HTTP) {
            throw new InvalidTestConfigException("For REST based micro service tests HTTP server supports the 'http' schema only! Fix setting for ? test class!", testModel.getTestClass().getName());
        }
    }

    @Override
    protected void validateUsingSpecificRules(TestModel testModel) {
        this.validateThatOnlyOneAnnotationExistsPerTestClass(testModel, this.supportedTestAnnotations);
        RxMicroTestExtensions.validateUsingTestExtensions(testModel, this.supportedTestAnnotations);
        if (testModel.isInstanceConfigsPresent()) {
            throw new InvalidTestConfigException("Rest-based microservice test supports static configs only! Remove not static configs or add the missing 'static' modifier for ? from '?' test class!", testModel.getInstanceConfigs(), testModel.getTestClass().getName());
        }
    }
}

