/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.test.local.component.validator;

import io.rxmicro.test.Alternative;
import io.rxmicro.test.WithConfig;
import io.rxmicro.test.local.BlockingHttpClientConfig;
import io.rxmicro.test.local.InvalidTestConfigException;
import io.rxmicro.test.local.component.RxMicroTestExtensions;
import io.rxmicro.test.local.component.validator.CommonTestValidator;
import io.rxmicro.test.local.model.BaseTestConfig;
import io.rxmicro.test.local.model.TestModel;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Set;

public final class IntegrationTestValidator
extends CommonTestValidator {
    private final Set<Class<? extends Annotation>> supportedTestAnnotations;

    public IntegrationTestValidator(Set<Class<? extends Annotation>> supportedTestAnnotations) {
        this.supportedTestAnnotations = supportedTestAnnotations;
    }

    public void validate(TestModel testModel, BlockingHttpClientConfig config) {
        if (!config.isFollowRedirects()) {
            throw new InvalidTestConfigException("For integration tests blocking HTTP client must support follow redirects! Fix setting for ? test class!", testModel.getTestClass().getName());
        }
    }

    @Override
    protected void validateUsingSpecificRules(TestModel testModel) {
        this.validateThatOnlyOneAnnotationExistsPerTestClass(testModel, this.supportedTestAnnotations);
        RxMicroTestExtensions.validateUsingTestExtensions(testModel, this.supportedTestAnnotations);
        if (testModel.isStaticConfigsPresent()) {
            this.validateSupportedConfigClasses(testModel, testModel.getStaticConfigs());
        }
        if (testModel.isInstanceConfigsPresent()) {
            this.validateSupportedConfigClasses(testModel, testModel.getInstanceConfigs());
        }
        if (!(testModel.getHttpClientFactories().isEmpty() && testModel.getSqlConnectionPools().isEmpty() && testModel.getRestClients().isEmpty() && testModel.getMongoDataBases().isEmpty() && testModel.getRepositories().isEmpty() && testModel.getTestedComponents().isEmpty() && testModel.getUserCreatedComponents().isEmpty())) {
            throw new InvalidTestConfigException("DBUnit test does not support alternatives. Remove all fields annotated by '@?' annotation from '?' test class!", Alternative.class.getName(), testModel.getTestClass().getName());
        }
    }

    private void validateSupportedConfigClasses(TestModel testModel, List<Field> configFields) {
        for (Field field : configFields) {
            if (BaseTestConfig.class.isAssignableFrom(field.getType())) continue;
            throw new InvalidTestConfigException("Integration test does not support custom configs. Remove all fields annotated by '@?' annotation from '?' test class!", WithConfig.class.getName(), testModel.getTestClass().getName());
        }
    }
}

