/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.test.local.component.validator;

import io.rxmicro.test.BlockingHttpClient;
import io.rxmicro.test.internal.validator.impl.TestedComponentFieldValidator;
import io.rxmicro.test.local.InvalidTestConfigException;
import io.rxmicro.test.local.component.RxMicroTestExtensions;
import io.rxmicro.test.local.component.validator.CommonTestValidator;
import io.rxmicro.test.local.model.TestModel;
import java.lang.annotation.Annotation;
import java.util.Set;

public final class ComponentTestValidator
extends CommonTestValidator {
    private final Set<Class<? extends Annotation>> supportedTestAnnotations;

    public ComponentTestValidator(Set<Class<? extends Annotation>> supportedTestAnnotations) {
        this.supportedTestAnnotations = supportedTestAnnotations;
    }

    @Override
    protected void validateUsingSpecificRules(TestModel testModel) {
        this.validateThatOnlyOneAnnotationExistsPerTestClass(testModel, this.supportedTestAnnotations);
        RxMicroTestExtensions.validateUsingTestExtensions(testModel, this.supportedTestAnnotations);
        if (!testModel.getBlockingHttpClients().isEmpty()) {
            throw new InvalidTestConfigException("Component test does not support '?' field. Remove this field from ? test class!", BlockingHttpClient.class.getName(), testModel.getTestClass().getName());
        }
        if (testModel.isInstanceConfigsPresent() && testModel.isStaticConfigsPresent()) {
            throw new InvalidTestConfigException("Redundant static config(s): ?. Remove redundant config(s) from ? test class!", testModel.getStaticConfigs(), testModel.getTestClass().getName());
        }
        new TestedComponentFieldValidator(testModel.getTestedComponentClass().orElseThrow()).validate(testModel.getTestedComponents());
    }
}

