/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.test.local.component.validator;

import io.rxmicro.common.RxMicroModule;
import io.rxmicro.test.SetConfigValue;
import io.rxmicro.test.internal.DetectTypeRules;
import io.rxmicro.test.internal.validator.impl.BlockingHttpClientFieldValidator;
import io.rxmicro.test.internal.validator.impl.ConfigFieldValidator;
import io.rxmicro.test.internal.validator.impl.HttpClientFactoryFieldValidator;
import io.rxmicro.test.internal.validator.impl.MongoDatabaseFieldValidator;
import io.rxmicro.test.internal.validator.impl.RepositoryFieldValidator;
import io.rxmicro.test.internal.validator.impl.RestClientFieldValidator;
import io.rxmicro.test.internal.validator.impl.SqlConnectionPoolFieldValidator;
import io.rxmicro.test.internal.validator.impl.SystemOutFieldValidator;
import io.rxmicro.test.internal.validator.impl.UserCreatedComponentFieldValidator;
import io.rxmicro.test.local.InvalidTestConfigException;
import io.rxmicro.test.local.component.RxMicroTestExtensions;
import io.rxmicro.test.local.model.TestModel;
import io.rxmicro.test.local.util.FieldNames;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class CommonTestValidator {
    private static final Set<Class<? extends Annotation>> SUPPORTED_PER_CLASS_ANNOTATIONS = Set.of(SetConfigValue.class, SetConfigValue.List.class);

    public final void validate(TestModel testModel) {
        this.validateUsingCommonRules(testModel);
        this.validateUsingSpecificRules(testModel);
        this.validateThatClassNotContainRedundantAnnotation(testModel);
    }

    private void validateUsingCommonRules(TestModel testModel) {
        new ConfigFieldValidator().validate(testModel.getStaticConfigs());
        new ConfigFieldValidator().validate(testModel.getInstanceConfigs());
        new BlockingHttpClientFieldValidator().validate(testModel.getBlockingHttpClients());
        new SystemOutFieldValidator().validate(testModel.getSystemOuts());
        new UserCreatedComponentFieldValidator().validate(testModel.getUserCreatedComponents());
        new RestClientFieldValidator().validate(testModel.getRestClients());
        new RepositoryFieldValidator().validate(testModel.getRepositories());
        new MongoDatabaseFieldValidator().validate(testModel.getMongoDataBases());
        new SqlConnectionPoolFieldValidator().validate(testModel.getSqlConnectionPools());
        new HttpClientFactoryFieldValidator().validate(testModel.getHttpClientFactories());
        this.validateRestClientFactoryState(testModel);
        this.validateRepositoryFactoryState(testModel);
    }

    protected abstract void validateUsingSpecificRules(TestModel var1);

    protected final void validateThatOnlyOneAnnotationExistsPerTestClass(TestModel testModel, Set<Class<? extends Annotation>> supportedAnnotations) {
        Set presentAnnotations = supportedAnnotations.stream().filter(a -> testModel.getTestClass().isAnnotationPresent((Class<Annotation>)a)).collect(Collectors.toSet());
        if (presentAnnotations.size() > 1) {
            throw new InvalidTestConfigException("Per test class only one annotation is allowed from the list: ?. Remove redundant annotation(s) from '?' test class!", supportedAnnotations, testModel.getTestClass().getName());
        }
    }

    private void validateThatClassNotContainRedundantAnnotation(TestModel testModel) {
        HashSet<Class<? extends Annotation>> supportedPerClassAnnotations = new HashSet<Class<? extends Annotation>>(SUPPORTED_PER_CLASS_ANNOTATIONS);
        supportedPerClassAnnotations.addAll(RxMicroTestExtensions.supportedPerClassAnnotationsFromTestExtensions());
        Arrays.stream(testModel.getTestClass().getAnnotations()).filter(a -> RxMicroModule.isRxMicroPackage((String)a.annotationType().getPackageName()) && !supportedPerClassAnnotations.contains(a.annotationType())).forEach(a -> {
            throw new InvalidTestConfigException("Test class annotated by redundant annotation: '@?'. Remove redundant annotation from '?' test class!", a.annotationType().getName(), testModel.getTestClass().getName());
        });
    }

    private void validateRestClientFactoryState(TestModel testModel) {
        if (!testModel.getRestClients().isEmpty() && !testModel.getHttpClientFactories().isEmpty()) {
            String httpClientFactoryField = FieldNames.getHumanReadableFieldName(testModel.getHttpClientFactories().get(0));
            String restClientField = FieldNames.getHumanReadableFieldName(testModel.getRestClients().get(0));
            throw new InvalidTestConfigException("'?' http client factory alternative conflicts with '?' rest client. Remove the http client factory alternative or the rest client field!", httpClientFactoryField, restClientField);
        }
    }

    private void validateRepositoryFactoryState(TestModel testModel) {
        if (!testModel.getRepositories().isEmpty()) {
            this.validateMongoRepositoryFactoryState(testModel);
            this.validatePostgresRepositoryFactoryState(testModel);
        }
    }

    private void validateMongoRepositoryFactoryState(TestModel testModel) {
        if (!testModel.getMongoDataBases().isEmpty()) {
            for (Field field : testModel.getRepositories()) {
                if (!DetectTypeRules.isMongoRepositoryField(field.getType())) continue;
                String mongoField = FieldNames.getHumanReadableFieldName(testModel.getMongoDataBases().get(0));
                String repositoryField = FieldNames.getHumanReadableFieldName(field);
                throw new InvalidTestConfigException("'?' mongo database alternative conflicts with '?' repository. Remove the mongo database alternative or the repository field!", mongoField, repositoryField);
            }
        }
    }

    private void validatePostgresRepositoryFactoryState(TestModel testModel) {
        if (!testModel.getSqlConnectionPools().isEmpty()) {
            for (Field field : testModel.getRepositories()) {
                if (!DetectTypeRules.isPostgreRepositoryField(field.getType())) continue;
                String connectionPoolField = FieldNames.getHumanReadableFieldName(testModel.getSqlConnectionPools().get(0));
                String repositoryField = FieldNames.getHumanReadableFieldName(field);
                throw new InvalidTestConfigException("'?' sql connection pool alternative conflicts with '?' repository. Remove the sql connection pool alternative or the repository field!", connectionPoolField, repositoryField);
            }
        }
    }
}

