/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.test.local.component.injector.internal;

import io.rxmicro.common.ImpossibleException;
import io.rxmicro.common.util.Requires;
import io.rxmicro.reflection.Reflections;
import io.rxmicro.test.internal.AlternativeEntryPoint;
import io.rxmicro.test.local.InvalidTestConfigException;
import io.rxmicro.test.local.model.internal.InjectedCandidate;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class InjectedCandidateInjector {
    private final Map<Class<?>, List<AlternativeEntryPoint>> alternativeEntryPointsMap;

    public InjectedCandidateInjector(Map<Class<?>, List<AlternativeEntryPoint>> alternativeEntryPointsMap) {
        this.alternativeEntryPointsMap = (Map)Requires.require(alternativeEntryPointsMap);
    }

    public void inject(Map<Class<?>, List<InjectedCandidate>> candidatesMap) {
        HashSet<AlternativeEntryPoint> injectedAlternatives = new HashSet<AlternativeEntryPoint>();
        for (Map.Entry<Class<?>, List<InjectedCandidate>> entry : candidatesMap.entrySet()) {
            List<InjectedCandidate> injectedCandidates = entry.getValue();
            List alternatives = (List)Requires.require(this.alternativeEntryPointsMap.get(entry.getKey()));
            if (injectedCandidates.size() == 1 && alternatives.size() == 1) {
                this.injectSingleAlternativeToInjectionCandidate(injectedAlternatives, injectedCandidates, alternatives);
                continue;
            }
            if (injectedCandidates.size() == 1 && alternatives.size() > 1) {
                this.throwConfigError(injectedCandidates, alternatives);
                continue;
            }
            if (!alternatives.isEmpty() && injectedCandidates.size() > 1) {
                this.injectMultipleAlternativesToInjectionCandidates(injectedAlternatives, injectedCandidates, alternatives);
                continue;
            }
            throw new ImpossibleException("Injected candidate internal logic error", new Object[0]);
        }
        this.validateRedundantAlternatives(injectedAlternatives);
    }

    private void injectSingleAlternativeToInjectionCandidate(Set<AlternativeEntryPoint> injectedAlternatives, List<InjectedCandidate> injectedCandidates, List<AlternativeEntryPoint> alternatives) {
        InjectedCandidate injectedCandidate = injectedCandidates.get(0);
        AlternativeEntryPoint alternative = alternatives.get(0);
        Reflections.setFieldValue((Object)injectedCandidate.getInstance(), (Field)injectedCandidate.getField(), (Object)alternative.getValue());
        injectedAlternatives.add(alternative);
    }

    private void throwConfigError(List<InjectedCandidate> injectedCandidates, List<AlternativeEntryPoint> alternatives) {
        InjectedCandidate injectedCandidate = injectedCandidates.get(0);
        throw new InvalidTestConfigException("Detected ? alternatives for one injection point: ?. Only one alternative is allowed from the following items: ?.Remove redundant alternatives!", alternatives.size(), injectedCandidate.getHumanReadableErrorName(), alternatives.stream().map(AlternativeEntryPoint::getHumanReadableErrorName).collect(Collectors.toList()));
    }

    private void injectMultipleAlternativesToInjectionCandidates(Set<AlternativeEntryPoint> injectedAlternatives, List<InjectedCandidate> injectedCandidates, List<AlternativeEntryPoint> alternatives) {
        boolean injected = false;
        for (AlternativeEntryPoint alternative : alternatives) {
            for (InjectedCandidate injectedCandidate : injectedCandidates) {
                if (!injectedCandidate.getField().getName().equals(alternative.getInjectionName())) continue;
                Reflections.setFieldValue((Object)injectedCandidate.getInstance(), (Field)injectedCandidate.getField(), (Object)alternative.getValue());
                injectedAlternatives.add(alternative);
                injected = true;
            }
        }
        if (alternatives.size() == 1 && !injected) {
            for (InjectedCandidate injectedCandidate : injectedCandidates) {
                AlternativeEntryPoint alternative = alternatives.get(0);
                Reflections.setFieldValue((Object)injectedCandidate.getInstance(), (Field)injectedCandidate.getField(), (Object)alternative.getValue());
                injectedAlternatives.add(alternative);
            }
        }
    }

    private void validateRedundantAlternatives(Set<AlternativeEntryPoint> injectedAlternatives) {
        this.alternativeEntryPointsMap.values().stream().flatMap(Collection::stream).filter(a -> !injectedAlternatives.contains(a)).findFirst().ifPresent(a -> {
            throw new InvalidTestConfigException("'?' alternative is redundant. Remove redundant alternative!", a.getHumanReadableErrorName());
        });
    }
}

