/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.test.local.component.injector;

import io.rxmicro.test.internal.AlternativeEntryPoint;
import io.rxmicro.test.local.InvalidTestConfigException;
import io.rxmicro.test.local.component.builder.internal.InjectedCandidateBuilder;
import io.rxmicro.test.local.component.injector.internal.InjectedCandidateInjector;
import io.rxmicro.test.local.model.internal.InjectedCandidate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class UserCreatedComponentInjector {
    private final List<AlternativeEntryPoint> userCreatedComponents;
    private final InjectedCandidateBuilder injectedCandidateBuilder;
    private final InjectedCandidateInjector injectedCandidateInjector;

    UserCreatedComponentInjector(List<AlternativeEntryPoint> userCreatedComponents) {
        this.userCreatedComponents = userCreatedComponents;
        HashMap alternativeEntryPointsMap = new HashMap();
        for (AlternativeEntryPoint alternative : userCreatedComponents) {
            alternativeEntryPointsMap.computeIfAbsent(alternative.getFieldType(), v -> new ArrayList()).add(alternative);
        }
        this.injectedCandidateBuilder = new InjectedCandidateBuilder(alternativeEntryPointsMap.keySet());
        this.injectedCandidateInjector = new InjectedCandidateInjector(alternativeEntryPointsMap);
    }

    public void injectIfFound(List<Object> testInstances, List<Object> destinationInstances) {
        if (this.userCreatedComponents.isEmpty()) {
            return;
        }
        this.userCreatedComponents.forEach(a -> a.readValue(testInstances));
        for (Object destinationInstance : destinationInstances) {
            Map<Class<?>, List<InjectedCandidate>> candidatesMap = this.injectedCandidateBuilder.build(destinationInstance);
            this.validate(candidatesMap);
            this.injectedCandidateInjector.inject(candidatesMap);
        }
    }

    private void validate(Map<Class<?>, List<InjectedCandidate>> candidatesMap) {
        for (Map.Entry<Class<?>, List<InjectedCandidate>> entry : candidatesMap.entrySet()) {
            if (!entry.getValue().isEmpty()) continue;
            throw new InvalidTestConfigException("Redundant alternative of the user component: '?'. Remove redundant alternative!", this.userCreatedComponents.stream().filter(a -> entry.getKey() == a.getFieldType()).findFirst().orElseThrow().getHumanReadableErrorName());
        }
    }
}

