/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.test.local.component.injector;

import io.rxmicro.reflection.Reflections;
import io.rxmicro.test.SystemErr;
import io.rxmicro.test.SystemOut;
import io.rxmicro.test.internal.SystemStream;
import io.rxmicro.test.internal.SystemStreamImpl;
import io.rxmicro.test.local.InvalidTestConfigException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.List;

public final class SystemStreamInjector {
    private static final PrintStream ORIGINAL_SYSTEM_OUT = System.out;
    private static final PrintStream ORIGINAL_SYSTEM_ERR = System.err;
    private final Field systemOutField;
    private final Field systemErrField;

    SystemStreamInjector(Field systemOutField, Field systemErrField) {
        this.systemOutField = systemOutField;
        this.systemErrField = systemErrField;
    }

    public void injectIfFound(List<Object> testInstances) {
        if (this.systemOutField != null) {
            System.setOut(this.createAndInject(testInstances, SystemOut.class, this.systemOutField, ORIGINAL_SYSTEM_OUT).getPrintStream());
        }
        if (this.systemErrField != null) {
            System.setErr(this.createAndInject(testInstances, SystemErr.class, this.systemErrField, ORIGINAL_SYSTEM_ERR).getPrintStream());
        }
    }

    private SystemStreamImpl createAndInject(List<Object> testInstances, Class<? extends SystemStream> systemStreamClass, Field field, PrintStream originalStream) {
        if (Reflections.getFieldValue(testInstances, (Field)field) != null) {
            throw new InvalidTestConfigException("Field with type '?' could not be initialized. Remove initialize statement!", systemStreamClass.getSimpleName());
        }
        SystemStreamImpl systemStreamImpl = new SystemStreamImpl(originalStream);
        Reflections.setFieldValue(testInstances, (Field)field, (Object)systemStreamImpl);
        return systemStreamImpl;
    }

    public void resetIfNecessary() {
        if (this.systemOutField != null) {
            System.setOut(ORIGINAL_SYSTEM_OUT);
        }
        if (this.systemErrField != null) {
            System.setErr(ORIGINAL_SYSTEM_ERR);
        }
    }
}

