/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.test.local.component.injector;

import io.rxmicro.test.Alternative;
import io.rxmicro.test.internal.AlternativeEntryPoint;
import io.rxmicro.test.local.component.TestedComponentResolver;
import io.rxmicro.test.local.component.injector.BeanFactoryInjector;
import io.rxmicro.test.local.component.injector.BlockingHttpClientInjector;
import io.rxmicro.test.local.component.injector.RepositoryInjector;
import io.rxmicro.test.local.component.injector.RestClientInjector;
import io.rxmicro.test.local.component.injector.RuntimeContextComponentInjector;
import io.rxmicro.test.local.component.injector.SystemStreamInjector;
import io.rxmicro.test.local.component.injector.UserCreatedComponentInjector;
import io.rxmicro.test.local.model.TestModel;
import java.lang.reflect.Field;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class InjectorFactory {
    private static final Function<Field, AlternativeEntryPoint> MAPPER = f -> new AlternativeEntryPoint(f.getAnnotation(Alternative.class), (Field)f);
    private final List<AlternativeEntryPoint> runtimeContextRegistrationComponents;
    private final List<AlternativeEntryPoint> repositoryComponents;
    private final List<AlternativeEntryPoint> restClientComponents;
    private final List<AlternativeEntryPoint> userCreatedComponents;
    private final List<AlternativeEntryPoint> beanComponents;
    private final Field testedComponent;
    private final Class<?> testedComponentClass;
    private final Field blockingHttpClientField;
    private final Field systemOutField;
    private final Field systemErrField;

    public InjectorFactory(TestModel testModel) {
        this.blockingHttpClientField = testModel.getBlockingHttpClients().stream().findFirst().orElse(null);
        this.systemOutField = testModel.getSystemOuts().stream().findFirst().orElse(null);
        this.systemErrField = testModel.getSystemErrs().stream().findFirst().orElse(null);
        this.testedComponent = testModel.getTestedComponents().stream().findFirst().orElse(null);
        this.testedComponentClass = testModel.getTestedComponentClass().orElse(null);
        this.runtimeContextRegistrationComponents = Stream.of(testModel.getMongoDataBases().stream(), testModel.getSqlConnectionPools().stream(), testModel.getHttpClientFactories().stream()).flatMap(Function.identity()).map(MAPPER).collect(Collectors.toList());
        this.repositoryComponents = testModel.getRepositories().stream().map(MAPPER).collect(Collectors.toList());
        this.restClientComponents = testModel.getRestClients().stream().map(MAPPER).collect(Collectors.toList());
        this.userCreatedComponents = testModel.getUserCreatedComponents().stream().map(MAPPER).collect(Collectors.toList());
        this.beanComponents = testModel.getBeanComponents().stream().map(MAPPER).collect(Collectors.toList());
    }

    public BlockingHttpClientInjector createBlockingHttpClientInjector() {
        return new BlockingHttpClientInjector(this.blockingHttpClientField);
    }

    public SystemStreamInjector createSystemOutInjector() {
        return new SystemStreamInjector(this.systemOutField, this.systemErrField);
    }

    public RuntimeContextComponentInjector createRuntimeContextComponentInjector() {
        return new RuntimeContextComponentInjector(this.runtimeContextRegistrationComponents);
    }

    public TestedComponentResolver createTestedComponentResolver() {
        return new TestedComponentResolver(this.testedComponent, this.testedComponentClass);
    }

    public RepositoryInjector createRepositoryInjector() {
        return new RepositoryInjector(this.repositoryComponents);
    }

    public RestClientInjector createRestClientInjector() {
        return new RestClientInjector(this.restClientComponents);
    }

    public UserCreatedComponentInjector createUserCreatedComponentInjector() {
        return new UserCreatedComponentInjector(this.userCreatedComponents);
    }

    public BeanFactoryInjector createBeanFactoryInjector() {
        return new BeanFactoryInjector(this.beanComponents);
    }
}

