/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.test.local.component.injector;

import io.rxmicro.config.Networks;
import io.rxmicro.reflection.Reflections;
import io.rxmicro.test.BlockingHttpClient;
import io.rxmicro.test.BlockingHttpClientSettings;
import io.rxmicro.test.local.BlockingHttpClientConfig;
import io.rxmicro.test.local.InvalidTestConfigException;
import io.rxmicro.test.local.component.builder.BlockingHttpClientSettingsRandomPortReader;
import io.rxmicro.test.local.util.Annotations;
import java.lang.reflect.Field;
import java.time.Duration;
import java.util.List;

public final class BlockingHttpClientInjector {
    private final BlockingHttpClientSettingsRandomPortReader reader = new BlockingHttpClientSettingsRandomPortReader();
    private final Field blockingHttpClientField;

    BlockingHttpClientInjector(Field blockingHttpClientField) {
        this.blockingHttpClientField = blockingHttpClientField;
    }

    public boolean hasField() {
        return this.blockingHttpClientField != null;
    }

    public BlockingHttpClientConfig getConfig(Class<?> testClass, boolean expectFollowRedirects, int defaultPort) {
        BlockingHttpClientSettings settings = Annotations.getPresentOrDefaultAnnotation(this.blockingHttpClientField, BlockingHttpClientSettings.class);
        this.validateConfig(settings);
        return new BlockingHttpClientConfig().setBaseUrlPath(settings.baseUrlPath()).setBaseUrlPosition(settings.baseUrlPosition()).setVersionStrategy(settings.versionStrategy()).setVersionValue(settings.versionValue()).setSchema(settings.schema()).setHost(settings.host()).setPort(this.getPort(settings, testClass, defaultPort)).setRequestTimeout(Duration.ofSeconds(settings.requestTimeout())).setFollowRedirects(settings.followRedirects().toBoolean(expectFollowRedirects));
    }

    private void validateConfig(BlockingHttpClientSettings settings) {
        if (settings.port() > -1 && !settings.randomPortProvider().isEmpty()) {
            throw new InvalidTestConfigException("Only one parameter must be set: '@?.port' or '@?.randomPortProvider'!", BlockingHttpClientSettings.class.getSimpleName(), BlockingHttpClientSettings.class.getSimpleName());
        }
    }

    private int getPort(BlockingHttpClientSettings settings, Class<?> testClass, int defaultPort) {
        if (settings.port() > -1) {
            return Networks.validatePort((int)settings.port());
        }
        String portProvider = settings.randomPortProvider();
        if (!portProvider.isEmpty()) {
            return this.reader.getPort(testClass, portProvider);
        }
        return defaultPort;
    }

    public void injectIfFound(List<Object> testInstances, BlockingHttpClient blockingHttpClient) {
        if (this.hasField()) {
            if (Reflections.getFieldValue(testInstances, (Field)this.blockingHttpClientField) != null) {
                throw new InvalidTestConfigException("Field with type '?' could not be initialized. Remove initialize statement!", BlockingHttpClient.class.getSimpleName());
            }
            Reflections.setFieldValue(testInstances, (Field)this.blockingHttpClientField, (Object)blockingHttpClient);
        }
    }
}

