/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.test.local.component.builder.internal;

import io.rxmicro.common.local.DeniedPackages;
import io.rxmicro.common.util.ExCollections;
import io.rxmicro.common.util.GeneratedClassRules;
import io.rxmicro.common.util.Requires;
import io.rxmicro.reflection.Reflections;
import io.rxmicro.test.local.model.internal.InjectedCandidate;
import io.rxmicro.test.local.util.Mocks;
import io.rxmicro.test.local.util.UserComponents;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class InjectedCandidateBuilder {
    private final Set<Class<?>> types;

    public InjectedCandidateBuilder(Set<Class<?>> types) {
        this.types = (Set)Requires.require(types);
    }

    public Map<Class<?>, List<InjectedCandidate>> build(Object destinationInstance) {
        Map<Class<?>, List<InjectedCandidate>> map = this.types.stream().collect(Collectors.toMap(Function.identity(), e -> new ArrayList()));
        this.extract(map, destinationInstance);
        return ExCollections.unmodifiableMap(map);
    }

    private void extract(Map<Class<?>, List<InjectedCandidate>> map, Object destinationInstance) {
        if (destinationInstance == null || Mocks.isMock(destinationInstance) || GeneratedClassRules.isGeneratedClass(destinationInstance.getClass()) || DeniedPackages.isDeniedPackage((String)destinationInstance.getClass().getPackageName())) {
            return;
        }
        for (Field field : Reflections.allFields(destinationInstance.getClass(), f -> true)) {
            if (this.types.contains(field.getType())) {
                map.get(field.getType()).add(new InjectedCandidate(field, destinationInstance));
                continue;
            }
            if (!UserComponents.isUserComponentField(field)) continue;
            Object childInstance = Reflections.getFieldValue((Object)destinationInstance, (Field)field);
            this.extract(map, childInstance);
        }
    }
}

