/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.test.local.component.builder;

import io.rxmicro.common.util.Requires;
import io.rxmicro.reflection.Reflections;
import io.rxmicro.rest.client.detail.HttpClient;
import io.rxmicro.test.Alternative;
import io.rxmicro.test.BlockingHttpClient;
import io.rxmicro.test.SystemOut;
import io.rxmicro.test.internal.DetectTypeRules;
import io.rxmicro.test.internal.SystemStreamImpl;
import io.rxmicro.test.internal.http.JdkBlockingHttpClient;
import io.rxmicro.test.local.InvalidTestConfigException;
import io.rxmicro.test.local.component.builder.internal.MockReplacementExclusion;
import io.rxmicro.test.local.component.builder.internal.ReplacementExclusion;
import io.rxmicro.test.local.model.TestModel;
import io.rxmicro.test.local.util.Inners;
import io.rxmicro.test.local.util.UserComponents;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Set;

public final class TestModelBuilder {
    private static final Map<Class<?>, Map<?, Set<ReplacementExclusion>>> REPLACEMENT = Map.of(BlockingHttpClient.class, Map.of(java.net.http.HttpClient.class, Set.of(MockReplacementExclusion.MOCK_REPLACEMENT_EXCLUSION), HttpClient.class, Set.of(MockReplacementExclusion.MOCK_REPLACEMENT_EXCLUSION), JdkBlockingHttpClient.class, Set.of()), SystemOut.class, Map.of(SystemStreamImpl.class, Set.of(), PrintStream.class, Set.of(MockReplacementExclusion.MOCK_REPLACEMENT_EXCLUSION)));
    private final Class<?> testedComponentClass;
    private final boolean rxMicroCdiAvailable;

    public TestModelBuilder(Class<?> testedComponentClass, boolean rxMicroCdiAvailable) {
        this.testedComponentClass = (Class)Requires.require(testedComponentClass);
        this.rxMicroCdiAvailable = rxMicroCdiAvailable;
    }

    public TestModelBuilder(boolean rxMicroCdiAvailable) {
        this(NotAccessedClass.class, rxMicroCdiAvailable);
    }

    public TestModel build(Class<?> testClass) {
        TestModel.Builder builder = new TestModel.Builder(testClass);
        if (this.testedComponentClass != NotAccessedClass.class) {
            builder.setTestedComponentClass(this.testedComponentClass);
        }
        if (Inners.isInnerClass(testClass)) {
            this.populateBuilder(Inners.getOuterClass(testClass), builder);
        }
        this.populateBuilder(testClass, builder);
        return builder.build();
    }

    private void populateBuilder(Class<?> testClass, TestModel.Builder builder) {
        for (Field field : Reflections.allFields(testClass, v -> true)) {
            this.validate(field);
            if (DetectTypeRules.isSystemOut(field.getType())) {
                builder.addSystemOut(field);
                continue;
            }
            if (DetectTypeRules.isSystemErr(field.getType())) {
                builder.addSystemErr(field);
                continue;
            }
            if (DetectTypeRules.isBlockingHttpClient(field.getType())) {
                builder.addBlockingHttpClient(field);
                continue;
            }
            if (field.getType() == this.testedComponentClass) {
                builder.addTestedComponent(field);
                continue;
            }
            if (DetectTypeRules.isConfig(field.getType())) {
                this.addConfig(builder, field);
                continue;
            }
            if (DetectTypeRules.isRepositoryField(field.getType())) {
                builder.addRepository(field);
                continue;
            }
            if (DetectTypeRules.isRestClientField(field.getType())) {
                builder.addRestClient(field);
                continue;
            }
            if (DetectTypeRules.isMongoDatabase(field.getType())) {
                builder.addMongoDatabase(field);
                continue;
            }
            if (DetectTypeRules.isSqlConnectionPool(field.getType())) {
                builder.addSqlConnectionPool(field);
                continue;
            }
            if (DetectTypeRules.isHttpClientFactory(field.getType())) {
                builder.addHttpClientFactory(field);
                continue;
            }
            if (!field.isAnnotationPresent(Alternative.class)) continue;
            this.addAlternative(builder, field);
        }
    }

    private void addConfig(TestModel.Builder builder, Field field) {
        if (Modifier.isStatic(field.getModifiers())) {
            builder.addStaticConfig(field);
        } else {
            builder.addInstanceConfig(field);
        }
    }

    private void addAlternative(TestModel.Builder builder, Field field) {
        if (UserComponents.isUserComponentField(field)) {
            builder.addUserCreatedComponent(field);
            if (this.rxMicroCdiAvailable) {
                builder.addBeanComponent(field);
            }
        } else {
            throw new InvalidTestConfigException("'@?' annotation couldn't be applied to type: '?'", Alternative.class.getName(), field.getType().getName());
        }
    }

    private void validate(Field field) {
        REPLACEMENT.forEach((cl, map) -> {
            Set replacementExclusions = (Set)map.get(field.getType());
            if (replacementExclusions != null) {
                for (ReplacementExclusion replacementExclusion : replacementExclusions) {
                    if (!replacementExclusion.isReplacementExclude(field)) continue;
                    return;
                }
                throw new InvalidTestConfigException("Use '?' instead of '?'", cl.getName(), field.getType().getName());
            }
        });
    }

    private static final class NotAccessedClass {
        private NotAccessedClass() {
        }
    }
}

