/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.test.local.component.builder;

import io.rxmicro.common.util.Formats;
import io.rxmicro.rest.client.detail.HttpClientContentConverter;
import io.rxmicro.runtime.local.Implementations;
import io.rxmicro.test.BlockingHttpClient;
import io.rxmicro.test.internal.http.JdkBlockingHttpClient;
import io.rxmicro.test.local.BlockingHttpClientConfig;
import io.rxmicro.test.local.InvalidTestConfigException;
import java.util.ServiceLoader;
import java.util.function.Function;

public final class BlockingHttpClientBuilder {
    public BlockingHttpClient build(BlockingHttpClientConfig blockingHttpClientConfig) {
        String baseUrlPath;
        JdkBlockingHttpClient.Builder builder = new JdkBlockingHttpClient.Builder().setBlockingHttpClientConfig(blockingHttpClientConfig).setContentConverter(Implementations.getOptionalImplementation(HttpClientContentConverter.class, ServiceLoader::load).orElseGet(() -> new DefaultHttpClientContentConverter()));
        String versionValue = blockingHttpClientConfig.getVersionValue();
        if (!versionValue.isEmpty()) {
            this.validateVersionValue(versionValue);
            builder.setVersion(blockingHttpClientConfig.getVersionStrategy(), versionValue);
        }
        if (!(baseUrlPath = blockingHttpClientConfig.getBaseUrlPath()).isEmpty()) {
            builder.setBaseUrl(baseUrlPath, blockingHttpClientConfig.getBaseUrlPosition());
        }
        return builder.build();
    }

    private void validateVersionValue(String versionValue) {
        if (!versionValue.equals(versionValue.trim())) {
            throw new InvalidTestConfigException("Invalid version value: '?'! Expected version value without spaces!", versionValue);
        }
    }

    private static final class DefaultHttpClientContentConverter
    implements HttpClientContentConverter {
        private DefaultHttpClientContentConverter() {
        }

        public Function<Object, byte[]> getRequestContentConverter() {
            return o -> {
                if (o == null) {
                    return new byte[0];
                }
                if (o instanceof byte[]) {
                    return (byte[])o;
                }
                throw new UnsupportedOperationException(Formats.format((String)"Can't convert ? to byte array", (Object[])new Object[]{o.getClass().getName()}));
            };
        }

        public Function<byte[], Object> getResponseContentConverter() {
            return bytes -> bytes;
        }

        public String getContentType() {
            return "application/octet-stream";
        }
    }
}

