/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.test.local.component;

import io.rxmicro.cdi.BeanFactory;
import io.rxmicro.data.RepositoryFactory;
import io.rxmicro.reflection.Reflections;
import io.rxmicro.rest.client.RestClientFactory;
import io.rxmicro.test.internal.DetectTypeRules;
import io.rxmicro.test.local.InvalidTestConfigException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Optional;

public final class TestedComponentResolver {
    private final Field testedComponent;
    private final Class<?> testedComponentClass;

    public TestedComponentResolver(Field testedComponent, Class<?> testedComponentClass) {
        this.testedComponent = testedComponent;
        this.testedComponentClass = testedComponentClass;
    }

    public Object getTestedComponentInstance(List<Object> testInstances) {
        if (this.testedComponent != null) {
            return this.getInstance(testInstances, this.testedComponent, true);
        }
        return this.createTestComponentInstance(this.testedComponentClass);
    }

    public void verifyState(List<Object> testInstances, Class<? extends Annotation> beforeEachAnnotation) {
        if (this.testedComponent != null && this.getInstance(testInstances, this.testedComponent, false) != null) {
            throw new InvalidTestConfigException("Invalid initialization of tested component: ?. These components must be instantiated by the RxMicro framework automatically or inside method, annotated by '@?' annotation.", this.testedComponent, beforeEachAnnotation.getName());
        }
    }

    private Object getInstance(List<Object> testInstances, Field field, boolean instantiateIfNotFound) {
        Object userCreatedInstance = Reflections.getFieldValue(testInstances, (Field)field);
        if (instantiateIfNotFound) {
            return Optional.ofNullable(userCreatedInstance).orElseGet(() -> {
                Object instance = this.createTestComponentInstance(field.getType());
                Reflections.setFieldValue((List)testInstances, (Field)field, (Object)instance);
                return instance;
            });
        }
        return userCreatedInstance;
    }

    private Object createTestComponentInstance(Class<?> type) {
        Object autoCreatedInstance = DetectTypeRules.isRepositoryField(type) ? RepositoryFactory.getRepository(type) : (DetectTypeRules.isRestClientField(type) ? RestClientFactory.getRestClient(type) : (DetectTypeRules.isBeanField(type) ? BeanFactory.getBean(type) : Reflections.instantiate(type)));
        return autoCreatedInstance;
    }
}

