/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.test.local.component;

import io.rxmicro.test.local.component.RxMicroTestExtension;
import io.rxmicro.test.local.model.TestModel;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;

public final class RxMicroTestExtensions {
    private static final Set<RxMicroTestExtension> RX_MICRO_TEST_EXTENSIONS;

    public static void validateUsingTestExtensions(TestModel testModel, Set<Class<? extends Annotation>> supportedRxMicroTestAnnotations) {
        RX_MICRO_TEST_EXTENSIONS.forEach(ex -> ex.validate(testModel, supportedRxMicroTestAnnotations));
    }

    public static Set<Class<? extends Annotation>> supportedPerClassAnnotationsFromTestExtensions() {
        return RX_MICRO_TEST_EXTENSIONS.stream().flatMap(ex -> ex.supportedPerClassAnnotations().stream()).collect(Collectors.toSet());
    }

    private RxMicroTestExtensions() {
    }

    static {
        HashSet<RxMicroTestExtension> rxMicroTestExtensions = new HashSet<RxMicroTestExtension>();
        for (RxMicroTestExtension rxMicroTestExtension : ServiceLoader.load(RxMicroTestExtension.class)) {
            rxMicroTestExtensions.add(rxMicroTestExtension);
        }
        RX_MICRO_TEST_EXTENSIONS = Collections.unmodifiableSet(rxMicroTestExtensions);
    }
}

