/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.test.local.component;

import io.rxmicro.common.util.Requires;
import io.rxmicro.reflection.Reflections;
import io.rxmicro.rest.server.local.model.ServerContainer;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public final class RestControllerInstanceResolver {
    private final Set<Class<?>> restControllerClasses;
    private final ServerContainer serverContainer;

    public RestControllerInstanceResolver(Class<?>[] restControllerClasses, ServerContainer serverContainer) {
        this.restControllerClasses = Set.of(restControllerClasses);
        this.serverContainer = (ServerContainer)Requires.require((Object)serverContainer);
    }

    public Set<Class<?>> getRestControllerClasses() {
        return this.restControllerClasses;
    }

    public List<Object> getRestControllerInstances() {
        return this.serverContainer.getRegisteredRestControllers().stream().filter(s -> this.restControllerClasses.contains(s.getRestControllerClass())).map(wrapper -> Reflections.getFieldValue((Object)wrapper, (String)"restController")).collect(Collectors.toList());
    }
}

