/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.test.local.component;

import io.rxmicro.common.util.ExCollections;
import io.rxmicro.common.util.Formats;
import io.rxmicro.config.Config;
import io.rxmicro.config.detail.DefaultConfigValueBuilder;
import io.rxmicro.reflection.Reflections;
import io.rxmicro.test.SetConfigValue;
import io.rxmicro.test.WithConfig;
import io.rxmicro.test.local.InvalidTestConfigException;
import io.rxmicro.test.local.model.TestModel;
import io.rxmicro.test.local.util.Inners;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public final class ConfigResolver {
    public Map<String, Config> getStaticConfigMap(TestModel testModel, Config ... defaultConfigs) {
        return this.getConfigMap(testModel.getStaticConfigs(), Collections.singletonList(null), defaultConfigs);
    }

    public Map<String, Config> getInstanceConfigMap(TestModel testModel, List<Object> testInstances, Config ... defaultConfigs) {
        return this.getConfigMap(testModel.getInstanceConfigs(), testInstances, defaultConfigs);
    }

    private Map<String, Config> getConfigMap(List<Field> configs, List<Object> testInstances, Config ... defaultConfigs) {
        Map<String, Config> configMap = configs.stream().map(f -> Map.entry(f, this.getConfigInstance(testInstances, (Field)f))).map(e -> Map.entry(this.getNameSpace((Map.Entry<Field, Config>)e), (Config)e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (o1, o2) -> o1));
        Arrays.stream(defaultConfigs).forEach(c -> configMap.putIfAbsent(c.getNameSpace(), (Config)c));
        return ExCollections.unmodifiableOrderedMap(configMap);
    }

    private Config getConfigInstance(List<Object> testInstances, Field field) {
        Config config = (Config)Reflections.getFieldValue(testInstances, (Field)field);
        if (config == null) {
            throw new InvalidTestConfigException("Test config could not be null! Add initialization block for field: ?", field);
        }
        return config;
    }

    private String getNameSpace(Map.Entry<Field, Config> entry) {
        return Optional.of(entry.getKey().getAnnotation(WithConfig.class).value()).filter(v -> !v.isEmpty()).orElseGet(() -> ((Config)entry.getValue()).getNameSpace());
    }

    public void setDefaultConfigValues(Class<?> testInstanceClass) {
        ArrayList<SetConfigValue> setConfigValues = new ArrayList<SetConfigValue>();
        if (Inners.isInnerClass(testInstanceClass)) {
            setConfigValues.addAll(Arrays.asList((SetConfigValue[])Inners.getOuterClass(testInstanceClass).getAnnotationsByType(SetConfigValue.class)));
        }
        setConfigValues.addAll(Arrays.asList((SetConfigValue[])testInstanceClass.getAnnotationsByType(SetConfigValue.class)));
        for (SetConfigValue configValue : setConfigValues) {
            String name = this.getConfigName(configValue);
            DefaultConfigValueBuilder.putDefaultConfigValue((String)name, (String)configValue.value());
        }
    }

    private String getConfigName(SetConfigValue configValue) {
        if (configValue.configClass() == Config.class) {
            String name = configValue.name();
            if (name.indexOf(46) == -1) {
                throw new InvalidTestConfigException("Missing namespace for config property: '?'. Add missing namespace or set configClass!", name);
            }
            return name;
        }
        String name = configValue.name();
        if (name.indexOf(46) != -1) {
            throw new InvalidTestConfigException("Redundant namespace for config property: '?'. Add redundant namespace or remove configClass!", name);
        }
        return Formats.format((String)"?.?", (Object[])new Object[]{Config.getDefaultNameSpace(configValue.configClass()), name});
    }
}

